/*
 * Decompiled with CFR 0.152.
 */
package dz;

public class Processor {
    private Enemy[] opponents;
    private int numopp;
    private int count;
    private int target;
    private int numalive;
    private int roundnum;
    private double fieldwidth;
    private double fieldheight;

    public void hit(double x, double y) {
        this.opponents[this.target].hit(x, y);
    }

    public void missed(double x, double y) {
        this.opponents[this.target].missed(x, y);
    }

    public void reset() {
        this.numalive = this.numopp;
        ++this.roundnum;
        int a = 0;
        while (a < this.numopp) {
            this.opponents[a].reset();
            ++a;
        }
    }

    public void fire(double ownx, double owny, double power, double v, double heading) {
        this.opponents[this.target].fire(ownx, owny, power, v, heading);
    }

    public int getTarget() {
        return this.target;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public static double normalizeHeading(double heading) {
        boolean bl;
        boolean bl2;
        boolean bl3 = true;
        do {
            if (!bl3 || (bl3 = false) || !true) {
                if (heading >= 360.0) {
                    heading -= 360.0;
                } else if (heading < 0.0) {
                    heading += 360.0;
                }
            }
            bl2 = false;
            if (heading >= 360.0) {
                bl2 = true;
            }
            bl = false;
            if (!(heading < 0.0)) continue;
            bl = true;
        } while (bl2 | bl);
        return heading;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public static double normalizeBearing(double bearing) {
        boolean bl;
        boolean bl2;
        boolean bl3 = true;
        do {
            if (!bl3 || (bl3 = false) || !true) {
                if (bearing > 180.0) {
                    bearing -= 360.0;
                } else if (bearing <= -180.0) {
                    bearing += 360.0;
                }
            }
            bl2 = false;
            if (bearing > 180.0) {
                bl2 = true;
            }
            bl = false;
            if (!(bearing <= -180.0)) continue;
            bl = true;
        } while (bl2 | bl);
        return bearing;
    }

    public static double findHeading(double x1, double y1, double x2, double y2) {
        double heading;
        double d = Processor.findDist(x1, y1, x2, y2);
        if (d != 0.0) {
            double h2;
            double h1 = Math.asin((y2 - y1) / d) * 57.29577951308232;
            if (Math.abs(h1 - (h2 = Math.acos((x2 - x1) / d) * 57.29577951308232)) < 1.0) {
                heading = (h1 + h2) / (double)2;
            } else if (Math.abs(h1 + h2) < 1.0) {
                heading = (h1 - h2) / (double)2;
            } else {
                boolean bl = false;
                if (h1 > 0.0) {
                    bl = true;
                }
                boolean bl2 = false;
                if (Math.abs(180.0 - h1 - h2) < 1.0) {
                    bl2 = true;
                }
                heading = bl & bl2 ? (180.0 - h1 + h2) / (double)2 : (-180.0 - h1 - h2) / (double)2;
            }
            heading += 360.0;
            heading = Processor.normalizeHeading(heading);
            heading = 360.0 - heading;
            heading += 90.0;
            heading = Processor.normalizeHeading(heading);
        } else {
            heading = 0.0;
        }
        return heading;
    }

    public static double findDist(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public double scanData(double heading, double bearing, double dist, double ownx, double owny, long t, double e, String n, double v, double theading, double[] pos, double[] fheading, double[] newmaxdodge) {
        double radarheading = heading + bearing;
        double power = 0.0;
        radarheading = Processor.normalizeHeading(radarheading);
        pos[0] = Math.sin(radarheading * Math.PI / 180.0) * dist + ownx;
        pos[1] = Math.cos(radarheading * Math.PI / 180.0) * dist + owny;
        int a = -1;
        while (a < this.numopp - 1) {
            if (n.equals("Salviusccvi") | n.equals(this.opponents[++a].getName())) break;
        }
        this.opponents[a].addData(n, pos[0], pos[1], ownx, owny, v, theading, e, t, newmaxdodge);
        this.target = this.chooseTarget(ownx, owny);
        if (this.target == a) {
            power = this.opponents[a].findFuture(ownx, owny, dist, v, theading, fheading);
        }
        return power;
    }

    public int chooseTarget(double mx, double my) {
        int t;
        int a = 0;
        while (!this.opponents[a].getName().equals("Salviusccvi") && ++a < this.numopp) {
        }
        if (a == 1) {
            t = 0;
        } else {
            double[] ratings = new double[a];
            int b = 0;
            while (b < a) {
                ratings[b] = (double)(99999 * this.opponents[b].aliveFactor()) + this.opponents[b].getEnergy() + this.opponents[b].getDamage() - Math.sqrt(Math.pow(mx - this.opponents[b].getX(), 2) + Math.pow(my - this.opponents[b].getY(), 2));
                if (b == this.target) {
                    int n = b;
                    ratings[n] = ratings[n] + 50.0;
                }
                ++b;
            }
            t = 0;
            b = 1;
            while (b < a) {
                if (ratings[b] > ratings[t]) {
                    t = b;
                }
                ++b;
            }
        }
        return t;
    }

    public void dodge(double d, double[] f) {
        this.opponents[this.target].dodge(d, f);
    }

    public void startDodge(double speed, double myx, double myy, double d, double h) {
        this.opponents[this.target].startDodge(speed, myx, myy, d, h);
    }

    public int findPlayer(String n) {
        int q = 0;
        while (q < this.numopp) {
            if (n.equals(this.opponents[q].getName()) | this.opponents[q].getName().equals("Salviusccvi")) break;
            ++q;
        }
        if (q >= this.numopp) {
            q = this.numopp - 1;
        }
        if (this.opponents[q].getName().equals("Salviusccvi")) {
            this.opponents[q].setName(n);
        }
        return q;
    }

    public void addDamage(int id, double d) {
        this.opponents[id].addDamage(d);
    }

    public void died(int id) {
        this.opponents[id].died();
        --this.numalive;
    }

    public void targetAccuracy(double[] a) {
        this.opponents[this.target].getAccuracy(a);
    }

    public void targetData(double[][] a) {
        this.opponents[this.target].getData(a);
    }

    public double targetEnergy() {
        return this.opponents[this.target].getEnergy();
    }

    public void hitByTarget(double x, double y, double mx, double my, long t) {
        this.opponents[this.target].hitByBot(x, y, mx, my, t);
    }

    public boolean targetIsItABullet(double p, long t) {
        return this.opponents[this.target].isItABullet(p, t);
    }

    public Processor(int numopponents, double w, double h) {
        this.fieldwidth = w;
        this.fieldheight = h;
        this.roundnum = 1;
        this.numalive = this.numopp = numopponents;
        this.opponents = new Enemy[this.numopp];
        this.count = 0;
        this.target = 0;
        int a = 0;
        while (a < this.numopp) {
            this.opponents[a] = new Enemy();
            ++a;
        }
    }

    public class Enemy {
        private String name = "Salviusccvi";
        private double[] x;
        private double[] y;
        private double[] energy;
        private double damage;
        private double[] hits;
        private double[] misses;
        private double[] directions;
        private double dirtotal = 0.0;
        private double[] heading;
        private double[] velocity;
        private double maxv = 0.0;
        private long[] time;
        private int amountdata = 0;
        private int learningtime = 0;
        private int numreactions = 0;
        private int numresponses = 0;
        private int numbullets = 0;
        private int onedirectiontime = 0;
        private int numsnapshots;
        private int intdirection = 0;
        private int randfactor = 0;
        private boolean alive;
        private double[][] reactions;
        private double[][] shots;
        private double[] accuracy = new double[5];
        private Reaction[] responses;
        private Dodge[] bullets;
        private Situation[] snapshots;
        private Situation[] tempsnapshots;
        private VBullet[] tempbullets = new VBullet[5];
        private VBullet[][] currentbullets = new VBullet[10][5];

        public void reset() {
            this.randfactor = 0;
            this.amountdata = 0;
            this.intdirection = 0;
            this.numresponses = 0;
            this.numbullets = 0;
            this.alive = true;
            this.onedirectiontime = 0;
            int h = 0;
            while (h < 5) {
                int n = h++;
                this.accuracy[n] = this.accuracy[n] * 0.9;
            }
            h = 0;
            while (h <= 2) {
                int n = h;
                this.hits[n] = this.hits[n] * 0.9;
                int n2 = h;
                this.misses[n2] = this.misses[n2] * 0.9;
                int f = 0;
                while (f <= 20) {
                    double[] dArray = this.reactions[h];
                    int n3 = f;
                    dArray[n3] = dArray[n3] * 0.9;
                    double[] dArray2 = this.shots[h];
                    int n4 = f++;
                    dArray2[n4] = dArray2[n4] * 0.9;
                }
                ++h;
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String n) {
            this.name = n;
        }

        public void hit(double x, double y) {
            double dist = Processor.findDist(x, y, this.getX(), this.getY());
            int i = dist < 200.0 ? 0 : (dist < 400.0 ? 1 : 2);
            int n = i;
            this.hits[n] = this.hits[n] + 1.0;
        }

        public void missed(double x, double y) {
            double dist = Processor.findDist(x, y, this.getX(), this.getY());
            int i = dist < 200.0 ? 0 : (dist < 400.0 ? 1 : 2);
            int n = i;
            this.misses[n] = this.misses[n] + 1.0;
        }

        public void addData(String n, double nx, double ny, double ownx, double owny, double v, double h, double e, long t, double[] newmaxdodge) {
            if (this.amountdata == 0) {
                this.name = n;
            }
            if (this.amountdata >= 100) {
                this.amountdata = 99;
                int f = 0;
                while (f < 99) {
                    this.x[f] = this.x[f + 1];
                    this.y[f] = this.y[f + 1];
                    this.energy[f] = this.energy[f + 1];
                    this.time[f] = this.time[f + 1];
                    this.heading[f] = this.heading[f + 1];
                    ++f;
                }
            }
            this.velocity[this.amountdata] = v;
            this.x[this.amountdata] = nx;
            this.y[this.amountdata] = ny;
            this.energy[this.amountdata] = e;
            this.time[this.amountdata] = t;
            this.heading[this.amountdata] = h;
            ++this.amountdata;
            if (Math.abs(v) > this.maxv) {
                this.maxv = Math.abs(v);
            }
            if (v == 0.0) {
                if (this.intdirection == 0) {
                    ++this.onedirectiontime;
                } else {
                    this.onedirectiontime = 0;
                    this.intdirection = 0;
                }
            } else if ((int)Math.round(v / Math.abs(v)) == this.intdirection) {
                ++this.onedirectiontime;
            } else {
                this.onedirectiontime = 0;
                this.intdirection = (int)Math.round(v / Math.abs(v));
            }
            if (v > 0.0) {
                this.directions[0] = this.directions[0] + 1.0;
            } else if (v == 0.0) {
                this.directions[1] = this.directions[1] + 1.0;
            } else {
                this.directions[2] = this.directions[2] + 1.0;
            }
            this.dirtotal += 1.0;
            if (this.numbullets >= 1 && this.bullets[0].movedPast(ownx, owny, t)) {
                --this.numbullets;
                int q = 0;
                while (q < this.numbullets) {
                    this.bullets[q] = this.bullets[q + 1];
                    ++q;
                }
                if (this.numbullets >= 1) {
                    newmaxdodge[0] = this.bullets[0].getDistRemaining(ownx, owny, t) * 7.0 / this.bullets[0].getV();
                    newmaxdodge[1] = this.bullets[0].getTimeTravelled(t);
                }
            }
            if (this.numresponses >= 1 && this.responses[0].atTarget(this.getX(), this.getY(), t)) {
                int q;
                double newheading = Processor.findHeading(this.responses[0].getMyX(), this.responses[0].getMyY(), this.getX(), this.getY());
                double oldheading = Processor.findHeading(this.responses[0].getMyX(), this.responses[0].getMyY(), this.responses[0].getTX(), this.responses[0].getTY());
                double deltaheading = newheading - oldheading;
                deltaheading = Processor.normalizeBearing(deltaheading);
                this.tempsnapshots[0].setResult(deltaheading);
                double decimal = deltaheading / this.responses[0].getTheta();
                int c = 0;
                while (c < 21) {
                    double j = c;
                    if (decimal < (j - 10.0) / 10.0 + 0.05) break;
                    ++c;
                }
                if (c >= 21) {
                    c = 20;
                }
                double[] dArray = this.reactions[this.responses[0].getRange()];
                int n2 = c;
                dArray[n2] = dArray[n2] + 1.0;
                if (this.responses[0].getHasVB()) {
                    q = 0;
                    while (q < 5) {
                        int n3 = q;
                        this.accuracy[n3] = this.accuracy[n3] + this.currentbullets[0][q].isHit(this.getX(), this.getY(), this.getTime());
                        int n4 = q++;
                        this.accuracy[n4] = this.accuracy[n4] + 1.0;
                    }
                }
                ++this.numreactions;
                --this.numresponses;
                if (this.numsnapshots >= 100) {
                    this.numsnapshots = 100;
                    q = 0;
                    while (q < 99) {
                        this.snapshots[q] = this.snapshots[q + 1];
                        ++q;
                    }
                    this.snapshots[99] = this.tempsnapshots[0];
                } else {
                    this.snapshots[this.numsnapshots] = this.tempsnapshots[0];
                    ++this.numsnapshots;
                }
                q = 0;
                while (q < this.numresponses) {
                    this.responses[q] = this.responses[q + 1];
                    this.tempsnapshots[q] = this.tempsnapshots[q + 1];
                    int w = 0;
                    while (w < 5) {
                        this.currentbullets[q][w] = this.currentbullets[q + 1][w];
                        ++w;
                    }
                    ++q;
                }
            }
        }

        /*
         * Handled impossible loop by adding 'first' condition
         * Enabled aggressive block sorting
         */
        public void fire(double ownx, double owny, double power, double v, double h) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            double v1 = v;
            boolean bl5 = false;
            if (v == 0.0) {
                bl5 = true;
            }
            boolean bl6 = false;
            if (this.amountdata >= 5) {
                bl6 = true;
            }
            if (bl5 & bl6) {
                v = Processor.findDist(this.getX(), this.getY(), this.x[this.amountdata - 5], this.y[this.amountdata - 5]) / (double)(this.getTime() - this.time[this.amountdata - 5]);
            }
            double bullettime = (Processor.findDist(ownx, owny, this.getX(), this.getY()) - 20.0) / (20.0 - (double)3 * power);
            double headingdifference = h - Processor.findHeading(ownx, owny, this.getX(), this.getY());
            v *= Math.sin(Math.abs(headingdifference) * Math.PI / 180.0);
            double maxdist = 0.0;
            int f = 0;
            while ((double)f < bullettime) {
                maxdist += v;
                v = v >= 0.0 ? (v <= 7.0 ? (v += 1.0) : 8.0) : (v >= -7.0 ? (v -= 1.0) : -8.0);
                ++f;
            }
            double avgvelocity = v1;
            avgvelocity *= (double)(v1 < 0.0 ? -1 : 1);
            if (this.amountdata >= 10) {
                avgvelocity = Processor.findDist(this.x[this.amountdata - 10], this.y[this.amountdata - 10], this.getX(), this.getY()) / (double)(this.getTime() - this.time[this.amountdata - 10]);
                if (v1 < 0.0) {
                    h += 180.0;
                    h = Processor.normalizeHeading(h);
                }
                if (Math.abs(Processor.normalizeBearing(Processor.findHeading(this.x[this.amountdata - 10], this.y[this.amountdata - 10], this.getX(), this.getY()) - h)) > 90.0) {
                    avgvelocity *= -1.0;
                }
            }
            double tdist = Processor.findDist(ownx, owny, this.getX(), this.getY());
            double theta = Math.atan(maxdist / tdist);
            theta *= 57.29577951308232;
            ++this.numresponses;
            int r = tdist < 200.0 ? 0 : (tdist < 400.0 ? 1 : 2);
            if (v1 < 0.0) {
                h += 180.0;
                headingdifference += 180.0;
                v1 *= -1.0;
            }
            headingdifference = Processor.normalizeBearing(headingdifference);
            h = this.getHeading();
            double acceleration = (this.velocity[this.amountdata - 1] - this.velocity[this.amountdata - 2]) / (double)(this.time[this.amountdata - 1] - this.time[this.amountdata - 2]);
            double angularvelocity = (this.heading[this.amountdata - 1] - this.heading[this.amountdata - 2]) / (double)(this.time[this.amountdata - 1] - this.time[this.amountdata - 2]);
            if (headingdifference < 0.0) {
                angularvelocity *= -1.0;
            }
            double tx = this.getX();
            double ty = this.getY();
            double front = 0.0;
            int q = 0;
            boolean bl7 = true;
            do {
                if (!bl7 || (bl7 = false) || !true) {
                    tx += Math.sin(h * Math.PI / 180.0) * 10.0;
                    ty += Math.cos(h * Math.PI / 180.0) * 10.0;
                    front += 10.0;
                    ++q;
                }
                boolean bl8 = false;
                if (q < 20) {
                    bl8 = true;
                }
                boolean bl9 = false;
                if (tx < Processor.this.fieldwidth - 17.0) {
                    bl9 = true;
                }
                boolean bl10 = bl8 & bl9;
                boolean bl11 = false;
                if (tx > 17.0) {
                    bl11 = true;
                }
                boolean bl12 = bl10 & bl11;
                boolean bl13 = false;
                if (ty > 17.0) {
                    bl13 = true;
                }
                bl4 = bl12 & bl13;
                bl3 = false;
                if (!(ty < Processor.this.fieldheight - 17.0)) continue;
                bl3 = true;
            } while (bl4 & bl3);
            double back = 0.0;
            tx = this.getX();
            ty = this.getY();
            int q2 = 0;
            boolean bl14 = true;
            do {
                if (!bl14 || (bl14 = false) || !true) {
                    tx -= Math.sin(h * Math.PI / 180.0) * 10.0;
                    ty -= Math.cos(h * Math.PI / 180.0) * 10.0;
                    back += 10.0;
                    ++q2;
                }
                boolean bl15 = false;
                if (q2 < 20) {
                    bl15 = true;
                }
                boolean bl16 = false;
                if (tx < Processor.this.fieldwidth - 17.0) {
                    bl16 = true;
                }
                boolean bl17 = bl15 & bl16;
                boolean bl18 = false;
                if (tx > 17.0) {
                    bl18 = true;
                }
                boolean bl19 = bl17 & bl18;
                boolean bl20 = false;
                if (ty > 17.0) {
                    bl20 = true;
                }
                bl2 = bl19 & bl20;
                bl = false;
                if (!(ty < Processor.this.fieldheight - 17.0)) continue;
                bl = true;
            } while (bl2 & bl);
            if (this.numresponses > 10) {
                this.numresponses = 10;
            } else if (this.numresponses > 0) {
                this.responses[this.numresponses - 1] = new Reaction(ownx, owny, this.getX(), this.getY(), 20.0 - (double)3 * power, theta, r, this.getTime());
                this.tempsnapshots[this.numresponses - 1] = new Situation(headingdifference, tdist, v1, front, back, angularvelocity, acceleration, power, avgvelocity, this.onedirectiontime);
                boolean bl21 = false;
                if (this.amountdata > 10) {
                    bl21 = true;
                }
                boolean bl22 = false;
                if (this.numreactions >= 2) {
                    bl22 = true;
                }
                if (bl21 & bl22) {
                    this.responses[this.numresponses - 1].nowHasVB();
                    this.currentbullets[this.numresponses - 1][0] = new VBullet(ownx, owny, this.directAim(ownx, owny), power, this.getTime());
                    this.currentbullets[this.numresponses - 1][1] = new VBullet(ownx, owny, this.circularAim(ownx, owny, tdist, v, h, power), power, this.getTime());
                    this.currentbullets[this.numresponses - 1][2] = new VBullet(ownx, owny, this.guessFactorAim(ownx, owny, v, tdist, h, headingdifference, r, power, false), power, this.getTime());
                    this.currentbullets[this.numresponses - 1][3] = new VBullet(ownx, owny, this.guessFactorAim(ownx, owny, v, tdist, h, headingdifference, r, power, true), power, this.getTime());
                    this.currentbullets[this.numresponses - 1][4] = new VBullet(ownx, owny, this.situationAim(ownx, owny, v, tdist, h, headingdifference, power), power, this.getTime());
                }
            }
            this.randfactor = (int)Math.random() * 10;
        }

        public void dodge(double d, double[] f) {
            int r = d < 200.0 ? 0 : (d < 400.0 ? 1 : 2);
            int q = 0;
            while (q <= 20) {
                f[q] = this.shots[r][q];
                if (q == 0) {
                    int n = q;
                    f[n] = f[n] + this.shots[r][1];
                } else if (q == 20) {
                    int n = q;
                    f[n] = f[n] + this.shots[r][19];
                } else if (r == 1) {
                    int n = q;
                    f[n] = f[n] + (this.shots[r][q - 1] + this.shots[r][q + 1]);
                } else if (r == 2) {
                    int n = q;
                    f[n] = f[n] + (this.shots[r][q - 1] + this.shots[r][q + 1]) / (double)2;
                } else if (q == 19) {
                    int n = q;
                    f[n] = f[n] + (this.shots[r][q - 1] + this.shots[r][q + 1] + this.shots[r][17] * 0.6);
                } else if (q == 1) {
                    int n = q;
                    f[n] = f[n] + (this.shots[r][q - 1] + this.shots[r][q + 1] + this.shots[r][3] * 0.6);
                } else {
                    int n = q;
                    f[n] = f[n] + (this.shots[r][q - 1] + this.shots[r][q + 1] + (this.shots[r][q - 2] + this.shots[r][q + 2]) * 0.6);
                }
                ++q;
            }
        }

        public boolean isItABullet(double p, long t) {
            if (this.numresponses == 0) {
                return true;
            }
            boolean bl = false;
            if (this.responses[0].getDistanceRemaining(this.getX(), this.getY(), this.getTime()) < 40.0) {
                bl = true;
            }
            boolean bl2 = false;
            if (Math.abs(p - (20.0 - this.responses[0].getV()) / (double)3) < 0.1) {
                bl2 = true;
            }
            return !(bl & bl2);
        }

        public void hitByBot(double x, double y, double mx, double my, long t) {
            int q = 0;
            while (q < this.numbullets) {
                if (this.bullets[q].isThisBullet(x, y, t)) break;
                ++q;
            }
            if (q < this.numbullets) {
                double d = Processor.findDist(this.bullets[q].getX(), this.bullets[q].getY(), mx, my);
                int r = d < 200.0 ? 0 : (d < 400.0 ? 1 : 2);
                double[] dArray = this.shots[r];
                int n = this.bullets[q].getFactor(mx, my, t);
                dArray[n] = dArray[n] + (double)2;
            }
        }

        public void startDodge(double speed, double myx, double myy, double d, double h) {
            this.bullets[this.numbullets] = new Dodge(speed, this.getX(), this.getY(), myx, myy, d, h, this.getTime());
            ++this.numbullets;
        }

        public void addDamage(double d) {
            this.damage += d;
        }

        public void died() {
            this.alive = false;
        }

        public int aliveFactor() {
            if (this.alive) {
                return 1;
            }
            return 0;
        }

        public double getX() {
            if (this.amountdata >= 1) {
                return this.x[this.amountdata - 1];
            }
            return -10000.0;
        }

        public double getY() {
            if (this.amountdata >= 1) {
                return this.y[this.amountdata - 1];
            }
            return -10000.0;
        }

        public double getEnergy() {
            if (this.amountdata >= 1) {
                return this.energy[this.amountdata - 1];
            }
            return 100.0;
        }

        public void getAccuracy(double[] a) {
            int b = 0;
            while (b <= 2) {
                a[b] = this.hits[b] + this.misses[b] > 0.0 ? this.hits[b] * 100.0 / (this.hits[b] + this.misses[b]) : 0.0;
                ++b;
            }
        }

        public void getData(double[][] a) {
            int b = 0;
            while (b <= 2) {
                int c = 0;
                while (c <= 20) {
                    a[b][c] = this.reactions[b][c];
                    ++c;
                }
                ++b;
            }
        }

        public long getTime() {
            return this.time[this.amountdata - 1];
        }

        public double getDamage() {
            return this.damage;
        }

        public double getHeading() {
            return this.heading[this.amountdata - 1];
        }

        public double getVelocity() {
            return this.velocity[this.amountdata - 1];
        }

        public double findFuture(double ox, double oy, double d, double v, double theading, double[] fheading) {
            int bah1;
            double t;
            double killpower;
            double p = 30.0 / Math.sqrt(d);
            int r = d < 200.0 ? 0 : (d < 400.0 ? 1 : 2);
            boolean sittingduck = false;
            if (Processor.this.numalive == 1 && Processor.findDist(ox, oy, this.getX(), this.getY()) < 270.0) {
                p = 3;
            }
            boolean bl = false;
            if (this.directions[0] / this.dirtotal > 0.75) {
                bl = true;
            }
            boolean bl2 = false;
            if (v > 0.0) {
                bl2 = true;
            }
            boolean bl3 = bl & bl2;
            boolean bl4 = false;
            if (this.directions[2] / this.dirtotal > 0.75) {
                bl4 = true;
            }
            boolean bl5 = false;
            if (v < 0.0) {
                bl5 = true;
            }
            boolean bl6 = bl3 | bl4 & bl5;
            boolean bl7 = false;
            if (this.onedirectiontime >= 20) {
                bl7 = true;
            }
            boolean onedirection = bl6 | bl7;
            if (this.hits[r] + this.misses[r] >= 8.0) {
                p = this.hits[r] / (this.hits[r] + this.misses[r]) < 0.14 ? 0.1 : (p *= (double)5 * (this.hits[r] / (this.hits[r] + this.misses[r])));
            }
            double d2 = killpower = this.getEnergy() > (double)4 ? (this.getEnergy() - (double)4) / 6.0 + 1.01 : this.getEnergy() / (double)4 + 0.01;
            if (p > killpower) {
                p = killpower;
            }
            if (p > (double)3) {
                p = 3;
            }
            if (p < 0.1) {
                p = 0.1;
            }
            double t1 = t = d / (20.0 - (double)3 * p);
            if (Processor.this.numalive == 1 && (bah1 = (int)Math.round((double)this.amountdata - t1 - 1.0)) >= 0) {
                boolean bl8 = false;
                if (Processor.findDist(this.x[bah1], this.y[bah1], this.getX(), this.getY()) < (double)5) {
                    bl8 = true;
                }
                sittingduck = bl8;
            }
            double headingdifference = theading - Processor.findHeading(ox, oy, this.getX(), this.getY());
            headingdifference = Processor.normalizeBearing(headingdifference);
            int bestmethod = 1;
            if (this.numreactions > 10) {
                double bestaccuracy = 0.0;
                int q = 0;
                while (q < 5) {
                    if (this.accuracy[q] > (double)bestmethod) {
                        bestaccuracy = this.accuracy[q];
                        bestmethod = q;
                    }
                    ++q;
                }
            }
            boolean bl9 = false;
            if (this.amountdata < 3) {
                bl9 = true;
            }
            boolean bl10 = false;
            if (this.getEnergy() == 0.0) {
                bl10 = true;
            }
            if (bl9 | bl10) {
                fheading[0] = this.directAim(ox, oy);
                p = 0.1;
            } else {
                boolean bl11 = false;
                if (bestmethod == 0) {
                    bl11 = true;
                }
                if (sittingduck | bl11) {
                    fheading[0] = this.directAim(ox, oy);
                } else {
                    boolean bl12 = false;
                    if (Processor.this.numalive == 1) {
                        bl12 = true;
                    }
                    boolean bl13 = bl12 & (onedirection ^ true);
                    boolean bl14 = false;
                    if (this.numsnapshots > 10) {
                        bl14 = true;
                    }
                    boolean bl15 = bl13 & bl14;
                    boolean bl16 = false;
                    if (bestmethod == 4) {
                        bl16 = true;
                    }
                    if (bl15 & bl16) {
                        fheading[0] = this.situationAim(ox, oy, v, d, theading, headingdifference, p);
                    } else {
                        boolean bl17 = false;
                        if (this.numreactions >= 10) {
                            bl17 = true;
                        }
                        boolean bl18 = false;
                        if (Processor.this.numalive == 1) {
                            bl18 = true;
                        }
                        boolean bl19 = bl17 & bl18 & (onedirection ^ true);
                        boolean bl20 = false;
                        if (bestmethod == 3) {
                            bl20 = true;
                        }
                        if (bl19 & bl20) {
                            fheading[0] = this.guessFactorAim(ox, oy, v, d, theading, headingdifference, r, p, true);
                        } else {
                            boolean bl21 = false;
                            if (this.numreactions >= 10) {
                                bl21 = true;
                            }
                            boolean bl22 = false;
                            if (Processor.this.numalive == 1) {
                                bl22 = true;
                            }
                            boolean bl23 = bl21 & bl22 & (onedirection ^ true);
                            boolean bl24 = false;
                            if (bestmethod == 2) {
                                bl24 = true;
                            }
                            fheading[0] = bl23 & bl24 ? this.guessFactorAim(ox, oy, v, d, theading, headingdifference, r, p, false) : this.circularAim(ox, oy, d, v, theading, p);
                        }
                    }
                }
            }
            return p;
        }

        public double directAim(double ox, double oy) {
            return Processor.findHeading(ox, oy, this.getX(), this.getY());
        }

        public double circularAim(double ox, double oy, double d, double v, double theading, double p) {
            double t;
            double period = this.time[this.amountdata - 1] - this.time[this.amountdata - 2];
            double theta = this.heading[this.amountdata - 1] - this.heading[this.amountdata - 2];
            theta = Processor.normalizeBearing(theta);
            theta /= period;
            double tx = this.getX();
            double ty = this.getY();
            double sin = Math.sin(theading * Math.PI / 180.0) * v;
            double cos = Math.cos(theading * Math.PI / 180.0) * v;
            double t1 = t = d / (20.0 - (double)3 * p);
            while (t >= 1.0) {
                t -= 1.0;
                theading += theta;
                theading = Processor.normalizeHeading(theading);
                sin = Math.sin(theading * Math.PI / 180.0) * v;
                cos = Math.cos(theading * Math.PI / 180.0) * v;
                if (v > 0.0) {
                    v = v <= this.maxv - 1.0 ? (v += 1.0) : this.maxv;
                } else if (v < 0.0) {
                    v = v >= -1.0 * (this.maxv - 1.0) ? (v -= 1.0) : -1.0 * this.maxv;
                }
                ty += cos;
                tx += sin;
                boolean bl = false;
                if (tx < 17.0) {
                    bl = true;
                }
                boolean bl2 = false;
                if (tx > Processor.this.fieldwidth - 17.0) {
                    bl2 = true;
                }
                boolean bl3 = bl | bl2;
                boolean bl4 = false;
                if (ty < 17.0) {
                    bl4 = true;
                }
                boolean bl5 = bl3 | bl4;
                boolean bl6 = false;
                if (ty > Processor.this.fieldheight - 17.0) {
                    bl6 = true;
                }
                if (bl5 | bl6) break;
            }
            t = Processor.findDist(tx, ty, ox, oy) / (20.0 - (double)3 * p);
            tx += sin * (t - t1) / period;
            ty += cos * (t - t1) / period;
            if (tx < 18.0) {
                tx = 18.0;
            } else if (tx > Processor.this.fieldwidth - 18.0) {
                tx = Processor.this.fieldwidth - 18.0;
            }
            if (ty < 18.0) {
                ty = 18.0;
            } else if (ty > Processor.this.fieldheight - 18.0) {
                ty = Processor.this.fieldheight - 18.0;
            }
            return Processor.findHeading(ox, oy, tx, ty);
        }

        public double guessFactorAim(double ox, double oy, double v, double d, double theading, double headingdifference, int r, double p, boolean random) {
            int s = 0;
            double guess = 0.0;
            double[] nr = new double[21];
            int[] nrsort = new int[21];
            int q = 0;
            while (q <= 20) {
                nrsort[q] = q;
                nr[q] = this.reactions[r][q];
                if (r <= 1) {
                    if (q == 0) {
                        int n = q;
                        nr[n] = nr[n] + this.reactions[r][1];
                    } else if (q == 20) {
                        int n = q;
                        nr[n] = nr[n] + this.reactions[r][19];
                    }
                } else if (q == 0) {
                    int n = q;
                    nr[n] = nr[n] + this.reactions[r][1] / (double)2;
                } else if (s == 20) {
                    int n = q;
                    nr[n] = nr[n] + this.reactions[r][19] / (double)2;
                }
                if (r >= 1) {
                    boolean bl = false;
                    if (q >= 1) {
                        bl = true;
                    }
                    boolean bl2 = false;
                    if (q <= 19) {
                        bl2 = true;
                    }
                    if (bl & bl2) {
                        int n = q;
                        nr[n] = nr[n] + (this.reactions[r][q - 1] + this.reactions[r][q + 1]) / (double)2;
                    }
                } else {
                    boolean bl = false;
                    if (q >= 1) {
                        bl = true;
                    }
                    boolean bl3 = false;
                    if (q <= 19) {
                        bl3 = true;
                    }
                    if (bl & bl3) {
                        int n = q;
                        nr[n] = nr[n] + (this.reactions[r][q - 1] + this.reactions[r][q + 1]);
                    }
                }
                ++q;
            }
            q = 19;
            while (q >= 0) {
                int u = 0;
                while (u <= q) {
                    if (nr[u] < nr[u + 1]) {
                        double tempd = nr[u];
                        int tempint = nrsort[u];
                        nr[u] = nr[u + 1];
                        nrsort[u] = nrsort[u + 1];
                        nr[u + 1] = tempd;
                        nrsort[u + 1] = tempint;
                    }
                    ++u;
                }
                --q;
            }
            boolean bl = false;
            if (v == 0.0) {
                bl = true;
            }
            boolean bl4 = false;
            if (this.amountdata >= 10) {
                bl4 = true;
            }
            if (bl & bl4) {
                v = Processor.findDist(this.getX(), this.getY(), this.x[this.amountdata - 10], this.y[this.amountdata - 10]) / (double)(this.getTime() - this.time[this.amountdata - 10]);
            }
            double bullettime = d / (20.0 - (double)3 * p);
            v *= Math.sin(Math.abs(headingdifference) * Math.PI / 180.0);
            double maxdist = 0.0;
            int f = 0;
            while ((double)f < bullettime) {
                maxdist += v;
                v = v >= 0.0 ? (v <= 7.0 ? (v += 1.0) : 8.0) : (v >= -7.0 ? (v -= 1.0) : -8.0);
                ++f;
            }
            if (random) {
                guess = nrsort[this.randfactor];
                guess -= 10.0;
                guess /= 10.0;
            } else {
                q = 0;
                while (q <= 20) {
                    guess = nrsort[q];
                    guess -= 10.0;
                    double nnx = (guess /= 10.0) * maxdist * Math.sin(theading * Math.PI / 180.0) + this.getX();
                    double nny = guess * maxdist * Math.cos(theading * Math.PI / 180.0) + this.getY();
                    boolean bl5 = false;
                    if (nnx < Processor.this.fieldwidth - 18.0) {
                        bl5 = true;
                    }
                    boolean bl6 = false;
                    if (nnx > 18.0) {
                        bl6 = true;
                    }
                    boolean bl7 = bl5 & bl6;
                    boolean bl8 = false;
                    if (nny < Processor.this.fieldheight - 18.0) {
                        bl8 = true;
                    }
                    boolean bl9 = bl7 & bl8;
                    boolean bl10 = false;
                    if (nny > 18.0) {
                        bl10 = true;
                    }
                    if (bl9 & bl10) break;
                    ++q;
                }
            }
            double theta = Math.atan(maxdist / d);
            theta *= 57.29577951308232;
            return Processor.findHeading(ox, oy, this.getX(), this.getY()) + (theta *= guess);
        }

        /*
         * Handled impossible loop by adding 'first' condition
         * Enabled aggressive block sorting
         */
        public double situationAim(double ox, double oy, double v, double d, double theading, double headingdifference, double p) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            double theta = 0.0;
            int bestsnapshot = 0;
            double besterror = 1000.0;
            double front = 0.0;
            double back = 0.0;
            double tx = this.getX();
            double ty = this.getY();
            int q = 0;
            boolean bl5 = true;
            do {
                if (!bl5 || (bl5 = false) || !true) {
                    tx += Math.sin(theading * Math.PI / 180.0) * 10.0;
                    ty += Math.cos(theading * Math.PI / 180.0) * 10.0;
                    front += 10.0;
                    ++q;
                }
                boolean bl6 = false;
                if (q < 20) {
                    bl6 = true;
                }
                boolean bl7 = false;
                if (tx < Processor.this.fieldwidth - 17.0) {
                    bl7 = true;
                }
                boolean bl8 = bl6 & bl7;
                boolean bl9 = false;
                if (tx > 17.0) {
                    bl9 = true;
                }
                boolean bl10 = bl8 & bl9;
                boolean bl11 = false;
                if (ty > 17.0) {
                    bl11 = true;
                }
                bl4 = bl10 & bl11;
                bl3 = false;
                if (!(ty < Processor.this.fieldheight - 17.0)) continue;
                bl3 = true;
            } while (bl4 & bl3);
            tx = this.getX();
            ty = this.getY();
            q = 0;
            boolean bl12 = true;
            do {
                if (!bl12 || (bl12 = false) || !true) {
                    tx -= Math.sin(theading * Math.PI / 180.0) * 10.0;
                    ty -= Math.cos(theading * Math.PI / 180.0) * 10.0;
                    back += 10.0;
                    ++q;
                }
                boolean bl13 = false;
                if (q < 20) {
                    bl13 = true;
                }
                boolean bl14 = false;
                if (tx < Processor.this.fieldwidth - 17.0) {
                    bl14 = true;
                }
                boolean bl15 = bl13 & bl14;
                boolean bl16 = false;
                if (tx > 17.0) {
                    bl16 = true;
                }
                boolean bl17 = bl15 & bl16;
                boolean bl18 = false;
                if (ty > 17.0) {
                    bl18 = true;
                }
                bl2 = bl17 & bl18;
                bl = false;
                if (!(ty < Processor.this.fieldheight - 17.0)) continue;
                bl = true;
            } while (bl2 & bl);
            double av = (this.heading[this.amountdata - 1] - this.heading[this.amountdata - 2]) / (double)(this.time[this.amountdata - 1] - this.time[this.amountdata - 2]);
            double acc = (this.velocity[this.amountdata - 1] - this.velocity[this.amountdata - 2]) / (double)(this.time[this.amountdata - 1] - this.time[this.amountdata - 2]);
            double avgvelocity = v;
            avgvelocity *= (double)(v < 0.0 ? -1 : 1);
            if (this.amountdata >= 10) {
                avgvelocity = Processor.findDist(this.x[this.amountdata - 10], this.y[this.amountdata - 10], this.getX(), this.getY()) / (double)(this.getTime() - this.time[this.amountdata - 10]);
                if (v < 0.0) {
                    theading += 180.0;
                    theading = Processor.normalizeHeading(theading);
                }
                if (Math.abs(Processor.normalizeBearing(Processor.findHeading(this.x[this.amountdata - 10], this.y[this.amountdata - 10], this.getX(), this.getY()) - theading)) > 90.0) {
                    avgvelocity *= -1.0;
                }
            }
            if (v < 0.0) {
                headingdifference += 180.0;
                v *= -1.0;
            }
            if ((headingdifference = Processor.normalizeBearing(headingdifference)) < 0.0) {
                av *= -1.0;
            }
            int q2 = 0;
            while (q2 < this.numsnapshots) {
                double tempfactor = this.snapshots[q2].getError(headingdifference, d, v, front, back, av, acc, p, avgvelocity, this.onedirectiontime);
                if (tempfactor < besterror) {
                    bestsnapshot = q2;
                    besterror = tempfactor;
                }
                ++q2;
            }
            if (headingdifference == 0.0) {
                headingdifference = 0.1;
            }
            theta = this.snapshots[bestsnapshot].getResult(p) * (headingdifference / Math.abs(headingdifference));
            return Processor.findHeading(ox, oy, this.getX(), this.getY()) + theta;
        }

        public Enemy() {
            this.velocity = new double[100];
            this.heading = new double[100];
            this.directions = new double[3];
            this.misses = new double[3];
            this.hits = new double[3];
            this.x = new double[100];
            this.y = new double[100];
            this.energy = new double[100];
            this.time = new long[100];
            this.reactions = new double[3][21];
            this.shots = new double[3][21];
            int c = 0;
            while (c < 4) {
                this.accuracy[c] = 0.0;
                ++c;
            }
            c = 0;
            while (c <= 2) {
                this.misses[c] = 0.0;
                this.hits[c] = 0.0;
                this.directions[c] = 0.0;
                int b = 0;
                while (b <= 20) {
                    this.reactions[c][b] = 0.0;
                    this.shots[c][b] = 0.0;
                    ++b;
                }
                ++c;
            }
            this.responses = new Reaction[10];
            this.bullets = new Dodge[10];
            this.snapshots = new Situation[100];
            this.tempsnapshots = new Situation[10];
            this.damage = 0.0;
            this.alive = true;
        }

        public class VBullet {
            private double ox;
            private double oy;
            private double heading;
            private double speed;
            private long time;

            public double isHit(double x, double y, long t) {
                double ny;
                double nx = this.ox + Math.sin(this.heading * Math.PI / 180.0) * (double)(t - this.time) * this.speed;
                if (Processor.findDist(nx, ny = this.oy + Math.cos(this.heading * Math.PI / 180.0) * (double)(t - this.time) * this.speed, x, y) < 25.0) {
                    return 1.0;
                }
                if (Processor.findDist(nx, ny, x, y) < 40.0) {
                    return 0.5;
                }
                return 0.0;
            }

            public VBullet(double x, double y, double h, double power, long t) {
                this.ox = x;
                this.oy = y;
                this.heading = h;
                this.speed = 20.0 - (double)3 * power;
                this.time = t;
            }
        }

        public class Reaction {
            private double tx;
            private double ty;
            private double myx;
            private double myy;
            private double v;
            private double maxtheta;
            private double time;
            private int range;
            private boolean havevb;

            public double getDistanceRemaining(double x, double y, long t) {
                return Processor.findDist(this.myx, this.myy, x, y) - ((double)t - this.time) * this.v;
            }

            public boolean atTarget(double x, double y, long t) {
                boolean bl = false;
                if (Processor.findDist(this.myx, this.myy, x, y) - 10.0 < ((double)t - this.time) * this.v) {
                    bl = true;
                }
                return bl;
            }

            public double getTX() {
                return this.tx;
            }

            public double getTY() {
                return this.ty;
            }

            public double getMyX() {
                return this.myx;
            }

            public double getMyY() {
                return this.myy;
            }

            public double getTheta() {
                return this.maxtheta;
            }

            public double getV() {
                return this.v;
            }

            public int getRange() {
                return this.range;
            }

            public boolean getHasVB() {
                return this.havevb;
            }

            public void nowHasVB() {
                this.havevb = true;
            }

            public Reaction(double x1, double y1, double x2, double y2, double v2, double max, int r, double t) {
                this.myx = x1;
                this.myy = y1;
                this.tx = x2;
                this.ty = y2;
                this.v = v2;
                this.maxtheta = max;
                this.time = t;
                this.range = r;
                this.havevb = false;
            }
        }

        public class Dodge {
            private double speed;
            private double tx;
            private double ty;
            private double myx;
            private double myy;
            private double time;
            private double dirfactor;
            private double myheading;

            public int getTimeTravelled(long t) {
                return (int)((double)t - this.time);
            }

            public int getFactor(double mx, double my, long t) {
                int factor;
                double maxbearing = Math.atan(8.0 / this.speed) * 180.0 / Math.PI;
                double heading1 = Processor.findHeading(this.tx, this.ty, this.myx, this.myy);
                double heading2 = Processor.findHeading(this.tx, this.ty, mx, my);
                double headingdiff = heading2 - heading1;
                headingdiff = Processor.normalizeBearing(headingdiff);
                double headingdiff2 = this.myheading - heading1;
                headingdiff2 = Processor.normalizeBearing(headingdiff2);
                if ((factor = (int)Math.round(10.0 * this.dirfactor * (headingdiff2 /= Math.abs(headingdiff2)) * headingdiff / maxbearing + 10.0)) < 0) {
                    factor = 0;
                } else if (factor > 20) {
                    factor = 20;
                }
                return factor;
            }

            public boolean isThisBullet(double x, double y, long t) {
                boolean bl = false;
                if (Math.abs(((double)t - this.time) * this.speed - Processor.findDist(x, y, this.tx, this.ty)) < 20.0) {
                    bl = true;
                }
                return bl;
            }

            public boolean movedPast(double x, double y, long t) {
                boolean bl = false;
                if (Processor.findDist(this.tx, this.ty, x, y) < this.speed * ((double)t - this.time) + 20.0) {
                    bl = true;
                }
                return bl;
            }

            public double getX() {
                return this.tx;
            }

            public double getV() {
                return this.speed;
            }

            public double getDistRemaining(double x, double y, long t) {
                return Processor.findDist(x, y, this.tx, this.ty) - ((double)t - this.time) * this.speed - 20.0;
            }

            public double getY() {
                return this.ty;
            }

            public Dodge(double v, double x, double y, double mx, double my, double d, double h, long t) {
                this.speed = v;
                this.dirfactor = d;
                this.tx = x;
                this.ty = y;
                this.myx = mx;
                this.myy = my;
                this.time = t;
                this.myheading = h;
            }
        }

        public class Situation {
            private double headingdifference;
            private double distance;
            private double velocity;
            private double dodgedegrees;
            private double front;
            private double back;
            private double angularvelocity;
            private double acceleration;
            private double power;
            private double avgvelocity;
            private int onedirectiontime;
            private int roundstored;

            public void setResult(double degrees) {
                this.dodgedegrees = degrees;
                this.dodgedegrees *= this.headingdifference / Math.abs(this.headingdifference);
                this.headingdifference = Math.abs(this.headingdifference);
            }

            public double getError(double hd, double dist, double v, double f, double b, double av, double acc, double p, double avgv, int dirtime) {
                double error = 0.0;
                error += Math.abs(hd - this.headingdifference) * (double)4 / 180.0;
                error += Math.abs(dist - this.distance) * (double)2 / 100.0;
                error += Math.abs(v - this.velocity) * (double)4 / 8.0;
                error += Math.abs(f - this.front) / 200.0;
                error += Math.abs(b - this.back) / 200.0;
                error += Math.abs(av - this.angularvelocity) / 10.0;
                error += Math.abs(acc - this.acceleration) / (double)2;
                error += Math.abs(p - this.power) / (double)3;
                error += Math.abs(avgv - this.avgvelocity) * (double)4 / 8.0;
                if (dirtime > 30) {
                    dirtime = 30;
                }
                error += (double)(Math.abs(dirtime - this.onedirectiontime) / 30);
                int rounddiff = Processor.this.roundnum - this.roundstored;
                if (rounddiff > 16) {
                    rounddiff = 16;
                }
                return error += Math.sqrt(rounddiff) / (double)2;
            }

            public double getResult(double p) {
                return this.dodgedegrees * (20.0 - (double)3 * this.power) / (20.0 - (double)3 * p);
            }

            public Situation(double hd, double dist, double v, double f, double b, double av, double acc, double p, double avgv, int dirtime) {
                this.headingdifference = hd;
                this.distance = dist;
                this.velocity = v;
                this.front = f;
                this.back = b;
                this.angularvelocity = av;
                this.acceleration = acc;
                this.power = p;
                this.avgvelocity = avgv;
                this.roundstored = Processor.this.roundnum;
                if (dirtime > 30) {
                    dirtime = 30;
                }
                this.onedirectiontime = dirtime;
            }
        }
    }
}

