/*
 * Decompiled with CFR 0.152.
 */
package cs;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Grudge
extends AdvancedRobot {
    static LinkedHashSet<String> grudges = new LinkedHashSet();
    HashSet<String> dead = new HashSet();

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.dead.add(e.getName());
    }

    public void onDeath(DeathEvent e) {
        System.out.println("Grudge List");
        int n = 0;
        Iterator it = grudges.iterator();
        while (it.hasNext()) {
            System.out.printf("#%d. %s\n", ++n, it.next());
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        int deadCount = 0;
        for (String name : grudges) {
            if (e.getName().equals(name)) {
                double angleToEnemy = this.getHeadingRadians() + e.getBearingRadians();
                this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(angleToEnemy - this.getGunHeadingRadians())));
                this.setFire(420.0 / e.getDistance());
                this.setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((double)(angleToEnemy - this.getRadarHeadingRadians())));
                this.goTo(angleToEnemy, e.getDistance());
                return;
            }
            if (this.dead.contains(name)) {
                ++deadCount;
                continue;
            }
            return;
        }
        if (deadCount == grudges.size()) {
            this.setTurnGunLeftRadians(6.0);
            this.setTurnRightRadians(6.0);
            this.setAhead(5.0);
        }
    }

    private void goTo(double angle, double distance) {
        this.setTurnRightRadians(Math.tan(angle -= this.getHeadingRadians()));
        this.setAhead(distance * Math.cos(angle));
    }

    public void onHitByBullet(HitByBulletEvent e) {
        grudges.add(e.getName());
    }
}

