/*
 * Decompiled with CFR 0.152.
 */
package jcz.linio.util;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import jcz.linio.util.LUtils;
import jcz.linio.util.PreciseWave;
import robocode.util.Utils;

public class PreciseUtils {
    public static double MARGIN = 18.0;
    public static double WIDTH = 800.0;
    public static double HEIGHT = 600.0;

    public static double[] getPreciseMEAs(Point2D.Double enemyLoc, double enemyHeading, double enemyVel, Point2D.Double myLoc, double power, double rotDir, ArrayList<Point2D.Double> pointsList) {
        ArrayList<Point2D.Double> endPoints = PreciseUtils.getEndPoints(enemyLoc, enemyHeading, enemyVel, myLoc, power, pointsList);
        double negAngle = Double.POSITIVE_INFINITY;
        double posAngle = Double.NEGATIVE_INFINITY;
        double directBearing = PreciseUtils.absoluteBearing(myLoc, enemyLoc);
        int i = endPoints.size() - 1;
        while (i >= 0) {
            double offset = Utils.normalRelativeAngle((double)(PreciseUtils.absoluteBearing(myLoc, endPoints.get(i)) - directBearing));
            if (offset < negAngle) {
                negAngle = offset;
            }
            if (offset > posAngle) {
                posAngle = offset;
            }
            --i;
        }
        if (rotDir == 1.0) {
            return new double[]{-negAngle, posAngle};
        }
        return new double[]{posAngle, -negAngle};
    }

    public static ArrayList<Point2D.Double> getEndPoints(Point2D.Double enemyLoc, double enemyHeading, double enemyVel, Point2D.Double myLoc, double power, ArrayList<Point2D.Double> pointsList) {
        ArrayList<Point2D.Double> endPoints = new ArrayList<Point2D.Double>();
        Point2D.Double[] elocs = PreciseUtils.getSmoothedEndPoints(enemyLoc, enemyHeading, enemyVel, myLoc, power, pointsList);
        int i = 0;
        while (i < elocs.length) {
            endPoints.add(elocs[i]);
            ++i;
        }
        elocs = PreciseUtils.getDirectEndPoints(enemyLoc, enemyHeading, enemyVel, myLoc, power, endPoints, pointsList);
        i = 0;
        while (i < elocs.length) {
            endPoints.add(elocs[i]);
            ++i;
        }
        elocs = PreciseUtils.getStraightEndPoints(enemyLoc, enemyHeading, enemyVel, myLoc, power, pointsList);
        i = 0;
        while (i < elocs.length) {
            endPoints.add(elocs[i]);
            ++i;
        }
        return endPoints;
    }

    public static Point2D.Double[] getSmoothedEndPoints(Point2D.Double enemyLoc, double enemyHeading, double enemyVel, Point2D.Double myLoc, double power, ArrayList<Point2D.Double> pointsList) {
        Point2D.Double[] locs = new Point2D.Double[2];
        double bulletVelocity = 20.0 - 3.0 * power;
        int i = -1;
        while (i < 2) {
            double angle = enemyHeading + 1.5707963267948966 * (double)(i - 1);
            double vel = (double)i * enemyVel;
            Point2D.Double eloc = enemyLoc;
            double bulletDistance = 0.0;
            double goalAngle = PreciseUtils.absoluteBearing(myLoc, eloc) + 1.5707963267948966;
            if (Math.cos(goalAngle - angle) < 0.0) {
                goalAngle += Math.PI;
            }
            while (bulletDistance < eloc.distance(myLoc)) {
                Point2D.Double testPoint = PreciseUtils.project(eloc, goalAngle, 120.0);
                double testBearing = PreciseUtils.absoluteBearing(myLoc, testPoint);
                double testDistance = testPoint.distance(myLoc);
                while (MARGIN > testPoint.x || testPoint.x > WIDTH - MARGIN || MARGIN > testPoint.y || testPoint.y > HEIGHT - MARGIN) {
                    testPoint = PreciseUtils.project(myLoc, testBearing, testDistance *= 0.95);
                }
                double maxTurn = 0.17453292519943295 - 0.01308996938995747 * Math.abs(vel);
                double smoothAngle = PreciseUtils.absoluteBearing(eloc, testPoint);
                double wantTurn = Utils.normalRelativeAngle((double)(smoothAngle - angle));
                angle = PreciseUtils.limit(angle - maxTurn, angle + wantTurn, angle + maxTurn);
                vel = vel < 0.0 ? (vel += 2.0) : Math.min(8.0, vel + 1.0);
                Point2D.Double nextLoc = PreciseUtils.project(eloc, angle, vel);
                if (nextLoc.x > WIDTH - MARGIN || nextLoc.x < MARGIN || nextLoc.y > HEIGHT - MARGIN || nextLoc.y < MARGIN) break;
                eloc = nextLoc;
                pointsList.add(eloc);
                bulletDistance += bulletVelocity;
            }
            locs[(i + 1) / 2] = eloc;
            i += 2;
        }
        return locs;
    }

    public static Point2D.Double[] getDirectEndPoints(Point2D.Double enemyLoc, double enemyHeading, double enemyVel, Point2D.Double myLoc, double power, ArrayList<Point2D.Double> prevLocs, ArrayList<Point2D.Double> pointsList) {
        Point2D.Double[] locs = new Point2D.Double[2];
        double bulletVelocity = 20.0 - 3.0 * power;
        int i = -1;
        while (i < 2) {
            double angle = enemyHeading + 1.5707963267948966 * (double)(i - 1);
            double vel = (double)i * enemyVel;
            Point2D.Double eloc = enemyLoc;
            double bulletDistance = 0.0;
            double goalAngle = PreciseUtils.absoluteBearing(eloc, prevLocs.get((i + 1) / 2));
            while (bulletDistance < eloc.distance(myLoc)) {
                Point2D.Double testPoint = PreciseUtils.project(eloc, goalAngle, 90.0);
                double testBearing = PreciseUtils.absoluteBearing(myLoc, testPoint);
                double testDistance = testPoint.distance(myLoc);
                while (MARGIN > testPoint.x || testPoint.x > WIDTH - MARGIN || MARGIN > testPoint.y || testPoint.y > HEIGHT - MARGIN) {
                    testPoint = PreciseUtils.project(myLoc, testBearing, testDistance *= 0.95);
                }
                double maxTurn = 0.17453292519943295 - 0.01308996938995747 * Math.abs(vel);
                double smoothAngle = PreciseUtils.absoluteBearing(eloc, testPoint);
                double wantTurn = Utils.normalRelativeAngle((double)(smoothAngle - angle));
                angle = PreciseUtils.limit(angle - maxTurn, angle + wantTurn, angle + maxTurn);
                vel = vel < 0.0 ? (vel += 2.0) : Math.min(8.0, vel + 1.0);
                Point2D.Double nextLoc = PreciseUtils.project(eloc, angle, vel);
                if (nextLoc.x > WIDTH - MARGIN || nextLoc.x < MARGIN || nextLoc.y > HEIGHT - MARGIN || nextLoc.y < MARGIN) break;
                eloc = nextLoc;
                pointsList.add(eloc);
                bulletDistance += bulletVelocity;
            }
            locs[(i + 1) / 2] = eloc;
            i += 2;
        }
        return locs;
    }

    public static Point2D.Double[] getStraightEndPoints(Point2D.Double enemyLoc, double enemyHeading, double enemyVel, Point2D.Double myLoc, double power, ArrayList<Point2D.Double> pointsList) {
        Point2D.Double[] locs = new Point2D.Double[2];
        double bulletVelocity = 20.0 - 3.0 * power;
        int i = -1;
        while (i < 2) {
            double angle = enemyHeading + 1.5707963267948966 * (double)(i - 1);
            double vel = (double)i * enemyVel;
            Point2D.Double eloc = enemyLoc;
            double bulletDistance = 0.0;
            double goalAngle = PreciseUtils.absoluteBearing(myLoc, eloc) + 1.5707963267948966;
            if (Math.cos(goalAngle - angle) < 0.0) {
                goalAngle += Math.PI;
            }
            while (bulletDistance < eloc.distance(myLoc)) {
                double maxTurn = 0.17453292519943295 - 0.01308996938995747 * Math.abs(vel);
                double wantTurn = Utils.normalRelativeAngle((double)(goalAngle - angle));
                angle = PreciseUtils.limit(angle - maxTurn, angle + wantTurn, angle + maxTurn);
                vel = vel < 0.0 ? (vel += 2.0) : Math.min(8.0, vel + 1.0);
                Point2D.Double nextLoc = PreciseUtils.project(eloc, angle, vel);
                if (nextLoc.x > WIDTH - MARGIN || nextLoc.x < MARGIN || nextLoc.y > HEIGHT - MARGIN || nextLoc.y < MARGIN) break;
                eloc = nextLoc;
                pointsList.add(eloc);
                bulletDistance += bulletVelocity;
            }
            locs[(i + 1) / 2] = eloc;
            i += 2;
        }
        return locs;
    }

    public static Point2D.Double project(Point2D.Double p, double angle, double distance) {
        return new Point2D.Double(p.x + distance * Math.sin(angle), p.y + distance * Math.cos(angle));
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static int intersects(Point2D.Double botLocation, PreciseWave wave) {
        double[] distSq = new double[]{wave.fireLoc.distanceSq(botLocation.x - 18.0, botLocation.y + 18.0), wave.fireLoc.distanceSq(botLocation.x + 18.0, botLocation.y + 18.0), wave.fireLoc.distanceSq(botLocation.x + 18.0, botLocation.y - 18.0), wave.fireLoc.distanceSq(botLocation.x - 18.0, botLocation.y - 18.0)};
        int score = 0;
        if (LUtils.sqr(wave.distanceTraveled) > Math.min(Math.min(distSq[0], distSq[1]), Math.min(distSq[2], distSq[3]))) {
            ++score;
        }
        if (LUtils.sqr(wave.distanceTraveled - wave.bulletVelocity) < Math.max(Math.max(distSq[0], distSq[1]), Math.max(distSq[2], distSq[3]))) {
            score += 2;
        }
        return score;
    }

    public static double[] getIntersectionRange(Point2D.Double botLocation, PreciseWave wave) {
        int k;
        Point2D.Double[] testPoints;
        int j;
        double[] yBounds = new double[]{botLocation.y - 18.0, botLocation.y + 18.0};
        double[] xBounds = new double[]{botLocation.x - 18.0, botLocation.x + 18.0};
        double[] radii = new double[]{wave.distanceTraveled, wave.distanceTraveled - wave.bulletVelocity};
        ArrayList<Point2D.Double> intersects = new ArrayList<Point2D.Double>();
        int i = 0;
        while (i < 2) {
            j = 0;
            while (j < 2) {
                testPoints = PreciseUtils.vertIntersect(wave.fireLoc.x, wave.fireLoc.y, radii[i], xBounds[j]);
                k = 0;
                while (k < testPoints.length) {
                    if (PreciseUtils.inBounds(testPoints[k].y, yBounds)) {
                        intersects.add(testPoints[k]);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 2) {
            j = 0;
            while (j < 2) {
                testPoints = PreciseUtils.horizIntersect(wave.fireLoc.x, wave.fireLoc.y, radii[i], yBounds[j]);
                k = 0;
                while (k < testPoints.length) {
                    if (PreciseUtils.inBounds(testPoints[k].x, xBounds)) {
                        intersects.add(testPoints[k]);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 2) {
            j = 0;
            while (j < 2) {
                Point2D.Double testCorner = new Point2D.Double(xBounds[i], yBounds[j]);
                double distSq = testCorner.distanceSq(wave.fireLoc);
                if (distSq <= LUtils.sqr(radii[0]) && distSq > LUtils.sqr(radii[1])) {
                    intersects.add(testCorner);
                }
                ++j;
            }
            ++i;
        }
        double antiClockAngle = 1.0;
        double clockAngle = -1.0;
        Point2D.Double antiClock = null;
        Point2D.Double clock = null;
        double absBearing = LUtils.angle(wave.fireLoc, botLocation);
        for (Point2D.Double p : intersects) {
            double angDiff = PreciseUtils.fastRelativeAngle(LUtils.angle(wave.fireLoc, p) - absBearing);
            if (angDiff > clockAngle) {
                clockAngle = angDiff;
                clock = p;
            }
            if (!(angDiff < antiClockAngle)) continue;
            antiClockAngle = angDiff;
            antiClock = p;
        }
        return new double[]{PreciseUtils.fastAbsoluteAngle(antiClockAngle + absBearing), PreciseUtils.fastAbsoluteAngle(clockAngle + absBearing)};
    }

    static boolean inBounds(double q, double[] bounds) {
        return bounds[0] <= q && q <= bounds[1];
    }

    public static double fastRelativeAngle(double angle) {
        return angle < -Math.PI ? angle + Math.PI * 2 : (angle > Math.PI ? angle - Math.PI * 2 : angle);
    }

    public static double fastAbsoluteAngle(double angle) {
        return angle > Math.PI * 2 ? angle - Math.PI * 2 : (angle < 0.0 ? angle + Math.PI * 2 : angle);
    }

    static Point2D.Double[] vertIntersect(double centerX, double centerY, double r, double intersectX) {
        double deltaX = centerX - intersectX;
        double sqrtVal = r * r - deltaX * deltaX;
        if (sqrtVal < 0.0) {
            return new Point2D.Double[0];
        }
        sqrtVal = Math.sqrt(sqrtVal);
        return new Point2D.Double[]{new Point2D.Double(intersectX, centerY + sqrtVal), new Point2D.Double(intersectX, centerY - sqrtVal)};
    }

    static Point2D.Double[] horizIntersect(double centerX, double centerY, double r, double intersectY) {
        double deltaY = centerY - intersectY;
        double sqrtVal = r * r - deltaY * deltaY;
        if (sqrtVal < 0.0) {
            return new Point2D.Double[0];
        }
        sqrtVal = Math.sqrt(sqrtVal);
        return new Point2D.Double[]{new Point2D.Double(centerX + sqrtVal, intersectY), new Point2D.Double(centerX - sqrtVal, intersectY)};
    }
}

