/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import metal.shared.MRanmar;

public class MMath {
    private static double degPerRad = 57.29577951308232;

    public static double abs(double d) {
        return Math.abs(d);
    }

    public static double acos(double val) {
        return Math.toDegrees(Math.acos(val));
    }

    public static double asin(double val) {
        return Math.toDegrees(Math.asin(val));
    }

    public static double atan(double val) {
        return Math.toDegrees(Math.atan(val));
    }

    public static double atan2(double x, double y) {
        return Math.toDegrees(Math.atan2(x, y));
    }

    public static double clamp(double max, double min, double value) {
        return Math.min(max, Math.max(min, value));
    }

    public static double cos(double deg) {
        return Math.cos(Math.toRadians(deg));
    }

    public static double random(double value1, double value2) {
        return Math.random() * Math.abs(value1 - value2) + Math.min(value1, value2);
    }

    public static double random2(double value1, double value2) {
        MRanmar r = new MRanmar();
        return r.raw() * Math.abs(value1 - value2) + Math.min(value1, value2);
    }

    public static double randomLarge(double d, double d1) {
        return d1 * Math.pow(Math.random(), 1.0 / (d + 1.0));
    }

    public static double randomSmall(double d, double d1) {
        return d1 * Math.sqrt(-2.0 * Math.log(d) / d);
    }

    public static double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public static double rollingAvg(double value, double newEntry, double n) {
        return (value * n + newEntry) / (n + 1.0);
    }

    public static double sign(double value) {
        return value < 0.0 ? -1.0 : 1.0;
    }

    public static double sin(double deg) {
        return Math.sin(Math.toRadians(deg));
    }

    public static double tan(double deg) {
        return Math.tan(Math.toRadians(deg));
    }
}

