/*
 * Decompiled with CFR 0.152.
 */
package MGAM;

public class Vec2D {
    public double x;
    public double y;
    private int hash = 0;

    public Vec2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public double distance(double x1, double y1) {
        double a = this.getX() - x1;
        double b = this.getY() - y1;
        return Math.sqrt(a * a + b * b);
    }

    public double distance(Vec2D point) {
        return this.distance(point.getX(), point.getY());
    }

    public Vec2D add(double x, double y) {
        return new Vec2D(this.getX() + x, this.getY() + y);
    }

    public Vec2D add(Vec2D point) {
        return this.add(point.getX(), point.getY());
    }

    public Vec2D subtract(double x, double y) {
        return new Vec2D(this.getX() - x, this.getY() - y);
    }

    public Vec2D multiply(double factor) {
        return new Vec2D(this.getX() * factor, this.getY() * factor);
    }

    public Vec2D subtract(Vec2D point) {
        return this.subtract(point.getX(), point.getY());
    }

    public Vec2D normalize() {
        double mag = this.magnitude();
        if (mag == 0.0) {
            return new Vec2D(0.0, 0.0);
        }
        return new Vec2D(this.getX() / mag, this.getY() / mag);
    }

    public Vec2D midpoint(double x, double y) {
        return new Vec2D(x + (this.getX() - x) / 2.0, y + (this.getY() - y) / 2.0);
    }

    public Vec2D midpoint(Vec2D point) {
        return this.midpoint(point.getX(), point.getY());
    }

    public double angle(double x, double y) {
        double ay;
        double ax = this.getX();
        double delta = (ax * x + (ay = this.getY()) * y) / Math.sqrt((ax * ax + ay * ay) * (x * x + y * y));
        if (delta > 1.0) {
            return 0.0;
        }
        if (delta < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(delta));
    }

    public double angle(Vec2D point) {
        return this.angle(point.getX(), point.getY());
    }

    public double angle(Vec2D p1, Vec2D p2) {
        double by;
        double x = this.getX();
        double y = this.getY();
        double ax = p1.getX() - x;
        double ay = p1.getY() - y;
        double bx = p2.getX() - x;
        double delta = (ax * bx + ay * (by = p2.getY() - y)) / Math.sqrt((ax * ax + ay * ay) * (bx * bx + by * by));
        if (delta > 1.0) {
            return 0.0;
        }
        if (delta < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(delta));
    }

    public double magnitude() {
        double x = this.getX();
        double y = this.getY();
        return Math.sqrt(x * x + y * y);
    }

    public double dotProduct(double x, double y) {
        return this.getX() * x + this.getY() * y;
    }

    public double dotProduct(Vec2D vector) {
        return this.dotProduct(vector.getX(), vector.getY());
    }

    public Vec2D rotateRadians(double angle) {
        Vec2D tempRotate = new Vec2D(0.0, 0.0);
        tempRotate.x = this.getX() * Math.cos(angle) - this.getY() * Math.sin(angle);
        tempRotate.y = this.getX() * Math.sin(angle) + this.getY() * Math.cos(angle);
        return tempRotate;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Vec2D) {
            Vec2D other = (Vec2D)obj;
            return this.getX() == other.getX() && this.getY() == other.getY();
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long bits = 7L;
            bits = 31L * bits + Double.doubleToLongBits(this.getX());
            bits = 31L * bits + Double.doubleToLongBits(this.getY());
            this.hash = (int)(bits ^ bits >> 32);
        }
        return this.hash;
    }

    public String toString() {
        return "Vec2D [x = " + this.getX() + ", y = " + this.getY() + "]";
    }
}

