/*
 * Decompiled with CFR 0.152.
 */
package gf.Centaur.utils;

import gf.Centaur.utils.ExecutingRobot;
import gf.Centaur.utils.Tools;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class VirtualRobot {
    String name;
    private Point2D.Double position;
    private double bearing;
    private double bearingRadians;
    private double heading;
    private double headingRadians;
    private double distance;
    private double energy;
    private double velocity = 0.0;
    private long time;
    private double acceleration;

    public VirtualRobot(ScannedRobotEvent e, AdvancedRobot robot) {
        this.set(e, robot);
    }

    public VirtualRobot(AdvancedRobot own, ExecutingRobot robot) {
        double x = own.getX() - robot.getX();
        double y = own.getY() - robot.getY();
        this.time = own.getTime();
        this.name = own.getName();
        this.bearingRadians = Utils.normalRelativeAngle((double)(Tools.toAbsolute(Math.atan2(y, x)) - robot.getHeadingRadians()));
        this.bearing = Math.toDegrees(this.bearingRadians);
        this.heading = own.getHeading();
        this.headingRadians = own.getHeadingRadians();
        this.distance = Math.sqrt(x * x + y * y);
        this.energy = own.getEnergy();
        this.velocity = own.getVelocity();
        this.position = new Point2D.Double(own.getX(), own.getY());
        double dist = own.getDistanceRemaining();
        this.acceleration = dist == 0.0 || Math.abs(this.velocity) >= 8.0 ? 0.0 : (double)(Math.abs(dist) <= 20.0 ? -2 : 1);
    }

    public VirtualRobot(VirtualRobot other, ExecutingRobot robot) {
        double x = other.getX() - robot.getX();
        double y = other.getY() - robot.getY();
        this.time = other.getTime();
        this.name = other.getName();
        this.bearingRadians = Utils.normalRelativeAngle((double)(Tools.toAbsolute(Math.atan2(y, x)) - robot.getHeadingRadians()));
        this.bearing = Math.toDegrees(this.bearingRadians);
        this.heading = other.getHeading();
        this.headingRadians = other.getHeadingRadians();
        this.distance = Math.sqrt(x * x + y * y);
        this.energy = other.getEnergy();
        this.velocity = other.getVelocity();
        this.position = other.getPosition();
        this.acceleration = other.getAcceleration();
    }

    public void set(ScannedRobotEvent e, AdvancedRobot robot) {
        this.time = robot.getTime();
        this.name = e.getName();
        this.bearing = e.getBearing();
        this.bearingRadians = e.getBearingRadians();
        this.heading = e.getHeading();
        this.headingRadians = e.getHeadingRadians();
        this.distance = e.getDistance();
        this.energy = e.getEnergy();
        double vDiff = Math.abs(e.getVelocity() - this.velocity);
        this.acceleration = Math.abs(e.getVelocity()) >= 8.0 ? 0 : (vDiff > 0.0 ? 1 : (vDiff == 0.0 ? 0 : -2));
        this.velocity = e.getVelocity();
        double absoluteBearing = Utils.normalRelativeAngle((double)(robot.getHeadingRadians() + e.getBearingRadians()));
        double x = robot.getX() + e.getDistance() * Math.sin(absoluteBearing);
        double y = robot.getY() + e.getDistance() * Math.cos(absoluteBearing);
        this.position = new Point2D.Double(x, y);
    }

    public Point2D.Double getPosition() {
        return this.position;
    }

    public double getX() {
        return this.position.getX();
    }

    public double getY() {
        return this.position.getY();
    }

    public String getName() {
        return this.name;
    }

    public double getBearing() {
        return this.bearing;
    }

    public double getBearingRadians() {
        return this.bearingRadians;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getHeadingRadians() {
        return this.headingRadians;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getLateralVelocity(ExecutingRobot robot) {
        double x = this.getX() - robot.getX();
        double y = this.getY() - robot.getY();
        double bearingRadians = Utils.normalRelativeAngle((double)(Tools.toAbsolute(Math.atan2(y, x)) - robot.getHeadingRadians()));
        return this.velocity * Math.sin(this.headingRadians - bearingRadians - robot.getHeadingRadians());
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public long getTime() {
        return this.time;
    }
}

