package axeBots;
import robocode.*;

import java.awt.Color;
import java.awt.geom.*;
//import java.text.DecimalFormat;
import java.text.DecimalFormat;
import java.util.*;

import axeBots.data.BotData;
import axeBots.data.BotScore;
import axeBots.data.SegmentedGFs;
//import axeBots.data.SegmentedGFs;
import axeBots.data.StaticDataCenter;
import axeBots.silversurfer.*;
import axeBots.pilot.AntiMirrorPilot;
import axeBots.pilot.AxePilot;
import axeBots.pilot.FlatPilot;
import axeBots.pilot.WaveSurferPilot;
import axeBots.pilot.navigator.Course;
import axeBots.pilot.navigator.WaveNavigator;
import axeBots.pilot.waves.EnemyWave;
import axeBots.util.*;

/**
 * SilverSurfer - 13/06/2004
 * 
 * @author Axe
 * 
 * This code is released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL (Basically it means you must keep the
 * code public if you base any code on it.) Not basically, i think it means that
 * the knowledge should not be retained, but shared. We must all remember that
 * the veins of the Knowledge must flow. Quoting(or some) PEZ�s comment about
 * OpenSouce: "At least is a good Karma".
 */
public class SilverSurfer extends AxeBot {
	private double energyDecay;
	private FlatPilot flatPilot;
	private AxePilot myPilot = null;
	private AntiMirrorPilot amPilot;
	private boolean threadGun = true;
	private AxeShooter as = new AxeShooter();
	private long lasttime = 0;
	private boolean wideScan = false;
	private boolean fullScan = false;
	private boolean rightScan = false;
	private boolean leftScan = false;
	private double scanStartTime = Double.NaN;
	private double lowest = Double.NaN;
	private double hightest = Double.NaN;
	private boolean choosen = false;
	private double lastEnergy = 0;
	private static BotScore scorer = new BotScore("SilverSurfer");
	private boolean firing = false;

	private double botDim;
	private int acertados = 0;
	private AxeAvoider wallAlert = null;
	private AxeAvoider centerAlert = null;
	private AxeAvoider wallBackUp = null;
	private AxeTargetMan tMan = null;
	private AxeTarget myTarget = null;
	private ArrayList posHistory = new ArrayList();
	private ArrayList velHistory = new ArrayList();

	private int countdown;
	private static boolean suicideSolution = false;
	private long lastFireTime;

	public SilverSurfer() {
		super();
		super.setIt(this);
	}
	private void fireAtWill(double gunAngle) {
		setTurnGunRight(turnGunTo(gunAngle));
		as.start();
	}

	private void setDuel() {
		if (this.getOthers() == 1) {
			tMan.setDuel(true);
		}
	}
	public Point2D.Double getPos(int atTime) {

		atTime = (posHistory.size() < atTime) ? posHistory.size() : atTime;
		return ((AxeVector) posHistory.get(atTime - 1)).getEndPoint();
	}

	public double getLastDesloc() {
		int atTime = posHistory.size();
		return ((AxeVector) posHistory.get(atTime - 1)).getEndPoint().distance(
				((AxeVector) posHistory.get(atTime - 2)).getEndPoint());
	}

	/**
	 * retorna o sentido da minha velocidade no instante.
	 * 
	 * @param atTime
	 * @param target
	 * @return
	 */
	public int getDirection(int atTime) {
		//		ALTERADO: INDICES DE TEMPO ERRADOS! BUG!
		atTime = (atTime > (velHistory.size() - 1))
				? velHistory.size() - 1
				: atTime - 1;
		int vel = 0;
		while (atTime >= 0
				&& (vel = ((Integer) velHistory.get(atTime--)).intValue()) == 0);
		return (vel < 0) ? -1 : 1;
	}
	public int getVelocity(int atTime) {
		//ALTERADO: INDICES DE TEMPO ERRADOS! BUG!
		atTime = (atTime > (velHistory.size() - 1))
				? velHistory.size() - 1
				: atTime - 1;
		return ((Integer) velHistory.get(atTime)).intValue();
	}
	public int getAcceleration(int atTime) {
		//		ALTERADO: INDICES DE TEMPO ERRADOS! BUG!
		atTime = (atTime > (velHistory.size() - 1))
				? velHistory.size() - 1
				: atTime - 1;
		int pre = ((Integer) velHistory.get(atTime > 0 ? atTime - 1 : atTime))
				.intValue();
		int pos = ((Integer) velHistory.get(atTime)).intValue();
		return Math.abs(pos) - Math.abs(pre);
	}
	private void addHistoryPos(double x, double y, double time) {
		double timesDelta = time - posHistory.size();
		AxeVector last;
		if (this.posHistory.size() == 0) {
			last = new AxeVector(x, y);
		} else {
			last = (AxeVector) posHistory.get(posHistory.size() - 1);
		}
		double x0 = last.getX();
		double y0 = last.getY();
		double Dx = x - x0;
		double Dy = y - y0;
		double dx = Dx / timesDelta;
		double dy = Dy / timesDelta;
		AxeVector interpol = null;
		for (int i = 0; i < timesDelta; i++) {
			x0 += dx;
			y0 += dy;
			interpol = new AxeVector(x0, y0); //, tetha, mod);
			posHistory.add(interpol);
			velHistory.add(new Integer((int) this.getVelocity()));
		}
	}
	/**
	 * run: Move around the walls
	 */
	public void run() {

		if (suicideSolution) {
			throw new RuntimeException(
					"This bot is disabled due to the absence of -Dsun.io.useCanonCaches=true in the jvm.");
		}

		System.gc();

		this.setRe(true);
		setEventPriority("HitByBulletEvent", 85);
		this.setBotDim(Math.max(this.getHeight(), this.getWidth()));
		this.setTotBots(this.getOthers() + 1);
		tMan = new AxeTargetMan(this.getBattleFieldHeight(), this
				.getBattleFieldWidth());
		super.setField(new Rectangle2D.Double(0, 0, this.getBattleFieldWidth(),
				this.getBattleFieldHeight()));
		if (BEE) {
			this.setColors(Color.yellow, Color.blue, Color.blue);
		} else {
			Color silver = new Color(220, 220, 255);
			this.setColors(silver, silver, Color.white);
		}
		double rw = this.getWidth();
		double rh = this.getHeight();
		scorer.newRound();
		EnemyWave.clear();
		flatPilot = new WaveSurferPilot(); //FlatPilot();
		amPilot = new AntiMirrorPilot();
		botDim = Math.max(rw, rh);
		tMan.setMaxOpps(this.getOthers());
		double d = (botDim * 2.0);
		double x1 = d;
		double y1 = d;
		double x2 = this.getBattleFieldWidth() - d;
		double y2 = this.getBattleFieldHeight() - d;
		wallAlert = new AxeAvoider(this, x1, y1, x2, y2, false);
		d = d + (botDim * 3);
		x1 = d;
		y1 = d;
		x2 = this.getBattleFieldWidth() - d;
		y2 = this.getBattleFieldHeight() - d;
		centerAlert = new AxeAvoider(this, x1, y1, x2, y2, true);
		d = botDim * 1.50;
		x1 = d;
		y1 = d;
		x2 = this.getBattleFieldWidth() - d;
		y2 = this.getBattleFieldHeight() - d;
		wallBackUp = new AxeAvoider(this, x1, y1, x2, y2, false);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		doFullScan();
		lastEnergy = this.getEnergy();
		execute();
		int i = 0;
		this.setDuel();
		countdown = this.getNumRounds() - this.getRoundNum();

		while (true) {
			if (this.getTime() > (lasttime + 1)) {
				out.println(" ********** PULOU ROUND:" + lasttime + " - "
						+ this.getTime());
			}
			this.lasttime = this.getTime();
			if (((int) (lastEnergy * 1000) - (int) (this.getEnergy())) == 10) {
				energyDecay = 0.1;
			} else if (((int) (lastEnergy * 1000) - (int) (this.getEnergy())) == 0) {
				energyDecay = 0.0;
			}
			addHistoryPos(this.getX(), this.getY(), this.getTime());
			i++;
			if (myTarget != null) {
				double mirrorAvg = myTarget.getMirrorAvg();
				//HISTORY v.2.42: 2004/09/20 anti-mirror avg de 30 para 20
				// (testar contra mirrors)
				//HISTORY v.2.42: 2004/09/20 Nada de anti-mirror se HeadOn!!
				if ((!myTarget.isHeadOn()) && (!Double.isNaN(mirrorAvg))
						&& (mirrorAvg < 20)) {
					myTarget.getStratego().setAntiMirror(true);
				} else {
					myTarget.getStratego().setAntiMirror(false);
				}
			}
			//ALTERADO: AGORA SITSTILL SE CHOCA CONTRA A ONDA...
			//HISTORY v2.43: 2004/09/22 SIT STILL DONT CHECK BULLET POWER IN
			// LAST ROUND!
			move();
			doRadar();
			if (!isSitStill()) {
				doGun();
			}

			execute();

		}
	}

	private void doGun() {
		if ((this.getOthers() == 1) && (myPilot != null)
				&& (!this.myPilot.fire())) {
			return;
		}
		if (firing || (this.getEnergy() <= 0)) {
			return;
		}
		AxeTarget oldTarget = myTarget;
		if (myTarget == null || !choosen || !myTarget.isAlive() //||
		) {
			myTarget = tMan.getTarget(this.getOthers());
			if (myTarget == null || !myTarget.isAlive()) {
				return;
			}
			choosen = true;
		}
		if (MC) {
			return;
		}
		int strat = -1;
		if (myTarget == null) {
			return;
		}

		if (UMBRELLA) {
			return;
		}
		if (BEE) {
			if (!myTarget.getStratego().isAntiMirror()) {
				return;
			}
		}

		setTurnGunRight(this.turnGunTo(RoboMath.normalRelativeAngle(Math
				.toDegrees(RoboMath.getang(this.pos(), myTarget.pos())))));
		if ((oldTarget != null) && (myTarget != oldTarget)) {
			myTarget.resetHitsOnARow();
		}
		if (!((getGunHeat() > this.getGunCoolingRate()) || (myTarget
				.getScanTime() != this.getTime()))) {
			strat = myTarget.getStratego().newAimStrat(myTarget, threadGun);
		}
		if (strat < 0) {
			return;
		}

		double pwr = tMan.getFirePwr(this, getAimingArc(myTarget
				.getAbsBearing(), 20), myTarget);

		double gunOffset = 0;
		boolean goodToFire = true;

		// trava de energia
		double trava = 8;
		if ((!TC)
				&& (myTarget.getDistance() > 200)
				&& (!myTarget.isRamming())
				&& ((this.getOthers() == 1) && (this.getEnergy() < trava)
						&& (myTarget.getDistance() > (4 * this.botDim)) && ((this
						.getEnergy() - (pwr + 0.2)) <= myTarget.getLife()))) {
			//out.println(" NOT GOOD TO FIRE!");
			goodToFire = false;
		}
		if ((getGunHeat() > this.getGunCoolingRate())
				|| (Math.toDegrees(gunOffset) > 20)
				|| (myTarget.getScanTime() != this.getTime()) || (pwr == 0)
				|| !goodToFire) {

			return;
		}
		as.make(this, pwr, (long) myTarget.getTimeToHit(), myTarget, strat,
				myTarget.getDistance(), myTarget.getAngle(), myTarget.getX(),
				myTarget.getY(), myTarget.getStratego().getGun());

		firing = true;
		if (!this.threadGun) {
			//			System.out.println("!Thread gun");
			as.start();
		} else {
			Point2D.Double p = myTarget.getStratego().aim(pwr);

			if (p == null) {
				firing = false;
				return;

			}
			this.fireAtWill(RoboMath.normalAbsoluteAngle(Math
					.toDegrees(RoboMath.getang(/* this.pos() */this
							.getFuturePos().getEndPoint(), p))));

		}

		choosen = false;
		if (getOthers() > 1) {
			doWideScan();
		}
	}
	private void doWideScan() {
		wideScan = true;
	}
	private void doFullScan() {
		fullScan = true;
	}
	private void doRadar() {
		if (tMan.notSeenSince(this.getTime()))
			doFullScan();
		double radarOffset = 360;
		if (wideScan) {
			if (Double.isNaN(scanStartTime)) {
				scanStartTime = this.getTime();
				lowest = tMan.getLowestEnemyBearing(this.getX(), this.getY(),
						this.getRadarHeading())
						+ RoboMath.normalRelativeAngle(getRadarHeading());
				hightest = tMan.getHightestEnemyBearing(this.getX(), this
						.getY(), this.getRadarHeading())
						+ RoboMath.normalRelativeAngle(getRadarHeading());

			}
			if (tMan.allScanned(scanStartTime)) {
				wideScan = leftScan = rightScan = false;
				scanStartTime = Double.NaN;
			} else if (!leftScan) {
				leftScan = true;
				radarOffset = RoboMath.normalRelativeAngle(RoboMath
						.normalRelativeAngle(lowest)
						- RoboMath.normalRelativeAngle(getRadarHeading()));
				if (radarOffset < 0)
					radarOffset -= 15;
				else
					radarOffset += 15;
				radarOffset = RoboMath.normalRelativeAngle(radarOffset);
			} else if (this.getRadarTurnRemaining() == 0) {
				if (!rightScan) {
					rightScan = true;
					radarOffset = RoboMath
							.normalRelativeAngle(RoboMath
									.normalRelativeAngle(RoboMath
											.normalRelativeAngle(hightest)
											- RoboMath
													.normalRelativeAngle(getRadarHeading())));
					if (radarOffset < 0)
						radarOffset -= 15;
					else
						radarOffset += 15;
					radarOffset = RoboMath.normalRelativeAngle(radarOffset);
				} else {
					wideScan = leftScan = rightScan = false;
					if (!tMan.allScanned(scanStartTime)) {
						doFullScan();
					} else {
						scanStartTime = Double.NaN;
					}
				}
			} else
				return;
		}
		if (fullScan) {
			if (Double.isNaN(scanStartTime)) {
				scanStartTime = this.getTime();
			}
			if (!tMan.allScanned(scanStartTime)) {
				radarOffset = 360; //RoboMath.PI*2;
			} else {
				fullScan = false;
				scanStartTime = Double.NaN;
			}
		}
		if (!wideScan && !fullScan) {
			if (myTarget == null) {
				radarOffset = 360;
			} else {
				double vou = Math.toDegrees(Math.PI
						/ 2
						- Math.atan2(myTarget.getY() - getY(), myTarget.getX()
								- getX()));
				radarOffset = RoboMath.normalRelativeAngle(RoboMath
						.normalRelativeAngle(vou)
						- RoboMath.normalRelativeAngle(getRadarHeading()));
				if (radarOffset < 0)
					radarOffset -= 5;
				else
					radarOffset += 5;
			}

		}
		setTurnRadarRight(radarOffset);
	}
	private void move() {
		if (TC) {
			return;
		}
		if (myTarget != null) {
			BotData enemyData = StaticDataCenter.get(myTarget.getName());
			enemyData.getGfHistory().draw(myTarget.getDistance());
		}
		if ((myTarget != null) && (myTarget.getStratego().isAntiMirror())) {
			this.myPilot = amPilot;
		} else {
			this.myPilot = flatPilot;
		}
		myPilot.move();
	}
	public void onCustomEvent(CustomEvent e) {
		Condition condition = e.getCondition();
		if (condition instanceof AxeShooter) {
			AxeShooter as = (AxeShooter) condition;
			Bullet bullet = setFireBullet(as.getBulletPwr());
			if (bullet != null) {
				AxeVector meToTarget = new AxeVector(new Point2D.Double(this
						.getX(), this.getY()), new Point2D.Double(as
						.getTarget().getX(), as.getTarget().getY()));
				BulletTracker bt = new BulletTracker(this, bullet, as
						.getTarget().getName(), as.getTimeToHit(), as
						.getAimStrat(), as.getTargetDist(),
						as.getFacingAngle(), as.getPoint(), meToTarget, as
								.getGun());
				as.getTarget().getStratego().setFiredAtTarget(
						(as.getTarget().getStratego().getFiredAtTarget()) + 1);
				tMan.fired(bt);
				lastFireTime = this.getTime();
			}
			firing = false;
		} else if (condition instanceof BulletTracker) {
			BulletTracker bt = (BulletTracker) condition;
			AxeTarget jaera = null;
			jaera = tMan.getTarget(this.getOthers());
			if (jaera != null) {
				if (bt.getTargetName().compareTo(jaera.getName()) == 0) {
					if (!bt.hitTarget()) {
						if (acertados > 0)
							acertados--;
					} else {
						acertados++;
					}
				}
			}

			if (!bt.hitTarget()) {
				tMan.missed(bt);
			} else {
				tMan.hit(bt);
			}
		}
	}
	public void onHitByBullet(HitByBulletEvent e) {
		tMan.hitMe(e.getName(), e.getPower());
		BotData bd = StaticDataCenter.get(e.getName());
		bd.getScorer().bullsEye(this, e, Double.NaN);
		if ((this.myPilot != null) && (this.myPilot instanceof FlatPilot)) {
			((FlatPilot) myPilot).hitByBullet(e.getPower());
		}
		Point2D.Double hitPoint = new Point2D.Double(e.getBullet().getX(), e
				.getBullet().getY());
		EnemyWave ew = EnemyWave.getWave(e.getPower(), hitPoint);

		EnemyWave currentWave = (myPilot instanceof WaveSurferPilot)
				? ((WaveSurferPilot) myPilot).getWave()
				: null;

		double gf = Double.NaN;

		if (ew != null) {
			gf = ew.getGF(e);
			bd.getGfHistory().hit((int) gf, e.getPower(),
					ew.getOriginalDistance(), ew);
			ew.hit();
		} else {
			System.out
					.println("********                                                       Onda nula!");
		}

		if (DEBUG_HITS) {
			DecimalFormat fmt = new DecimalFormat("0.00");

			double decimalGF = (gf - SegmentedGFs.MID_GF)
					/ (SegmentedGFs.MID_GF);

			String dbg = "HIT!!! ";

			dbg += (ew != null) ? (" GF:" + fmt.format(decimalGF) + "(" + gf
					+ ") myGF:" + ew.getGF(pos())) : " NOT MATCHED WAVE! ("
					+ e.getPower() + ")";

			dbg += " round:" + this.getRoundNum() + " time:" + getTime()
					+ " pilot:" + myPilot + " myPos:" + pos();

			dbg += "\r\n   enemy:" + myTarget + "\r\n   " + Course.getCourse();
			dbg += "\r\n   hitPointToWaveCenter:"
					+ hitPoint.distance(ew.getCenter());
			dbg += (ew != null) ? ("\r\n   Bullet Wave:" + ew
					+ "\r\n   CurrentWave:" + currentWave) : "";

			dbg += "\r\n   Radar:";
			ArrayList radar = EnemyWave.getAllWaves();
			for (int i = 0; i < radar.size(); i++) {
				dbg += "\r\n   " + radar.get(i);
			}
			dbg += "\r\n";

			//System.out.println(dbg);
		}
	}
	public void onBulletHit(BulletHitEvent e) {
		tMan.getBot(e.getName()).setExpectedLifeDiff(
				-RoboMath.getBulletDamage(e.getBullet().getPower()));
		scorer.bullsEye(e, Double.NaN);
	}

	public void onHitRobot(HitRobotEvent e) {
		if (this.myPilot != null) {
			myPilot.botHitBot();
		}
		if (!e.isMyFault()) {
			return;
		}
	}
	public void doRe() {
		doRe(!isRe());
	}
	public void doRe(boolean dir) {
		setRe(dir);
		//        reCount= 0;
		wallBackUp.setOn(true);
	}

	public void onScannedRobot(ScannedRobotEvent e) {

		if ((e.getTime() != this.getTime()) || (this.getEnergy() <= 0)) {
			return;
		}
		tMan.setScanned(e, this);

	}
	public double turnGunTo(double to) {
		double ret;
		to = RoboMath.normalAbsoluteAngle(to);
		ret = RoboMath.normalRelativeAngle(to
				- RoboMath.normalAbsoluteAngle(this.getGunHeading()));
		return ret;
	}
	public void onRobotDeath(RobotDeathEvent e) {
		out.println(">>>>>>>>>>>>> KILL <<<<<<<<<<<<< :" + e.getName()
				+ "  => " + this.getOthers());
		this.setDuel();
		double rz = (double) tMan.getOpps() / (double) tMan.getMaxOpps();
		rz /= 2.0;
		rz += 0.5;
		centerAlert.reDim(rz);
		tMan.anotherOneBitesTheDust(e, this.getOthers());
	}
	public void onHitWall(HitWallEvent e) {
		if (this.myPilot != null) {
			// myPilot.botHitWall();
		}
		out.println("---------------- BATEU NO MURO:" + this.getX() + ","
				+ this.getY() + " at:" + this.getTime());
	}
	public void onWin(WinEvent e) {
		out.println("  VENCI!!!!!" + this.getTime());
		if (myTarget != null) {
			myTarget.loose();
		}
		scorer.win();
		this.terminate();
	}
	private void terminate() {
		if (getRoundNum() == getNumRounds() - 1) {

			SegmentedGFs.debugGraphs();
			SegmentedGFs.saveDebugGraphs();

			if (SAVE_PMGUN_DATA) {

				AxeFiles.cleanDir();
			}
		}
		tMan.terminate();
		out.println(scorer);
	}
	public void onDeath(DeathEvent event) {
		out.println("  MORRI!!!!!" + this.getTime());
		if (myTarget != null) {
			myTarget.win();
		}
		scorer.died();
		terminate();
	}
	public boolean goingNorte() {
		double going = this.getMoveHeading();
		if ((going > 270) || (going < 90)) {
			return true;
		} else {
			return false;
		}
	}
	public boolean goingLeste() {
		double going = this.getMoveHeading();
		if (going < 180) {
			return true;
		} else {
			return false;
		}
	}
	public boolean goingOeste() {
		double going = this.getMoveHeading();
		if (going > 180) {
			return true;
		} else {
			return false;
		}
	}
	public boolean goingSul() {
		double going = this.getMoveHeading();
		if ((going > 90) && (going < 270)) {
			return true;
		} else {
			return false;
		}
	}
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		super.onBulletHitBullet(e);
		EnemyWave ew = EnemyWave.getWave(e.getHitBullet().getPower(),
				new Point2D.Double(e.getHitBullet().getX(), e.getHitBullet()
						.getY()));
		if (ew != null) {
			BotData bd = myTarget.getBotData();
			int gf = ew.getGF(e.getHitBullet());
			double pw = e.getHitBullet().getPower();
			double d = ew.getOriginalDistance();
			bd.getGfHistory().hit(gf, pw, d, ew);
			ew.hitBull();
		}
	}
	public AxeTarget getMyTarget() {
		return myTarget;
	}
	public AxeAvoider getWallAlert() {
		return wallAlert;
	}
	public static BotScore getScorer() {
		return scorer;
	}
	public AxePilot getMyPilot() {
		return myPilot;
	}
	public double getEnergyDecay() {
		return energyDecay;
	}
	public boolean isFirstBlood(EnemyWave ew) {
		double bPow = ew.getBulletPower();
		return isSitStill()
				&& ((bPow <= 1) ? true : ((countdown <= 1)) ? true : false);
	}
	private boolean isSitStill() {
		//		ALTERADO: 2004/09/30 NEW SIT STILL, SEM COUNTDOWN E + SIMPLES
		//		HISTORY v2.43: 2004/09/22 SIT STILL DISABLED IN MOVEMENT CHALLENGES
		if (myTarget == null) {
			return false;
		}
		if ((countdown <= 4)
				&& (myTarget.getBotData().getScorer().getScore() <= 1)
				&& (myTarget.getLife() < 50)
				&& (WaveNavigator.getWave() != null) && !MC) {
			return true;
		} else {
			return false;
		}
	}
	public void suicideSolution() {
		suicideSolution = true;

	}
	public long getLastFireTime() {

		return lastFireTime;
	}
	private AxeVector futurePos = new AxeVector();
	public void setFuturePos() {
		double vel = this.getVelocity();
		double head = RoboMath.normalRelativeAngle(this.getHeading());
		double mv = this.getDistanceRemaining();
		double trn = this.getTurnRemaining();

		mv = ((vel * mv) < 0) ? ((Math.abs(vel) > 1) ? ((vel < 0)
				? vel + 2
				: vel - 2) : 0) : ((Math.abs(vel) < 8) ? ((vel < 0)
				? vel - 1
				: vel + 1) : vel);

		double maxtrn = 10 - (0.75 * vel);

		maxtrn = (trn < 0) ? -maxtrn : maxtrn;
		trn = (Math.abs(maxtrn) < Math.abs(trn)) ? maxtrn : trn;

		futurePos.set(this.pos(), RoboMath.normalRelativeAngle(head + trn), mv);

	}
	public AxeVector getFuturePos() {
		setFuturePos();
		return (AxeVector) futurePos.clone();
	}
}