package bons;
import robocode.*;

/* bons.NanoStalker - The Nano (<250) entry in the Stalker line of bots.
 *
 * Ken Boucher / bons
 * bons@nozen.com 
 * 
 * 1.0 birth. Sloppy code. No compression. But what do you expect from a 1.0?
 * It does cheat however. By keeping the radar locked to the gun it gets to
 * use the advanced targeting techniques that the API says only applies to class
 * Robot. This means the bullet goes in the direction of the target, not the gun.
 * 1.1 fixes, fixes, and more fixes.
 * 1.2 tweaked. Cleaned up. codesize = 200. And sadly enough I can't think of 
 * anything I really want to do to it. Added gunshot detection but that just 
 * ended up making it charge bullets. Bleagh.
 *///////////////////////////////////////////////////////////////////////////////

public class NanoStalker extends AdvancedRobot
{
	public double bearing;
	public void run() {
		double right;
		double forward = 1.0;
		do {
			//if you're not moving, move.
			if (getDistanceRemaining() == 0.0)
				{
				setAhead(125.0 * forward);
				forward = (forward * -1.0);
				};
			//turn to be 60% from enemy				
			if (bearing > 0.0)
				{right = -1.0;}
			else
				{right = 1.0;};
			/* The following line just kind of evolved.
			 * Bearing points at the bot.
			 * +90 (or -90 depending on right) moves opposite of bearing
			 * placing you at 90 degrees to the bot. Example. If it's a 
			 * 30 degree turn to face the bot, it's a -60 degree turn to
			 * be at a 90 degree angle to the bot.
			 * We then have to incline in to the bot 30 degrees if we're
			 * going forwards or head out 30 degrees if we're in reverse.
			 *//////////////////////////////////////////////////////////
			setTurnRight(bearing + (90.0 + (30.0 * forward)) * right);
				
			//If nothing is scanned, spin the gun.
			if (getGunTurnRemaining() == 0.0)
			    setTurnGunRight(Double.POSITIVE_INFINITY);
			//That's all for this tick
			execute();
		} while(true);
	}

	//Track that baby.
	public void onScannedRobot(ScannedRobotEvent e) {
		//Get the direction of the robot relative to the battlefield.
		//This is used to aim the gun and move the robot at the enemy.
		bearing = minimize(e.getBearing());
		//Figure where to move the gun to point directly at the target.
		double gunturn = minimize (bearing  + getHeading() - getGunHeading());
		//Since the gunturn width is 20 degrees, keeping the gun within 10
		//degrees keeps the target in the center of the gun wiggle and yet 
		//allows new targets to be found.
		//So we'll move the gun  10 degrees past the target. 
		if (gunturn > 0.0)
			setTurnGunRight(gunturn + 10.0);
		else
			setTurnGunRight(gunturn - 10.0);
		setFire(getEnergy()/2.0 - 0.1);
		//test for Targeting Assistance from the robocode.alphaworks forum.
		/*
		Bullet bang = setFireBullet(3);
		if (bang != null)
			{
			if (bang.getHeading() == getGunHeading()) 
				{
				out.println("Targeting Assistance Failed");
				out.println(Double.toString(bang.getHeading()));
				out.println(Double.toString(getGunHeading()));
				};
			};
		*/
		};
		
	public double minimize(double a) {
		//Set degree to be as close to 0 as possible
		while (a < -180.0) {a = a + 360.0;};
		while (a > 180.0) {a = a - 360.0;};
		return a;
		}		
}
