package mnt.utils;

import robocode.*;
import robocode.util.*;

import java.awt.geom.*;
import java.util.*;

public class MovimientoMinimoRiesgo {

	public static final int MITAD_FACTORES = 15;

	public static final int FACTORES = 2 * MITAD_FACTORES;

	private static double[][][][][] guessFactors = new double[3][3][3][7][FACTORES + 1];

	private static double[][][][][] hitFactors = new double[3][3][3][7][FACTORES + 1];

	private Rectangle2D.Double BF;

	private double bearingDir = 1;

	private double energiaEnemigo;

	private double potenciaBalaE;

	private double ultimaVelocidad;

	private double velocidad;

	private double velocidadLateral;

	private double heading;

	private Point2D posE = new Point2D.Double();

	private Point2D miPos = new Point2D.Double();

	private List waves = new ArrayList();

	private double miBearing;

	private long tiempo;

	private double distanciaE;

	private AdvancedRobot miRobot;

	public MovimientoMinimoRiesgo(AdvancedRobot me) {
		for (int i = 0; i < 3; i++)
			for (int j = 0; j < 3; j++)
				for (int k = 0; k < 3; k++)
					for (int l = 0; l < 7; l++)
						hitFactors[i][j][k][l][MITAD_FACTORES] = 1;

		this.miRobot = me;

		BF = new Rectangle2D.Double(18, 18, me.getBattleFieldWidth() - 36, me
				.getBattleFieldHeight() - 36);
		waves.clear();
	}

	public void onScannedRobot(ScannedRobotEvent e) {

		boolean esBala = false;

		double difEnergia = energiaEnemigo - e.getEnergy();
		if (difEnergia > 0 && difEnergia <= 3) {
			potenciaBalaE = difEnergia;
			esBala = true;
		}

		WaveEnemiga w = new WaveEnemiga();
		w.isBullet = esBala;
		w.velocidadBala = RoboMath.velocidadBala(potenciaBalaE);
		w.centro = posE;
		w.tiempoInicio = tiempo;
		w.posObjetivo = miPos;
		w.bearingDir = bearingDir;

		int indiceDistancia = Math.min(6, (int) (distanciaE / 140));

		int indiceAceleracion = (int) Math.round(Math.abs(velocidad)
				- Math.abs(ultimaVelocidad));
		if (indiceAceleracion != 0)
			indiceAceleracion = (indiceAceleracion < 0) ? 2 : 1;
		int indiceVelRelativa = (int) (Math.abs(velocidadLateral) / 3);
		int indicePared = RoboMath.indicePared(miPos, miRobot
				.getBattleFieldWidth(), miRobot.getBattleFieldHeight());

		w.GFs = guessFactors[indicePared][indiceAceleracion][indiceVelRelativa][indiceDistancia];
		w.HFs = hitFactors[indicePared][indiceAceleracion][indiceVelRelativa][indiceDistancia];
		int bestGF = MITAD_FACTORES;
		int bestHF = MITAD_FACTORES;
		for (int i = 0; i <= FACTORES; i++) {
			if (w.GFs[i] > w.GFs[bestGF])
				bestGF = i;
			if (w.HFs[i] > w.HFs[bestHF])
				bestHF = i;
		}
		w.hf = bestHF;
		w.gf = bestGF;
		waves.add(w);

		miPos = new Point2D.Double(miRobot.getX(), miRobot.getY());
		ultimaVelocidad = velocidad;
		velocidad = miRobot.getVelocity();
		tiempo = miRobot.getTime();
		heading = miRobot.getHeadingRadians();
		double absBearing = miRobot.getHeadingRadians() + e.getBearingRadians();
		distanciaE = e.getDistance();
		posE = RoboMath.calculaPosicion(miPos, absBearing, distanciaE);
		miBearing = RoboMath.absoluteBearing(posE, miPos);
		energiaEnemigo = e.getEnergy();
		velocidadLateral = velocidad * Math.sin(heading - miBearing);
		if (velocidadLateral != 0)
			bearingDir = velocidadLateral > 0 ? 1 : -1;

		actualizarWaves(miPos, tiempo);
	}

	public void hacerMovimiento() {
		miPos = new Point2D.Double(miRobot.getX(), miRobot.getY());
		ultimaVelocidad = velocidad;
		velocidad = miRobot.getVelocity();
		tiempo = miRobot.getTime();
		heading = miRobot.getHeadingRadians();
	
		WaveEnemiga sigWave = balaMasCercana(tiempo, miPos);
		double dir = bearingDir;
	
		if (sigWave == null) {
			Point2D p1 = getReferencePoint(miPos, posE, bearingDir);
			Point2D p2 = getReferencePoint(miPos, posE, -bearingDir);
			if (Math.abs(RoboMath.angleBetween(miPos, posE, p1)) >= Math
					.abs(RoboMath.angleBetween(miPos, posE, p2))
					^ (energiaEnemigo < 5))
				dir = bearingDir;
			else
				dir = -bearingDir;
		} else {
			double riesgoFwd = calculaRiesgo(miPos, bearingDir, velocidad,
					tiempo, heading);
			double riesgoRew = calculaRiesgo(miPos, -bearingDir, velocidad,
					tiempo, heading);
	
			dir = riesgoFwd > riesgoRew ? -bearingDir : bearingDir;
		}
	
		Point2D proxPos = getReferencePoint(miPos, getCentro(), dir);
		double ang;
	
		ang = RoboMath.absoluteBearing(miPos, proxPos)
				- miRobot.getHeadingRadians();
		miRobot.setAhead(Math.cos(ang) * 100);
		miRobot.setTurnRightRadians(Math.tan(ang));
	}

	private double calculaRiesgo(Point2D posInicial, double dir,
			double velocidad, long tiempo, double heading) {
		WaveEnemiga sigWave = balaMasCercana(tiempo, posInicial);
		if (sigWave == null)
			return 0;
	
		Point2D sigPunto = new Point2D.Double(posInicial.getX(), posInicial
				.getY());
		Point2D ref;
	
		double riesgo = 0;
		double maxVel = 8;
		do {
	
			ref = getReferencePoint(sigPunto, sigWave.centro, dir);
	
			if (Math.abs(Utils.normalRelativeAngle(RoboMath.absoluteBearing(
					sigPunto, ref)
					- heading)) > Math.PI / 2) {
				heading = Utils.normalRelativeAngle(heading + Math.PI);
				velocidad = -velocidad;
			}
	
			double maxTurn = Math.toRadians(10 - .75 * Math.abs(velocidad));
			double turn = Math.tan(Utils.normalRelativeAngle(RoboMath
					.absoluteBearing(sigPunto, ref)
					- heading));
			turn = RoboMath.ajustar(turn, -maxTurn, maxTurn);
	
			if (velocidad < 0)
				velocidad = Math.min(velocidad + 2, 0);
			else
				velocidad = Math.min(Math.max(maxVel, velocidad - 2),
						velocidad + 1);
			heading = Utils.normalRelativeAngle(heading + turn);
			sigPunto = RoboMath.calculaPosicion(sigPunto, heading, velocidad);
	
		} while (sigWave.distanciaAPos(tiempo++, sigPunto) > 18);
	
		riesgo = sigWave.riesgo(sigPunto);
	
		return riesgo
				+ Math.min(calculaRiesgo(sigPunto, dir, velocidad, tiempo,
						heading), calculaRiesgo(sigPunto, -dir, velocidad,
						tiempo, heading));
	}

	private Point2D getReferencePoint(Point2D start, Point2D orbitCentre,
			double circleDir, double angle) {

		double distDelta = 0.1 + Math.PI / 2 + angle;
		Point2D.Double newDestination;
		while (!BF.contains(newDestination = RoboMath.calculaPosicion(start,
				RoboMath.absoluteBearing(start, orbitCentre) - circleDir
						* (distDelta -= 0.1), 170)))
			;

		return newDestination;

	}

	private Point2D getReferencePoint(Point2D start, Point2D orbitCentre,
			double circleDir) {
		double bestDist = 525;
		double closeAngle = -.1;
		double angle = (orbitCentre.distance(start) > bestDist ? closeAngle
				: .5);

		return getReferencePoint(start, orbitCentre, circleDir, angle);

	}

	private Point2D getCentro() {
		WaveEnemiga e = balaMasCercana(tiempo, miPos);
		if (e == null)
			return posE;
		return e.centro;
	}

	private void actualizarBalas(Bullet b) {
		Point2D impact = new Point2D.Double(b.getX(), b.getY());
		WaveEnemiga closestWave = balaMasCercana(miRobot.getTime(), impact);
		if (closestWave == null)
			return;
		closestWave.hit(impact);
	}

	public void onBulletHitBullet(BulletHitBulletEvent e) {
		actualizarBalas(e.getHitBullet());
	}

	public void onHitByBullet(HitByBulletEvent e) {
		energiaEnemigo += 3 * e.getBullet().getPower();
		actualizarBalas(e.getBullet());
	}

	public void onBulletHit(BulletHitEvent event) {
		Bullet b = event.getBullet();
		double power = b.getPower();
		energiaEnemigo -= 4 * power + Math.max(2 * power - 1, 0);
	}

	private WaveEnemiga balaMasCercana(long tiempo, Point2D pos) {
		WaveEnemiga masCercana = null;
		double min = Double.POSITIVE_INFINITY;
		for (Iterator it = waves.iterator(); it.hasNext();) {
			WaveEnemiga w = (WaveEnemiga) it.next();
			double d = w.distanciaAPos(tiempo, pos);
			if (w.isBullet && d < min && d > 18) {
				min = d;
				masCercana = w;
			}
		}
		return masCercana;
	}

	private void actualizarWaves(Point2D pos, long tiempo) {
		for (Iterator it = waves.iterator(); it.hasNext();) {
			WaveEnemiga w = (WaveEnemiga) it.next();
			if (w.isBullet) {
				if (w.distanciaAPos(tiempo, pos) < -40) {
					//w.HFs[w.hf] -= 0.1;
					it.remove();
				}
			} else if (w.pasada(tiempo, pos))
				it.remove();
		}
	}

}