package dz;
import robocode.*;
import java.awt.geom.*;
import robocode.util.Utils;

import java.awt.Color;

/**
 * GalbaMini - a robot by David Zhang
 */
public class GalbaMini extends AdvancedRobot
{
	static double move = 150;
	static long myLastReverse; //Time of my last reverse
	static int timeSinceGFOneHit = 1000000;
	static boolean flatMovement = false;
	
	
	static double enemyEnergy;
	static double bulletSpeed; //Speed of enemy's bullets.
	static double radarMove;
	//static double eHeading; //Enemy's heading.
	static double eVelocity = 0;
	static double eVDir;
	static int lastDir = 1;
	//static long lastMove; //Time of last movement.
	static double enemyCoolingTime;
	static int timeSinceReverse;
	
	//static int afterWall;
	
	//static double stat1 [][];
	//static double stat2 [][][][];
	static double stat2 [][][][][][];
	static int amtStats = 0;
	static Wave wavesInAir [];
	static int numInAir;
	
	static double eDist; //Distance to enemy.
		
	public void run() {
		setColors(Color.blue,Color.black,Color.yellow);
		
		myLastReverse = 0;
		
		//lastMove = 0;
		//afterWall = 0;
		radarMove = 0.785398; // =PI/4
		numInAir = 0;
		timeSinceReverse = 0;
		wavesInAir = new Wave[100];
		if(getRoundNum() == 0){
			//stat1 = new double[10][41]; // dist, gf
			stat2 = new double[15][3][3][3][4][31]; //dist, acc, speed,wall segmentation, time since reverse, gf
			//stat2 = new double[10][3][3][41]; //dist, acc, speed, gf
		}
		/*
		else{
			for(int c = 2; c < 5; c++){
				for(int d = 0; d < 41; d++){
					out.println(c+","+d+":"+stat2[c][1][0][d]);
				}
			}
		}
		*/
		while(true) {
			//afterWall++;
			turnRadarRightRadians(radarMove);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		
		
		double myX, myY;
		double myHeading;
		double headingToEnemy = e.getBearingRadians() + (myHeading = getHeadingRadians());
		
		Rectangle2D.Double field = new Rectangle2D.Double(18, 18, getBattleFieldWidth() - 36, getBattleFieldHeight() - 36);
		//Rectangle2D.Double field = new Rectangle2D.Double(18, 18, 764, 564);
		
		//double eDist; //Distance to enemy.
		double myEnergy;
		double power = Math.min(2 + ((int)(70/(eDist = e.getDistance()))) , Math.min(myEnergy = getEnergy(),enemyEnergy)/4);
		//////////  Movement  //////////////
		double myVelocity = getVelocity();
		//move -= (myVelocity = getVelocity());
		
		double energyDrop = enemyEnergy - (enemyEnergy = e.getEnergy());
		
		
		boolean enemyFired = false;
		
		if(energyDrop <= 3 && energyDrop >= 0.1){
			enemyFired = true;
			bulletSpeed = 20 - 3*energyDrop;
			enemyCoolingTime = 10 + (2 * energyDrop);
		}
		
		/*
		if(!field.contains(getX() + move*Math.sin(getHeadingRadians()),getY() + move*Math.cos(getHeadingRadians()))){
			move = -move;
		}
		*/
		
		//Wall avoidance.
		double advanceAngle;
		double perpendicularHeading = headingToEnemy - Math.atan(100*e.getBearing()); //For crazy fun movment, reverse the sign.
		//int advanceAngle = (getEnergy()/((enemyEnergy = e.getEnergy())+0.1) >= 3)? 15 : 0;
		//int advanceAngle = (getEnergy()/((enemyEnergy = e.getEnergy())+0.1) >= 3)? 15 : (eDist < 400? -3:0); //Backs away slightly if too close to enemy.
		int direction = move*e.getBearingRadians() > 0? 1:-1;
		
		for(advanceAngle = 0; !field.contains(getX() + move*Math.sin(perpendicularHeading + direction*advanceAngle) , getY() + move*Math.cos(perpendicularHeading + direction*advanceAngle)); advanceAngle += 0.01){
			//Empty
		}		

		//if(Math.random() < 7*Math.pow(bulletSpeed/Math.max(150,eDist),1.3)/Math.cos(advanceAngle)){
		double probOfRev = 0.18/(1 + Math.pow(eDist/bulletSpeed,3)/27000) + 0.02;
		//double probOfRev = 33/((eDist = e.getDistance()) * Math.cos(advanceAngle));
		/*
		double probOfRev = eDist/bulletSpeed < 50? 0.05 : 0.05;
		if(eDist/bulletSpeed < 20){
			probOfRev = 0.175;
		}
		else if(eDist/bulletSpeed < 30){
			probOfRev = 0.15;
		}
		else if(eDist/bulletSpeed < 40){
			probOfRev = 0.07;
		}
		*/
		
		timeSinceGFOneHit++;
		
		if(Math.random() < probOfRev/Math.cos(advanceAngle) && flatMovement || Math.cos(advanceAngle) < 0.4){  
			move = -move;
			myLastReverse = getTime();
		}
		if(enemyEnergy != 100){
			setAhead(move);
		}
		double botTurn;
		setMaxVelocity(8 - Math.sqrt(advanceAngle)*Math.abs(Math.round(20*(botTurn = Utils.normalRelativeAngle(perpendicularHeading + direction * advanceAngle - getHeadingRadians())))));
		setTurnRightRadians(botTurn);
		
		//////////  Aiming  /////////////
		
		
		//Initial position of virtual enemy.
		double x = (myX = getX()) + eDist * Math.sin((headingToEnemy = (e.getBearingRadians() + (myHeading = getHeadingRadians() )))); //Head-on targeting.
		double y = (myY = getY()) + eDist * Math.cos(headingToEnemy);
		
		//Shoot wave
		long time = getTime();
		double eV;
		double enemyHeading = e.getHeadingRadians();
		timeSinceReverse++;
		if((eV = e.getVelocity()) != 0){
			//lastDir = 1 if clockwise, else = -1.
			int newDir = (eV > 0? 1: -1) * (Utils.normalRelativeAngle(enemyHeading - headingToEnemy) > 0? 1: -1);
			
			if(newDir != lastDir){
				timeSinceReverse = 0;
			}
			
			lastDir = newDir;
			eVDir = 50*Math.atan(100*eV);
		}
		double botSpeed = Math.abs(eV);
		//Gather stats
		for(int c = 0; c < numInAir; c++){
			if(wavesInAir[c].bulletSpeed * (time - wavesInAir[c].originTime) > (eDist - 8)){
				Wave theWave = wavesInAir[c];
				double maxAngle = Math.asin(8.0/theWave.bulletSpeed);
				double currAngle = Utils.normalRelativeAngle(Math.atan((x - theWave.originX)/(y - theWave.originY)) + ((y < theWave.originY)? Math.PI:0) - theWave.heading);
				double gf = (double)(theWave.direction) * currAngle / maxAngle;
				amtStats++;
				int distSeg = theWave.distSeg;
				int d = Math.max(Math.min((int)((gf + 1.0 + (1.0/(12.0 + 2.0*distSeg))) * (distSeg + 6.0)) , 12 + 2*distSeg) , 0);
				/*
				for(int d = 0; d < 13 + 2*distSeg; d++){
					if(((double)(d / (distSeg + 6.0))) - 1.0 + (1.0/(12.0 + 2.0*distSeg)) > gf){
					//stat2[i][j][k][d]+=wavesInAir[c].weighting;
						stat2[distSeg][theWave.accSeg][theWave.speedSeg][theWave.wallSeg][theWave.revSeg][d] += theWave.weighting;
						break;
					}
				}
				*/
				stat2[distSeg][theWave.accSeg][theWave.speedSeg][theWave.wallSeg][theWave.revSeg][d] += theWave.weighting;
				
				wavesInAir[c] = wavesInAir[--numInAir];
				c--;
			}
		}
				
		//Turn radar.
		radarMove = Utils.normalRelativeAngle(headingToEnemy - getRadarHeadingRadians());
		radarMove += (radarMove >= 0)? 0.3927 : -0.3927; // =PI/8
		double aimHeading = headingToEnemy;
		int distIndex = (int)(eDist/100);
		/*
		do{
			distIndex--;
		}while(eDist <= distIndex*100);
		*/
		/*
		for(int c = 9; c >= 0; c--){
			if(eDist > c*100){
				distIndex = c;
				break;
			}
		}
		*/
		long acceleration = Math.round(botSpeed - Math.abs(eVelocity)); //eVelocity is old data.
		int accIndex = -1;
		do{
			accIndex++;
		//}while((botSpeed - Math.abs(eVelocity))*(accIndex-1) <= 0 && ((int)(eV-eVelocity) != 0 || accIndex != 1) );
		}while((acceleration*(accIndex-1) <= 0 && (acceleration != 0 || accIndex != 1) ) && accIndex < 2);
		/*
		for(int c = 0; c <3; c++){
			if((Math.abs(eV) - Math.abs(eVelocity)) * (c - 1) > 0 || (eV-eVelocity == 0.0 && (c-1) == 0)){
				accIndex = c;
				break;
			}
		}
		*/
		int speedIndex = (int)(botSpeed/3);
		/*
		do{
			speedIndex--;
		}while(botSpeed < speedIndex*3);
		*/
		/*
		for(int c = 2; c >= 0; c--){
			if(Math.abs(eV) >= c*3){
				speedIndex = c;
				break;
			}
		}
		*/
		
		int revIndex = Math.min(3,(int)(Math.sqrt(timeSinceReverse/2)));
		/*
		do{
			revIndex--;
		}while(timeSinceReverse < 4*revIndex*revIndex);
		*/
		
		int wallIndex = 3;
		do{
			wallIndex--;
		}while(!field.contains(x + wallIndex*eVDir*Math.sin(enemyHeading),y + wallIndex*eVDir*Math.cos(enemyHeading)) && wallIndex > 0);
		/*
		for(int c = 3; c >= 0; c--){
			if(timeSinceReverse >= c*10){
				revIndex = c;
				break;
			}
		}
		*/
		double maxData = 0;
		int maxIndex = 10;
		/*
		if(accIndex > 2 || accIndex < 0 || speedIndex > 2 || speedIndex < 0){
			out.println("Dist index:"+distIndex + "  Acc index:"+ accIndex + "  Speed index:" + speedIndex + "  Wall index:"+wallIndex+"  Reverse index:"+revIndex);
		}
		*/
		for(int c = 0; c < 31; c++){
			double tempData;
			
			//if(amtStats > 1000){
				//if((tempData = stat2[distIndex][accIndex][speedIndex][revIndex][c]) > maxData){
				if((tempData = stat2[distIndex][accIndex][speedIndex][wallIndex][revIndex][c]) > maxData){
				//if((tempData = stat2[distIndex][accIndex][speedIndex][c]) > maxData){
					maxData = tempData;
					maxIndex = c;
				}
			//}
			/*
			else if((tempData = stat1[distIndex][c]) > maxData){
				maxIndex = c;
				maxData = tempData;
			}
			*/
		}
		if(enemyEnergy > 0){
			aimHeading += (double)(lastDir * ((maxIndex/(6.0 + distIndex) -1.0))*Math.asin((8.0/(20.0 - 3.0*power))));
			/*
			if(time % 20 == 0){
				out.println(accIndex+","+speedIndex+","+maxIndex);
			}
			*/
		}
		
		
		//Turn gun.
		setTurnGunRightRadians(Utils.normalRelativeAngle(aimHeading - getGunHeadingRadians()));
		//Fire.
		//if((myEnergy >= 0.4 || enemyEnergy == 0) && getGunHeat() == 0){
		if(myEnergy >= 0.4 || enemyEnergy == 0){
			setFire(power);
			if(enemyEnergy > 0){
				wavesInAir[numInAir++] = new Wave(myX, myY, headingToEnemy, power, lastDir, (getGunHeat() == 0? 2 : 1), distIndex, speedIndex, accIndex, wallIndex, revIndex, time);
			}
			//wavesInAir[numInAir++] = new Wave(myX, myY, headingToEnemy, power, lastDir, (getGunHeat() == 0? Math.log(amtStats + 3) : 1), distIndex, speedIndex, accIndex, wallIndex, revIndex, time);
			
			//wavesInAir[numInAir++] = new Wave(myX, myY, eDist, headingToEnemy, eVelocity, botSpeed, power, lastDir, (getGunHeat() == 0? Math.log(amtStats + 3) : 1),timeSinceReverse,time);
			//wavesInAir[numInAir++] = new Wave(myX, myY, eDist, headingToEnemy, eVelocity, botSpeed, power, lastDir, (getGunHeat() == 0? Math.log(amtStats + 3) : 1),time);
		}
		eVelocity = eV;
	}
	
	public void onHitByBullet(HitByBulletEvent e){
		if(Math.abs(getVelocity()) > 5 && eDist > 140 && (getTime() - myLastReverse)*e.getVelocity() > (eDist + 50)){
			if(timeSinceGFOneHit < 100){
				flatMovement = true;
			}
			timeSinceGFOneHit = 0;
		}
	}
							
}
class Wave{
	public double originX, originY;
	//public double targetX, targetY;
	//public double distance;
	public double heading;
	//public double botSpeed;
	public double bulletSpeed;
	public double weighting;
	public int direction;
	//public int reverseTime;
	public long originTime;
	public int distSeg;
	public int speedSeg;
	public int accSeg;
	public int wallSeg;
	public int revSeg;
	//Wave(double oX, double oY, double tX, double tY, double acc, double power, long t){
	//Wave(double oX, double oY, double dist, double h, double lastV, double currBotSpeed, double power, int dir,double weight,int rt, int wall, long t){
	//Wave(double oX, double oY, double dist, double h, double lastV, double currBotSpeed, double power, int dir,double weight,long t){
	Wave(double oX, double oY, double h, double power, int dir, double weight, int dS, int sS, int aS, int wS, int rS, long t){
		originX = oX;
		originY = oY;
		//targetX = tX;
		//targetY = tY;
		//distance = dist;
		heading = h;
		//acceleration = (int)(Math.abs(lastV) - currBotSpeed);
		//botSpeed = currBotSpeed;
		bulletSpeed = 20 - 3*power;
		direction = dir;
		//reverseTime = rt;
		weighting = weight;
		
		originTime = t;
		
		distSeg = dS;
		speedSeg = sS;
		accSeg = aS;
		wallSeg = wS;
		revSeg = rS;
	}
}
