//$Id: WaveGun.java,v 1.5.6.1.2.1 2004/10/24 19:00:18 lolo Exp $
package mnt.utils;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.util.*;

public class WaveGun {
    private double bearingDir = 1;

    private double ultimaVelRelativa, ultimaVelocidad, velocidadRelativa,
            velocidad;

    private double energiaEnemigo, distanciaEnemigo;

    private Point2D.Double posEnemigo;

    private Point2D.Double miPos;

    public static final int MITAD_FACTORES = 12;

    public static final int FACTORES = 2 * MITAD_FACTORES;
    
    public static final int POTENCIA_BALA = 2;

    private boolean activo = true;

    private double[][][][][][] guessFactors = new double[3][5][3][3][6][FACTORES + 1];

    private List waves = new ArrayList();

    private Rectangle2D.Double BF;

    private AdvancedRobot miRobot;

    public WaveGun(AdvancedRobot a) {
        miRobot = a;
        BF = new Rectangle2D.Double(18, 18, miRobot.getBattleFieldWidth() - 36,
                miRobot.getBattleFieldHeight() - 36);
    }

    public void newRound() {
        waves.clear();
    }

    public void onScannedRobot(ScannedRobotEvent e) {

        miPos = new Point2D.Double(miRobot.getX(), miRobot.getY());
        double delta;
        double enemiBearing = miRobot.getHeadingRadians()
                + e.getBearingRadians();
        distanciaEnemigo = e.getDistance();
        posEnemigo = RoboMath.calculaPosicion(miPos, enemiBearing,
                distanciaEnemigo);
        energiaEnemigo = e.getEnergy();
        
        actualizarWaves();
      
        Wave w = new Wave();

        ultimaVelRelativa = velocidadRelativa;
        ultimaVelocidad = velocidad;
        velocidadRelativa = (velocidad = e.getVelocity())
                * Math.sin(e.getHeadingRadians() - enemiBearing);

        int indiceDeDistancia = Math.min(5, (int) distanciaEnemigo / 140);

        double potenciaBala = indiceDeDistancia == 0 ? 3 : POTENCIA_BALA;
        delta = Math.min(miRobot.getEnergy() / 4, Math.min(energiaEnemigo / 4,
                potenciaBala));
        if (delta == potenciaBala)
            waves.add(w);
        potenciaBala = delta;
        w.velocidadBala = RoboMath.velocidadBala(potenciaBala);

        int indiceDeAceleracion = (int) Math.round(Math.abs(velocidadRelativa)
                - Math.abs(ultimaVelRelativa));

        if (velocidadRelativa != 0)
            bearingDir = velocidadRelativa > 0 ? 1 : -1;
        w.dirBearing = bearingDir * RoboMath.maxAnguloDeHuida(w.velocidadBala)
                / MITAD_FACTORES;

        int bestGF = 0;

        int indiceDeVelocidad = (int) Math.abs(velocidadRelativa / 3);

        if (Math.abs(Math.abs(velocidad) - Math.abs(ultimaVelocidad)) > .6) {
            indiceDeAceleracion = (int) Math.round(Math.abs(velocidad)
                    - Math.abs(ultimaVelocidad));
            indiceDeVelocidad = (int) Math.abs(velocidad / 3);
        }

        if (indiceDeAceleracion != 0)
            indiceDeAceleracion = indiceDeAceleracion > 0 ? 1 : 2;

        w.centro = miPos;
        w.enemiBearing = enemiBearing;
        int indiceDePared = BF.contains(RoboMath.calculaPosicion(miPos,
                enemiBearing + w.dirBearing * MITAD_FACTORES, distanciaEnemigo)) ? 0
                : BF.contains(RoboMath.calculaPosicion(miPos, enemiBearing + .5
                        * w.dirBearing * MITAD_FACTORES, distanciaEnemigo)) ? 1 : 2;

        w.waveGuessFactors = guessFactors[indiceDeAceleracion]
                                          [bestGF]
                                           [indiceDeVelocidad]
                                            [indiceDePared]
                                             [indiceDeDistancia];

        if (activo) {
            bestGF = MITAD_FACTORES;

            if (energiaEnemigo > 0)
                bestGF = mejorGF(w.waveGuessFactors, distanciaEnemigo);

            miRobot.setTurnGunRightRadians(Utils
                    .normalRelativeAngle(enemiBearing
                            - miRobot.getGunHeadingRadians() + w.dirBearing
                            * (bestGF - MITAD_FACTORES)));

            if (miRobot.getEnergy() > 1 || indiceDeDistancia == 0)
                miRobot.setFire(potenciaBala);
        }
    }

    private int mejorGF(double[] gfs, double distance) {
        int mejorGF = MITAD_FACTORES;
        for (int gf = FACTORES; gf >= 0; gf--) {
            if(gfs[gf] > gfs[mejorGF])
                mejorGF = gf;
        }
        return mejorGF;
    }
    
    private void actualizarWaves(){
        for (Iterator it = waves.iterator(); it.hasNext();) {
            Wave w = (Wave) it.next();
            if (w.pasada(posEnemigo))
                it.remove();
        }
    }
}