/*
 * Created on 2004-9-25
 */
package tide;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

import pez.rumble.pgun.Bee;
import wiki.rmove.RaikoNMT;

/**
 * Robot super class for tide framework.
 * 
 * It's a more advanced type of robot that divorce the robot 
 * control interface and the event handle, and present a pure
 * Descartes reference frame.
 * 
 * You can register various event listener to the robot, when
 * certain event occurred, it send the event to all event 
 * listener, and the event listener can actually deal with a 
 * certain event.
 *
 * All robot control interface is define in the class tide.RobotConsole,
 * you can get the robot information and control your robot via this 
 * console.
 * 
 * @author xiemin
 */
public abstract class Robot extends robocode.TeamRobot
{
	//robot console
	private static RobotConsole console = new RobotConsole();
	//listener list
	private static List listeners;
	
    RaikoNMT movement;
    Bee      bee;
	
	/**
	 * called by the game to create a new Robot.
	 */
	public Robot()
	{
		console.reset(this);
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Runnable#run()
	 */
	public void run()
	{
		initRun();
		while(true)
		{
			for(int i=0; i<listeners.size(); i++)
			{
				EventListener listener = (EventListener)listeners.get(i);
				listener.onWork();
			}
			execute();
		}
	}
	
	//Initialize before run.
	private void initRun()
	{
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		setColors(Color.yellow.brighter(),Color.white,new Color(100,200,16));
		if( listeners == null )
		{
			listeners = new ArrayList();
			initListeners();
		}
		if(isRRGC)
			movement = new RaikoNMT(this);
		if(useBee)
			bee = new Bee(this);
		onRoundBegin();
	}
	
	/**
	 * Initialize the listeners. Sub class must implements this
	 * method to register event listener to the robot. This method
	 * will be called only once at the begining of the first round.
	 * All event listeners will be always avialable in current battle.
	 */
	public abstract void initListeners();
	
	/**
	 * Return the robot console. This console is always avaliable 
	 * in current battle.
	 * @return the robot console
	 */
	protected static RobotConsole getConsole()
	{
		return console; 
	}
	
	/**
	 * Add a event listener.
	 * @param listener The listener will be registered.
	 */
	public void addListener(EventListener listener)
	{
		listeners.add(listener);
	}
	
	/**
	 * Remove a event listener.
	 * @param listener the listener will be removed.
	 */
	public void removeListener(EventListener listener)
	{
		listeners.remove(listener);
	}
	
	//////////////////////////////////////////////////////////////////////
	//check if is the last round
	private boolean isLastRound()
	{
		return console.getCurrentRound()==(console.getTotalRounds()-1);
	}
	
	//check if is the first round	
	private boolean isFirstRound()
	{
		return console.getCurrentRound()==0;
	}
	
	//round begin
	private void onRoundBegin()
	{
		if(isFirstRound()) onBattleBegin();
		for(int i=0; i<listeners.size(); i++)
		{
			EventListener listener = (EventListener)listeners.get(i);
			listener.onRoundBegin();
		}
	}
	
	//round finish
	private void onRoundFinish()
	{
		for(int i=0; i<listeners.size(); i++)
		{
			EventListener listener = (EventListener)listeners.get(i);
			listener.onRoundFinish();
		}
		if(isLastRound()) onBattleFinish();
	}
	
	//battle begin
	private void onBattleBegin()
	{
		for(int i=0; i<listeners.size(); i++)
		{
			EventListener listener = (EventListener)listeners.get(i);
			listener.onBattleBegin();
		}
	}
	
	//battle finish
	private void onBattleFinish()
	{
		for(int i=0; i<listeners.size(); i++)
		{
			EventListener listener = (EventListener)listeners.get(i);
			listener.onBattleFinish();
		}
	}
	
	////////////////////////////////////////////////////////////////////////
	//event handle
	public static boolean isRRGC = false;
	public static boolean useBee = false;
	/* (non-Javadoc)
	 * @see robocode.Robot#onScannedRobot(robocode.ScannedRobotEvent)
	 */
	public void onScannedRobot(robocode.ScannedRobotEvent event)
	{
		if(isRRGC)
			movement.onScannedRobot(event);
		if(useBee)
			bee.onScannedRobot(event);
		
		ScannedRobotEvent newEvent = new ScannedRobotEvent(event, this);
		for(int i=0; i<listeners.size(); i++)
		{
			EventListener listener = (EventListener)listeners.get(i);
			listener.onScannedRobot(newEvent);
		}
	}
	
	/* (non-Javadoc)
	 * @see robocode.Robot#onBulletHit(robocode.BulletHitEvent)
	 */
	public void onBulletHit(robocode.BulletHitEvent event)
	{
		if(useBee)
			bee.onBulletHit(event);
		
		BulletHitEvent newEvent = new BulletHitEvent(event);
		for(int i=0; i<listeners.size(); i++)
		{
			EventListener listener = (EventListener)listeners.get(i);
			listener.onBulletHit(newEvent);
		}
	}
	
	/* (non-Javadoc)
	 * @see robocode.Robot#onBulletHitBullet(robocode.BulletHitBulletEvent)
	 */
	public void onBulletHitBullet(robocode.BulletHitBulletEvent event)
	{
		BulletHitBulletEvent newEvent = new BulletHitBulletEvent(event);
		for(int i=0; i<listeners.size(); i++)
		{
			EventListener listener = (EventListener)listeners.get(i);
			listener.onBulletHitBullet(newEvent);
		}
	}
	
	/* (non-Javadoc)
	 * @see robocode.Robot#onHitByBullet(robocode.HitByBulletEvent)
	 */
	public void onHitByBullet(robocode.HitByBulletEvent event)
	{
		HitByBulletEvent newEvent = new HitByBulletEvent(event);
		for(int i=0; i<listeners.size(); i++)
		{
			EventListener listener = (EventListener)listeners.get(i);
			listener.onHitByBullet(newEvent);
		}
	}
	
	/* (non-Javadoc)
	 * @see robocode.Robot#onHitRobot(robocode.HitRobotEvent)
	 */
	public void onHitRobot(robocode.HitRobotEvent event)
	{
		HitRobotEvent newEvent = new HitRobotEvent(event, this);
		for(int i=0; i<listeners.size(); i++)
		{
			EventListener listener = (EventListener)listeners.get(i);
			listener.onHitRobot(newEvent);
		}
	}
	
	/* (non-Javadoc)
	 * @see robocode.Robot#onHitWall(robocode.HitWallEvent)
	 */
	public void onHitWall(robocode.HitWallEvent event)
	{
		HitWallEvent newEvent = new HitWallEvent(event);
		for(int i=0; i<listeners.size(); i++)
		{
			EventListener listener = (EventListener)listeners.get(i);
			listener.onHitWall(newEvent);
		}
	}
	
	/* (non-Javadoc)
	 * @see robocode.AdvancedRobot#onSkippedTurn(robocode.SkippedTurnEvent)
	 */
	public void onSkippedTurn(robocode.SkippedTurnEvent event)
	{
        OvertimeEvent newEvent = new OvertimeEvent(event);
		for(int i=0; i<listeners.size(); i++)
		{
			EventListener listener = (EventListener)listeners.get(i);
			listener.onOvertime(newEvent);
		}
	}
	
	/* (non-Javadoc)
	 * @see robocode.Robot#onRobotDeath(robocode.RobotDeathEvent)
	 */
    public void onRobotDeath(robocode.RobotDeathEvent event)
	{
		RobotDeathEvent newEvent = new RobotDeathEvent(event);
		for(int i=0; i<listeners.size(); i++)
		{
			EventListener listener = (EventListener)listeners.get(i);
			listener.onRobotDeath(newEvent);
		}
	}

	/* (non-Javadoc)
	 * @see robocode.Robot#onWin(robocode.WinEvent)
	 */
	public void onWin(robocode.WinEvent event)
	{
		onRoundFinish();
	}
    
	/* (non-Javadoc)
	 * @see robocode.Robot#onDeath(robocode.DeathEvent)
	 */
	public void onDeath(robocode.DeathEvent event) 
	{
		onRoundFinish();
	}

	/* (non-Javadoc)
	 * @see robocode.TeamRobot#onMessageReceived(robocode.MessageEvent)
	 */
	public void onMessageReceived(robocode.MessageEvent event)
	{
		MessageEvent newEvent = new MessageEvent(event);
		for(int i=0; i<listeners.size(); i++)
		{
			EventListener listener = (EventListener)listeners.get(i);
			listener.onMessageReceived(newEvent);
		}
	}
	
}





