package blir.nano.inch;

import robocode.*;
import static robocode.util.Utils.*;
import java.awt.Color;

/**
 * Inchworm - a robot by Blir
 */
public class Inchworm extends Robot {

	/**
	 * run: Inchworm's default behavior
	 */
	public void run() {
		setColors(Color.black,Color.red,Color.red, Color.red, null);
		ahead(50);
		setAdjustGunForRobotTurn(true);
		while (true) {
			turnGunLeft(180);
			ahead(100);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent evt) {
		fire(Rules.MAX_BULLET_POWER);
		if (evt.getVelocity() <= 1) {
			turnGunRight(0);
			scan();
		}
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent evt) {
		turnGunRight(normalRelativeAngleDegrees(evt.getHeading() - getGunHeading() - 180));
		fire(Rules.MAX_BULLET_POWER);
	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent evt) {
		turnLeft(90);
	}
	
	/**
	 * OnHitRobot: What to do when you hit another robot
	 */
	public void onHitRobot(HitRobotEvent evt) {
		turnGunRight(normalRelativeAngleDegrees(evt.getBearing() + getHeading() - getGunHeading()));
		fire(Rules.MAX_BULLET_POWER);
	}
}						