package tobe.guns;
import tobe.util.*;
import tobe.statistics.*;
import robocode.*;
import java.util.List;
import tobe.platform.*;

	public class TimeLaser implements Gun{
		
		public Aim aim(CommandCentre cc) {
			AdvancedRobot bot = cc.getBot();
			if(target == null) target = cc.getPreferredTarget();
			if(target == null) return null;
			if(!target.isSeen()) {
				reset();
				target = cc.getPreferredTarget();
				if(target == null) return null;
			}
			CircularArray evasions = target.getEvasions();
			v.setVector(target.getPosition());
			v.changeOrigin(bot.getX(), bot.getY());
			double shotPower = Math.min(3,bot.getEnergy()-5.0);
			if(shotPower < 0.5) shotPower = Math.min(0.5, bot.getEnergy()-0.1);
			shotPower = (target.getEnergy() > 0 ? shotPower : 0.1);
			if(shotPower < 0.1) return null;
			double maxShotPower = shotPower;
			double bulletVelocity = (20-3*shotPower);
			double scanAge = bot.getTime()-target.getTime();
			double timeToHit = Math.min(wishedTimeToHit-scanAge+2*bot.getOthers(), v.getDistance()/bulletVelocity);
			//targetting here
			if(evasions.size() > 0 && target.getEnergy() > 0) {
				//if( chosenEvasion == null) {
					int k = (int) random.nextDouble()*evasions.size();
					chosenEvasion = (Evasion) evasions.get(k);
				//}
				//time method, should be better in melee when scans are old
			    int n = 5;
			    do {
				double time = timeToHit+scanAge;
				v.add(chosenEvasion.getHeadingRelativeHeading()+target.getHeading(), chosenEvasion.getVelocity()*time);
				v.changeOrigin(bot.getX(), bot.getY());
				bulletVelocity = v.getDistance()/timeToHit;
				shotPower = (20-bulletVelocity)/3;
				if(shotPower > maxShotPower) {
					timeToHit--;
					v.setVector(target.getPosition());
					v.changeOrigin(bot.getX(), bot.getY());
				}
				n--;
			    } while( shotPower > maxShotPower && n>0);
			}
			double m = bot.getWidth()*0.8;
			double h = cc.getPlayingField().getHeight();
			double w = cc.getPlayingField().getWidth();
			double x = Math.min(w-m,Math.max(m,v.getToX()));
			double y = Math.min(h-m,Math.max(m,v.getToY()));
			v.setPoints(x,y,bot.getX(), bot.getY());
			shotPower = (target.getEnergy() > 0 ? shotPower : 0.1);
			if(shotPower < 0.1) return null;
			return new Aim(v.getBearing(), Math.atan(bot.getWidth()/2/v.getDistance()), shotPower);
		}
		
		public void reset() {
			chosenEvasion = null;
			target = null;
		}
	
	//constants
	static final double wishedTimeToHit = 40;
	
	//variables
		private BearingVector v = new BearingVector();//for calculations
		private java.util.Random random = new java.util.Random();
		private Evasion chosenEvasion;//to keep aiming "the same shot"
		private TargetStatistics target;
}
	