/*
 * Written by Kinsen Choy
 */

package kinsen.melee.Guns;
import kinsen.melee.Details;
import java.awt.Point;

/*
 * StopAndGo - A gun class that fires stop and go predicted bullets.
 */
public class Oscillator extends Gun
{
	// Last enemy details
	private Details enemy = null;
	// Last my details
	private Details me = null;
	// Average enemy turn
	private double enemyTurn;

	// Time of oscillation
	private long oscillationTime = 0;
	// Last time of oscillation change
	private long lastOscillation = 0;
	// Last change end point
	private Point endPoint = null;
	// Non-zero oscillation direction
	private int oscillationDirection = 1;
	// Previous average enemy velocity because robot will have to slow down
	private double averageVelocity = 7;
	// Current average velocity
	private double newAverageVelocity = 0;
	// Last details time
	private long lastTime = 0;
	// Average velocity count
	private int velocityCount = 0;

	public void calculateGun(double initialFirePower)
	{
		// If there is no data then it can not fire
		if (enemy != null)
		{
			firePower = initialFirePower;
			long predictTime = oscillationTime - lastTime - lastOscillation;
			// If oscillation should change then assume oscillation change
			if (predictTime <= 0)
				predictTime = oscillationTime;
			// Make sure that it has picked up on an oscillation first
			if (oscillationTime != 0)
				fireAt = super.predictPosition(enemy.getX(), enemy.getY(), me.getX(), me.getY(), enemy.getHeading(),
								averageVelocity * oscillationDirection, enemyTurn, firePower, (int) predictTime, (int) oscillationTime, true);
			else
				fireAt = new Point((int) enemy.getX(), (int) enemy.getY());
		}
	}

	public void calculateGun(double initialFirePower, boolean canChangePower)
	{
		calculateGun(initialFirePower);
	}

	public void recordData(Details enemyDetails, Details myDetails, long time)
	{
		// If there is previous data then calculate turn
		if (enemy != null)
			enemyTurn = (enemyDetails.getHeading() - enemy.getHeading()) / (time - lastTime);

		enemy = enemyDetails;
		me = myDetails;
		if (endPoint == null)
			endPoint = new Point((int) enemy.getX(), (int) enemy.getY());

		// Set oscillation direction
		if (enemy.getVelocity() != 0)
		{
			int newDirection = (int) (enemy.getVelocity() / Math.abs(enemy.getVelocity()));
			if (newDirection != oscillationDirection)
			{
				oscillationDirection = newDirection;
				// Absolute value so that if time is not reset it does not crash
				oscillationTime = Math.abs(time - lastOscillation);
				lastOscillation = time;
				velocityCount = 0;
				averageVelocity = newAverageVelocity;
			}
		}

		newAverageVelocity = (newAverageVelocity * velocityCount + Math.abs(enemy.getVelocity())) / (velocityCount + 1);
		velocityCount++;

		lastTime = time;
	}
}