package jgap;

import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;

public class JGAP7247_2
    extends AdvancedRobot {
  private double global1 = 3.0;
  static double lastEnemyHeading;
  static double radarturn = 1;
  static int shots = 0;
  static double x = 2.0;
  static double y = 1.0;
  static double z = 3.0;
  static double enemyX = 0;
  static double enemyY = 0;
  static double distance = -1.0;
  static double[] memory = new double[50];
  Point2D robotLocation = new Point2D.Double();
  Point2D enemyLocation = new Point2D.Double();
  void toLocation(double angle, double length, Point2D sourceLocation,
                  Point2D targetLocation) {
    targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length,
                               sourceLocation.getY() + Math.cos(angle) * length);
  }

  double normalize(double angle) {
    return angle - 2 * Math.PI * Math.floor( (angle + Math.PI) / (2 * Math.PI));
  }

  public void run() {
    setColors(Color.red, Color.blue, Color.green);
    setAdjustRadarForGunTurn(true);
// Initialization stuff
    do {
      turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }
    while (true);
  }

  public void onScannedRobot(ScannedRobotEvent e) {
    x = getHeading() + e.getBearing();
    y = getRadarTurnRemaining();
    distance = e.getDistance();
    robotLocation.setLocation(getX(), getY());
    double enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
    toLocation(enemyAbsoluteBearing, distance, robotLocation, enemyLocation);
    enemyX = enemyLocation.getX();
    enemyY = enemyLocation.getY();
    {
      memory[ (int) ( ( (11) + getRoundNum()) -
                     ( (2) - (11)))] = Math.min(Math.sin(getGunHeat()),
                                                e.getEnergy());
      {
        setAhead( (40.53856658935547d));
        setTurnLeft( ( -180d));
        {
          scan();
          shots++;
          setFireBullet( (int) getTime());
        }

        // TurnGunRightEnemy
        setTurnGunRight(getHeading() + e.getBearing() - getGunHeading());
        // CircularLinePredictor:Begin
        radarturn = -radarturn;
        double w = e.getHeadingRadians() - lastEnemyHeading;
        lastEnemyHeading = e.getHeadingRadians();
        double absbearing = e.getBearingRadians() + getHeadingRadians();
        double eX = e.getDistance() * Math.sin(absbearing);
        double eY = e.getDistance() * Math.cos(absbearing);
        double db = 0;
        double ww = lastEnemyHeading;
        do {
          db += 11;
          double dx = e.getVelocity() * Math.sin(ww);
          double dy = e.getVelocity() * Math.cos(ww);
          ww += w;
          eX += dx;
          eY += dy;
        }
        while (db < Point2D.distance(0, 0, eX, eY));
        setTurnGunRightRadians(Math.asin(Math.sin(Math.atan2(eX, eY) -
                                                  getGunHeadingRadians())));
        setTurnRightRadians(e.getBearingRadians() + .5 * Math.PI);
        // CircularLinePredictor:End

      }

      setTurnRadarRight(e.getEnergy());
      scan();
    }

  }

  public void onHitByBullet(HitByBulletEvent e) {
    setTurnLeft(getGunHeat());
    if ( ( (getGunHeading() / ( -90d)) == ( -90d))) {
      {
        setAhead(getDistanceRemaining());
        setAhead(getX());
        shots++;
        setFire(getX());
      }
    }
    else {
      setTurnRight(e.getHeading());
    }

  }

  public void onHitWall(HitWallEvent e) {
    {
      setAhead( ( (getHeading() * (54.39848327636719d)) * (5.275475978851318d)));
      {
        setAhead(getHeading());
        setBack( (54.39848327636719d));
      }

    }

  }

  public void onHitRobot(HitRobotEvent e) {
    setTurnRight(getGunTurnRemaining());
  }

}
