package cx.mini;
import robocode.*;
import java.awt.Color;
import java.util.Vector;
import java.awt.geom.Point2D;
import cx.utils.Wave;
/**
 *-----------------------------------------------------------------
 * @author:iiley (iiley@hotmail.com)
 * http://www.robochina.org
 *---
 * Stay by the window,smoke and listen to the Lacrimas Profundere'Black Swans...
 *---
 * BlackSwans:use Sigaret's pattern analyser but very different movement.
 *-------------------------------------------------------
 * 0.36:improved pattern analyzer a little.
 *--------------------version 0.38 2003.1.8--------------
 * 0.38:improved pattern analyzer a little.
 *--------------------version 0.40 2003.1.15--------------
 * 0.40:aded a property gunNeedTurn to judge if can turn compeletly.
 * and added minDTW(enemy min distance to wall)(codesize 1493)
 *--------------------version 0.40 2003.1.15--------------
 * 0.40:keep the aim same to new Cigaret.(codesize 1488)
 *--------------------version 0.60 2003.1.15--------------
 * 0.50:keep the aim same to new Cigaret.(codesize 1447)
 *-------------------------------------------------------
 * future:...No one know how future will be...
 *+++++++++++++++++++++++++++++++++Open Source+++++++++++++++++++++++++++
 *--
 * This bot is open source. 
 * - Don't just copy-paste the code .
 * - Don't just copy-paste and then improve.(I don't want to fight modified versions of my own bot)
 * - Maybe some useful skill in this codes,if you use,Make your bot open source
 * - And preferably give credit.:)
 *
 * If you want to know more or suggest,
 * email me or post messages on www.robochina.org or www.robocoderepository's forums.
 * every messages will be pleasent.
 *--
 */
public class BlackSwans extends AdvancedRobot
{
	private static Vector waves=new Vector();
	private static double minDTW=50;
    private static double preDiffAngle;
	private static double power;

	public void run( ) {
		setColors(Color.gray,Color.gray,new Color(100,15,16));
		setAdjustGunForRobotTurn(true);
	    setAdjustRadarForGunTurn(true);
	    setAdjustRadarForRobotTurn(true);
		while(waves.size()>3500) waves.remove(0);   //max size 3500
		do{
			turnRadarRightRadians(5);	
		}
		while(true);
	} 
    // -------------------- function for event handle ---------------
   	public void onScannedRobot( ScannedRobotEvent e ) {
		double absBearing=Wave.standardAngle(e.getBearingRadians()+getHeadingRadians()); 
		// Radar turn grabed from David Alves.
		setTurnRadarRightRadians(Math.sin(absBearing - getRadarHeadingRadians()));

        long time=getTime();
        double myX=getX();
		double myY=getY();
		double edistance=e.getDistance(); 
		double ex=myX+Math.sin(absBearing)*edistance;
		double ey=myY+Math.cos(absBearing)*edistance;
		minDTW=Math.min(minDTW,distanceToWall(ex,ey));
		//--------------movement---------------------
		double hbw=getBattleFieldWidth()/2;
		double hbh=getBattleFieldHeight()/2;
		double enemyBearingToCenter=Math.atan2(ex-hbw,ey-hbh);
		double myBearingOfCenter=Math.atan2(hbw-myX,hbh-myY);
		double disBearing=Wave.standardAngle(enemyBearingToCenter-myBearingOfCenter);
		double disToCenterBearing=Wave.standardAngle(myBearingOfCenter-getHeadingRadians());
		double moveDistance=Math.abs(disBearing)*edistance;
		moveDistance+=moveDistance*Math.random();
		if(disToCenterBearing*disBearing<0)
			moveDistance=-moveDistance;
			//see this usage of Smog
		double distanceToCenter=Point2D.distance(hbw,hbh,myX,myY);
		double enemyDToC=Point2D.distance(hbw,hbh,ex,ey);

		double willDistanceToCenter=Math.max(
			Math.min(enemyDToC+(20*Math.random()-10),
			Math.min(hbh,hbw)-30),     //maxR
			150
			);

		if(enemyDToC<150 || moveDistance>edistance*1.5){
			distanceToCenter=edistance;
			willDistanceToCenter=150+Math.random()*80;
			disToCenterBearing=e.getBearingRadians();
			moveDistance*=Math.random();
		}
        double needTurn=0.5*Math.PI*(willDistanceToCenter)/distanceToCenter;
		setTurnRightRadians(disToCenterBearing-(getVelocity()>0?needTurn:(Math.PI-needTurn)));
		if(moveDistance>0)
	    	moveDistance+=(edistance*Math.random()-edistance/2);
		else
			moveDistance-=(edistance*Math.random()-edistance/2);
		moveDistance*=Math.random();
		if(moveDistance>200) moveDistance*=Math.random();
        if(Math.abs(getDistanceRemaining())<8*Math.random() || getTime()%50==0)
			setAhead(moveDistance);
		needTurn=Math.abs(getTurnRemaining()) > 15 ? 2+Math.random()*6 : 8;
		if(needTurn<4) needTurn=2+Math.random()*6;
        setMaxVelocity( needTurn );
		//------------------------------patten analyser----------------------------------

		int i,wavesSize=waves.size();
		//use 200,200*11>2000,usually > battleFiledWidth and battleFiledHeight
		for(i=wavesSize-1;i>=0 && i>wavesSize-201;i--)
			((Wave)waves.elementAt(i)).test(ex,ey,time);

		double firedPower=0d;
		if(power>0d && getEnergy()-power>0.1d && Math.abs(preDiffAngle)<0.35d){
		    if(setFireBullet(power)!=null) 
			    firedPower=power;
		}
        power=Math.min(3,e.getEnergy()/5+0.1);

        waves.add(new Wave(myX,myY,firedPower,time,absBearing,edistance,(firedPower=e.getVelocity())*Math.sin(e.getHeadingRadians()-absBearing),firedPower*Math.sin(e.getHeadingRadians()-Math.atan2(ex-getBattleFieldWidth()/2,ey-getBattleFieldHeight()/2))/2));
		preDiffAngle=0d;
		if(getGunHeat()/getGunCoolingRate()<4d){
            //-------------find match wave---------------
	    	double moveAngle,matchValue=Double.POSITIVE_INFINITY;//very large
    		for(i=73;i<wavesSize;i++){
	    		double comVal,comValD;
    			Wave wave=(Wave)waves.elementAt(i);
	    		if(wave.willHitDiffAngle<10D){//is a succeded wave
				    int j=0; 
					double div=0;
				    double dir=1d;
		    	    comVal=comValD=(Math.abs(power-wave.power)-3)/10d;

					do{
						comVal+=Wave.getComVal(waves.elementAt(wavesSize-j),waves.elementAt(i-j),1d)/(div=div*2+1);
						comValD+=Wave.getComVal(waves.elementAt(wavesSize-j),waves.elementAt(i-j),-1d)/(div);
					}while((j+=8)<73);

					if(comValD<comVal){
                		comVal=comValD;
						dir=-1d;
					}
					if(comVal<=matchValue){
                		//moveAngle is enemy's furture bearing now
                    	ex=myX+Math.sin(moveAngle=absBearing+wave.willHitDiffAngle*dir)*wave.velocity;   //matched wave's velocity is distance(not v)
                    	ey=myY+Math.cos(moveAngle)*wave.velocity;

						if(distanceToWall(ex,ey)>=minDTW){
			            	matchValue=comVal;
			        		preDiffAngle=wave.willHitDiffAngle*dir;
						}
					}
	    		}
    		}
		}
		if(e.getEnergy()==0d) preDiffAngle=0d;
        //turn gun
        setTurnGunLeftRadians(preDiffAngle=Wave.standardAngle(getGunHeadingRadians()-absBearing-preDiffAngle));
		execute();
    }

	public double distanceToWall(double x,double y){
		return Math.min(Math.min(x,getBattleFieldWidth()-x),Math.min(y,getBattleFieldHeight()-y));
	}
}
