package dft;
import dft.inject.gun.*;
import dft.inject.move.*;
import robocode.*;
import java.awt.Color;

//	Cyanide: by Alcatraz (Dave Todd, USA; v1.90 - Apr 24 2006)
//	Released under the RWPCL (robowiki.net)
	
public class Cyanide extends AdvancedRobot {
	
	public void run() {
		
		setColors(new Color(175,0,0),new Color(75,0,0),new Color(250,250,250));
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setTurnRadarRight(360);
		
		while (true) {
			
			// Keep working even if there are no enemies		
			if (lastScan != null) {
				Move.onScannedRobot(this,lastScan);		
				setTurnRightRadians(Move.getTurn());
				setAhead(Move.getAhead());
				setMaxVelocity(Move.getMaxVelocity());						
				Gun.onScannedRobot(this,lastScan);	
				setTurnGunRightRadians(Gun.getGunTurn());
				
				if (Gun.getBulletPower() > 0) 					
					setFire(Gun.getBulletPower());
			}
			
			if (getTime()-scanTime>8)
				setTurnRadarRight(360);
			
			
			execute();
			//turnRadarRightRadians(1);
		}
	}	
	
	Cannon Gun = new Cannon();
	Surf Move = new Surf();
	
	ScannedRobotEvent lastScan = null;	
	long scanTime = 0;
	
	public void onScannedRobot(ScannedRobotEvent e) {		
		scanTime = getTime();
		lastScan = e;
		setTurnRadarRightRadians(Math.tan(e.getBearingRadians()+getHeadingRadians()-getRadarHeadingRadians())*1.94);							
	
	}
	
	// Trigger movement behavior
	public void onHitByBullet(HitByBulletEvent e) {
		Move.onHitByBullet(this,e);
	}
	public void onBulletHitBullet(BulletHitBulletEvent e) {	
		Move.onBulletHitBullet(this,e);
	}
	
	// Statistics, mostly just outputted	
	static int wins = 0;	
	public void onWin(WinEvent e) {
		roundOver("WIN");
	}
	public void onDeath(DeathEvent e) {
		roundOver("LOSS");		
	}
	public void roundOver(String result) {
		if (result.equals("WIN")) {
			wins++;
		}
		System.out.println("W/L: " + wins + "-" + (getRoundNum()+1-wins));
		System.out.println("---");
		System.out.println("RND: " + rHit/(rMiss+rHit)*100+"%");
		System.out.println("TOT: " + tHit/(tMiss+tHit)*100+"%");		
	}	
	
	static double tHit, tMiss;
	double rHit, rMiss;
	
	public void onBulletHit(BulletHitEvent e) {		
		Move.onBulletHit(this,e);		
		gunStatUpdate("HIT");
	}
		
	public void onBulletMissed(BulletMissedEvent e) {
		if (getOthers() > 0) gunStatUpdate("MISS");
	}
		
	public void gunStatUpdate(String result) {		
		if (result.equals("HIT")) {
			rHit++; tHit++;
		}
		else {
			tMiss++; rMiss++;
		}
	}
	
}