package apv;
import robocode.*;

/** NanoLauLectrik -  by Albert Prez 
* v 0.6	I managed to put a pattern matcher in a Nano... 
* v 0.7 New pattern matcher with fixed length. Previous one was too bugous and didn't fit after fixing
* v 0.8 More bugs fixed
*		Now compatible with java 1.3
* v 0.9 Again, only compatible with 1.4
* 		Improved pattern matcher:
*			Codesize reduced - I included some very good improvements Mike made on his bot (Moebious)
*			Now, it uses the perp. velocity for the matching (like Moebious)
*			Now, it matches the closer pattern in the time, so it caches changes in behaviour
*			Variable pattern-size pattern matcher !!!! into a nanobot !!!
*		Reduced main loop bucle
*		Eliminated AdjustRadarForGunTurn
*		Other minor improvements to reduce code size
* v 1.0	Reduced pattern matcher code size thanks to Kuuran's trick in NanoSatan
*		Added some more complex oscillatory movement
*		  
*/		  

public class NanoLauLectrik extends AdvancedRobot {
	
	static int n; 
	static double[] ev = new double[100000];
	static StringBuffer pattern = new StringBuffer();
			
	public void run() {	turnRadarRightRadians(Double.POSITIVE_INFINITY); }		
	
	public void onScannedRobot(ScannedRobotEvent e) {
		//ENEMY DATA 
		double targetBearing;
		int pointer;
		ev[++n] = ev[n-1] + (pointer = (int) (e.getVelocity()*Math.sin(e.getHeadingRadians()-(targetBearing=e.getBearingRadians() + getHeadingRadians()))));
		pattern.append((char)pointer);	
		//AIMING & FIRING
		int len = 30;
		//reduced code size thanks to NanoSatan's (from Kuuran) trick of using "n" instead of pattern.lenght()
		do { pointer = pattern.lastIndexOf(pattern.substring(Math.max(n-len,0)),n-100);		
		} while (--len*pointer < -1); 
		pointer += len;
		setTurnGunRightRadians(Math.sin( 
			(ev[pointer+((int)(e.getDistance()/11))]-ev[pointer])/e.getDistance() + targetBearing - getGunHeadingRadians()
		));
		setFire(3); 
		//MOVEMENT
		setTurnRightRadians(e.getBearingRadians()+Math.PI/2);
		setAhead(Math.sin(n/12)*Math.cos(n/7)*200);
		//RADAR
		setTurnRadarLeftRadians(getRadarTurnRemaining());
	}
		
}

										