package myl.micro;
import robocode.*;
import java.awt.Color;
import java.awt.geom.Point2D;

/**
 + Avipes "bird foot" - a microbot at codesize 657 by Martin Y Lepsoy (DrLoco)
 + email: mlepsoy@yahoo.no
 |
 |
 + Version 1.00
 + 31.03.2003
 + features a new movement based on Troodon's
 + and Kakuru's nanosized pattern matcher
 |
 |
 + The reason I made this bot an open source bot is becasue I hope it will inspire and give ideas to other robocoders
 + Feel free to use parts of my codes for your own use as long as you
 + make your bot open source,
 + don't just copy this bot as it is,
 + don't just copy this bot and modify it. 
 + Also I would appreciate credit;)
 |
 |
 + I would like to thank Albert Prez with his NanoLauLectrik for giving me the ideas I needed to finish my nano pattern analyzer
 */
public class Avipes extends AdvancedRobot
{
	/**
	 * Variables used for our movement
	 *
	 * moveTime decides how long it will be before we start with counting down for our next move
	 * stopTime decides how long we will stand still before we start moving again
	 * these two variables is not controlling our movement completely, because Avipes can move further than or shorter than the time given by the timers
	 */
	
	static double		moveTime;
	static double		stopTime;
	
	/**
	 * Variables used for our gun
	 *
	 * storageSize is the size of our stored values for our pattern matcher
	 * searchSize is the size of the array we will search in when trying to find a pattern
	 * pattern[] is the array we store every directional velocity in
	 */
	
	final static int	storageSize = 1000;
	final static int	searchSize = storageSize - 111;
	static double[]		pattern = new double[ storageSize ];
	
		public void run() {
		
		/**
		 * setAdjustRadarForGunTurn(true) can be removed with little problem if codesize forces me to it, but it's not needed at this time
		 */
		
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		setColors( Color.cyan.darker().darker() , Color.yellow , Color.yellow );
		
		while( true ) {
			turnRadarRightRadians( 5 );
		}
	}
	
	public void onScannedRobot( ScannedRobotEvent e ) {
		double ourX , ourY , enemyX , enemyY , testX , testY , destinationX , destinationY , distance , bearing , firePower , move , force , smallestForce , match , bestMatch;
		int index , matchIndex , timeToImpact , length;
		enemyX = ( ourX = destinationX = getX() ) + ( distance = e.getDistance() ) * Math.sin( bearing = getHeadingRadians() + e.getBearingRadians() );
		enemyY = ( ourY = destinationY = getY() ) + distance * Math.cos( bearing );
		smallestForce = 0;
		bestMatch = Double.POSITIVE_INFINITY;
		if ( moveTime-- < 0 ) {
			stopTime = Math.random() * distance * 0.025;
			moveTime = Double.POSITIVE_INFINITY;
		}
		if ( stopTime-- < 0 ) {
			index = 0;
			moveTime = Math.random() * distance * 0.5;
			stopTime = Double.POSITIVE_INFINITY;
			do {
				
				/**
				 * testX and testY makes a random point within our search square
				 * the coordinate is then fixed so it won't excede 20 pixles inside our battlefield
				 */
				
				testX = 20 + Math.random() * ( getBattleFieldWidth() - 40 );
				testY = 20 + Math.random() * ( getBattleFieldHeight() - 40 );
					
				/**
				 * set the force of a point to the power of the distance from the point to us multiplied by how far the angle,
				 * between the line from us to the enemy and the line beween us to the point,
				 * is from staying perpendicular to the enemy
				 * later we go to the point with the highest force
				 */
				
				force = Math.abs( Math.tan( Math.atan2( testX - ourX , testY - ourY ) - bearing ) ) - ( Point2D.Double.distance( ourX , ourY , testX , testY ) / distance );
				
				if ( force > smallestForce && Point2D.Double.distance( ourX , ourY , testX , testY ) > moveTime ) {
					smallestForce = force;
					destinationX = testX;
					destinationY = testY;
				}
			} while( index++ < 200 );
			
			/**
			 * this is the code of the smallest way to drive
			 * to a given point in the shortest route.
			 * - developed by David Alves and Dummy
			 */
			
			setAhead(
			 ( ( testX = relative( Math.atan2( destinationX - ourX , destinationY - ourY ) - getHeadingRadians() ) ) ==
			 ( testX = Math.atan( Math.tan( testX ) ) ) ? 1 : - 1 )
			 * Point2D.Double.distance( ourX , ourY , destinationX , destinationY ) );
			setTurnRightRadians( testX );
			
			moveTime /= 8;
		}
		
		/**
		 * stop when we are turning more than
		 * 45 degrees to make sharper turns
		 */
		
		setMaxVelocity( getTurnRemaining() > 45 ? 0.0001 : 8 );
		
		/**
		 * fire a bullet if the criteria below is met.
		 * firePower varies by our own energy left, and distance to the enemy
		 */
		
		if ( getEnergy() - ( firePower = Math.min( 3 , 40 * getEnergy() / distance ) ) - 0.1 > Math.min( e.getEnergy() , 3 ) ) {
			setFire( firePower );
		}
		
		/**
		 * timeToImpact is the time a bullet needs to reach the enemy.
		 * index is set to searchSize so we start to try to find a pattern at the end of our stored values,
		 * then index is lowered until it gets 1.
		 * pattern[ 0 ] is set to the enemy's directional velocity.
		 * later we set the next index in 'pattern' to the value of this index in 'pattern'
		 */
		
		timeToImpact = (int)( distance / ( 20 - 3 * firePower ) );
		index = matchIndex = searchSize;
		pattern[ 0 ] += e.getVelocity() * Math.sin( e.getHeadingRadians() - bearing );
		
		do {
			match = 0;
			length = 1;
			do {
				
				/**
				 * cycle every value in a range of 'timeToImpact'
				 * and add the difference between the value in this index and the current values to 'match'
				 * later we pick the lowest 'match' as the 'bestMatch'
				 */
				
				match += Math.abs( getOffset( length , 1 ) - getOffset( index + length , 1 ) );
			} while( length++ < timeToImpact );
			
			if ( match < bestMatch && index > timeToImpact ) {
				matchIndex = index;
				bestMatch = match;
			}
			pattern[ index + 1 ] = pattern[ index ];
		} while( index-- > 0 );
		
		setTurnGunRightRadians( relative( bearing + getOffset( matchIndex , timeToImpact ) / distance - getGunHeadingRadians() ) );
		
		setTurnRadarRightRadians( relative( bearing - getRadarHeadingRadians() ) );
		
		execute();
	}
	
	/**
	 * get the relative angle where - PI < angle < PI
	 */
	
	public double relative( double angle ) {
		return Math.atan2( Math.sin( angle ), Math.cos( angle ) );
	}
	
	/**
	 * get the angle difference between two points in our stored results.
	 * index is our start point, then we find the angle between this point and the point which is 'range' away
	 */
	
	public double getOffset( int index , int range ) {
		return ( pattern[ index - range ] - pattern[ index ] );
	}
}