package cs.s2;

import robocode.*;

import java.util.*;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;

import cs.s2.gun.*;
import cs.s2.move.*;


import static cs.s2.Constants.*;

/**
 * 2.0.1 : Rank 208 @ 1744.0
 * 2.0.2 : Rank 86  @ 1888.6
 * 2.0.3 : Rank 60  @ 1945.5
 * 
 * @author Chase
 *
 */
public class Seraphim extends AdvancedRobot {
	public static Extension[] ext;
	public static boolean initialized = false;
	/** Fires 3.0 power, stationary */
	public static boolean isReference = false;
	/** Moves but does not fire */
	public static boolean isChallenge = false;
	
	public Seraphim() {
		final List<Extension> extList = new ArrayList<Extension>();
		
		/************************
		 * Add Extensions Here! 
		 ***********************/
		extList.add(new Radar());
		extList.add(new TestSword());
		extList.add(new SurferBaseX());
		/************************
		 * End Add Extensions! 
		 ***********************/
		
		ext = new Extension[extList.size()];
		extList.toArray(ext);
		
		for(Extension e : ext) {
			e.bot = this;
		}
	}
	
	public void run() {
		if(!initialized) {
			Extension.field = new Rectangle2D.Double(0, 0,
				getBattleFieldWidth(), getBattleFieldHeight());
			Extension.battlefield = new Rectangle2D.Double(18, 18,
					getBattleFieldWidth()-36, getBattleFieldHeight()-36);
			
			//Load our properties
			Properties p = new Properties();
			try {
				p.load(new FileInputStream(getDataFile("config.ini")));
			} catch (Exception e) {
				//Properties failed to load in some way
			}
			String behavior = p.getProperty("behavior","normal");
			if(behavior.toLowerCase().equals("reference")) isReference = true;
			if(behavior.toLowerCase().equals("challenge")) isChallenge = true;
			if(behavior.toLowerCase().equals("disable")) isReference = isChallenge = true;
			System.out.println("Setting mode to " + behavior + ".");
			
			setBodyColor(COLOR_BODY);
			setGunColor(COLOR_GUN);
			setRadarColor(COLOR_RADAR);
			setScanColor(COLOR_SCAN);
			setBulletColor(COLOR_BULLET);
			
			initialized = true;
		}
		
		setAdjustRadarForRobotTurn(true);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		for(Extension e : ext) {
			e.bot = this;
			e.run();
		}
		
	    while(true) {
	    	for(Extension e : ext) {
				e.execute();
			}
	    	execute();
	    }
	}
	
	public final void onSkippedTurn(SkippedTurnEvent e) {
		System.out.println("Skipped turn " + e.getTime());
	}
	
	public final void onStatus(StatusEvent e) {
		for(Extension ex : ext)
			ex.onStatus(e);
	}
	public void onBulletHit(BulletHitEvent e) {
		for(Extension ex : ext)
			ex.onBulletHit(e);
	}
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		for(Extension ex : ext)
    		ex.onBulletHitBullet(e);
	}
	public void onBulletMissed(BulletMissedEvent e) {
		for(Extension ex : ext)
    		ex.onBulletMissed(e);
	}
	public void onHitByBullet(HitByBulletEvent e) {
		for(Extension ex : ext)
    		ex.onHitByBullet(e);
	}
	public void onHitRobot(HitRobotEvent e) {
		for(Extension ex : ext)
    		ex.onHitRobot(e);
	}
	public void onHitWall(HitWallEvent e) {
		for(Extension ex : ext)
    		ex.onHitWall(e);
	}
	public void onRobotDeath(RobotDeathEvent e) {
		for(Extension ex : ext)
    		ex.onRobotDeath(e);
	}
	public void onScannedRobot(ScannedRobotEvent e) {
		for(Extension ex : ext)
    		ex.onScannedRobot(e);
	}
	public void onRoundEnd() {
		for(Extension ex : ext)
    		ex.onRoundEnd();
	}
	public void onPaint(Graphics2D g) {
		for(Extension ex : ext)
    		ex.onPaint(g);
	}
    public void onDeath(DeathEvent e) {
    	onRoundEnd();
    }
	public void onWin(WinEvent e) {
		onRoundEnd();
	}
	public void onBattleEnded(BattleEndedEvent e) {
		for(Extension ex : ext)
    		ex.onBattleEnded(e);
	}
}
