package adt;
import robocode.*;
import java.util.Iterator;
import java.util.LinkedList;
import java.awt.geom.Point2D;

/**
 * MyClass - a class by (your name here)
 *
 *		y = ay*t + by
 *		x = ax*t + bx
 */
public class SLP_RobotMemory extends RobotMemory {
	
	boolean stationary=true;
	double ax,bx , ay,by;
	double maxVelocityError = 2;
	Context my;
	
	public SLP_RobotMemory( Robot self, String name, Context my )
	{
		super( self,name );
		this.my = my;
	}
	
	public void update( long t, Object eventData, Point2D.Double position )
	{
		if ( entries.size() > 0 )
		{
			if (stationary)
			{
				// we think it was stationary, just check if its is moving
				RobotMemoryEntry thisMemoryEntry = (RobotMemoryEntry)(entries.getFirst());
				
				if ( ((ScannedRobotEvent)(thisMemoryEntry.getEvent())).getVelocity() > 0 )
				{
					stationary = false;
					estimateMovementFromLastScan( thisMemoryEntry );
				}
				else if ( entries.size() > 1 )
				{
					// it isn't currently moving, but has it moved since we say it last moved...
					if (position.distance( thisMemoryEntry.getPosition() ) > maxVelocityError )
					{
						// it HAS moved....
						stationary = false;
						doLinearRegression();
					}
				}
								
			}
			else
			{
				RobotMemoryEntry thisMemoryEntry = (RobotMemoryEntry)(entries.getFirst());
				long old = thisMemoryEntry.getTime();
						
				// it was moving, check if we're predicting its position correctly
				if ( position.distance( predictPosition(t) ) > maxVelocityError*(t-old) )
				{
					// its not where we think it should be: reasses
					doLinearRegression();
				}
			}
		}

		// let parent class do rest of update()		
		super.update( t,eventData,position );
	}
	
	public Point2D.Double getAimPoint()
	{
		if (stationary)
		{
			// parent class is fine for stationary targets.
			return super.getAimPoint();
		}
		else
		{
			// its on the move - we need to aim ahead.
			
			double flightTime = 1.0;
			
			// get position after flight time
			Point2D.Double newPosn = predictPosition( (long)(self.getTime()+flightTime) );
			
			// calculate new flight time
			double speed = 19.7;
			int itter=50;
			Point2D.Double posn;
			do
			{
				
				posn = newPosn;
				flightTime = posn.distance( my.x+my.vx*3,my.y+my.vy*3 ) / speed;
				newPosn = predictPosition( (long)(self.getTime()+flightTime) );
		
				itter--;
				
			} while ( itter>0 && newPosn.distance( posn ) > 10 );
						
			return newPosn;  
		}
	}	

	public Point2D.Double predictPosition( long t )
	{
		double x = ax*t+bx;
		double y = ay*t+by;
		if ( x < 20 ) {
			x=20;
		}
		else if ( x>(self.getBattleFieldWidth()-20) ) {
			x=self.getBattleFieldWidth()-20;
		}			
		if ( y < 20 ) {
			y=20;
		}
		else if ( y>(self.getBattleFieldHeight()-20) ) {
			y=self.getBattleFieldHeight()-20;
		}			
		Point2D.Double pos = new Point2D.Double( x,y );
		return pos;
	}

	public void estimateMovementFromLastScan( RobotMemoryEntry memory )
	{
		ScannedRobotEvent lastScan = (ScannedRobotEvent)memory.getEvent();
		
		ax = lastScan.getVelocity() * Math.sin( lastScan.getHeadingRadians() );
		ay = lastScan.getVelocity() * Math.cos( lastScan.getHeadingRadians() );
		
		bx = memory.getPosition().getX() - memory.getTime()*ax;
		by = memory.getPosition().getY() - memory.getTime()*ay;
	}
							
	public void doLinearRegression()
	{
		int n=0, el=0;
		double sig_tx=0 , sig_t=0, sig_x=0, sig_t_sq=0;
		double sig_ty=0 , sig_y=0;
		
		Iterator thisIter = entries.listIterator(0);
		
		while ( thisIter.hasNext() )
		{
			RobotMemoryEntry entry = (RobotMemoryEntry)thisIter.next();
			
			if (el++>2)
			{
				break;
			}
			n++;
			sig_tx   += entry.getPosition().getX() * entry.getTime();
			sig_ty   += entry.getPosition().getY() * entry.getTime();
			sig_t    += entry.getTime();
			sig_t_sq += entry.getTime() * entry.getTime();				
			sig_x    += entry.getPosition().getX();				
			sig_y    += entry.getPosition().getY();
		}
		
		//double ax,bx , ay,by;
		double divisor = (n*sig_t_sq - sig_t*sig_t);
		
		ax = (n*sig_tx - sig_t*sig_x)/divisor;
		ay = (n*sig_ty - sig_t*sig_y)/divisor;
		bx = (sig_x*sig_t_sq - sig_t*sig_tx)/divisor;
		by = (sig_y*sig_t_sq - sig_t*sig_ty)/divisor;	
		
		//System.out.println( name+": ax = "+ax+" , ay = "+ay );		
	}
}

