package repositorio;

import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class NanoStep extends AdvancedRobot {
	int r;
	double enemyBearing,enemyDistancia;
	Rectangle2D campo;
	public void run() {
		campo=new Rectangle2D.Double(200,200,800-400,600-400);
		setAdjustRadarForRobotTurn(true);
		setTurnRadarLeft(Double.NEGATIVE_INFINITY);
		while(true){
			if(campo.contains(getX(),getY())){
				setTurnLeft(enemyBearing);
				setAhead(50);
			}else{
				double roboOffset=getHeadingRadians()-Math.atan2(400-getX(),300-getY());
				setTurnLeftRadians(normalRelativeAngleRadians(roboOffset));
				setAhead(100);
			}
			execute();
	   }
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		r*=-1;
		setTurnGunRightRadians(r*Math.PI/15+robocode.util.Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()));
		setTurnRadarLeft(getRadarTurnRemaining());
		if(e.getDistance()<150)setFire(3);
		else setFire(14*getEnergy()/e.getDistance());	
		enemyBearing=e.getBearing();
		enemyDistancia=e.getDistance();
	}
	private double normalRelativeAngleRadians(double angle) {
        return Math.atan2(Math.sin(angle), Math.cos(angle));
	}
}
