package sgp;
import robocode.*;
import java.util.*;

/**
 * Scorer - a class by Simon Parker
 */

public class Scorer
{
	public double score = 0; //cumulative score
	private int numberOfOthers = 0;

	public double roundScore = 0;
	public double minimumScore = -1;
	
	private final double WIN_BONUS_MULTIPLIER = 10.0; //game value is 10
	private final double SURVIVAL_BONUS = 50.0; //game value is 50

/*
o Major scoring changes
  -- 50 points every time an enemy dies while you are alive
  -- (10 * numOthers) points if you are the sole survivor
  -- 1 point for each point of damage you do with bullets
  -- 2 points for each point of damage you do by ramming (see Ramming changes, below)
  -- bonus .2 * damage done to a specific enemy, if you kill that robot, or
  -- bonus .3 * damage done to a specific enemy, if you kill by ramming
*/

	public void reset(int numOthers)
	{
		score = 0;
		numberOfOthers = numOthers;
		roundScore = 0;
		minimumScore = -1;
	}

	public void onBulletHit(BulletHitEvent event)
	{
		double power = event.getBullet().getPower();
		double damage = 4 * power;
		if (power > 1)
		{
			damage += 2 * (power-1);
		}

		roundScore +=  damage;
	}

	public void onRobotDeath(RobotDeathEvent event)
	{
		roundScore += SURVIVAL_BONUS;// game value is 50;
	}

	public void onWin(WinEvent event)
	{
		roundScore += WIN_BONUS_MULTIPLIER * numberOfOthers; // game value is 10 * others
		setScore();
	}

	public void onDeath(int numOthers)
	{
//		roundScore -= numOthers * 50; //the remaining robots get a bonus
//		roundScore -= numberOfOthers * 10; //someone else wins
		setScore();
	}

	private void setScore()
	{
		score += roundScore;
		if (minimumScore != -1)
		{
			if (minimumScore > roundScore)
			{
				minimumScore = roundScore;
			}
		}
		else
		{
			minimumScore = roundScore;
		}
		roundScore = 0;
	}

	public void onHitByBullet(HitByBulletEvent e)
	{
		double power = e.getPower();
		double damage = 4 * power;
		if (power > 1)
		{
			damage += 2 * (power-1);
		}

//		roundScore -= damage;
	}
}