package cvt;
import robocode.*;
//import java.awt.Color;

/**
 * Firsty - a robot by Corné van Tonder
 */
public class Firsty extends Robot
{
	public static final int MAX_HITS = 3;
	public static final int TIMER = 3;
	double lastBearing = 0;
	int hitCounter = 0;
	int myTimer = TIMER;
	
	/**
	 * run: Firsty's default behavior
	 */
	public void run() {
		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
		//setColors(Color.red,Color.blue,Color.green);
		while(true) {
			// Replace the next 4 lines with any behavior you would like
			myTimer = myTimer - 1;
			ahead(lastBearing);
			turnGunRight(360);
			back(100);
			turnGunRight(lastBearing + 90);
			
				if(myTimer == 0) {
					
					if(hitCounter > MAX_HITS) {
						runLikeHell();
					} else {
						hitCounter = 0;
						myTimer = TIMER;
					} 
				}
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		fire(2);
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		turnLeft(90 - e.getBearing());
		lastBearing = e.getBearing();
		hitCounter = hitCounter + 1;
	}
	
	public void onHitWall(HitWallEvent e) {
		turnRight(e.getBearing() + 153);
	}
	
	public void runLikeHell() {
		out.println("evading....");
		turnLeft(172);
		ahead(500);
		hitCounter = 0;
		myTimer = TIMER;
	}	
}
