package zyx.mega.movement;

import static java.lang.Double.POSITIVE_INFINITY;
import static java.lang.Math.abs;
import static java.lang.Math.ceil;
import static java.lang.Math.exp;
import static java.lang.Math.max;
import static java.lang.Math.min;
import static java.lang.Math.sqrt;
import static zyx.mega.bot.Bot.CloneMe;
import static zyx.mega.bot.Bot.field_;
import static zyx.mega.geometry.Geometry.HALF_PI;
import static zyx.mega.geometry.Geometry.Square;
import static zyx.mega.utils.Range.Normalize;
import static zyx.mega.utils.RollingAverage.Roll;
import static zyx.mega.utils.Snapshot.WS_ACCELERATION;
import static zyx.mega.utils.Snapshot.WS_AHEAD_TICKS;
import static zyx.mega.utils.Snapshot.WS_APPROACHING_VELOCITY;
import static zyx.mega.utils.Snapshot.WS_ATTRIBUTES;
import static zyx.mega.utils.Snapshot.WS_BACK_TICKS;
import static zyx.mega.utils.Snapshot.WS_DISTANCE;
import static zyx.mega.utils.Snapshot.WS_LATERAL_VELOCITY;
import static zyx.mega.utils.Snapshot.WS_ROTATION;
import static zyx.mega.utils.Snapshot.WS_VELOCITY;
import static zyx.mega.utils.TurnHandler.Move;
import static zyx.mega.utils.TurnHandler._melee_;
import static zyx.mega.utils.TurnHandler.me_;
import static zyx.mega.utils.TurnHandler.time_;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

import zyx.debug.painter.Painter;
import zyx.mega.bot.Bot;
import zyx.mega.bot.Enemy;
import zyx.mega.geometry.Bullet;
import zyx.mega.geometry.Point;
import zyx.mega.utils.PerformanceTracker;
import zyx.mega.utils.Range;
import zyx.mega.utils.Snapshot;
import zyx.mega.utils.TurnHandler;
import zyx.mega.utils.WeightedDistancer;
import zyx.mega.utils.wave.SurfingWave;
import zyx.mega.utils.wave.WaveHit;
import zyx.simonton.utils.MyTree;

public class WaveSurfing {
  private static final WeightedDistancer virtual_distancers_[] = new WeightedDistancer[] {
      new WeightedDistancer() {
        public void InitWeight() {
          weight_ = new double[WS_ATTRIBUTES];
          weight_[WS_DISTANCE] = 0.5;
          weight_[WS_LATERAL_VELOCITY] = 1;
          weight_[WS_APPROACHING_VELOCITY] = 1;
          weight_[WS_VELOCITY] = 0.5;
          weight_[WS_ACCELERATION] = 1;
          weight_[WS_ROTATION] = 0.3;
          weight_[WS_AHEAD_TICKS] = 0.7;
          weight_[WS_BACK_TICKS] = 0.7;
          //weight_[WS_TIME_STOPPED] = 0.2;
          //weight_[WS_TIME_RUNNING] = 0.2;
          //weight_[WS_TIME_DIRECTION] = 0.5;
        }
      },
      new WeightedDistancer() {
        public void InitWeight() {
          weight_ = new double[WS_ATTRIBUTES];
          weight_[WS_DISTANCE] = 0.5;
          weight_[WS_LATERAL_VELOCITY] = 1.5;
          weight_[WS_APPROACHING_VELOCITY] = 1.5;
          weight_[WS_VELOCITY] = 0.5;
          weight_[WS_ACCELERATION] = 1;
          weight_[WS_ROTATION] = 0.3;
          weight_[WS_AHEAD_TICKS] = 1;
          weight_[WS_BACK_TICKS] = 1;
          //weight_[WS_TIME_STOPPED] = 0.05;
          //weight_[WS_TIME_RUNNING] = 0.05;
          //weight_[WS_TIME_DIRECTION] = 0.1;
        }
      },
      new WeightedDistancer() {
        public void InitWeight() {
          weight_ = new double[WS_ATTRIBUTES];
          Arrays.fill(weight_, 1);
        }
      },
  };

  
  public static final int NUM_DISTANCERS = virtual_distancers_.length;
  
  private static final double FIRST = 0.8;
  private static final double SECOND = 1 - FIRST;
  private static final double THRESHOLD1 = 0.1;
  private static final double THRESHOLD2 = 0.2;


  public static boolean _paint_;


  private Enemy enemy_;
  private ArrayList<SurfingWave> waves_;
  private SurfingWave surf_wave1_;
  private SurfingWave surf_wave2_;

  private double surf_danger_[];
  private long surf_time_[];
  private int hits_;

  
  
  private MyTree<Snapshot> flattener_;
  private MyTree<Snapshot> danger_;
  private double virtual_scores_[] = new double[virtual_distancers_.length];
  private int virtual_hits_ = 0;
  private static final int DEPTH = 17;
  private static final int DEPTH2 = 5;
  private static final double C = 0.07;
  private static final double K = -1 / (2 * C * C);
  private static final double HOT_FACTOR = 0;
  private static final double ORBITAL_FACTOR = 0.85;
  private int distancer_;
  private double hot_avg_;
  private double linear_avg_;
  private double circular_avg_;
  private double orbital_avg_;
  private double hit_avg_[] = new double[virtual_distancers_.length];
  private double flat_avg_[] = new double[virtual_distancers_.length];
  private double hot_weight_;
  private double linear_weight_;
  private double circular_weight_;
  private double adaptative_weight_;
  private double orbital_weight_;
  private double HIT;
  private double FLAT;


  private boolean stats_printed_;


  public WaveSurfing(Enemy enemy) {
    enemy_ = enemy;
    hits_ = 0;
    surf_danger_ = new double[2];
    surf_time_ = new long[2];
    danger_ = new MyTree<Snapshot>(WS_ATTRIBUTES, 8, 1, 500);
    flattener_ = new MyTree<Snapshot>(WS_ATTRIBUTES, 8, 1, 500);
    if ( _melee_ ) {
      hot_weight_ = 0.7;
      linear_weight_ = 0.1;
      circular_weight_ = 0.2;
      orbital_weight_ = 0;
      adaptative_weight_ = 0;
      HIT = 1;
      FLAT = 0;
    } else {
      hot_weight_ = 10000;
      linear_weight_ = 0;
      circular_weight_ = 0;
      orbital_weight_ = 0;
      adaptative_weight_ = 0;
      HIT = 1;
      FLAT = 0;
    }
  }
  public void Init() {
    waves_ = new ArrayList<SurfingWave>();
    stats_printed_ = false;
  }
  public void onHitByBullet(long time, Bullet bullet, boolean real) {
    //if ( bullet.fire_power_ < 1 && !_melee_ ) return;
    if ( real ) ++hits_;
    double min_distance = POSITIVE_INFINITY;
    SurfingWave hit_wave = null;
    int hit_i = -1;
    for ( int i = 0; i < waves_.size(); ++i ) {
      SurfingWave wave = waves_.get(i);
      if ( abs(wave.velocity_ - bullet.velocity_) < 1e-1 + 1e-9 ) {
        wave.Update(time);
        double distance = abs(wave.radius_ - wave.distance(bullet));
        if ( distance < min_distance ) {
          min_distance = distance;
          hit_wave = wave;
          hit_i  = i;
        }
      }
    }
    if ( hit_wave == null ) System.out.printf("Missed surfing wave\n");
    else {
      hit_wave.snapshot_.ws_hit_ = true;
      hit_wave.snapshot_.ws_hit_factor_ = hit_wave.Factor(bullet);
      waves_.remove(hit_i);
      //if ( hit_wave.snapshot_.distance_ > 80 || _melee_ ) {
      //if ( ShouldSave(hit_wave) ) {
        UpdateWeights(hit_wave);
        danger_.add(hit_wave.snapshot_.ws_normal_, hit_wave.snapshot_);
        for ( SurfingWave wave : waves_ ) if ( wave != hit_wave ) BuildHitDanger(wave);
      //}
    }
  }
  /**
  private boolean ShouldSave(SurfingWave wave) {
    return wave.time_ > last_death_ + 7;
  }
  /**/
  //private StringBuilder AAA; 
  public void onScannedRobot(boolean new_shot, double power) {
    if ( new_shot ) CreateWave(power);
    UpdateWaves();
    if ( surf_wave1_ == null || surf_wave2_ == null ) Position();
    else {
      surf_danger_[0] = surf_danger_[1] = POSITIVE_INFINITY;
      //System.out.printf("Surfing distance\ndesired: %.4f\ncurrent: %.4f\n", enemy_.desired_distance_, enemy_.distance_);
      //AAA = new StringBuilder();
      Surf(CloneMe(), new SurfingWave(surf_wave1_), -1);
      Surf(CloneMe(), new SurfingWave(surf_wave1_), +1);
      //System.out.println(AAA);
      if ( abs(surf_danger_[0] - surf_danger_[1]) > 1e-5 ) {
        if ( surf_danger_[0] < surf_danger_[1] ) {
          enemy_.orbit_direction_ = -1;
        } else {
          enemy_.orbit_direction_ = 1;
        }
      }
      //System.out.println(min(surf_danger_[0], surf_danger_[1]));
      double distance = surf_time_[max(0, enemy_.orbit_direction_)] == 0 ? 0 : POSITIVE_INFINITY;
      double angle = me_.OrbitAngle(surf_wave1_, enemy_.orbit_direction_, enemy_.desired_distance_);
      Move(distance, angle);
    }
  }
  private void Position() {
    if ( time_ > 25 && time_ < 31 ) {
      Move(0, enemy_.bearing_ + HALF_PI);
      return;
    }

    double heading = 0;
    boolean ram = enemy_.desired_distance_ == 0 && enemy_.energy_ratio_ < 1 - 1e-5 && me_.energy_ > 3;
    ram = ram || enemy_.energy_ == 0;
    if ( ram ) heading = enemy_.bearing_;
    else {
      double desired = max(40, enemy_.desired_distance_);
      //if ( desired == 50 ) System.out.println("Get really close to him!");
      Bot left = CloneMe();
      double lerror = POSITIVE_INFINITY;
      //System.out.printf("Positioning distance (%d)\ndesired: %.4f\ncurrent: %.4f\n", time_, desired, enemy_.distance_);
      for ( int i = 0; i < 40 && lerror > 40; ++i ) {
        left.OrbitFast(enemy_, -1, desired);
        lerror = abs(desired - left.distance(enemy_));
        if ( field_.ForceInside(left, false) ) {
          lerror = abs(desired - left.distance(enemy_));
          break;
        }
      }
      Bot right = CloneMe();
      double rerror = POSITIVE_INFINITY;
      for ( int i = 0; i < 40 && rerror > lerror + 40 && lerror > 40; ++i ) {
        right.OrbitFast(enemy_, 1, desired);
        rerror = abs(desired - right.distance(enemy_));
        if ( field_.ForceInside(right, false) ) {
          rerror = abs(desired - right.distance(enemy_));
          break;
        }
      }
      if ( abs(lerror - rerror) > 50 && max(lerror, rerror) < 40 ) enemy_.orbit_direction_ = lerror < rerror ? -1 : 1;
      heading = me_.OrbitAngleFast(enemy_, enemy_.orbit_direction_, desired);
    }
    Move(POSITIVE_INFINITY, heading);
  }
  private SurfingWave FakeWave() {
    if ( enemy_._1ago_ == null ) return null;
    SurfingWave wave = new SurfingWave(enemy_);
    wave.snapshot_ = enemy_._1ago_;
    wave.time_ = time_;
    wave.bearing_ = wave.snapshot_.me_.bearing_;
    wave.direction_ = wave.snapshot_.me_.direction_;
    wave.SetPower(enemy_.avg_fire_power_.average_);
    BuildDanger(wave);
    return wave;
  }
  private void CreateWave(double fire_power) {
    if ( enemy_._2ago_ == null ) return;
    PerformanceTracker.AddEnemyShot(fire_power);
    SurfingWave wave = new SurfingWave(enemy_._1ago_.enemy_);
    wave.snapshot_ = enemy_._2ago_;
    wave.time_ = time_ - 1;
    wave.bearing_ = wave.snapshot_.me_.bearing_;
    wave.direction_ = wave.snapshot_.me_.direction_;
    wave.SetPower(fire_power);
    waves_.add(wave);
    BuildDanger(wave);
  }
  protected void UpdateWaves() {
    surf_wave1_ = surf_wave2_ = null;
    double run_time1 = Double.POSITIVE_INFINITY;
    double run_time2 = Double.POSITIVE_INFINITY;
    for ( int i = 0; i < waves_.size(); ++i ) {
      SurfingWave wave = waves_.get(i);
      wave.Update(TurnHandler.time_);
      WaveHit hit = wave.Hit(me_);
      boolean as_first = false;
      boolean as_second = false;
      if ( hit.AllIn() ) {
        UpdateFlattener(wave);
        if ( !wave.snapshot_.ws_hit_ ) enemy_.accuracy_.Roll(0, 1);
        waves_.remove(i--);
      } else if ( hit.Hitting() ) {
        as_first = true;
        wave.UpdateWS(hit.corners_);
      } else if ( hit.AllOut() ) {
        if ( hit.run_time_ < run_time1 ) {
          as_first = true;
        } else if ( hit.run_time_ < run_time2 ) {
          as_second = true;
        }
      }
      if ( !wave.snapshot_.ws_hit_ ) {
        if ( as_first ) {
          run_time2 = run_time1;
          surf_wave2_ = surf_wave1_;
          run_time1 = hit.run_time_;
          surf_wave1_ = wave;
        } else if ( as_second ) {
          run_time2 = hit.run_time_;
          surf_wave2_ = wave;
        }
      }
    }
    if ( surf_wave1_ == null ) {
      if ( enemy_.time_since_shot_ < 30 && time_ > 30 ) surf_wave1_ = FakeWave();
      /* else Ram(); */
    } /*else*/ if ( surf_wave2_ == null ) {
      surf_wave2_ = FakeWave();
    }
    if ( surf_wave1_ != null && (surf_wave1_.hit_cluster_ == null || surf_wave1_.flat_cluster_ == null) ) BuildDanger(surf_wave1_);
    if ( surf_wave2_ != null && (surf_wave2_.hit_cluster_ == null || surf_wave2_.flat_cluster_ == null) ) BuildDanger(surf_wave2_);
    if ( _paint_ ) {
      if ( surf_wave1_ != null ) Painter.Add(surf_wave1_, Color.BLACK);
      if ( surf_wave2_ != null ) Painter.Add(surf_wave2_, Color.BLUE);
    }
  }
  private void Surf(Bot me, SurfingWave wave, int direction) {
    Range window = new Range();
    WaveHit hit = null;
    long t = 0;
    int index = max(0, direction);
    for ( ; t < 100; ++t, me.Orbit(wave, direction, false, enemy_.desired_distance_) ) {
      if ( !field_.Inside(me, false) && t > 0 ) return;
      wave.Update(time_ + t);
      hit = wave.Hit(me);
      if ( hit.AllIn() ) break;
      else {
        if ( hit.Hitting() ) {
          window.Update(hit.corners_);
        } else if ( hit.AllOut() ) {
          double danger = StopDanger(t, new Bot(me), wave, direction);
          if ( danger - 1e-9 < surf_danger_[index] ) {
            surf_danger_[index] = danger;
            surf_time_[index] = t;
          }
        }
      }
    }
    if ( window.Size() == 0 ) {
      //System.out.printf("window size is 0: %d (%d)\n", t, index);
      return;
    }
    double danger = Danger(window, surf_wave2_.Hit(me).corners_) + DistanceError(me);
    //AAA.append(String.format("%.11f %.11f %.11f\n", Danger(window, surf_wave2_.Hit(me).corners_), DistanceError(me), danger));
    if ( danger - 1e-9 < surf_danger_[index] ) {
      surf_danger_[index] = danger;
      surf_time_[index] = t;
    }
  }
  private double StopDanger(long time, Bot me, SurfingWave wave, int direction) {
    Range window = new Range();
    WaveHit hit = null;
    long t = time;
    for ( ; t < 100; ++t, me.Orbit(wave, direction, true, enemy_.desired_distance_) ) {
      if ( !field_.Inside(me, false) && t > 0 ) return POSITIVE_INFINITY;
      wave.Update(time_ + t);
      hit = wave.Hit(me);
      if ( me.velocity_ == 0 ) {
        window.Update(hit.corners_);
        break;
      } else {
        if ( hit.Hitting() ) {
          window.Update(hit.corners_);
        } else if ( hit.AllIn() ) {
          break;
        }
      }
    }
    if ( window.Size() == 0 ) {
      //System.out.printf("window size is 0: %d\n", t);
      return 0;
    }
    //AAA.append(String.format("%.11f %.11f %.11f\n", Danger(window, surf_wave2_.Hit(me).corners_), DistanceError(me),
      //  Danger(window, surf_wave2_.Hit(me).corners_) * DistanceError(me)));
    return Danger(window, surf_wave2_.Hit(me).corners_) + DistanceError(me);
  }
  private double DistanceError(Point me) {
    //if ( true ) return 1;
    double d = me.distance(enemy_);
    return Normalize(enemy_.desired_distance_ - d, 50, 600, true) * (d < enemy_.desired_distance_ ? 0.1 : 0.05);
  }
  protected void UpdateFlattener(SurfingWave wave) {
    //if ( ShouldSave(wave) )
      flattener_.add(wave.snapshot_.ws_normal_, wave.snapshot_);
  }
  private void UpdateWeights(SurfingWave wave) {
    Range window1 = new Range(wave.snapshot_.ws_hit_factor_, THRESHOLD1, true);
    Range window2 = new Range(wave.snapshot_.ws_hit_factor_, THRESHOLD2, true);
    int depth = min(virtual_hits_, DEPTH);
    int depth2 = min(virtual_hits_++, DEPTH2);
    int best = distancer_ = 0;
    for (int i = 0; i < virtual_distancers_.length; ++i ) {
      int j = (i + distancer_) % virtual_distancers_.length;
      double hit_danger = HitDanger(j, window1, window2);
      double flat_danger = FlatDanger(j, window1, window2);
      Roll(hit_avg_, j, hit_danger, depth2);
      Roll(flat_avg_, j, flat_danger, depth2);
      Roll(virtual_scores_, j, hit_danger, depth);
      if ( virtual_scores_[j] > virtual_scores_[best] ) {
        best = j;
      }
    }
    hot_avg_ = Roll(hot_avg_, Gauss(wave.snapshot_.ws_hit_factor_, HOT_FACTOR), depth);
    linear_avg_ = Roll(linear_avg_, Gauss(wave.snapshot_.ws_hit_factor_, wave.linear_factor_), depth);
    circular_avg_ = Roll(circular_avg_, Gauss(wave.snapshot_.ws_hit_factor_, wave.circular_factor_), depth);
    orbital_avg_ = Roll(orbital_avg_, Gauss(wave.snapshot_.ws_hit_factor_, ORBITAL_FACTOR), depth);
    distancer_ = best;
    if ( hot_avg_ > 0.85 ) {
      hot_weight_ = 0.5;
      linear_weight_ = orbital_weight_ = circular_weight_ = 0;
      adaptative_weight_ = 0.5;
      HIT = 1;
      FLAT = 0;
    } else {
      double simple_avg = hot_avg_ + linear_avg_ + circular_avg_ + orbital_avg_;
      double adaptative_avg = max(1 + min(danger_.size() / 10, 4) - simple_avg, 0);
      double total = simple_avg + adaptative_avg;
      hot_weight_ = hot_avg_ / total;
      linear_weight_ = linear_avg_ / total;
      circular_weight_ = circular_avg_ / total;
      orbital_weight_ = orbital_avg_ / total;
      adaptative_weight_ = adaptative_avg / total;
      total = hit_avg_[best] + flat_avg_[best];
      if ( total < 1e-5 ) {
        HIT = simple_avg;
      } else {
        HIT = hit_avg_[best] / total;
      }
      if ( max(max(hot_avg_, linear_avg_), max(circular_avg_, orbital_avg_)) > 0.65 ) HIT = 1;
      FLAT = 1 - HIT;
    }
  }
  private double Gauss(double value, double center) {
    return exp(K * Square(value - center));
  }
  protected double Danger(Range window, Range window2) {
    double hot = HotDanger(window, window2) * hot_weight_;
    double linear = LinearDanger(window, window2) * linear_weight_;
    double circular = CircularDanger(window, window2) * circular_weight_;
    double orbital = OrbitalDanger(window, window2) * orbital_weight_;
    double adaptative = 0;
    double total = 0;
    for ( int i = 0; i < virtual_distancers_.length; ++i ) {
      double weight = Square(1 + virtual_scores_[i]);
      //System.out.println(weight);
      adaptative += Danger(i, window, window2) * weight;
      total += weight;
    }
    return hot + linear + circular + orbital + /*adaptative_weight_ */ adaptative / (total == 0 ? 1 : total);
  }
  protected double Danger(int distancer, Range window, Range window2) {
    return HitDanger(distancer, window, window2) * HIT + FlatDanger(distancer, window, window2) * FLAT;
  }
  private double HotDanger(Range window, Range window2) {
    return SimpleDanger(window, HOT_FACTOR) * FIRST + SimpleDanger(window2, HOT_FACTOR) * SECOND;
  }
  private double OrbitalDanger(Range window, Range window2) {
    return SimpleDanger(window, ORBITAL_FACTOR) * FIRST + SimpleDanger(window2, ORBITAL_FACTOR) * SECOND;
  }
  private double LinearDanger(Range window, Range window2) {
    return SimpleDanger(window, surf_wave1_.linear_factor_) * FIRST + SimpleDanger(window2, surf_wave2_.linear_factor_) * SECOND;
  }
  private double CircularDanger(Range window, Range window2) {
    return SimpleDanger(window, surf_wave1_.circular_factor_) * FIRST + SimpleDanger(window2, surf_wave2_.circular_factor_) * SECOND;
  }
  private double SimpleDanger(Range window, double factor) {
    if ( window.Inside(factor) ) return 1;
    else if ( factor > window.window_[1] ) return Gauss(window.window_[1], factor);
    else return Gauss(window.window_[0], factor);
  }
  private double HitDanger(int distancer, Range window, Range window2) {
    if ( surf_wave1_.hit_cluster_[distancer] == null ) return 0;
    Range extended = new Range(window.window_[0] - THRESHOLD1, window.window_[1] + THRESHOLD1);
    Range extended2 = new Range(window2.window_[0] - THRESHOLD2, window2.window_[1] + THRESHOLD2);
    double hits = 0;
    double total = 0;
    for ( Iterator<Snapshot> it = surf_wave1_.hit_cluster_[distancer].getValues().iterator(); it.hasNext(); ) {
      Snapshot snapshot = it.next();
      if ( window.Inside(snapshot.ws_hit_factor_) ) hits += 1;
      if ( extended.Inside(snapshot.ws_hit_factor_) ) hits += 1;
      hits += (SimpleDanger(window, snapshot.ws_hit_factor_) + SimpleDanger(extended, snapshot.ws_hit_factor_)) / 2;
      total += 1;
    }
    double second_hits = 0;
    double second_total = 0;
    for ( Iterator<Snapshot> it = surf_wave2_.hit_cluster_[distancer].getValues().iterator(); it.hasNext(); ) {
      Snapshot snapshot = it.next();
      if ( window2.Inside(snapshot.ws_hit_factor_) ) second_hits  += 1;
      if ( extended2.Inside(snapshot.ws_hit_factor_) ) second_hits += 1;
      second_hits += (SimpleDanger(window2, snapshot.ws_hit_factor_) + SimpleDanger(extended2, snapshot.ws_hit_factor_)) / 2;
      second_total += 1;
    }
    final int per_snap = 3;
    double first = hits / max(1.0, total * per_snap);
    double second = second_hits / max(1.0, second_total * per_snap);
    return first * FIRST + second * SECOND;
  }
  private double FlatDanger(int distancer, Range window, Range window2) {
    if ( surf_wave1_.flat_cluster_[distancer] == null ) return 0;
    Range extended = new Range(window.window_[0] - THRESHOLD1, window.window_[1] + THRESHOLD1);
    Range extended2 = new Range(window2.window_[0] - THRESHOLD2, window2.window_[1] + THRESHOLD2);
    double hits = 0;
    double total = 0;
    for ( Iterator<Snapshot> it = surf_wave1_.flat_cluster_[distancer].getValues().iterator(); it.hasNext(); ) {
      Snapshot snapshot = it.next();
      double size = min(window.Size(), snapshot.ws_hit_factor_window_ == null ? 0 : snapshot.ws_hit_factor_window_.Size());
      double e_size = min(extended.Size(), snapshot.ws_hit_factor_window_ == null ? 0 : snapshot.ws_hit_factor_window_.Size());
      Range inter = window.Intersection(snapshot.ws_hit_factor_window_);
      Range inter2 = extended.Intersection(snapshot.ws_hit_factor_window_);
      hits += inter.Size() + inter2.Size();
      total += size + e_size;
    }
    double second_hits = 0;
    double second_total = 0;
    for ( Iterator<Snapshot> it = surf_wave2_.flat_cluster_[distancer].getValues().iterator(); it.hasNext(); ) {
      /* First SurfingWave */
      Snapshot snapshot = it.next();
      double size = min(window2.Size(), snapshot.ws_hit_factor_window_ == null ? 0 : snapshot.ws_hit_factor_window_.Size());
      double e_size = min(extended2.Size(), snapshot.ws_hit_factor_window_ == null ? 0 : snapshot.ws_hit_factor_window_.Size());
      Range inter = window2.Intersection(snapshot.ws_hit_factor_window_);
      Range inter2 = extended2.Intersection(snapshot.ws_hit_factor_window_);
      second_hits += inter.Size() + inter2.Size();
      second_total += size + e_size;
    }
    double first = total == 0 ? 0 : (hits / total);
    double second = total == 0 ? 0 : (second_hits / second_total);
    return first * FIRST + second * SECOND;
  }
  private void BuildHitDanger(SurfingWave wave) {
    for ( int i = 0; i < virtual_distancers_.length; ++i ) BuildHitDanger(wave, i);
  }
  private void BuildHitDanger(SurfingWave wave, int distancer) {
    int danger_size = ClusterSize(danger_);
    if ( danger_size > 0 )
      wave.hit_cluster_[distancer] = danger_.buildCluster(wave.snapshot_.ws_normal_, danger_size, virtual_distancers_[distancer]);
  }
  private void BuildDanger(SurfingWave wave) {
    for ( int i = 0; i < virtual_distancers_.length; ++i ) BuildDanger(wave, i);
  }
  private void BuildDanger(SurfingWave wave, int distancer) {
    int danger_size = ClusterSize(danger_);
    int flattener_size = ClusterSize(flattener_);
    if ( danger_size > 0 )
      wave.hit_cluster_[distancer] = danger_.buildCluster(wave.snapshot_.ws_normal_, danger_size, virtual_distancers_[distancer]);
    if ( flattener_size > 0 )
      wave.flat_cluster_[distancer] = flattener_.buildCluster(wave.snapshot_.ws_normal_, flattener_size, virtual_distancers_[distancer]);
  }
  private int ClusterSize(MyTree<Snapshot> tree) {
    if ( tree.size() < 1 ) return tree.size();
    return min((int)ceil(sqrt(tree.size() * 0.6)), 50);
  }
  public boolean HaveWaves() {
    return waves_.size() > 0;
  }
  public void PrintStats() {
    if ( stats_printed_ ) return;
    stats_printed_ = true;
    System.out.printf("SURF STATS AGAINST: %s\n", enemy_.name_);
  }
}
