package zyx.mega.utils;

import static java.lang.Math.PI;
import static java.lang.Math.abs;
import static java.lang.Math.ceil;
import static robocode.util.Utils.normalRelativeAngle;
import static zyx.mega.bot.Enemy.Find;
import static zyx.mega.bot.Enemy.Phonebook;
import static zyx.mega.bot.Enemy.PreMeleeRun;
import static zyx.mega.geometry.Geometry.HALF_PI;
import static zyx.mega.utils.Config.Load;
import static zyx.mega.utils.Config.*;
import static zyx.mega.utils.Config.movement_enabled_;
import static zyx.mega.utils.Config.radar_enabled_;

import java.awt.Graphics2D;

import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import rz.HawkOnFireOS;
import wiki.mc2k7.RaikoGun;
import zyx.debug.Printer;
import zyx.debug.painter.Painter;
import zyx.mega.bot.Bot;
import zyx.mega.bot.Enemy;
import zyx.mega.movement.melee.MinimumRisk;
import zyx.mega.radar.Radar;
import zyx.mega.targeting.melee.MeleeGun;


public class TurnHandler {
  private static RaikoGun raiko_gun_;
  private static HawkOnFireOS hawk_move_;
  public static AdvancedRobot robot_;
  public static Bot me_;
  public static TurnHandler handler_;

  public static int time_;
  public static long exact_time_;
  public static int num_enemies_;
  public static int others_;
  public static int round_;
  public static int ticks_to_fire_;
  public static boolean _1v1_;
  public static boolean _melee_;
  //public static Bullet last_bullet_;

  private Graphics2D g_;
  public static int last_death_;


  public static Radar radar_;
  public static MinimumRisk minimum_risk_;
  public static MeleeGun melee_gun_;
  
  public TurnHandler(AdvancedRobot robot) {
    robot_ = robot;
    handler_ = this;
    Load(robot_);
    num_enemies_ = robot_.getOthers();
    _melee_ = num_enemies_ > 1;
    _1v1_ = !_melee_;
    me_ = new Bot();
    Bot.InitStatic();
    g_ = null;
    last_death_ = 0;
  }

  public void Update() {
    long time = robot_.getTime();
    if ( time == time_ ) return;
    ++exact_time_;
    others_ = robot_.getOthers();
    time_ = (int)time;
    round_ = robot_.getRoundNum();
    ticks_to_fire_ = (int)ceil(robot_.getGunHeat() / robot_.getGunCoolingRate());
    _1v1_ = others_ < 2;
    me_.Update(robot_);
    //System.out.printf("my position: %.4f %.4f\n", me_.x_, me_.y_);
  }
  public void run() {
    //System.out.println(robot_.getName());
    Update();
    if ( radar_enabled_ && radar_ == null ) radar_ = new Radar();
    if ( _melee_ && minimum_risk_ == null ) {
      if ( _hawk_ ) hawk_move_ = new HawkOnFireOS();
      else minimum_risk_ = new MinimumRisk();
      melee_gun_ = new MeleeGun();
    }
    PerformanceTracker.InitRound();
    Enemy.StaticInit();
    for (Enemy enemy : Phonebook()) {
      enemy.Init();
    }
    if ( radar_enabled_ ) radar_.Init();
    if ( minimum_risk_ != null ) minimum_risk_.Init();
    if ( hawk_move_ != null ) hawk_move_.Init();
    robot_.setAdjustGunForRobotTurn(true);
    robot_.setAdjustRadarForGunTurn(true);
    if ( _raiko_ ) {
      if ( raiko_gun_ == null ) raiko_gun_ = new RaikoGun(robot_);
      raiko_gun_.run();
    } else {
      if ( _melee_ ) {
        melee_gun_.Init();
      }
      time_ = -1;
      while ( true ) {
        Update();
        if ( !_1v1_ ) {
          PreMeleeRun();
          if ( minimum_risk_ != null ) minimum_risk_.run();
          else hawk_move_.run();
          melee_gun_.run();
        }
        if ( radar_enabled_ ) radar_.run();
        FinishTurn();
      }
    }
  }

  private void FinishTurn() {
    Painter.onPaint(g_);
    Printer.onPrint(robot_.out);
    g_ = null;
    robot_.execute();
  }  
  public static Bullet FireBullet(double power, Enemy enemy) {
    if ( power == 0 ) return null;
    Bullet bullet = robot_.setFireBullet(power);
    if ( bullet != null && !_melee_ ) PerformanceTracker.AddShot(power);
    if ( bullet != null ) me_.energy_ -= bullet.getPower();
    return bullet;
  }
  public static void AimGun(double angle) {
    //System.out.printf("Turn %d: AimGun called\n", time_);
    robot_.setTurnGunRightRadians(normalRelativeAngle(angle - robot_.getGunHeadingRadians()));
  }

  public void onBattleEnded(BattleEndedEvent event) {
  }
  public void onBulletHit(BulletHitEvent event) {
    Update();
    Enemy enemy = Find(event.getName());
    enemy.onBulletHit(event);
    if ( !_melee_ ) PerformanceTracker.onBulletHit(event);
  }
  public void onBulletHitBullet(BulletHitBulletEvent event) {
    Update();
    Bullet bullet = event.getHitBullet();
    Bullet my_bullet = event.getBullet();
    if ( bullet.getName().equals(robot_.getName()) ) {
      bullet = event.getBullet();
      my_bullet = event.getHitBullet();
      if ( bullet.getName().equals(robot_.getName()) ) {
        if ( !_melee_ ) PerformanceTracker.RemoveMyShots(bullet.getPower(), my_bullet.getPower());
        return;
      }
    }
    Enemy enemy = Find(bullet.getName());
    enemy.onBulletHitBullet(time_, my_bullet, new zyx.mega.geometry.Bullet(bullet));
    if ( !_melee_ ) PerformanceTracker.RemoveShot(event.getBullet().getPower(), event.getHitBullet().getPower());
    else if ( !_1v1_ && minimum_risk_ != null ) minimum_risk_.onBulletHitBullet(enemy, event.getHitBullet());
  }
  public void onBulletMissed(BulletMissedEvent event) {
  }
  public void onDeath(DeathEvent event) {
    /*
    for (Enemy enemy : Phonebook()) if ( !enemy.dead_ ) {
      enemy.Log();
    }
    */
    Update();
    Printer.onPrint(robot_.out);
    if ( !_melee_ ) PerformanceTracker.onDeath(robot_);
    else System.out.printf("Died at place: %d\n", others_ + 1);
  }
  public void onHitByBullet(HitByBulletEvent event) {
    Update();
    Enemy enemy = Find(event.getName());
    enemy.onHitByBullet(event);
    if ( !_melee_ ) PerformanceTracker.onHitByBullet(event);
    else if ( !_1v1_ && minimum_risk_ != null ) minimum_risk_.onHitByBullet(enemy, event.getBullet());
  }
  public void onHitRobot(HitRobotEvent event) {
    Update();
    Enemy enemy = Find(event.getName());
    enemy.onHitRobot(event);
    if ( !_1v1_ && minimum_risk_ != null ) minimum_risk_.onHitRobot(enemy);
  }
  public void onHitWall(HitWallEvent event) {
    Update();
    for (Enemy enemy : Phonebook()) {
      enemy.onHitWall(event);
    }
    if ( !_1v1_ && minimum_risk_ != null ) minimum_risk_.onHitWall();
    System.out.println("*********************** HIT WALL (" + event.getTime() + ") ******************");
  }
  public void onPaint(Graphics2D g) {
    g_ = g;
  }
  public void onRobotDeath(RobotDeathEvent event) {
    if ( hawk_move_ != null ) hawk_move_.onRobotDeath(event);
    Update();
    //System.out.println(event.getName()  + " died");
    if ( !_melee_ ) PerformanceTracker.onRobotDeath(robot_);
    Enemy enemy = Find(event.getName());
    enemy.onRobotDeath(event);
    radar_.onRobotDeath(enemy);
    last_death_ = time_;
  }
  public void onScannedRobot(ScannedRobotEvent event) {
    if ( raiko_gun_ != null ) raiko_gun_.onScannedRobot(event);
    if ( hawk_move_ != null ) hawk_move_.onScannedRobot(event);
    Update();
    Enemy enemy = Find(event.getName());
    enemy.onScannedRobot(event);
    if ( radar_enabled_ ) radar_.onScannedRobot(enemy);
    if ( raiko_gun_ != null ) {
      FinishTurn();
    }
  }
  public void onSkippedTurn(SkippedTurnEvent event) {
    Update();
    PerformanceTracker.onSkippedTurn(robot_.out);
  }
  public void onWin(WinEvent event) {
    System.out.println("Round is mine");
  }

  public static void Move(double distance, double angle) {
    angle = normalRelativeAngle(angle - me_.heading_);
    if ( abs(angle) > HALF_PI ) {
      angle = normalRelativeAngle(angle + PI);
      distance = -distance;
    }
    robot_.setTurnRightRadians(angle);
    robot_.setAhead(distance);
  }
}
