package zyx.mega.geometry;

import static java.lang.Math.toDegrees;
import java.awt.Graphics2D;

public class Arc extends Circle {
  public int start_;
  public int end_;

  public Arc(Point center, double radius, double start, double end) {
    super(center, radius);
    start_ = (int)toDegrees(start);
    end_ = (int)toDegrees(end - start);
    //System.out.println(start_ + " : " + end_);
  }
  public void onPaint(Graphics2D g) {
    double side = 2 * radius_;
    g.fillArc((int)(x_ - radius_), (int)(y_ - radius_), (int) side, (int) side, start_, end_);
  }
}
