/*
 * Created on Sep 9, 2004
 *
 */
package davidalves.net.gun.segmentation;

import davidalves.PhoenixOS;
import davidalves.net.util.RobotState;
import davidalves.net.util.Utils;

/*
 * Splits distance traveled into equally sized segments
 * 
 * @author David Alves
 *
 */
public class TimeAtVelocityFactorSegmentation extends LinearSegmentation {
	
	public TimeAtVelocityFactorSegmentation(int segments){
		super(0.0, 2.0, false, true, segments);
	}

	protected double getValue(RobotState shooter, RobotState target, double bulletPower) {
		double bulletFlightTime = shooter.distanceTo(target) / Utils.bulletSpeed(bulletPower);
		return target.timeAtThisSpeed / bulletFlightTime;
	}
	
}
