package voidious.perceptual;

import robocode.*;
import robocode.util.Utils;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import ags.utils.dataStructures.trees.thirdGenKD.DistanceFunction;
import ags.utils.dataStructures.trees.thirdGenKD.KdTree;
import ags.utils.dataStructures.trees.thirdGenKD.SquareEuclideanDistanceFunction;

import voidious.utils.genetic.DnaSequence;
import voidious.utils.genetic.DnaString;
import voidious.utils.genetic.DnaSequence.Gene;

/**
 * Copyright (c) 2011 - Voidious
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *    1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 *
 *    2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 *    3. This notice may not be removed or altered from any source
 *    distribution.
 */

public class RetroGirl extends AdvancedRobot {
    private static final double WALL_STICK = 160;
    private static final double DEFAULT_DISTANCE = 450;
    private static final double DIVE_THRESHOLD = 0.9;
    private static final double POWER_TWO_DISTANCE = 300;
    
    private static final double HALF_PI = Math.PI / 2;
    private static final double A_BIT_MORE_THAN_HALF_PI = HALF_PI * 1.3;
    private static final double A_BIT_LESS_THAN_HALF_PI = HALF_PI * 0.7;
    private static final Rectangle2D.Double FIELD_RECT =
        new java.awt.geom.Rectangle2D.Double(18, 18, 764, 564);

    private static final int NUM_POINTS = 250;
    private static final int COORDINATE_BITS = 5;
    private static final int BIN_BITS = 6;
    private static final int NUM_ATTR = 7;
    private static final String SKNN_HEX_STRING = 
        "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
    private static final DnaString SKNN_DNA_STRING = new DnaString(
        knnSpaceSequence(NUM_POINTS, NUM_ATTR, 
            COORDINATE_BITS, BIN_BITS), SKNN_HEX_STRING);
    private static final double[] WEIGHTS = 
        weightsFromDnaString(SKNN_DNA_STRING, NUM_ATTR);
    private static final KdTree<Integer> TREE = 
        kdTreeFromDnaString(SKNN_DNA_STRING, WEIGHTS);
    private static final int BINS = power(2, BIN_BITS);

    private static final DistanceFunction DIST_FUNC = 
        new SquareEuclideanDistanceFunction();
    private static final int BYTE_SIZE = 8;

    public void run() {
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        setColors(Color.white, Color.red, Color.black); 

        do {
            turnRadarRightRadians(1);
        } while (true);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double eDistance = e.getDistance();
        double enemyAbsoluteBearing = 
            getHeadingRadians() + e.getBearingRadians();
        Point2D.Double myLocation = new Point2D.Double(getX(), getY());
        Point2D.Double enemyLocation = 
            project(myLocation, enemyAbsoluteBearing, eDistance);

        setTurnRadarRightRadians(Utils.normalRelativeAngle(
            enemyAbsoluteBearing - getRadarHeadingRadians()) * 2);

        double invAttackAngle = 
            (eDistance < DEFAULT_DISTANCE ? A_BIT_MORE_THAN_HALF_PI :
                (eDistance > DEFAULT_DISTANCE + 30 ? 
                    A_BIT_LESS_THAN_HALF_PI : HALF_PI));
        double goAnglePos = wallSmoothing(
            enemyAbsoluteBearing - invAttackAngle, myLocation, 1);
        double diveDangerPos = DIVE_THRESHOLD /
            Math.abs(enemyAbsoluteBearing - goAnglePos);
        double goAngleNeg = wallSmoothing(
            enemyAbsoluteBearing + invAttackAngle, myLocation, -1);
        double diveDangerNeg = DIVE_THRESHOLD /
            Math.abs(enemyAbsoluteBearing - goAngleNeg);

        int orbitDirection;
        if (diveDangerPos > 1 && diveDangerNeg < diveDangerPos) {
            orbitDirection = -1;
        } else if (diveDangerNeg > 1 && diveDangerPos < diveDangerNeg) {
            orbitDirection = 1;
        } else {
            orbitDirection = (((int)((getEnergy() * 100) +
                (getTime() / 120)))
                % 2 == 0 ? 1 : -1);
        }

        double goAngle = (orbitDirection == 1) ? goAnglePos : goAngleNeg;
        setTurnRightRadians(Math.tan(goAngle -= getHeadingRadians()));
        setAhead(Math.cos(goAngle) * Double.POSITIVE_INFINITY);

        double bulletPower = Math.min(e.getEnergy() / 4,
//            (Math.round((POWER_TWO_DISTANCE / eDistance) * 2.0 * 100) / 100.0) - 0.002
//                (eDistance < 100 ? 2.997 : 1.997)
//                - Math.max(0, (40 - getEnergy()) / 11));
            (Math.round((POWER_TWO_DISTANCE / eDistance) * 2.0 * 100) / 100.0) 
                - 0.002 - Math.max(0, (20 - getEnergy()) / 11));
//                    (e.getEnergy() - getEnergy() - 10) / 10)));
        double bulletSpeed = 20.0 - (3 * bulletPower);
        
        double relativeHeading = e.getHeadingRadians() - enemyAbsoluteBearing;
        double latVel = e.getVelocity() * Math.sin(relativeHeading);
        int enemyDirection = sign(latVel);
        int bulletFlightTime = (int)Math.ceil(eDistance / bulletSpeed);
        double wallDist = orbitalWallDistance(myLocation, enemyLocation, 
            bulletPower, enemyDirection);
        double revWallDist = orbitalWallDistance(myLocation, enemyLocation, 
            bulletPower, -enemyDirection);
        
        double[] p = new double[]{
            Math.abs(e.getVelocity()) / 8.0,
            (Math.abs(e.getVelocity()) % 2) / 2.0,
            Math.min(bulletFlightTime, 90) / 90.0,
            Math.sin(relativeHeading),
            (Math.cos(relativeHeading) + 1) / 2.0,
            Math.min(1.25, wallDist) / 1.25,
            Math.min(1.15, revWallDist) / 1.15
        };

        double[] wp = weightedPoint(p, WEIGHTS);

        int gfBin = TREE.findNearestNeighbors(wp, 1, DIST_FUNC).getMax();
        double guessFactor;
        if (gfBin == (BINS / 2) || gfBin == (BINS / 2 - 1)) {
            guessFactor = 0;
        } else {
            guessFactor = ((double)(gfBin - (BINS / 2) + 1)) / (BINS / 2);
        }

//        if ((getTime() / 50) % 4 == 3) {
//            guessFactor = Math.max(-0.8, Math.random() + Math.random() - 1);
//        }

        if (e.getEnergy() == 0) {
            guessFactor = 0;
        }
        
        setTurnGunRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing
            - getGunHeadingRadians() + (enemyDirection * guessFactor
                * Math.asin(8.0 / bulletSpeed))));

        if (getEnergy() > bulletPower) {
            setFire(bulletPower);
        }
    }
    
    private static Point2D.Double project(Point2D.Double sourceLocation,
            double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length,
            sourceLocation.y + Math.cos(angle) * length);
    }
    
    private static int sign(double d) {
        if (d < 0) { return -1; }
        return 1;
    }
    
    private static double wallSmoothing(double goAngle, 
        Point2D.Double myLocation, int orbitDirection) {
        while (!FIELD_RECT.contains(project(myLocation, goAngle, WALL_STICK))) {
            goAngle += orbitDirection*0.05;
        }
        return goAngle;
    }
    
    private static double orbitalWallDistance(Point2D.Double sourceLocation,
            Point2D.Double targetLocation, double bulletPower, int direction) {
        double absBearing = absoluteBearing(sourceLocation, targetLocation);
        double distance = sourceLocation.distance(targetLocation);
        double maxAngleRadians = Math.asin(8.0/(20-3.0*bulletPower));

        double wallDistance = 2.0;
        for (int x = 0; x < 200; x++) {
            if (!FIELD_RECT.contains(
                sourceLocation.x + (Math.sin(absBearing +
                    (direction*(x/100.0)*maxAngleRadians))*distance),
                sourceLocation.y + (Math.cos(absBearing +
                    (direction*(x/100.0)*maxAngleRadians))*distance))) {
                wallDistance = x/100.0;
                break;
            }
        }

        return wallDistance;
    }
    
    private static double absoluteBearing(Point2D.Double sourceLocation,
            Point2D.Double target) {
        return Math.atan2(target.x - sourceLocation.x, 
            target.y - sourceLocation.y);
    }
    
    private static DnaSequence knnSpaceSequence(int numPoints, int numAttr,
            int coordBits, int binBits) {
        int coordinateValues = power(2, coordBits);
        int bins = power(2, binBits);
        
        DnaSequence treeSequence = new DnaSequence();
        for (int x = 0; x < numAttr; x++) {
            treeSequence.addGene(new Gene("w" + (x+1), Gene.SHORT));
        }

        for (int x = 0; x < numPoints; x++) {
            for (int y = 0; y < numAttr; y++) {
                treeSequence.addGene(new Gene("p" + (x+1) + "x" + (y+1), 
                    Gene.BYTE, coordinateValues - 1));
            }
            treeSequence.addGene(new Gene("r" + (x+1), Gene.BYTE, bins - 1));
        }
        
        return treeSequence;
    }
    
    private static KdTree<Integer> kdTreeFromDnaString(DnaString dnaString, 
            double[] weights) {
        int numAttr = weights.length;
        KdTree<Integer> tree = new KdTree<Integer>(numAttr);
        
        String bitString = dnaString.bitString();
        int numPoints = (bitString.length() - (numAttr * 2 * BYTE_SIZE)) 
            / ((numAttr+1) * BYTE_SIZE);
        int coordinateValues = (numPoints == 0 ? 0 :
            (int)dnaString.getDnaSequence().getGene("p1x1").max);

        for (int x = 0; x < numPoints; x++) {
            double[] p = new double[numAttr];
            for (int y = 0; y < numAttr; y++) {
                p[y] = (((double)dnaString.getByte("p" + (x+1) + "x" + (y+1))) /
                    coordinateValues) * weights[y];
            }
            tree.addPoint(p, (int)dnaString.getByte("r" + (x+1)));
        }

        return tree;
    }
    
    private static double[] weightsFromDnaString(DnaString dnaString,
            int numAttr) {
        double[] weights = new double[numAttr];
        for (int x = 0; x < numAttr; x++) {
            weights[x] = ((double)dnaString.getShort("w" + (x+1))) 
                / Short.MAX_VALUE;
        }
        return weights;
    }
    
    private static int power(int base, int exp) {
        int retVal = 1;
        for (int x = 0; x < exp; x++) {
            retVal *= base;
        }
        return retVal;
    }
    
    private static double[] weightedPoint(double[] p, double[] weights) {
        double[] wp = new double[p.length];
        for (int x = 0; x < wp.length; x++) {
            wp[x] = p[x] * weights[x];
        }
        return wp;
    }
}
