package ags.muse.recon;

import ags.util.points.*;
import ags.muse.base.Rules;
import ags.muse.physics.*;
import ags.muse.recon.events.*;

public class SelfRobot extends Robot {
    public SelfRobot(Rules rules) {
        super(rules, null, rules.NAME);
    }

    // Variables
    private AbsolutePoint nextLocation;
    private double gunHeading, gunHeat, radarHeading;
    
    // Getters
    public AbsolutePoint getNextLocation() { return nextLocation; }
    public double getGunHeading() { return gunHeading; }
    public double getGunHeat() { return gunHeat; }
    public double getRadarHeading() { return radarHeading; }
    
    @Override
    public boolean update(ReconEvent event) {
        if (!(event instanceof SelfReconEvent)) {
            throw new IllegalArgumentException();
        }
        if (super.update(event)) {
            SelfReconEvent selfEvent = (SelfReconEvent)event;
            gunHeading = selfEvent.getGunHeading();
            gunHeat = selfEvent.getGunHeat();
            radarHeading = selfEvent.getRadarHeading();
            if (nextLocation != null)
            {
                double mismatch = getLocation().distance(nextLocation);
                if (mismatch > 0.0001) 
                {
                    System.out.println("Movement Mismatch! " + mismatch + " : " + getEnergy());
                }
            }
            nextLocation = getLocation();
            return true;
        }
        return false;
    }

    public void setIntention(Rules rules, double ahead, double turn) {
        // NOTE: If we get to 0 energy, a mismatch is expected
        RobotSimV2 sim = new RobotSimV2(getLocation(), getVelocity());
        sim.simTick(ahead, turn);
        nextLocation = AbsolutePoint.fromXY(sim.getX(), sim.getY());
    }
}
