package stelo;
import robocode.*;
//import java.awt.Color;
import robocode.util.Utils;
import java.util.*;
import java.awt.geom.*;

// mirror movement
public class Mirror extends AdvancedRobot
{
	double centerX, centerY;

	Point2D robotLocation;
    Point2D enemyLocation;
    double enemyDistance;
    double enemyAbsoluteBearing;
    double movementLateralAngle = 0.2;

	double lastEnemyAbsoluteBearing;
	double lastEnemyHeading;
	
    static double MAX_VELOCITY = 8;
	static DCGun_1on1 gun;
	static MirrorMovement movement;
	
	boolean stationary = false;
	boolean neverShoots = false;
		
	/**
	 * run: Mirror's default behavior
	 */
	public void run() {
		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
		//setColors(Color.red,Color.blue,Color.green);
		setAdjustRadarForGunTurn(true);
		//setAdjustRadarForRobotTurn(true);
		//setAdjustGunForRobotTurn(true);
				
		centerX = getBattleFieldWidth() / 2.0;
		centerY = getBattleFieldHeight() / 2.0;
		
		if (movement == null) movement = new MirrorMovement(this);
		movement.initRound();
		
		if (gun == null) {
			gun = new DCGun_1on1(this);
			if (stationary) {
				gun.minBulletPower = 3;
				gun.referenceMode = true;
			}
			if (neverShoots) {
				gun.maxBulletPower = 0;
				gun.minBulletPower = 0;
			}
		}
		gun.initRound();		
		
		while(true) {
			if (!stationary) movement.execute();
			else movement.radarOnly();
			gun.execute();
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		movement.update(e);
		if (!neverShoots) gun.update(e);
	}

	/*
    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    } */

	public void onHitWall(HitWallEvent e) {
		out.println("Hit wall");
	}

	public void onHitByBullet(HitByBulletEvent e) {
		if (getOthers() > 1)
			turnRadarRightRadians(Utils.normalRelativeAngle(e.getBearingRadians() + getHeadingRadians() - getRadarHeadingRadians()));
	}

	public void onRobotDeath(RobotDeathEvent e) {
		if (getOthers() == 0) {
			movement.cleanUpRound();
			gun.cleanUpRound();
		}
	}

	public void onBulletHit(BulletHitEvent e) {
		gun.update(e);
	}

	public void onDeath(DeathEvent event) {
		if (getOthers() > 0) {
			movement.cleanUpRound();
			gun.cleanUpRound();
		}
	}
}
