package ags.rougedc.movement;

import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import ags.rougedc.base.*;
import ags.rougedc.base.actors.MovementActor;
import ags.rougedc.waves.*;
import ags.rougedc.robots.*;
import ags.utils.points.*;

public class Surfing {
    private final Rules rules;
    private final StatusRobot status;
    private final EnemyWaveManager ewm;
    
    //private final StateHolder stateholder;
    private final List<RobotDriver> drivers;
    private final RobotDriver defaultdriver;
    
    public Map<RobotDriver, Double> options;
    
    public Surfing(Rules rules, StatusRobot status, EnemyList enemies, EnemyWaveManager ewm) {
        this.rules = rules;
        this.status = status;
        this.ewm = ewm;
        
        options = new HashMap<RobotDriver, Double>();
        
        // Set up robot drivers
        drivers = new ArrayList<RobotDriver>();
        // No movement
        drivers.add(new StoppedDriver());
        // Perpendicular movement
        drivers.add(new OrbitDriver(rules, 400, Math.PI/2));
        drivers.add(new OrbitDriver(rules, 400, -Math.PI/2));
        
        defaultdriver = new DistanceDriver(rules, enemies, 400);
        // Vertical movement
        //drivers.add(new TronDriver(stateholder, Double.POSITIVE_INFINITY, 0));
        //drivers.add(new TronDriver(stateholder, Double.NEGATIVE_INFINITY, 0));
        // Horizontal movement
        //drivers.add(new TronDriver(stateholder, Double.POSITIVE_INFINITY, Math.PI/2));
        //drivers.add(new TronDriver(stateholder, Double.NEGATIVE_INFINITY, Math.PI/2));
    }
    
    public void run(MovementActor movementActor) {
        //long t = System.nanoTime();
        List<EnemyWave> waves = new ArrayList<EnemyWave>(ewm.getAll());
        waves.addAll(ewm.getAllHeat());
        List<RobotDriver> selecteddrivers = new ArrayList<RobotDriver>(drivers);
        
        // Find the best driver!
        RobotDriver bestdriver = defaultdriver;
        double lowestDanger = Double.POSITIVE_INFINITY;
        options.clear();
        if (waves.size() > 0) {
            final AbsolutePoint fieldcorner = AbsolutePoint.fromXY(rules.BATTLEFIELD_WIDTH, rules.BATTLEFIELD_HEIGHT);
            
            for (RobotDriver driver : selecteddrivers) {
                // Evaluate the danger of the driver
                SurfingPredictor predictor = new SurfingPredictor(status, driver, drivers, waves, null, null, fieldcorner, 0); 
                double danger = predictor.getDanger(lowestDanger);

                driver.run(status, waves);
                options.put(driver, danger);
                
                //System.out.println(driver.getClass().getSimpleName()+": "+danger);
                // Find the best driver
                if (danger < lowestDanger) {
                    bestdriver = driver;
                    lowestDanger = danger;
                }
            }
        } else
            options.put(defaultdriver, 0.0);
        
        // Drive with it!
        bestdriver.run(status, waves);
        double v = bestdriver.getAcceleration() + status.getVelocity().magnitude;
        movementActor.setMove(v);
        movementActor.setTurnBody(bestdriver.getAngularVelocity());

        //System.out.println("Surfing time: " + (System.nanoTime()-t)/1000000.0 + "ms");
    }
}
