package penguin;
import robocode.*;
import java.awt.Color;
import robocode.util.Utils;
import java.awt.*;
import java.awt.geom.*;
import java.util.ArrayList;
import java.util.*;
//import org.apache.commons.collections4.map.MultiValueMap;

public class MrFreeze extends AdvancedRobot
{
//change this if u want to see a cool painting of all waves considered
	static final boolean paintTheoryShots = true;

	Condor enemy = new Condor();
	
	static ArrayList<IceWave> _whipGroup;
	static ArrayList<BatHook> _hookGroup;
	static ArrayList<Point2D.Double> _positionGroup;	
	
	static final double PI = Math.PI;
	static double heading;
	
	static Point2D.Double ourLocation;
	static Point2D.Double desiredLoc;
	
	double icePower = 3;
	
	static final int BINS = 47;
	static final int MIDBIN = (BINS-1)/2;
	static final int DISTANCESEGMENTS = 5;
	static final int NEARWALLSEGMENTS = 2;
	static final int ACCELERATIONSEGMENTS = 3;
	static final int LATERALHEADINGSEGMENTS = 5;
	static final int VELOCITYSEGMENTS = 5;
	static final int TIMESINCESHOTSEGMENTS = 11;
	static final int TDIRECTIONCHANGESEGMENTS =11;
	static final int BULLETPOWERSEGMENTS = 4;
	
	static double anglePerBin = Math.asin(11)/(double)BINS;

	static double[] _binList = new double[BINS];
	static ArrayList<Double> _guessFactorList;
	static ArrayList<Double> _dodgeFactorList;
	static int aimBin = MIDBIN;
	static double[]/*[][][][][]*/ hookLog = new double[BINS];/*[DISTANCESEGMENTS][NEARWALLSEGMENTS][LATERALHEADINGSEGMENTS]
											/*[VELOCITYSEGMENTS][TDIRECTIONCHANGESEGMENTS]; */

	static Hashtable<String,ArrayList<Double>> whipTable = new Hashtable<String,ArrayList<Double>>();
	static Hashtable<String,double[]> weightTable = new Hashtable<String,double[]>();
	
	static Hashtable<String,ArrayList<Double>> hookTable = new Hashtable<String,ArrayList<Double>>();
	static Hashtable<String,double[]> hookWeightTable = new Hashtable<String,double[]>();

	static double[] frequencyMap;
	static int stateKey = 0;
	
	static long shotTime;
	
	static int distanceSegment = 0;
	static int nearWallSegment = 0;
	static int accelerationSegment = 0;
	static int lateralHeadSegment = 0;
	static int timeSinceShotSegment = 0;
	static int velocitySegment = 0;
	static int lastVelocitySegment = 0;
	static int tDirectionChangeSegment = 0;
	static int bulletPowerSegment = 0;
	static int ourNearWallSegment = 0;
	static int ourLateralHeadingSegment = 0;
	static int ourVelocitySegment = 0;
	static int ourTDirectionChangeSegment = 0;
	
	static Rectangle2D.Double playField;
	static int wallConsideration = 18;
	
	static double newBearing, oldBearing;
	static double newDeltaBearing, oldDeltaBearing;
	
/*	static double totalRadarTurn = Math.PI/25;
	static double avgRadarTurn = 2*Math.PI;
	static double radarInstances;
*/	
	static long fireTime = 200;
	
	static boolean quickLogShot = true;
	static float quickLogShots = 0;
	static float totalShots = 0;
	static float oldTotalShots = 0;
	static float theoryShots = 0;	

	static boolean orientated = false;
	
	static float roundNumber;

	static float timeOfLastShot;
	
	Color purple = Color.getHSBColor(.8f,.9f,.8f);
	
	float [] hsbTealCode = Color.RGBtoHSB(0,171,169,null);
	Color teal = Color.getHSBColor(hsbTealCode[0],hsbTealCode[1],hsbTealCode[2]);
	
	static float timeSinceDirectionChange = 0;
	static float ourTimeSinceDirectionChange = 0;
	
	static int lateralDirection = 1;
	static double lateralVelocity  = 0;
	static int lastLateralDirection = 1;
	
	static double currDanger, nextDanger, lastDanger;
	
	static double lateralHeading;
	
	static boolean FIRING = true;
	static boolean MOVING = true;
	static boolean CAREFUL = false;
	static boolean FLATTEN = false;
	
	static double distancingRatio = 1;
	
	static float theirShots = 0;
	static float theirHits = 1;
	
	static boolean emptySurf;
	static int emptyDirection = 1;
	
	static double surfDir = 1;
	
	static float numSaves = 0;
	
	static double totalSaveAmount = 0;
	
	static double theoryHooks;
	static double realHooks;
	static double totalHookSaveAmount = 0;
	
	static double distanceFromTrueState;
	
	static String currentState = "";
	static String stage0State = "", stage1State = "a", stage2State = "aa", stage3State = "aaa";
	static String stage4State = "aaaa", stage5State = "aaaaa", stage6State = "aaaaaa", stage7State = "aaaaaaa";
	
	static String surfState = "aaaaaaaa";
	static String surfState0 = "", surfState1 = "a", surfState2 = "aa", surfState3 = "aaa", surfState4 = "aaaa";
	static String surfState5 = "aaaaa", surfState6 = "aaaaaa", surfState7 = "aaaaaaa";
	
	static String Alphabet = new String("abcdefghijklmnopqrstuvwxyz");
	
	static long numSkippedTurns;
	static double numTheorySaves;

	public void run() {
	

		setColors(teal,teal,purple);
		setBulletColor(teal);
		
		_whipGroup = new ArrayList<IceWave>();
		_hookGroup = new ArrayList<BatHook>();
		_positionGroup = new ArrayList<Point2D.Double>();
		_guessFactorList = new ArrayList<Double>();
		_dodgeFactorList = new ArrayList<Double>();

		playField = new Rectangle2D.Double(wallConsideration,wallConsideration,
			getBattleFieldWidth()-2*wallConsideration,getBattleFieldHeight()-2*wallConsideration);

		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		
		desiredLoc = new Point2D.Double(getX(),getY());
		
		roundNumber ++;
		
		// Robot main loop
		while(true) {
			turnRadarRight(Double.POSITIVE_INFINITY);
		}
	}
	
	void update(){
	

			ourLocation = new Point2D.Double(getX(),getY());
			
			trackIcesAndHooks();

		//	sprayIce(false);
			
			
		//	out.println(_whipGroup.size());
			
		timeSinceShotSegment = (int)Math.round((getTime() - timeOfLastShot) / (/*8d/(Math.abs(enemy.velocity)+1)*/2d));
		timeSinceShotSegment = (int)limit(0, timeSinceShotSegment, TIMESINCESHOTSEGMENTS-1);
		
		tDirectionChangeSegment = (int)Math.round(timeSinceDirectionChange / 2d);
		tDirectionChangeSegment = (int)limit(0, tDirectionChangeSegment, TDIRECTIONCHANGESEGMENTS-1);
		
		ourTDirectionChangeSegment = (int)Math.round(ourTimeSinceDirectionChange / 2d);
		ourTDirectionChangeSegment = (int)limit(0, ourTDirectionChangeSegment, TDIRECTIONCHANGESEGMENTS-1);
		
		
		if(FIRING) //{
			prepareIce(); //Entangle(); }
			
	}

	public void prepareIce(){
	
			long realTestCount = 0;

			for(int i = 0; i < _whipGroup.size(); i ++){
				IceWave realTest = _whipGroup.get(i);
				if(realTest.real) realTestCount ++;
			}

			if(enemy.energy<=getEnergy()||!CAREFUL){
			if(fireTime==getTime()&getGunHeat()==0&getGunTurnRemaining()==0&(getEnergy()>=icePower|!MOVING)&&getEnergy()!=0/*&&_whipGroup.size()==0*/){
				sprayIce(true,icePower);
				timeOfLastShot = getTime();
				totalShots ++;
				if(quickLogShot) quickLogShots ++;
			} }
			else if(CAREFUL){
			if(fireTime==getTime()&&getGunHeat()==0&&getGunTurnRemaining()==0&&(getEnergy()>=icePower|!MOVING)&&realTestCount==0&&getEnergy()!=0/*&&_whipGroup.size()==0*/){
				sprayIce(true,icePower);
				timeOfLastShot = getTime();
				totalShots ++;
				if(quickLogShot) quickLogShots ++;
			} } 

			if(getEnergy()>=icePower&&oldTotalShots==totalShots&&timeSinceShotSegment!=0){
				sprayIce(false,icePower);
				theoryShots ++;
				//out.println(timeSinceShotSegment);
			} 

		oldTotalShots = totalShots;
	}

	public void produceString(){
		
		currentState = "";
		stage0State = currentState;
		currentState = currentState.concat(getLetterForNumber(distanceSegment));
		stage1State = currentState;
		currentState = stage1State.concat(getLetterForNumber(nearWallSegment));
		stage2State = currentState;
		currentState = stage2State.concat(getLetterForNumber(velocitySegment));
		stage3State = currentState;
		currentState = stage3State.concat(getLetterForNumber(lastVelocitySegment));
		stage4State = currentState;
		//currentState = stage4State.concat(getLetterForNumber(accelerationSegment));
		currentState = stage4State.concat(getLetterForNumber(lateralHeadSegment));
		stage5State = currentState;
		currentState = stage5State.concat(getLetterForNumber(bulletPowerSegment));
		stage6State = currentState;
		currentState = stage6State.concat(getLetterForNumber(tDirectionChangeSegment));
	//	currentState = stage6State.concat(getLetterForNumber(timeSinceShotSegment));
		stage7State = currentState;
		currentState = stage7State.concat(getLetterForNumber(timeSinceShotSegment));
		
		//why didnt i do it this way?

		
		surfState0 = "";
		surfState1 = surfState0.concat(getLetterForNumber(ourVelocitySegment));
		surfState2 = surfState1.concat(getLetterForNumber(distanceSegment));
		surfState3 = surfState2.concat(getLetterForNumber(ourNearWallSegment));
		surfState4 = surfState3.concat(getLetterForNumber(ourLateralHeadingSegment));
		surfState = surfState4.concat(getLetterForNumber(ourTDirectionChangeSegment));

		
	}
	public String getLetterForNumber(int num){
		return String.valueOf(Alphabet.charAt(num%26));
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
	
//		radarInstances ++;
		timeSinceDirectionChange ++;
		ourTimeSinceDirectionChange ++;
		
		update();

		enemy.name = e.getName();
		
		enemy.bearing = e.getBearingRadians();
		heading = getHeadingRadians();
		enemy.distance = e.getDistance();
		enemy.absBearing = (NormaliseBearing(enemy.bearing+heading));
		enemy.velocity = e.getVelocity();
		enemy.lateralHeading = e.getHeadingRadians() - enemy.absBearing;
		enemy.lateralVelocity = enemy.velocity * Math.sin(enemy.lateralHeading);
		
		enemy.lateralDirection = (int)(enemy.lateralVelocity>=0?1:-1);
		if(enemy.lateralVelocity==0) enemy.lateralDirection = enemy.recentDirection;
		
		if(enemy.lateralDirection!=enemy.recentDirection) timeSinceDirectionChange = 0;
		
		enemy.recentDirection = enemy.lateralDirection;
		
		enemy.position = project(ourLocation,enemy.absBearing,enemy.distance);
		
		enemy.absBearingToUs = absoluteBearing(enemy.position, ourLocation);
		
		newBearing = enemy.absBearing;
		newDeltaBearing = newBearing-oldBearing;
		oldBearing = newBearing;
		

		setTurnRadarRightRadians(Utils.normalRelativeAngle(enemy.absBearing - getRadarHeadingRadians())*2);

		///////////////////////
		lateralVelocity = getVelocity() * Math.sin(enemy.bearing);
		lateralDirection = (lateralVelocity>=0?1:-1);
		if(lateralVelocity == 0) lateralDirection = lastLateralDirection;
		if(lastLateralDirection != lateralDirection) ourTimeSinceDirectionChange = 0;
		lastLateralDirection = lateralDirection;
		
		lateralHeading = Utils.normalRelativeAngle(getHeadingRadians() - enemy.absBearingToUs);
		
		boolean theoryTravel = true;

		double energyDelta = enemy.energy - e.getEnergy();
		if(energyDelta > 0 && energyDelta <= 3){
			catalogBatHook(energyDelta, true);
			realHooks ++;
		}
		if(theoryTravel){
			catalogBatHook((float)(Math.random()*3), false);
			theoryHooks ++;
		}
		
		
		enemy.energy = e.getEnergy();
		
		distanceSegment = (int)limit(0,(int)Math.ceil(enemy.distance/(getBattleFieldWidth()/new Double(DISTANCESEGMENTS).doubleValue())),DISTANCESEGMENTS-1);
		
		Point2D.Double enemyProjection = project(enemy.position, Utils.normalRelativeAngle(e.getHeadingRadians()+(e.getVelocity()>=0?0:Math.PI)),
							enemy.position.distance(ourLocation)/(20-3*icePower)*Math.abs(e.getVelocity()));
		nearWallSegment = (playField.contains(enemyProjection)?0:1);
		
		accelerationSegment = accelSegment(newDeltaBearing,oldDeltaBearing);
	
		lateralHeadSegment = (int)limit(0,(Math.round(Math.abs(enemy.lateralHeading / (Math.PI/2)) *
			(new Double(LATERALHEADINGSEGMENTS-1).doubleValue()))),LATERALHEADINGSEGMENTS-1);
		
		oldDeltaBearing = newDeltaBearing;
		
		velocitySegment = (int)limit(0,Math.ceil(enemy.velocity/2),VELOCITYSEGMENTS-1);
		lastVelocitySegment = (int)limit(0,Math.ceil(enemy.lastVelocity/2),VELOCITYSEGMENTS-1);
		
		enemy.lastVelocity = enemy.velocity;
		
		//icePower = limit(1,getEnergy(),3);
		if(MOVING){
			if(e.getEnergy() >= 12){
				icePower = limit(.1,(((16/e.getVelocity())) + (1/(e.getDistance()/getBattleFieldWidth()))
						+ 2.5*(getEnergy()/(e.getEnergy()))) / 3,3);
				out.println(icePower);
			}
			else{
				icePower = limit(.1,e.getEnergy()/4,3);
			}
		}
		
		bulletPowerSegment = (int)Math.round(icePower);
		
		//anglePerBin = Math.asin(8/(20-3*icePower))/(double)MIDBIN;
		anglePerBin = 1/(double)MIDBIN;
		
	//	if(getGunHeat()==0&&(getEnergy()>=icePower|!CAREFUL)&&getGunTurnRemaining()==0){
	//		fireTime=getTime()+1;
	//	}
		
		Point2D.Double ourProjection = project(ourLocation, getHeadingRadians(), (enemy.position.distance(ourLocation)/(20))*getVelocity());
		ourNearWallSegment = (playField.contains(ourProjection)?0:1);
		ourLateralHeadingSegment = (int)limit(0,(Math.round(Math.abs(lateralHeading / (Math.PI/2)) *
			(new Double(LATERALHEADINGSEGMENTS-1).doubleValue()))),LATERALHEADINGSEGMENTS-1);
		ourVelocitySegment = (int)limit(0,Math.ceil(getVelocity()/2),VELOCITYSEGMENTS-1);
		

		produceString();

		if(MOVING)
		flexOnBatman();

		
	//	stateKey = currentState.hashCode();
	//	whipTable.put(stateKey, currentState);
	//	System.out.println(currentState);
		Entangle();
		

		execute();
	}
	
	int accelSegment(double deltaBearing, double oldDeltaBearing) {
        int delta = (int)(Math.round(5 * enemy.distance * (Math.abs(deltaBearing) - Math.abs(oldDeltaBearing))));
        if (delta < 0) {
            return 0;
        } else if (delta > 0) {
            return 2;
        }
        return 1;
    }
	
	public void sprayIce(boolean realBullet, double bPower){
	
		IceWave snowBall = new IceWave();
		snowBall.targetName = enemy.name;
		snowBall.bearing = enemy.absBearing;
		snowBall.distance = enemy.distance;
		snowBall.distanceTraveled = 0;
		snowBall.targetLoc = enemy.position;
		snowBall.time = getTime();
		snowBall.direction = enemy.lateralDirection;
		snowBall.iceSpeed = 20-3*bPower;
		snowBall.shotLoc = ourLocation;
		snowBall.maxEscapeAngle = Math.asin(8/snowBall.iceSpeed)*snowBall.direction;
		snowBall.minBearingOffset = snowBall.bearing-snowBall.maxEscapeAngle;
		snowBall.maxBearingOffset = snowBall.bearing+snowBall.maxEscapeAngle;
		snowBall.distanceSeg = distanceSegment;
		snowBall.nearWallSeg = nearWallSegment;
		snowBall.accelSeg = accelerationSegment;
		snowBall.headSeg = lateralHeadSegment;
		snowBall.real = realBullet;
		snowBall.vSeg = velocitySegment;
		snowBall.timeSeg = timeSinceShotSegment;
		snowBall.tDSeg = tDirectionChangeSegment;
		snowBall.state = currentState;
		snowBall.state0 = stage0State;
		snowBall.state1 = stage1State;
		snowBall.state2 = stage2State;
		snowBall.state3 = stage3State;
		snowBall.state4 = stage4State;
		snowBall.state5 = stage5State;
		snowBall.state6 = stage6State;
		snowBall.state7 = stage7State;
		snowBall.heavyBinKey = currentState.concat(getLetterForNumber(getHeaviestBin()));
		
		_whipGroup.add(snowBall);
		
		

		if(snowBall.real)
		setFire(bPower);

	}
	
	public void Entangle(){
	
		int targetBin = getHeaviestBin();
		
		double binOffset;// = (targetBin - MIDBIN) * enemy.lateralDirection;
		//binOffset /= new Double(MIDBIN);
		double theta=0;// = NormaliseBearing(binOffset*Math.asin(8/(20-3*icePower))+enemy.absBearing);
		
	//	if(getGunHeat()==0&&(getEnergy()>=icePower|!CAREFUL)){
			binOffset = (targetBin - MIDBIN) * enemy.lateralDirection;
			binOffset /= new Double(MIDBIN);
			theta = NormaliseBearing(binOffset*Math.asin(8/(20-3*icePower))+enemy.absBearing);
			fireTime=getTime()+1; //}
		//	fireTime = getTime();
			
			setTurnGunRightRadians(NormaliseBearing(theta - getGunHeadingRadians()));
		
		//	if(FIRING)
		//		prepareIce();
				
			//setTurnGunRightRadians(NormaliseBearing(theta - getGunHeadingRadians()));
		
	/*	}
		else {
			targetBin = MIDBIN;
		
			binOffset = 0;//(targetBin - MIDBIN) * enemy.lateralDirection;
			//binOffset /= new Double(MIDBIN);
			theta = (/*binOffset*Math.asin(8/(20-3*icePower))+*///enemy.absBearing);
		//	setTurnGunRightRadians(NormaliseBearing(theta - getGunHeadingRadians()));
		//	if(FIRING)
		//		prepareIce();
		//}

	}
	
	public int getHeaviestBin(){
	
		Integer heavyBin = MIDBIN;//, tempBin = MIDBIN;
		Set<String> keySet = whipTable.keySet();
		//String newKey = "";

		double weight = 0, tempWeight = 0; boolean useKey = true;
		if(keySet!=null){
		
		if(keySet.contains(currentState)){
			if(((ArrayList<Double>)whipTable.get(currentState)).size()<currentState.length()) useKey = false;
			if(weightTable.containsKey(currentState)){
					_binList = (double[])weightTable.get(currentState);
			for(int i = 0; i < BINS; i ++){
				//newKey = stage1State.concat(new Integer(i).toString());
				tempWeight = _binList[i];
				if(tempWeight > weight) {
					weight = tempWeight;
					heavyBin = i;
				}
			}
			if(weight!=0&&useKey)
			return heavyBin; }
		}
		useKey = true;
		if(keySet.contains(stage7State)){
		if(((ArrayList<Double>)whipTable.get(stage7State)).size()<stage7State.length()) useKey = false;
			if(weightTable.containsKey(stage7State)){
					_binList = (double[])weightTable.get(stage7State);
			for(int i = 0; i < BINS; i ++){
				//newKey = stage1State.concat(new Integer(i).toString());
				tempWeight = _binList[i];
				if(tempWeight > weight) {
					weight = tempWeight;
					heavyBin = i;
				}
			}
			if(weight!=0&&useKey)
			return heavyBin; }
		}
		useKey = true;
		if(keySet.contains(stage6State)){
		if(((ArrayList<Double>)whipTable.get(stage6State)).size()<stage6State.length()) useKey = false;
			if(weightTable.containsKey(stage6State)){
					_binList = (double[])weightTable.get(stage6State);
			for(int i = 0; i < BINS; i ++){
				//newKey = stage1State.concat(new Integer(i).toString());
				tempWeight = _binList[i];
				if(tempWeight > weight) {
					weight = tempWeight;
					heavyBin = i;
				}
			}
			if(weight!=0&&useKey)
			return heavyBin; }
		}
		useKey = true;
		if(keySet.contains(stage5State)){ 
		if(((ArrayList<Double>)whipTable.get(stage5State)).size()<stage5State.length()) useKey = false;
			if(weightTable.containsKey(stage5State)){
					_binList = (double[])weightTable.get(stage5State);
			for(int i = 0; i < BINS; i ++){
				//newKey = stage1State.concat(new Integer(i).toString());
				tempWeight = _binList[i];
				if(tempWeight > weight) {
					weight = tempWeight;
					heavyBin = i;
				}
			}
			if(weight!=0&&useKey)
			return heavyBin; }
		}
		useKey = true;
		if(keySet.contains(stage4State)){
		if(((ArrayList<Double>)whipTable.get(stage4State)).size()<stage4State.length()) useKey = false;
			if(weightTable.containsKey(stage4State)){
					_binList = (double[])weightTable.get(stage4State);
			for(int i = 0; i < BINS; i ++){
				//newKey = stage1State.concat(new Integer(i).toString());
				tempWeight = _binList[i];
				if(tempWeight > weight) {
					weight = tempWeight;
					heavyBin = i;
				}
			}
			if(weight!=0&&useKey)
			return heavyBin; }
		}
		useKey = true;
		if(keySet.contains(stage3State)){
		if(((ArrayList<Double>)whipTable.get(stage3State)).size()<stage3State.length()) useKey = false;
			if(weightTable.containsKey(stage3State)){
					_binList = (double[])weightTable.get(stage3State);
			for(int i = 0; i < BINS; i ++){
				//newKey = stage1State.concat(new Integer(i).toString());
				tempWeight = _binList[i];
				if(tempWeight > weight) {
					weight = tempWeight;
					heavyBin = i;
				}
			}
			if(weight!=0&&useKey)
			return heavyBin; }
		}
		useKey = true;
		if(keySet.contains(stage2State)){ 
		if(((ArrayList<Double>)whipTable.get(stage2State)).size()<stage2State.length()) useKey = false;
			if(weightTable.containsKey(stage2State)){
					_binList = (double[])weightTable.get(stage2State);
			for(int i = 0; i < BINS; i ++){
				//newKey = stage1State.concat(new Integer(i).toString());
				tempWeight = _binList[i];
				if(tempWeight > weight) {
					weight = tempWeight;
					heavyBin = i;
				}
			}
			if(weight!=0&&useKey)
			return heavyBin; }
		}
		useKey = true;
		if(keySet.contains(stage1State)){ 
		if(((ArrayList<Double>)whipTable.get(stage1State)).size()<stage1State.length()) useKey = false;
			//frequencyMap = (double[])whipTable.get(stage1State);
			//heavyBin = getHeaviestBin(frequencyMap);
			if(weightTable.containsKey(stage1State)) {
					_binList = (double[])weightTable.get(stage1State);
			for(int i = 0; i < BINS; i ++){
				//newKey = stage1State.concat(new Integer(i).toString());
				tempWeight = _binList[i];
				if(tempWeight > weight) {
					weight = tempWeight;
					heavyBin = i;
				}
			}
		//	out.println("shooting at: " + heavyBin);
			if(weight!=0&&useKey)
			return heavyBin; }
		}
		useKey = true;
		if(keySet.contains(stage0State)){ 
		if(((ArrayList<Double>)whipTable.get(stage0State)).size()<stage0State.length()) useKey = false;
			if(weightTable.containsKey(stage0State)) {
					_binList = (double[])weightTable.get(stage0State);
			for(int i = 0; i < BINS; i ++){
				//newKey = stage1State.concat(new Integer(i).toString());
				tempWeight = _binList[i];
				if(tempWeight > weight) {
					weight = tempWeight;
					heavyBin = i;
				}
			}
			if(weight!=0&&useKey)
			return heavyBin; }
		}
		}

		return heavyBin;
	}
	
	public int getHeaviestBin(double[] binList) {
		double tempHeight = 0, maxHeight = 0;
		int heavyBin = MIDBIN;
		for(int i = 0; i < binList.length; i ++){
			tempHeight = binList[i];
			if(tempHeight > maxHeight){ maxHeight = tempHeight; heavyBin = i; }
		}
		return heavyBin;
	}
	
	public void kernelSmoother(ArrayList<Double> list, double factor, String key, boolean real) {
//	for(int q = 0; q < 2; q ++){
		/*boolean useKernel = true; */ double[] binList;// = new double[BINS];
//		if(list.size()<(double)key.length()/2) useKernel = false;
	//	if(useKernel){
		boolean placeList = true;
		ArrayList<Double> steadyList = list;
	//String tempKey = "";
		String updateKey = ""; double storageWeight = 1;

	//	for(int l = 0; l < key.length(); l++){
		if(real){
			
	//		tempKey = tempKey.concat(Character.toString(key.charAt(l)));
		
		//list.add(factor);

	/*	for(int k = 0; k < 11; k ++){
			//binList = new double[BINS];
			//tempKey = tempKey.remove(k);
			
			if(!real&&k>0) break;
			if(!real){ updateKey = key; numTheorySaves++; }
			
			if(key.length()>0){
				updateKey = key.substring(0,key.length()-1);
				updateKey = updateKey.concat(Character.toString(Alphabet.charAt(k)));
				//out.println("updateKey : " + updateKey);
				
				distanceFromTrueState = Math.abs(k - Alphabet.indexOf(key.charAt(key.length()-1)))+1;
			}
			else{
				updateKey = "";
				distanceFromTrueState = 1;
				if(k>0) break;
			} */
			updateKey = key;
			
			//out.println("tempKey: " + tempKey);
		
			
			
	//		if(whipTable.containsKey(tempKey)) list = (ArrayList)whipTable.get(tempKey);
		//	if(whipTable.containsKey(updateKey)){ 

		//		list = (ArrayList<Double>)whipTable.get(updateKey); 
				if(list.size()>20){
					list.remove(0);
					whipTable.put(key,list);
				}

		//	}//out.println("foundList"); }
			out.println(list.size());
	//		else{ list = steadyList; placeList = false; }
			//System.out.println("first: " + whipTable.containsKey(updateKey));
		//	whipTable.put(updateKey,list);
			
		//	if(updateKey.equals(key)) list.add(factor);
			
			//System.out.println("second: " + whipTable.containsKey(updateKey));
			//list.add(factor);
			
			int bin = MIDBIN, lastBin = 0;// heavyBin = MIDBIN, lastBin = 0;
	//	String newKey = "";
		double /*x0 = MIDBIN, x2 = MIDBIN,*/ maxVal = -1, minVal = 1; 
		double multiplier = 1, bandWidth = 0, standardMultiplier = 1;
		double totalValue = 0; double listAverage = 0, sDeviation = 0;// deltaX = 0;
		double kernelValue = 0;// listCenter = MIDBIN, maxHeight = 0, tempHeight = 0;
		double squaredDifferenceSum = 0;// weight = 0, tempWeight = 0;
	//	long duck = System.currentTimeMillis(); double adjustedTotal = 0;
		double testOffset = 0;

			//out.println("distance: " + distanceFromTrueState);
		
			//storageWeight = limit(1/100d,1/distanceFromTrueState,1);
			
		// double oldWeight = 0, newWeight = 0;
	//	double centroidX = 0; double integralValue = 0;
//	System.out.println("upK: " + updateKey + "\nsize: " + list.size() + "\n-----------");
		for(int i = 0; i < list.size(); i ++){
			testOffset = list.get(i);
			if(testOffset < minVal) minVal = testOffset;
			if(testOffset > maxVal) maxVal = testOffset;
			
		//	deltaX = testOffset - offset;

			totalValue += testOffset;
			
			//totalValue += bin;
			//adjustedTotal += binList[bin]*(double)(bin);

			//tempHeight = binList[bin];

		//	if(tempHeight > maxHeight){ maxHeight = tempHeight; heavyBin = bin; }
		}
		listAverage = totalValue/((double)list.size());
		//listAverage = adjustedTotal/(double)list.size();
		//listAverage = adjustedTotal/totalValue;
	//	listCenter = (minVal+maxVal)/2;

		standardMultiplier = 1/(double)list.size();

		for(int i = 0; i < list.size(); i ++){
			squaredDifferenceSum += Math.pow(list.get(i)-listAverage,2);
		}

		sDeviation = Math.sqrt(standardMultiplier*squaredDifferenceSum);
		if(Double.isNaN(sDeviation)) sDeviation = .5;
		if(sDeviation==0) sDeviation = .5;
		
	//	sDeviation = .35;

		bandWidth = 1.06*sDeviation*Math.pow((double)list.size(),-1.0/5.0);

	//	out.println("bandWidth: " + bandWidth);
	//	out.println("sigma: " + sDeviation);
	//	out.println("variance: " + Math.pow(sDeviation,2));

		//if(sDeviation!=0)
		multiplier = 1/((Math.sqrt(2*PI)*sDeviation)*bandWidth);
		//else multiplier=1;
		
	//	System.out.println("sDev: " + sDeviation);
	//	System.out.println("fact: " + factor);
	//	out.println("------");
		
	//	String keyIncrement = "a"; int incrementValue = 1;
	//	double keyDistance = 0;
		
	//	out.println(key.length() + " keylength");
	//	for(String i = ""; i.length()<3; i.concat("a")){
	//	out.println(i);
		//}
		
	//	for(int i = incrementValue; i < key.length(); i ++){
		
			//out.println("episode : " + incrementValue);
			
	//		incrementValue++;

	//	double kernelSum = 0; 
		
	/*	String tempKey = "";
		String updateKey = "";

		for(int l = 0; l < key.length(); l++){
		
			binList = new double[BINS];
			tempKey = tempKey.concat(Character.toString(key.charAt(l))); */

/*			for(int k = 0; k < 16; k ++){
			
			//tempKey = tempKey.remove(k);
			updateKey = tempKey.substring(0,tempKey.length()-1);
			//out.println("tempKey: " + tempKey);
			
			updateKey = updateKey.concat(Character.toString(Alphabet.charAt(k)));
			//out.println("updateKey : " + updateKey);
			
			distanceFromTrueState = Math.abs(k - Alphabet.indexOf(tempKey.charAt(tempKey.length()-1)));
*/
			
			//out.println("distance: " + distanceFromTrueState);
		
			storageWeight = limit(1/255d,Math.pow(1/distanceFromTrueState,2),1) * 100;
			
		//	if(!real) storageWeight /= (theoryShots/totalShots)/numTheorySaves;
			
	//		if(weightTable.containsKey(updateKey)){
	//			binList = (double[])weightTable.get(updateKey);
				//out.println("loaded properly");
	//		}
	//		else binList = new double[BINS];
		binList = new double[BINS];	
		

	//	if(weightTable.containsKey(key))
	//		binList = (double[])weightTable.get(key);
//	if(placeList){
	//	int factorBin = getBinForGuessFactor(factor);
		double offset;
		for(int p = 0; p < list.size(); p ++){
		offset = list.get(p);
		for(double t = -1 + anglePerBin/2d; t <= 1 - anglePerBin/2d; t += anglePerBin){
	//	for(int b = 0; b < bins; b ++){
	//	for(int i = 0; i < list.size(); i ++){
			bin = getBinForGuessFactor(t);
		//	kernelValue = 0;
			//out.println(bin);
		//	if(bin!=lastBin){
		//	if(sDeviation!=0)
			//kernelValue = multiplier*Math.exp( -1*( Math.pow((t-factor)/bandWidth,2)/(2*Math.pow(sDeviation,2)) ));
			kernelValue = multiplier*Math.exp( -1*( Math.pow((t-offset)/bandWidth,2)/(2*Math.pow(sDeviation,2)) ));
		//	else
		//	kernelValue = 0;
		//	kernelValue = storageWeight;
			//kernelValue = 1/Math.pow(bin-factorBin,2);
			
			//kernelValue *= storageWeight;
		//	kernelValue += binList[bin];
			//integralValue += Math.pow(factor,2)*kernelValue;
		//	integralValue = factor;
			//kernelSum += kernelValue;
		//	kernelValue = 1/(Math.pow(bin-getBinForGuessFactor(factor),2)+1);
			
		//	newKey = key.concat(new Integer(bin).toString());

	//		oldWeight = binList[bin];
		//	newWeight = oldWeight + kernelValue;
			binList[bin] += /*integralValue*/kernelValue;
	//		out.println("binC : " + bin);
			
		//	_binList[bin] = kernelValue;
		//	if(kernelValue>maxHeight) {
		//		maxHeight = kernelValue;
		//		heavyBin = bin;
		//	}
		//	binList[i] += multiplier*kernelValue;
		//	binList[i] += 1/(Math.pow(i-incBin,2)+1);

		//}
		 lastBin = bin; }
	//	out.println("newHeavyBin: " + heavyBin);
	//	}
		//centroidX = integralValue/kernelSum;
	//	bin = getBinForGuessFactor(centroidX);
	//	binList[bin] += multiplier;
	//	for(int b = 0; b < BINS; b ++){
	//		binList[b] += 1/(Math.pow(b-bin,2)+1);
	//	}
	//	out.println("resultBin: " + getBinForGuessFactor(factor));
		//out.println("is now   : " + getBinForGuessFactor(centroidX));
		} //}
	//	if(placeList)
		weightTable.put(updateKey, binList); } //}
	//	if(!list.equals(steadyList)) whipTable.put(updateKey, list);}
		
	//	out.println("listSize: " + list.size());
	//	}
	//	return heavyBin;
	
	}
	
	public void trackIcesAndHooks(){
	
		for(int i = 0; i < _whipGroup.size(); i ++) {	
			IceWave snowBall = _whipGroup.get(i);
			snowBall.distanceTraveled = snowBall.iceSpeed * (getTime() - snowBall.time);
			if(snowBall.distanceTraveled >= snowBall.shotLoc.distance(enemy.position)){
				saveIceData(snowBall);
				_whipGroup.remove(_whipGroup.lastIndexOf(snowBall));
				i--;
			}
		}
		
		for(int i = 0; i < _hookGroup.size(); i ++){
			BatHook hook = _hookGroup.get(i);
			hook.distanceTraveled = hook.hookSpeed * (getTime() - hook.time);
			if(hook.distanceTraveled >= hook.shotLoc.distance(ourLocation) + 18){
				if(FLATTEN) flatten(hook,ourLocation);
			//	logHit(ourLocation);
				_hookGroup.remove(i);
				i--;
			}
		}

	}
	

	public void saveIceData(IceWave saver){
		
	//	int bin = getResulticeBin(saver,enemy.position);
		double offsetFactor = getResultIceFactor(saver,enemy.position);
	//	double weight = 1d;
	//	double[] binList = new double [BINS];
		
	//	int weight = 1;

	//	int prevBin = bin;
		
	//	String newKey = "";
	//	ArrayList<Integer> _binList = new ArrayList<Integer>();
		
	//	_binList.add(bin);
	

		if(saver.real){
			//out.println("bin: " + bin);
	//	if(!whipTable.isEmpty()){
	//	newKey = saver.state.concat(new Integer(MIDBIN).toString());
	
	//	for(int i = 0; i < BINS; i ++){
		//	newKey = saver.state.concat(new Integer(bin).toString());
//	_binList.add(new Integer(bin));
			
		//if(whipTable.containsKey(newKey)){//whipTable.get(bin).concat(new Integer(bin).toString()))){
		//	weight = Integer.parseInt(whipTable.get(newKey).toString())+1;//(Math.pow(i-bin,2)+1);
		//	whipTable.remove(newKey);
		//}
	//	}
	//		whipTable.put(newKey,weight);
//		if(!whipTable.containsKey(saver.state))
		//	_binList = new double[BINS];
			//_binList.add(new Integer(bin));
			
	//		out.println("saver " + _binList);
	//		weightTable.put(saver.state,_guessFactorList);
		//	_binList.clear();
		/*	newKey = saver.state.concat(new Integer(bin).toString());
			if(weightTable.containsKey(newKey))
			weightTable.put(newKey, (Integer.parseInt(weightTable.get(newKey).toString())+1));
			else weightTable.put(newKey, 1);*/
//			}
//		else{
		//	prevBin = Integer.parseInt(whipTable.get(saver.state).toString(
			//whipTable
		//	newKey = saver.state.concat();
			//whipTable.put(saver.state,(int)Math.ceil(new Double(prevBin+bin).doubleValue()/2));
			
//		}
	//	if(!whipTable.containsKey(saver.state0))
	//	newKey = saver.state0.concat(new Integer(bin).toString());
			
	//	if(whipTable.containsKey(newKey)){//whipTable.get(bin).concat(new Integer(bin).toString()))){
	//		weight = Integer.parseInt(whipTable.get(newKey).toString())+1;
		//	whipTable.remove(newKey);
	//	}
	//	whipTable.put(newKey,weight);
	//_binList = new ArrayList<Integer>();
			//_binList.add(new Integer(bin));
//			_binList = new double[BINS];
//			_binList[bin] += 1;
if(saver.real){
			_guessFactorList = new ArrayList<Double>();
			_guessFactorList.add(offsetFactor);
			}
			if(whipTable.containsKey(saver.state0)){
	//			_binList = (double[])whipTable.get(saver.state0);
			//	if(_binList==null) _binList = new double[BINS];
	//			_binList = kernelSmoother(_binList, bin);
				//out.println("state0");
		//		out.println("preSize0: " + _binList.size());
				//_binList.add(new Integer(bin));
		//		out.println("postSize: " + _binList.size());
				if(saver.real){
				_guessFactorList = (ArrayList<Double>)whipTable.get(saver.state0);
				_guessFactorList.add(offsetFactor);
				}
	//			if(_guessFactorList.size()>300) _guessFactorList.remove(0);
			//	out.println("state0");
				kernelSmoother(_guessFactorList, offsetFactor, saver.state0,saver.real);
			}
		//	if(!whipTable.containsKey(saver.state0))
		if(saver.real)
			whipTable.put(saver.state0,_guessFactorList);
	//		out.println("saver0: " + _binList);
	//		whipTable.put(saver.state0,_binList);
	/*		newKey = saver.state0.concat(new Integer(bin).toString());
			if(weightTable.containsKey(newKey))
			weightTable.put(newKey, (Integer.parseInt(weightTable.get(newKey).toString())+1));
			else weightTable.put(newKey, 1); */
//		}
//		else{
//			prevBin = Integer.parseInt(whipTable.get(saver.state0).toString());
//			whipTable.put(saver.state0,(int)Math.ceil(new Double(prevBin+bin).doubleValue()/2));
//		}
//		if(!whipTable.containsKey(saver.state1))
	//	newKey = saver.state1.concat(new Integer(bin).toString());
			
		//if(whipTable.containsKey(newKey)){//whipTable.get(bin).concat(new Integer(bin).toString()))){
		//	weight = Integer.parseInt(whipTable.get(newKey).toString())+1;
		//	whipTable.remove(newKey);
		//}
		//whipTable.put(newKey,weight);
		//_binList = new ArrayList<Integer>();
		//	_binList.add(new Integer(bin));
//		_binList = new double[BINS];
//			_binList[bin] += 1;
if(saver.real){
			_guessFactorList = new ArrayList<Double>();
			_guessFactorList.add(offsetFactor);
			}
			if(whipTable.containsKey(saver.state1)){
	//			out.println("precheck1: " + _binList.size());
			//	_binList = (double[])whipTable.get(saver.state1);
			//	if(_binList==null) _binList = new double[BINS];
	//			out.println("postSize1: " + _binList.size());
			//	_binList.add(new Integer(bin));
				if(saver.real){
				_guessFactorList = (ArrayList<Double>)whipTable.get(saver.state1);
				_guessFactorList.add(offsetFactor);
				}
	//			if(_guessFactorList.size()>300) _guessFactorList.remove(0);
			//	_binList = kernelSmoother(_binList, bin);
			//	out.println("state1");
			kernelSmoother(_guessFactorList, offsetFactor, saver.state1,saver.real);
			//	newKey = saver.state1.concat(new Integer(bin).toString());
			//	if(weightTable.containsKey(newKey)) oldWeight = Double.parseDouble(weightTable.get(newKey).toString());
			//	weightTable.put(newKey, oldWeight +1);
	//			out.println("postSize: " + _binList.size());
			}
		//	out.println("saver1: " + _binList);
		//	if(!whipTable.containsKey(saver.state1))
		if(saver.real)
			whipTable.put(saver.state1,_guessFactorList);
	/*		newKey = saver.state1.concat(new Integer(bin).toString());
			if(weightTable.containsKey(newKey))
			weightTable.put(newKey, (Integer.parseInt(weightTable.get(newKey).toString())+1));
			else weightTable.put(newKey, 1); */
//			}
//		else{
//			prevBin = Integer.parseInt(whipTable.get(saver.state1).toString());
//			whipTable.put(saver.state1,(int)Math.ceil(new Double(prevBin+bin).doubleValue()/2));
///		}
//		if(!whipTable.containsKey(saver.state2))
	//	newKey = saver.state2.concat(new Integer(bin).toString());
			
	//	if(whipTable.containsKey(newKey)){//whipTable.get(bin).concat(new Integer(bin).toString()))){
	//		weight = Integer.parseInt(whipTable.get(newKey).toString())+1;
		//	whipTable.remove(newKey);
	//	}
	//	whipTable.put(newKey,weight);
//	if(!whipTable.isEmpty())
//_binList = new ArrayList<Integer>();
	//		_binList.add(new Integer(bin));
//	_binList = new double[BINS];
//			_binList[bin] += 1;
			if(saver.real){
			_guessFactorList = new ArrayList<Double>();
			_guessFactorList.add(offsetFactor);
			}
			if(whipTable.containsKey(saver.state2)){
	//			out.println("precheck2: " + _binList.size());
	//			_binList = (double[])whipTable.get(saver.state2);
			//	if(_binList==null) _binList = new double[BINS];
	//			out.println("postSize2: " + _binList.size());
			//	_binList.add(new Integer(bin));
//				_binList = kernelSmoother(_binList, bin);
	//			out.println("postSize: " + _binList.size());
				if(saver.real){
				_guessFactorList = (ArrayList<Double>)whipTable.get(saver.state2);
				_guessFactorList.add(offsetFactor);
				}
	//			if(_guessFactorList.size()>300) _guessFactorList.remove(0);
			//	out.println("state2");
				kernelSmoother(_guessFactorList, offsetFactor, saver.state2,saver.real);
			}
		//	if(!whipTable.containsKey(saver.state2))
		if(saver.real)
			whipTable.put(saver.state2,_guessFactorList);
		//	out.println("saver2: " + _binList);
	//		whipTable.put(saver.state2,_binList);
		/*	newKey = saver.state2.concat(new Integer(bin).toString());
			if(weightTable.containsKey(newKey))
			weightTable.put(newKey, (Integer.parseInt(weightTable.get(newKey).toString())+1));
			else weightTable.put(newKey, 1); */
//			}
//		else{
//			prevBin = Integer.parseInt(whipTable.get(saver.state2).toString());
//			whipTable.put(saver.state2,(int)Math.ceil(new Double(prevBin+bin).doubleValue()/2));
//		}
//		if(!whipTable.containsKey(saver.state3))
//		newKey = saver.state3.concat(new Integer(bin).toString());
			
//		if(whipTable.containsKey(newKey)){//whipTable.get(bin).concat(new Integer(bin).toString()))){
//			weight = Integer.parseInt(whipTable.get(newKey).toString())+1;
		//	whipTable.remove(newKey);
	//	}
//		whipTable.put(newKey,weight);
//if(!whipTable.isEmpty())
			//_binList = new ArrayList<Integer>();
			//_binList.add(new Integer(bin));
		//	_binList = new double[BINS];
		//	_binList[bin] += 1;
			if(saver.real){
			_guessFactorList = new ArrayList<Double>();
			_guessFactorList.add(offsetFactor);
			}
			if(whipTable.containsKey(saver.state3)){
	//			out.println("precheck3: " + _binList.size());
		//		_binList = (double[])whipTable.get(saver.state3);
			//	if(_binList==null) _binList = new double[BINS];
	//			out.println("postSize3: " + _binList.size());
				//_binList.add(new Integer(bin));
//				_binList = kernelSmoother(_binList, bin);
	//			out.println("postSize: " + _binList.size());
	if(saver.real){
				_guessFactorList = (ArrayList<Double>)whipTable.get(saver.state3);
				_guessFactorList.add(offsetFactor);
				}
	//			if(_guessFactorList.size()>300) _guessFactorList.remove(0);
			//	out.println("state3");
				kernelSmoother(_guessFactorList, offsetFactor, saver.state3,saver.real);
			}
		//	if(!whipTable.containsKey(saver.state3))
		if(saver.real)
			whipTable.put(saver.state3,_guessFactorList);
	//		out.println("saver3: " + _binList);
		//	whipTable.put(saver.state3,_binList);
	/*		newKey = saver.state3.concat(new Integer(bin).toString());
			if(weightTable.containsKey(newKey))
			weightTable.put(newKey, (Integer.parseInt(weightTable.get(newKey).toString())+1));
			else weightTable.put(newKey, 1);*/
///		else{
//			prevBin = Integer.parseInt(whipTable.get(saver.state3).toString());
//			whipTable.put(saver.state3,(int)Math.ceil(new Double(prevBin+bin).doubleValue()/2));
//		}
//		if(!whipTable.containsKey(saver.state4))
	//	newKey = saver.state4.concat(new Integer(bin).toString());
			
	//	if(whipTable.containsKey(newKey)){//whipTable.get(bin).concat(new Integer(bin).toString()))){
	//		weight = Integer.parseInt(whipTable.get(newKey).toString())+1;
		//	whipTable.remove(newKey);
	//	}
	//	whipTable.put(newKey,weight);
//	_binList = new ArrayList<Integer>();
	//		_binList.add(new Integer(bin));
//	_binList = new double[BINS];
//			_binList[bin] += 1;
if(saver.real){
			_guessFactorList = new ArrayList<Double>();
			_guessFactorList.add(offsetFactor);
			}
			if(whipTable.containsKey(saver.state4)){
	//			out.println("precheck4: " + _binList.size());
		//		_binList = (double[])whipTable.get(saver.state4);
			//	if(_binList==null) _binList = new double[BINS];
	//			out.println("postSize4: " + _binList.size());
				//_binList.add(new Integer(bin));
//				_binList = kernelSmoother(_binList, bin);
	//			out.println("postSize: " + _binList.size());
	if(saver.real){
				_guessFactorList = (ArrayList<Double>)whipTable.get(saver.state4);
				_guessFactorList.add(offsetFactor);
				}
		//		if(_guessFactorList.size()>300) _guessFactorList.remove(0);
			//	out.println("state4");
				kernelSmoother(_guessFactorList, offsetFactor, saver.state4, saver.real);
			}
		//	if(!whipTable.containsKey(saver.state4))
		if(saver.real)
			whipTable.put(saver.state4,_guessFactorList);
	//		out.println("saver4: " + _binList);
		//	whipTable.put(saver.state4,_binList);
		/*	newKey = saver.state4.concat(new Integer(bin).toString());
			if(weightTable.containsKey(newKey))
			weightTable.put(newKey, (Integer.parseInt(weightTable.get(newKey).toString())+1));
			else weightTable.put(newKey, 1);*/
//		else{
//			prevBin = Integer.parseInt(whipTable.get(saver.state4).toString());
//			whipTable.put(saver.state4,(int)Math.ceil(new Double(prevBin+bin).doubleValue()/2));
//		}
//		if(!whipTable.containsKey(saver.state5))
	//	newKey = saver.state5.concat(new Integer(bin).toString());
			
	//	if(whipTable.containsKey(newKey)){//whipTable.get(bin).concat(new Integer(bin).toString()))){
	//		weight = Integer.parseInt(whipTable.get(newKey).toString())+1;
		//	whipTable.remove(newKey);
	//	}
	//	whipTable.put(newKey,weight);
	//_binList = new ArrayList<Integer>();
			//_binList.add(new Integer(bin));
//			_binList = new double[BINS];
//			_binList[bin] += 1;
if(saver.real){
			_guessFactorList = new ArrayList<Double>();
			_guessFactorList.add(offsetFactor);
			}
			if(whipTable.containsKey(saver.state5)){
	//			out.println("precheck5: " + _binList.size());
		//		_binList = (double[])whipTable.get(saver.state5);
		//		if(_binList==null) _binList = new double[BINS];
	//			out.println("postSize5: " + _binList.size());
				//_binList.add(new Integer(bin));
//				_binList = kernelSmoother(_binList, bin);
	//			out.println("postSize: " + _binList.size());
	if(saver.real){
				_guessFactorList = (ArrayList<Double>)whipTable.get(saver.state5);
				_guessFactorList.add(offsetFactor);
				}
		//		if(_guessFactorList.size()>300) _guessFactorList.remove(0);
			//	out.println("state5");
				kernelSmoother(_guessFactorList, offsetFactor, saver.state5, saver.real);
			}
		//	out.println("saver5: " + _binList);
	//		if(!whipTable.containsKey(saver.state5))
	if(saver.real)
			whipTable.put(saver.state5,_guessFactorList);
		/*	newKey = saver.state5.concat(new Integer(bin).toString());
			if(weightTable.containsKey(newKey))
			weightTable.put(newKey, (Integer.parseInt(weightTable.get(newKey).toString())+1));
			else weightTable.put(newKey, 1);*/
//		else{
//			prevBin = Integer.parseInt(whipTable.get(saver.state5).toString());
//			whipTable.put(saver.state5,(int)Math.ceil(new Double(prevBin+bin).doubleValue()/2));
//		}
//		if(!whipTable.containsKey(saver.state6))
	//	newKey = saver.state6.concat(new Integer(bin).toString());
			
	//	if(whipTable.containsKey(newKey)){//whipTable.get(bin).concat(new Integer(bin).toString()))){
	//		weight = Integer.parseInt(whipTable.get(newKey).toString())+1;
		//	whipTable.remove(newKey);
	//	}
	//	whipTable.put(newKey,weight);
	//_binList = new ArrayList<Integer>();
			//_binList.add(new Integer(bin));
	//		_binList = new double[BINS];
	//		_binList[bin] += 1;
	if(saver.real){
			_guessFactorList = new ArrayList<Double>();
			_guessFactorList.add(offsetFactor);
			}
			if(whipTable.containsKey(saver.state6)){
	//			out.println("precheck4: " + _binList.size());
	//			_binList = (double[])whipTable.get(saver.state6);
			//	if(_binList==null) _binList = new double[BINS];
	//			out.println("postSize6: " + _binList.size());
				//_binList.add(new Integer(bin));
//				_binList = kernelSmoother(_binList, bin);
	//			out.println("postSize: " + _binList.size());
			//	whipTable.put(saver.state6,_binList);
			if(saver.real){
				_guessFactorList = (ArrayList<Double>)whipTable.get(saver.state6);
				_guessFactorList.add(offsetFactor);
				}
	//			if(_guessFactorList.size()>300) _guessFactorList.remove(0);
			//	out.println("state6");
				kernelSmoother(_guessFactorList, offsetFactor, saver.state6, saver.real);
			}
		//	if(!whipTable.containsKey(saver.state6))
		if(saver.real)
			whipTable.put(saver.state6,_guessFactorList);
			
			if(saver.real){
			_guessFactorList = new ArrayList<Double>();
			_guessFactorList.add(offsetFactor);
			}
			if(whipTable.containsKey(saver.state7)){
	//			out.println("precheck4: " + _binList.size());
	//			_binList = (double[])whipTable.get(saver.state6);
			//	if(_binList==null) _binList = new double[BINS];
	//			out.println("postSize6: " + _binList.size());
				//_binList.add(new Integer(bin));
//				_binList = kernelSmoother(_binList, bin);
	//			out.println("postSize: " + _binList.size());
			//	whipTable.put(saver.state6,_binList);
			if(saver.real){
				_guessFactorList = (ArrayList<Double>)whipTable.get(saver.state7);
				_guessFactorList.add(offsetFactor);
				}
	//			if(_guessFactorList.size()>300) _guessFactorList.remove(0);
			//	out.println("state6");
				kernelSmoother(_guessFactorList, offsetFactor, saver.state7, saver.real);
			}
		//	if(!whipTable.containsKey(saver.state6))
		if(saver.real)
			whipTable.put(saver.state7,_guessFactorList);

if(saver.real){
			_guessFactorList = new ArrayList<Double>();
			_guessFactorList.add(offsetFactor);
			}
			if(whipTable.containsKey(saver.state)){
	//			out.println("precheckfull: " + _binList.size());
			//	_binList = (double[])whipTable.get(saver.state);
		//		_guessFactorList = (ArrayList<Double>)whipTable.get(saver.state);
			//	if(_binList==null) _binList = new double[BINS];
	//			out.println("fullSize : " + _binList.size());
				//_binList.add(new Integer(bin));
//				_binList = kernelSmoother(_binList, bin);
		//		bin = kernelSmoother(_guessFactorList, bin);
		if(saver.real){
				_guessFactorList = (ArrayList<Double>)whipTable.get(saver.state);
				_guessFactorList.add(offsetFactor);
				}
	//			if(_guessFactorList.size()>300) _guessFactorList.remove(0);
		//		out.println("state");
				kernelSmoother(_guessFactorList, offsetFactor, saver.state, saver.real);
			}
			//kernelSmoother(_guessFactorList, offsetFactor, saver.state);
		//	if(!whipTable.containsKey(saver.state))
		if(saver.real)
			whipTable.put(saver.state,_guessFactorList);
	//		out.println("saver6: " + _binList);
	//		whipTable.put(saver.state6,_binList);
		//	_binList.clear();
		/*	newKey = saver.state6.concat(new Integer(bin).toString());
			if(weightTable.containsKey(newKey))
			weightTable.put(newKey, (Integer.parseInt(weightTable.get(newKey).toString())+1));
			else weightTable.put(newKey, 1);*/
//		else{
//			prevBin = Integer.parseInt(whipTable.get(saver.state6).toString());
//			whipTable.put(saver.state6,(int)Math.ceil(new Double(prevBin+bin).doubleValue()/2));
//		}
	//	}
		//out.println(whipTable.get(newKey));
//		}
		}
	}
	
	public int getResulticeBin(IceWave saver, Point2D.Double position){
		
		double angleOffset = NormaliseBearing(absoluteBearing(saver.shotLoc,position) - saver.bearing);
		double escapedAnglePercent = angleOffset/saver.maxEscapeAngle;
		int bin = (int)Math.round(limit(0, escapedAnglePercent*MIDBIN + MIDBIN,BINS-1));

		return bin;
	}
	
	public double getResultIceFactor(IceWave saver, Point2D.Double position){
		
		double angleOffset = NormaliseBearing(absoluteBearing(saver.shotLoc,enemy.position) - saver.bearing);
		double escapedAnglePercent = angleOffset/saver.maxEscapeAngle;
	//	int bin = (int)Math.round(limit(0, escapedAnglePercent*MIDBIN + MIDBIN,BINS-1));

		return limit(-1,escapedAnglePercent,1);
	}
	
	public int getBinForGuessFactor(double escapedAnglePercent){
		
		int bin = (int)Math.round(limit(0, escapedAnglePercent*MIDBIN + MIDBIN,BINS-1));
		return bin;
		

	}
/////////////////////////////////////////////////////////////////////
/////////////////////MOVEMENT CODE///////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////

	public void catalogBatHook(double energyDelta, boolean real){
		
		BatHook hook = new BatHook();
		hook.absBearingToUs = enemy.absBearingToUs;
		hook.hookPower = energyDelta;
		hook.hookSpeed = 20-3*hook.hookPower;
 		hook.distance = enemy.distance;
		hook.distanceTraveled = hook.hookSpeed;
		hook.ourLoc = ourLocation;
		hook.shotLoc = enemy.position;
		hook.time = getTime()-1;
		hook.direction = lateralDirection;
		hook.maxEscapeAngle = Math.asin(8/hook.hookSpeed) * hook.direction;
		hook.maxBearingOffset = NormaliseBearing(hook.absBearingToUs + hook.maxEscapeAngle);
		hook.minBearingOffset = NormaliseBearing(hook.absBearingToUs - hook.maxEscapeAngle);
		hook.distSeg = distanceSegment;
		hook.headSeg = ourLateralHeadingSegment;
		hook.vSeg = ourVelocitySegment;
		hook.nearWallSeg = ourNearWallSegment;
		hook.tDSeg = ourTDirectionChangeSegment;
		hook.isReal = real;
		hook.state = surfState;
		hook.state0 = surfState0;
		hook.state1 = surfState1;
		hook.state2 = surfState2;
		hook.state3 = surfState3;
		hook.state4 = surfState4;
		
		theirShots ++;
		
		_hookGroup.add(hook);
	}
	
	public BatHook getClosestBatHook(){
		BatHook closeHook = null;
		double distance = 1000000;
		for(int i = 0; i < _hookGroup.size(); i ++){
			BatHook testHook = _hookGroup.get(i);
			if(testHook.isReal){
			if((ourLocation.distance(testHook.shotLoc)-testHook.distanceTraveled)<distance){
				closeHook = testHook;
				distance = (ourLocation.distance(testHook.shotLoc)-testHook.distanceTraveled);
			}}
		}
		return closeHook;
	}
	
	public BatHook getClosestSurfableBatHook(){
		BatHook closeHook = null;
		double testDistance, timeTillHit = 1000000;
		for(int i = 0; i < _hookGroup.size(); i ++){
			BatHook testHook = _hookGroup.get(i);
			testHook.isActive = false;
			if(testHook.isReal){
			testDistance = (ourLocation.distance(testHook.shotLoc)-testHook.distanceTraveled);
			if(testDistance/testHook.hookSpeed < timeTillHit && testDistance > testHook.hookSpeed){
				closeHook = testHook;
				timeTillHit = testDistance/testHook.hookSpeed;
			} }
		}
		if(closeHook!=null) closeHook.isActive = true;
		return closeHook;
	}
	
	public double getDanger(Point2D.Double position, BatHook hook){
		double danger = 0;
		int bin, deltaBin, lowBin, highBin;
		double botWidth, binWidth, distanceOut=1;
		double[] binList = new double[BINS];
	//	for(int i = 0; i < _hookGroup.size(); i ++){
	//		hook = _hookGroup.get(i);
		if(hook!=null&&hook.isReal){
			bin = getHookBin(position,hook);
			
			botWidth = Math.asin(36/(hook.shotLoc.distance(position)))/2;
			binWidth = Math.abs(hook.maxEscapeAngle)/(new Double(MIDBIN).doubleValue());
		
			deltaBin = new Double(Math.ceil(Math.abs(botWidth/binWidth))+1).intValue();
			//deltaBin = new Double(botWidth%binWidth + Math.ceil(botWidth/binWidth)).intValue();
			
			lowBin = bin - deltaBin; highBin = bin + deltaBin;
		
		/*	if(lowBin <= 0) bin = deltaBin;
			if(highBin >= BINS-1) bin = BINS - deltaBin - 1; */
		
		//	lowBin = (int)limit(0,bin - deltaBin,bin);
		//	highBin = (int)limit(bin,bin + deltaBin,BINS-1);
			
//			int tempLowBin = lowBin;
//			int tempHighBin = highBin;
			
	//		boolean duplicated = false;
			
	//		if(lowBin < 0 || highBin > BINS-1)
	//		duplicated = true;
			
			///lowBin = (int)limit(0,Math.abs(bin - deltaBin),bin);
			///highBin = (int)limit(bin,Math.abs(bin + deltaBin),BINS-1);

			distanceOut = Math.pow(hook.shotLoc.distance(position) - hook.distanceTraveled,2);

			if(hookWeightTable.containsKey(hook.state0)){
				if(hookTable.containsKey(hook.state0))
				if(((ArrayList<Double>)hookTable.get(hook.state0)).size()>hook.state0.length()/2d)
				binList = (double[])hookWeightTable.get(hook.state0);
	//			out.println("0");
			}
			if(hookWeightTable.containsKey(hook.state1)){
				if(hookTable.containsKey(hook.state1))
				if(((ArrayList<Double>)hookTable.get(hook.state1)).size()>hook.state1.length()/2d)
				binList = (double[])hookWeightTable.get(hook.state1);
	//			out.println("1");
			}
			if(hookWeightTable.containsKey(hook.state2)){
				if(hookTable.containsKey(hook.state2))
				if(((ArrayList<Double>)hookTable.get(hook.state2)).size()>hook.state2.length()/2d)
				binList = (double[])hookWeightTable.get(hook.state2);
	//			out.println("2");
			}
			if(hookWeightTable.containsKey(hook.state3)){
				if(hookTable.containsKey(hook.state3))
				if(((ArrayList<Double>)hookTable.get(hook.state3)).size()>hook.state3.length()/2d)
				binList = (double[])hookWeightTable.get(hook.state3);
	//			out.println("3");
			}
			if(hookWeightTable.containsKey(hook.state4)){
				if(hookTable.containsKey(hook.state4))
				if(((ArrayList<Double>)hookTable.get(hook.state4)).size()>hook.state4.length()/2d)
				binList = (double[])hookWeightTable.get(hook.state4);
	//			out.println("4");
			}
			if(hookWeightTable.containsKey(hook.state)){
				if(hookTable.containsKey(hook.state))
				if(((ArrayList<Double>)hookTable.get(hook.state0)).size()>hook.state.length()/2d)
				binList = (double[])hookWeightTable.get(hook.state);
	//			out.println("5");
			}
				
			int c = 0;
			for(int b = lowBin; b <= highBin; b ++){
				c = b;
				if((b)<0)
				c = 0;
				if(b>BINS-1)
				c = BINS-1;
				danger += binList[c] / distanceOut;//[hook.distSeg][hook.nearWallSeg][hook.headSeg][hook.vSeg][hook.tDSeg] / Math.pow(distanceOut,2) * Math.pow(hook.hookPower,2);
			//	if(duplicated) b--;
	//			c = b;
			}
			//danger = binList[bin];
	//	out.println(danger);
		//	danger += hookLog[bin][hook.distSeg][hook.nearWallSeg][hook.headSeg][hook.vSeg][hook.tDSeg] / (distanceOut);
	//	}
		}
		return danger;
	}

	public void flexOnBatman(){
		BatHook hook = getClosestSurfableBatHook();
		//The closer distancingRatio is to 1, the farther away we go.
		//Likewise, the closer to -1, the closer we encroach.
		distancingRatio = limit(-1, ( enemy.energy - getEnergy() )/15 ,1);
		distancingRatio = 1;
	//	distancingRatio = (enemy.energy - getEnergy())/80;
		double turnAmount = getTurnAmount(ourLocation, enemy.position, sign(getVelocity()), getHeadingRadians());
		double goDistance = getVelocity();
		if(hook!=null){
			
			emptySurf = false;

		//	int Dir = surfDir;
		//	if(ourLocation.distance(desiredLoc)<=Math.abs(getVelocity()));
		//	desiredLoc = setPosition(hook);
			Point2D.Double _forwardMove = anticipateMovement(ourLocation, new Double(1/*hook.direction*/).intValue(), hook);
			Point2D.Double _backwardMove = anticipateMovement(ourLocation, new Double(-1/*hook.direction*/).intValue(), hook);
			
			double forwardDanger = getDanger(_forwardMove,hook);
			double backwardDanger = getDanger(_backwardMove,hook);
			double currentDanger = getDanger(ourLocation,hook);
		
		//	int currBin = getHookBin(ourLocation,hook);
		//	int stopBin = getHookBin(desiredLoc,hook);
			
		//	if(currBin>stopBin) Dir = (int)new Double(-1*hook.direction).intValue();
		//	if(stopBin>currBin) Dir = (int)new Double(hook.direction).intValue();
			
			turnAmount = getTurnAmount(ourLocation, hook.shotLoc, sign(getVelocity()), getHeadingRadians());
			
		//	goDistance = desiredLoc.distance(ourLocation);
			goDistance = 100*hook.direction;
			if(forwardDanger>backwardDanger)
			goDistance*=-1;
			
		//	turnAmount = NormaliseBearing(Utils.normalRelativeAngle(absoluteBearing(ourLocation, desiredLoc)) - getHeadingRadians());
			
	//		turnAmount = NormaliseBearing(angleToPoint - getHeadingRadians());

			setMaxVelocity(8);
			
			if(currentDanger<Math.min(forwardDanger,backwardDanger))
				setMaxVelocity(0);
		
		//	if(Math.abs(turnAmount)>PI/2){
			//	goDistance *= -1;
				//if(turnAmount>PI/2) turnAmount -= PI;
				//if(turnAmount<-PI/2) turnAmount += PI;
			//}
		//	out.println("idealBin : " + (stopBin-MIDBIN));
	//		if(getDanger(ourLocation,hook)<=getDanger(desiredLoc,hook)){//stopBin==currBin){
	//			setMaxVelocity(0);}// out.println("stopping at bin: " + (currBin-MIDBIN)); }
			
			setAhead(goDistance);
			
			emptyDirection = lateralDirection;			
		//	if(FLATTEN) flatten(hook,ourLocation);
			
		//	if(FLATTEN)
		//	flatten(hook,desiredLoc);
		}
		else { emptySurf = true; }
		
		//BasicGTSurfer's hacked way
		setTurnRightRadians(turnAmount*Math.signum(Math.abs((int)goDistance)));
		
		if(emptySurf){
			setAhead(160*emptyDirection);
			setMaxVelocity(PI/getTurnRemainingRadians());
			Point2D.Double nextPos = project(ourLocation,getHeadingRadians(),160*emptyDirection);
			if(!playField.contains(nextPos)&&enemy.position.distance(nextPos)<enemy.distance)
		    emptyDirection*=-1;
		}
	}
	
	public double getTurnAmount(Point2D.Double position, Point2D.Double rotationLocation, double dir, double heading){
		
		double absBearingToIncident = absoluteBearing(position,rotationLocation);
		double tangentLine = Utils.normalRelativeAngle(absBearingToIncident - PI/2 - PI/8*dir*distancingRatio);
		double turnAmount = NormaliseBearing(tangentLine - heading);
		
		Point2D.Double projectPosition = project(position,Utils.normalRelativeAngle(heading+turnAmount),160*dir);
		long itterations = 0;
		
		while(!playField.contains(projectPosition)){
			turnAmount += .01*dir;
			projectPosition = project(position,Utils.normalRelativeAngle(heading+turnAmount),160*dir);
			itterations ++;
			if(itterations>500) break;
		}
		
		return NormaliseBearing(turnAmount);
	}
	
	public void dodgeSmoother(ArrayList<Double> list, double factor, String  key){
		
		int bin; //heavyBin = MIDBIN;
		double[] binList = new double[BINS];
	//	String newKey = "";
	//	double x0 = MIDBIN, x2 = MIDBIN, maxVal = 0, minVal = 10; 
		double multiplier, bandWidth = 0, standardMultiplier = 1;
		double totalValue = 0; double listAverage = 0, sDeviation = 0;// deltaX = 0;
		double kernelValue = 0;// listCenter = MIDBIN, maxHeight = 0, tempHeight = 0;
		double squaredDifferenceSum = 0;// weight = 0, tempWeight = 0;
	//	long duck = System.currentTimeMillis(); double adjustedTotal = 0;
		double testOffset = 0;// double oldWeight = 0, newWeight = 0;

		for(int i = 0; i < list.size(); i ++){
			testOffset = (Double)list.get(i);

			totalValue += testOffset;
		}
		listAverage = totalValue/((double)list.size());

		standardMultiplier = 1/(double)list.size();

		for(int i = 0; i < list.size(); i ++){
			squaredDifferenceSum += Math.pow((Double)list.get(i)-listAverage,2);
		}

		sDeviation = Math.sqrt(standardMultiplier*squaredDifferenceSum);
		if(sDeviation == 0)
		sDeviation = Math.abs(factor);
		bandWidth = 1.06*sDeviation*Math.pow((double)list.size(),-1.0/5.0);
	//	out.println("bandWidth: " + bandWidth);
	//	out.println("sigma: " + sDeviation);

		multiplier = 100/((Math.sqrt(2*PI)*sDeviation)*(double)list.size()*bandWidth);
		
		if(hookWeightTable.containsKey(key))
			binList = (double[])hookWeightTable.get(key);
		
		for(double t = -1; t <= 1; t += 0.01){
	//	for(int b = 0; b < bins; b ++){
	//	for(int i = 0; i < list.size(); i ++){
		
			kernelValue = multiplier*Math.exp( -1*( Math.pow((t-factor)/bandWidth,2)/(2*Math.pow(sDeviation,2)) ));
			bin = getSurfBinForGuessFactor(t);
		//	kernelValue = 1/(Math.pow(bin-getBinForGuessFactor(factor),2)+1);
			
		//	newKey = key.concat(new Integer(bin).toString());

	//		oldWeight = binList[bin];
		//	newWeight = oldWeight + kernelValue;
			binList[bin] += kernelValue;
		//	_binList[bin] = kernelValue;

		}
		out.println("binWeight: " + binList[MIDBIN]);
		hookWeightTable.put(key,binList);

	}

	public void logHit(Point2D.Double bulletPosition, BatHook hook){
		
		//Point2D.Double bulletPosition = new Point2D.Double(bullet.getX(),bullet.getY());
		if(hook==null)
		hook = getClosestBatHook();
		theirHits++;

		if(hook!=null){
			
			double saveRatio = Math.sqrt((theoryHooks-totalHookSaveAmount));
			totalHookSaveAmount += saveRatio*saveRatio;
			//double multiplier;
			int hitBin = getHookBin(bulletPosition, hook);
			out.println("hit at bin : " + (hitBin-MIDBIN));
			double offsetFactor = getOffsetFactor(bulletPosition,hook);
			ArrayList<Double> list = new ArrayList<Double>();
			list.add(offsetFactor);
		//	_dodgeFactorList.add(offsetFactor);
			
			if(hookTable.containsKey(surfState0)){
				list = (ArrayList<Double>)hookTable.get(surfState0);
				list.add(offsetFactor);
				dodgeSmoother(list,offsetFactor,surfState0);
			}
			hookTable.put(surfState0,list);
			
			list = new ArrayList<Double>();
			list.add(offsetFactor);
			
			if(hookTable.containsKey(surfState1)){
				list = (ArrayList<Double>)hookTable.get(surfState1);
				list.add(offsetFactor);
				dodgeSmoother(list,offsetFactor,surfState1);
			}
			hookTable.put(surfState1,list);
			
			list = new ArrayList<Double>();
			list.add(offsetFactor);
			
			if(hookTable.containsKey(surfState2)){
				list = (ArrayList<Double>)hookTable.get(surfState2);
				list.add(offsetFactor);
				dodgeSmoother(list,offsetFactor,surfState2);
			}
			hookTable.put(surfState2,list);
			
			list = new ArrayList<Double>();
			list.add(offsetFactor);
			
			if(hookTable.containsKey(surfState3)){
				list = (ArrayList<Double>)hookTable.get(surfState3);
				list.add(offsetFactor);
				dodgeSmoother(list,offsetFactor,surfState3);
			}
			hookTable.put(surfState3,list);
			
			list = new ArrayList<Double>();
			list.add(offsetFactor);
			
			if(hookTable.containsKey(surfState4)){
				list = (ArrayList<Double>)hookTable.get(surfState4);
				list.add(offsetFactor);
				dodgeSmoother(list,offsetFactor,surfState4);
			}
			hookTable.put(surfState4,list);
			
			list = new ArrayList<Double>();
			list.add(offsetFactor);
			
			if(hookTable.containsKey(surfState)){
				list = (ArrayList<Double>)hookTable.get(surfState);
				list.add(offsetFactor);
				dodgeSmoother(list,offsetFactor,surfState);
			}
			hookTable.put(surfState,list);
			
	/*		for(int i = 0; i < BINS; i ++){
				
				multiplier = saveRatio/(Math.pow(i-hitBin,2)+1);
		//		if(FLATTEN)
		//		multiplier = (theirShots/theirHits)/(Math.pow(i-hitBin,2)+1);
				hookLog[i][hook.distSeg][hook.nearWallSeg][hook.headSeg][hook.vSeg][hook.tDSeg] += multiplier;
				
				for(int d = 0; d < DISTANCESEGMENTS; d ++){
					hookLog[i][d][hook.nearWallSeg][hook.headSeg][hook.vSeg][hook.tDSeg] += saveRatio/(Math.pow(d-hook.distSeg,2)+1) * multiplier;
				}
				for(int w = 0; w < NEARWALLSEGMENTS; w ++){
					hookLog[i][hook.distSeg][w][hook.headSeg][hook.vSeg][hook.tDSeg] += saveRatio/(Math.pow(w-hook.nearWallSeg,2)+1) * multiplier;
				}
				for(int h = 0; h < LATERALHEADINGSEGMENTS; h ++){
					hookLog[i][hook.distSeg][hook.nearWallSeg][h][hook.vSeg][hook.tDSeg] += saveRatio/(Math.pow(h-hook.headSeg,2)+1) * multiplier;
				}
				for(int v = 0; v < VELOCITYSEGMENTS; v ++){
					hookLog[i][hook.distSeg][hook.nearWallSeg][hook.headSeg][v][hook.tDSeg] += saveRatio/(Math.pow(v-hook.vSeg,2)+1) * multiplier;

				}
				for(int td = 0; td < TDIRECTIONCHANGESEGMENTS; td ++){
					hookLog[i][hook.distSeg][hook.nearWallSeg][hook.headSeg][hook.vSeg][td] += saveRatio/(Math.pow(td-hook.tDSeg,2)+1) * multiplier;
		//			hookLog[i][d][w][h][v][td] += 1/(Math.pow(d-hook.distSeg,2)+1) * 1/(Math.pow(w-hook.nearWallSeg,2)+1) *
		//										1/(Math.pow(h-hook.headSeg,2)+1)* 1/(Math.pow(v-hook.vSeg,2)+1) * 1/(Math.pow(td-hook.tDSeg,2)+1) * multiplier;
				}
	//}}}}
			} */
		
		}
	}
	
	public int getHookBin(Point2D.Double bPos, BatHook hook){
		
		double bearingOffsetPercent = Utils.normalRelativeAngle(absoluteBearing(hook.shotLoc,bPos)-hook.absBearingToUs)/hook.maxEscapeAngle;
		int bin = ((int)Math.round(bearingOffsetPercent*MIDBIN)+MIDBIN);
		
		return bin;
	}
	
	public double getOffsetFactor(Point2D.Double bPos, BatHook hook){
	
		return NormaliseBearing(absoluteBearing(hook.shotLoc,bPos)-hook.absBearingToUs)/hook.maxEscapeAngle;
	
	}
	
	public int getSurfBinForGuessFactor(double factor){
		
		return (int)Math.round(limit(0, factor*MIDBIN + MIDBIN,BINS-1));	

	}
	
/*	public Point2D.Double setPosition(BatHook hook){
		
	//	Point2D.Double nextLocation = anticipateMovement(ourLocation, new Double(-1*hook.direction).intValue(), hook);
	//	Point2D.Double backLocation = anticipateMovement(ourLocation, new Double(hook.direction).intValue(), hook);
	//	anticipateMovement(ourLocation, new Double(-1*hook.direction).intValue(), hook);
	//	anticipateMovement(ourLocation, new Double(1*hook.direction).intValue(), hook);
		ArrayList<Point2D.Double> _forwardMoves = anticipateMovement(ourLocation, new Double(hook.direction).intValue(), hook);
		ArrayList<Point2D.Double> _backwardMoves = anticipateMovement(ourLocation, new Double(-1*hook.direction).intValue(), hook);
		
		Point2D.Double possibleStopPoint = ourLocation;
		Point2D.Double stopPoint = _backwardMoves.get(_backwardMoves.size()-1);
		
	//	if (getHookBin(stopPoint, hook)!=getHookBin(ourLocation,hook))
	//	if(stopPoint.distance(ourLocation)!=0)
	//	return stopPoint;
		
		double danger = Double.POSITIVE_INFINITY;
		double tempDanger = 0;
		

		for(int i = 0; i < _forwardMoves.size(); i ++){
			possibleStopPoint = (Point2D.Double)_forwardMoves.get(i);
			tempDanger = getDanger(possibleStopPoint, hook);
			if(tempDanger<danger){
				//BasticGTSurfer's requirement
		//		if(possibleStopPoint.distanceSq(ourLocation)>20*20*1.1){
					surfDir = hook.direction;
					danger = tempDanger;
					stopPoint = possibleStopPoint;
		//		}
			}
		}
		for(int i = 0; i < _backwardMoves.size(); i ++){
			possibleStopPoint = (Point2D.Double)_backwardMoves.get(i);
			tempDanger = getDanger(possibleStopPoint, hook);
			if(tempDanger<danger){
		//		if(possibleStopPoint.distanceSq(ourLocation)>20*20*1.1){
					danger = tempDanger;
					stopPoint = possibleStopPoint;
					surfDir = hook.direction*-1;
		//	 	}
			}
		}
		_positionGroup.clear();
		_forwardMoves.clear();
		_backwardMoves.clear();
		
	//	currDanger = getDanger(ourLocation, hook);
	//	nextDanger = getDanger(nextLocation, hook);
	//	lastDanger = getDanger(backLocation, hook);
		
		return stopPoint;

	} */
	
	public /*ArrayList<Point2D.Double>*/ Point2D.Double anticipateMovement(Point2D.Double tempPosition, int direction, BatHook hook){
		
		boolean interrupted = false;
		long itterations = 1;
		double tempHeading = getHeadingRadians();
		ArrayList<Point2D.Double> _movePoints = new ArrayList<Point2D.Double>();
		double tempVelocity = getVelocity();
		double turnAmount;// = getTurnAmount(tempPosition,hook.shotLoc,direction*lateralDirection,heading);
		direction *= hook.direction;
		double maxTurn;
		_movePoints.add(ourLocation);
		
		do{
			
			if(tempVelocity!=0) {
			tempVelocity += (direction*tempVelocity>0?direction:2*direction); }
			else {
			tempVelocity = direction; }
			tempVelocity = limit(-8, tempVelocity, 8);
			
			turnAmount = NormaliseBearing(getTurnAmount(tempPosition,hook.shotLoc,sign(tempVelocity),tempHeading));

			maxTurn = PI/720d*(40d - 3d*Math.abs(tempVelocity));
			
			if(turnAmount>PI/2) { turnAmount -= PI; direction*=-1; }
			if(turnAmount<-PI/2) { turnAmount += PI; direction*=-1; }
			tempHeading += limit(-maxTurn,turnAmount,maxTurn);
			tempHeading = Utils.normalRelativeAngle(tempHeading);
			
			tempPosition = project(tempPosition,tempHeading,tempVelocity);
			
			_positionGroup.add(tempPosition);
			_movePoints.add(tempPosition);

			double distHookTraveled = itterations * hook.hookSpeed + hook.distanceTraveled;
			
			if(distHookTraveled>=tempPosition.distance(hook.shotLoc)-hook.hookSpeed) interrupted = true;

			//if(itterations > tempPosition.distance(hook.shotLoc)/hook.hookSpeed) break;
			
			itterations ++;
			
		}while(!interrupted);
		

		return tempPosition;
		//return _movePoints;
	}
	
	public void flatten(BatHook hook, Point2D.Double loc){
		//int bin = (int)Math.round(Math.random() * ((BINS-1)));
	//	for(int i = 0; i < BINS; i ++){
		//	hookLog[i][hook.distSeg][hook.nearWallSeg][hook.headSeg][hook.vSeg][hook.tDSeg] += 1/(Math.pow(i-bin,2)+1);
	//	}
//		else
	//		hookLog[bin][hook.distSeg][hook.nearWallSeg][hook.headSeg][hook.vSeg][hook.tDSeg] += 1/(Math.pow(i-MIDBIN,2)+1);
	}

/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {

		logHit(new Point2D.Double(e.getBullet().getX(),e.getBullet().getY()), null);

	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent e) {

	}
	
	public void onBulletHitBullet(Bullet bullet, Bullet theirBullet){
		
		Point2D.Double bulletPos = new Point2D.Double(theirBullet.getX(),theirBullet.getY());
		BatHook hook = getBHBHook(bulletPos);
		logHit(bulletPos, hook);

	}
	
	public BatHook getBHBHook(Point2D.Double pos){
		
		BatHook closeHook = null, testHook = null;
		double distance = 10000, testDistance = 10000;
		for(int i = 0; i < _hookGroup.size(); i ++){
			testHook = _hookGroup.get(i);
			if(testHook.isReal){
			testDistance = Math.abs(pos.distance(testHook.shotLoc)-testHook.distanceTraveled);
			if(testDistance < distance){
				closeHook = testHook;
				distance = testDistance;
			} }
		}

		return closeHook;

	}

	public void onDeath(DeathEvent e) {
		out.println("quickLogShots: " + quickLogShots);
		out.println("totalShots   : " + totalShots);
		out.println("percent QL/T : " + (quickLogShots/totalShots*100));
		out.println("theoryShots  : " + theoryShots);//(totalShots/(theoryShots+totalShots)*theoryShots));
		out.println("skippedTurns : " + numSkippedTurns);
		orientated = false;
	}
	public void onWin(WinEvent e) {
		out.println("quickLogShots: " + quickLogShots);
		out.println("totalShots   : " + totalShots);
		out.println("percent QL/T : " + (quickLogShots/totalShots)*100);
		out.println("theoryShots  : " + theoryShots);//(totalShots/(theoryShots+totalShots)*theoryShots));
		out.println("skippedTurns : " + numSkippedTurns);
		orientated = false;
	}
	




	double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }
	double absoluteBearing(double sourcex, double sourcey,double targetx,double targety){
		return Math.atan2(targetx - sourcex, targety - sourcey);
	}	
	Point2D.Double project(Point2D sourceLocation, double angle, double length) {
		return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
				sourceLocation.getY() + Math.cos(angle) * length);
	}
	double NormaliseBearing(double ang) {
		if (ang > PI)
			ang -= 2*PI;
		if (ang < -PI)
			ang += 2*PI;
		return Utils.normalRelativeAngle(ang);
	}
	double limit(double min, double value, double max){
		if(max>=min)
		return Math.min(Math.max(min,value),max);
		if(max<min)
		return Math.min(Math.max(max,value),min);
		return Math.min(Math.max(min,value),max);
	}
	int sign(double number){
		return (number>=0?1:-1);
	}
	
	public void onSkippedTurn(SkippedTurnEvent e){
		numSkippedTurns ++;
	}
	

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

public void onPaint(Graphics2D g) {

	//	g.drawString("Fighting: " + enemy.name, 2, new Double(this.getBattleFieldHeight()).intValue()-10);
	g.setColor(Color.green);
	g.drawOval(new Double(getX() - 25).intValue(), new Double(getY() - 25).intValue(), 50, 50);
	double radius = 0;
	Point2D.Double midBin = ourLocation;
	Point2D.Double maxBin = ourLocation;
	Point2D.Double minBin = ourLocation;
	if(_whipGroup!=null)
	for(int i = 0; i < _whipGroup.size(); i ++){
		IceWave gW = (IceWave)_whipGroup.get(i);
		radius = gW.distanceTraveled+gW.iceSpeed;
		midBin = new Point2D.Double((radius*Math.sin(gW.bearing)) + gW.shotLoc.getX(), (radius*Math.cos(gW.bearing)) + gW.shotLoc.getY());
		maxBin = new Point2D.Double((radius*Math.sin(gW.maxBearingOffset)) + gW.shotLoc.getX(), (radius*Math.cos(gW.maxBearingOffset)) + gW.shotLoc.getY());
		minBin = new Point2D.Double((radius*Math.sin(gW.minBearingOffset)) + gW.shotLoc.getX(), (radius*Math.cos(gW.minBearingOffset)) + gW.shotLoc.getY());
	/*	if(!gW.real&& paintTheoryShots){
		g.setColor(Color.RED);
		g.drawOval(new Double(gW.shotLoc.getX() - (radius)).intValue(), new Double(gW.shotLoc.getY() - (radius)).intValue(), new Double(radius*2).intValue(), new Double(radius*2).intValue());
		g.setColor(Color.YELLOW);
		g.drawOval(new Double(midBin.x - 5).intValue(), new Double(midBin.y - 5).intValue(), 10, 10);
		g.setColor(Color.BLUE);
		g.drawOval(new Double(maxBin.x - 5).intValue(), new Double(maxBin.y - 5).intValue(), 10, 10);
		g.setColor(Color.WHITE);
		g.drawOval(new Double(minBin.x - 5).intValue(), new Double(minBin.y - 5).intValue(), 10, 10);
		}
		else*/ if(gW.real || paintTheoryShots){
		g.setColor(purple);
		g.drawOval(new Double(gW.shotLoc.getX() - (radius)).intValue(), new Double(gW.shotLoc.getY() - (radius)).intValue(), new Double(radius*2).intValue(), new Double(radius*2).intValue());
		g.setColor(Color.YELLOW);
		g.drawOval(new Double(midBin.x - 5).intValue(), new Double(midBin.y - 5).intValue(), 10, 10);
		g.setColor(Color.BLUE);
		g.drawOval(new Double(maxBin.x - 5).intValue(), new Double(maxBin.y - 5).intValue(), 10, 10);
		g.setColor(Color.WHITE);
		g.drawOval(new Double(minBin.x - 5).intValue(), new Double(minBin.y - 5).intValue(), 10, 10);
		}
	}
	for(int i = 0; i < _hookGroup.size(); i ++){
		BatHook gW = _hookGroup.get(i);
		radius = gW.distanceTraveled+gW.hookSpeed;
		if(gW.isReal || paintTheoryShots){
		midBin = new Point2D.Double((radius*Math.sin(gW.absBearingToUs)) + gW.shotLoc.getX(), (radius*Math.cos(gW.absBearingToUs)) + gW.shotLoc.getY());
		maxBin = new Point2D.Double((radius*Math.sin(gW.maxBearingOffset)) + gW.shotLoc.getX(), (radius*Math.cos(gW.maxBearingOffset)) + gW.shotLoc.getY());
		minBin = new Point2D.Double((radius*Math.sin(gW.minBearingOffset)) + gW.shotLoc.getX(), (radius*Math.cos(gW.minBearingOffset)) + gW.shotLoc.getY());
		
		if(gW.isActive) g.setColor(purple);
		else g.setColor(Color.green);
		g.drawOval(new Double(gW.shotLoc.getX() - (radius)).intValue(), new Double(gW.shotLoc.getY() - (radius)).intValue(), new Double(radius*2).intValue(), new Double(radius*2).intValue());
		g.setColor(Color.YELLOW);
		g.drawOval(new Double(midBin.x - 5).intValue(), new Double(midBin.y - 5).intValue(), 10, 10);
		g.setColor(Color.BLUE);
		g.drawOval(new Double(maxBin.x - 5).intValue(), new Double(maxBin.y - 5).intValue(), 10, 10);
		g.setColor(Color.WHITE);
		g.drawOval(new Double(minBin.x - 5).intValue(), new Double(minBin.y - 5).intValue(), 10, 10);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

	
}





class Condor {
	
	String name;
	
	Point2D.Double position;
	double energy = 100d;
	double distance;
	double absBearing;
	double absBearingToUs;
	double bearing;
	double velocity;
	double lastVelocity;
	double lateralHeading;
	double lateralVelocity;
	
	int lateralDirection;
	int recentDirection;
	
	
}

class IceWave {
	
	String targetName;
	double bearing;
	double iceSpeed;
	double distance;
	double distanceTraveled;
	Point2D.Double targetLoc;
	double time;
	double direction;
	Point2D.Double shotLoc;
	double maxEscapeAngle;
	double maxBearingOffset;
	double minBearingOffset;
	int distanceSeg;
	int nearWallSeg;
	int accelSeg;
	int headSeg;
	int timeSeg;
	int vSeg;
	int lvSeg;
	int tDSeg;
	boolean real;
	String state,state0,state1,state2,state3,state4,state5,state6,state7;
	String heavyBinKey;
	
}

class BatHook {

	double absBearingToUs;
	double hookSpeed;
	double hookPower;
	double distance;
	double distanceTraveled;
	Point2D.Double ourLoc;
	Point2D.Double shotLoc;
	double time;
	double direction;
	double maxEscapeAngle;
	double maxBearingOffset;
	double minBearingOffset;
	int distSeg;
	int nearWallSeg;
	int headSeg;
	int vSeg;
	int tDSeg;
	String state,state0,state1,state2,state3,state4,state5,state6,state7;
	String heavyBinKey;
	
	boolean isReal;
	boolean isActive;

}