package tm;

/********************************************************************
* BulletPower1on1SB6b.java -- Cep[vZ
*
* Date:		2002/Dec/31
* Author:	Matunaga Takateru
*
*******************************************************************/
public class BulletPower1on1SB6b implements BulletPower {
	int count = 0;
	double myEne, eneEne;		//GlM[
	double distance;			//CGԋ

	//---------------------------------------------------------
	// getBulletPower()
	//
	//
	//---------------------------------------------------------
	public double getBulletPower(double myEne, double eneEne, double distance, double hitRate) {
		this.myEne = myEne;
		this.eneEne = eneEne;
		this.distance = distance;

		double distancePow, myEnePow, eneEnePow;

		if (myEne <= 0.2) return 0;
		
		if (myEne <= 1.8) {
			if (count > 15) {
				count = 0;
				return 0.1;
			} else {
				count++;
				return 0.0;
			}
		}
		
		// p[
		if (distance < 300)      distancePow = 3;
		else if (distance < 900) distancePow = 4 - (distance / 300);
		else                     distancePow = 3.25 - (distance / 400);
		
		if (distancePow >= 3 && myEne > 5 && distance < 140) return 3;
		
		myEnePow = calcPowerForMyEnergy(distancePow);
		eneEnePow = calcPowerForEneEnergy();
	
		
		if (myEne > 16 && eneEne < 16) return eneEnePow;
		if (eneEne < 16 && myEne > eneEne * 2) return eneEnePow;
		
		double bp = Math.min(Math.min(distancePow, myEnePow), eneEnePow);

		if (bp < 0.1) bp = 0.1;
		
		return bp;
	}


	//---------------------------------------------------------
	// calcPowerForMyEnergy() -- GlM[ɉăp[vZ
	//
	//
	//---------------------------------------------------------
	double calcPowerForMyEnergy(double dPow) {
		if (myEne < 20) {
			return 3 * myEne / 20;
		}
		
		return 3;
	}
	
	//---------------------------------------------------------
	// calcPowerForEneEnergy() -- GGlM[ɉăp[vZ
	//
	//
	//---------------------------------------------------------
	double calcPowerForEneEnergy() {
		//ŏ
		if (eneEne <= 4) {
			return eneEne / 4 + 0.1;
		} else if (eneEne <= 15.4) {
			return (eneEne + 2) / 6 + 0.1;
		} else {
			return 3.0;
		}
	}
}