package tm;
import robocode.*;
import java.util.*;

/********************************************************************
* MoveGravity2.java -- d͈ړ
*                      œKn, R[i[ړt
*                      ǋߔ
*
* Date:		2002/Nov/23
* Author :	Matunaga Takateru
*
********************************************************************/
class MoveGravity2 implements Move {
	MyRobot my;
	double fW, fH;
	double dstX, dstY;
	Random rand = new Random(System.currentTimeMillis());
	Point poRough;
	final int NORTH = MyRobot.NORTH;
	final int SOUTH = MyRobot.SOUTH;
	final int WEST = MyRobot.WEST;
	final int EAST = MyRobot.EAST;
	final int NE = MyRobot.NE;
	final int SE = MyRobot.SE;
	final int NW = MyRobot.NW;
	final int SW = MyRobot.SW;	
	int nearWall, nearCorner;

	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public MoveGravity2(MyRobot my) {
		this.my = my;
		fW = my.fW;
		fH = my.fH;
		init();
	}
	
	public void init() {
		dstX = my.getX();
		dstY = my.getY();
		my.EPSILON = 50;
		my.setMaxVelocity(8);
		poRough = getRoughPoint();
	}
	
	public double getDstX() {
		return dstX;
	}
	
	public double getDstY() {
		return dstY;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void setNextPoint() {
		//d͂ňړ
		HashMap data;
		Iterator itr;
		Enemy ene;
		double distance;
		double dx = 0, dy = 0;
		double vx = 0;		//ړxNg
		double vy = 0;
		int n = 0;
		final int GDistance = 1000;		//d͓_ɂׂ_̍ő勗
		
		if (my.isArrived(dstX, dstY)) {
			data = my.map.getNearEnemy(GDistance);
			itr = data.values().iterator();
			
			while (itr.hasNext()) {
				ene = (Enemy)itr.next();
				dx = my.getX() - ene.getX();
				dy = my.getY() - ene.getY();
				distance = ene.getDistance();
				vx += dx / (distance * distance);
				vy += dy / (distance * distance);
//				print("vx vy = " + vx + " " + vy);
				n++;
			}
			
			double dd;
			if ((dd = Math.sqrt(vx * vx + vy * vy)) == 0) return;
				
			double cc = 1.0 / dd;

			dstX = my.getX() + vx * cc * 50;
			dstY = my.getY() + vy * cc * 50;
			
			dstX += M.sign(vx) * rand.nextInt(80) - 40;
			dstY += M.sign(vy) * rand.nextInt(80) - 40;
				
			//go to rought point
			if (my.getTime() < 120 || my.getOthers() < 5) poRough = getRoughPoint();
			double rdx, rdy;
			rdx = poRough.x - dstX;
			rdy = poRough.y - dstY;
			
			dstX += rdx / 10;
			dstY += rdy / 10;
				
			refrection();
			correctDestination();
		}
		
		my.setGoPos(dstX, dstY);
//M.print("I will go to dstX Y = " + dstX + " " + dstY);
//M.print("moveGravity2");
	}

	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void setMove() {
		;
	}
	
	//---------------------------------------------------------
	// getRoughPoint() -- eȒn_Ԃ
	//
	//
	//---------------------------------------------------------
	Point getRoughPoint() {
		Iterator itr = my.map.data.values().iterator();
		Enemy[] ene = new Enemy[20];
		Point[] po = new Point[20];			//enemy point
		int[] dis = new int[20];
		int i;
		int others;
		int[] disTotal = new int[8];

		
		if (my.getTime() < 10) return new Point(0, 0);
		
		//get enemy point
		others = 0;
		while (itr.hasNext()) {
			if (others >= 20) break;
			ene[others] = (Enemy)itr.next();
			po[others] = new Point(ene[others].getX(), ene[others].getY());
			others++;			
		}
		
		//calculate rought point
		int x, y;
		double xx, yy;
		double dx, dy;
		int maxDisTotal = 0;
		int maxIndex = 0;
		double safeX = 0, safeY = 0;
		int count = 0;
		for (y = 0; y < 3; y++) {
			yy = y * fH / 2;
			for (x = 0; x < 3; x++) {
				xx = x * fW / 2;
				
				if (x == 1 && y == 1) continue;			//except center
				
				for (i = 0; i < others; i++) {
					dx = po[i].x - xx;
					dy = po[i].y - yy;
					dis[i] = (int)Math.sqrt(dx*dx + dy*dy);
					disTotal[count] += dis[i];
				}
				if (maxDisTotal < disTotal[count]) {
					maxDisTotal = disTotal[count];
					maxIndex = x + y * 3;
					safeX = xx;
					safeY = yy;
				}
				count++;
			}
		}
		
//M.print("safeX Y = " + safeX + " " + safeY);
//M.print("disTotal = " + maxDisTotal);
		
		final int MARGIN = 30;
		
		if (safeX < MARGIN)           safeX = MARGIN;
		else if (safeX > fW - MARGIN) safeX = fW - MARGIN;
		if (safeY < MARGIN)           safeY = MARGIN;
		else if (safeY > fH - MARGIN) safeY = fH - MARGIN;

		return new Point(safeX, safeY);
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void wallNear() {
		;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void hitByBullet(HitByBulletEvent e) {
		my.result.damage();
	}

	//--------------------------------------------------------------
	// refrection() -- ǔ
	//
	//
	//--------------------------------------------------------------
	void refrection() {
		final double RMARGIN = 10;		//˃}[W
		final int DIFF = 150;
		final int DIFF2 = 100;
		
		setNearWall();
		
		//refrection
		if (dstX < RMARGIN || fW - dstX < RMARGIN || dstY < RMARGIN || fH - dstY < RMARGIN) {
			switch (nearWall) {
				case NORTH:
					dstY = fH - DIFF;
					if (dstX < fW / 2) {
						dstX = my.getX() - DIFF2;
					} else {
						dstX = my.getX() + DIFF2;						
					}
					break;

				case EAST:
					dstX = fH - DIFF;
					if (dstY < fH / 2) {
						dstY = my.getY() - DIFF2;
					} else {
						dstY = my.getY() + DIFF2;						
					}
					break;

				case SOUTH:
					dstY = DIFF;
					if (dstX < fW / 2) {
						dstX = my.getX() - DIFF2;
					} else {
						dstX = my.getX() + DIFF2;						
					}
					break;

				case WEST:
					dstX = DIFF;
					if (dstY < fH / 2) {
						dstY = my.getY() - DIFF2;
					} else {
						dstY = my.getY() + DIFF2;						
					}
					break;
			}
		}																	
	}
	
	//--------------------------------------------------------------
	// correctDestination() -- dstX, dstY tB[h̒lɂ
	//
	//
	//--------------------------------------------------------------
	private void correctDestination() {
		final double MARGIN = 50;
		
		if (dstX < MARGIN)            dstX = MARGIN;
		else if (fW - dstX < MARGIN)  dstX = fW - MARGIN;
		if (dstY < MARGIN)            dstY = MARGIN;
		else  if (fH - dstY < MARGIN) dstY = fH - MARGIN;
	}
	

	//------------------------------------------------------------------
	// setNearWall()
	//
	//
	//------------------------------------------------------------------
	void setNearWall() {
		double min = my.getX();
		double myX = my.getX();
		double myY = my.getY();
		
		nearWall = WEST;
		
		//Ƃ߂ǂ̕ṕH
		if (min > fH - myY) {
			nearWall = NORTH;
			min = fH - myY;
		}

		if (min > fW - myX) {
			nearWall = EAST;
			min = fW - myX;
		}
		
		if (min > myY) {
			nearWall = SOUTH;
			min = myY;
		}
	}


	//------------------------------------------------------------------
	// scannedRobot()
	//
	//
	//------------------------------------------------------------------
	public void scannedRobot(ScannedRobotEvent e) {
		my.map.put(e, my.getHeading(), my.getTime(), my.getX(), my.getY());
	}
}