package ph.movement;

import java.awt.geom.*;
import ph.*;
import ph.intelligence.*;
import robocode.util.*;

public class AntiGravityMovementModule extends RobotModule {
    
    private ModularRobot robot;
    private long nextTurn;
    private Point2D robotLocation;
    
    public AntiGravityMovementModule(ModularRobot robot) {
        this.robot=robot;
    }
    
    public void execute() {
        if(robot.getTime()<nextTurn) return;
        robotLocation=new Point2D.Double(robot.getX(),robot.getY());
        nextTurn=robot.getTime()+16;
        double bestAG=Double.POSITIVE_INFINITY;
        double bestAngle=0;
        for(double angle=0; angle<Math.PI*2; angle+=Math.PI/18) {
            double curAG=0;
            Point2D curDestination=new Point2D.Double(Math.max(50,Math.min(robot.battlefieldWidth-50,robotLocation.getX()+48*Math.sin(angle))),
            Math.max(50,Math.min(robot.battlefieldHeight-50,robotLocation.getY()+48*Math.cos(angle))));
            for(int i=0; i<robot.otherRobotsInfo.size(); i++) {
                robotInfo ri=(robotInfo)robot.otherRobotsInfo.elementAt(i);
                Point2D enemyLocation=new Point2D.Double(ri.x(),ri.y());
                double distance=curDestination.distance(enemyLocation);
                curAG += 1/(distance * distance);
            }
            Point2D[] pts={new Point2D.Double(curDestination.getX(), 0),
            new Point2D.Double(curDestination.getX(), robot.battlefieldHeight),
            new Point2D.Double(0, curDestination.getY()),
            new Point2D.Double(robot.battlefieldWidth, curDestination.getY())};
            for(int j=0; j<pts.length; j++) {
                double distance=pts[j].distance(curDestination);
                curAG += 1/(distance*distance);
            }
            if(curAG<bestAG) {
                bestAG=curAG;
                bestAngle=angle;
            }
        }
        goTo(new Point2D.Double(Math.max(50,Math.min(robot.battlefieldWidth-50,robotLocation.getX()+192*Math.sin(bestAngle))),
            Math.max(50,Math.min(robot.battlefieldHeight-50,robotLocation.getY()+192*Math.cos(bestAngle)))));
    }
    
    private void goTo(Point2D destination) {
        double angle = Utils.normalRelativeAngle(absoluteBearing(robotLocation, destination) - robot.getHeadingRadians());
        double turnAngle = Math.atan(Math.tan(angle));
        robot.setTurnRightRadians(turnAngle);
        robot.setAhead(robotLocation.distance(destination) * (angle == turnAngle ? 1 : -1));
    }
    
    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
    
}
