package nat.sGun;

import robocode.*;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.WeakHashMap;

import nat.M;
import nat.Samekh;

public class SamekhGun {
	Samekh r;

	@SuppressWarnings("serial")
	static class Scan extends Point2D.Double {
		public double velocity, latVelocity, advVelocity, accl;
		public double wallDist, wallDistBack;
		public double distance, currentGF;
		public double heading, headingR, headingDelta;
		public double dist10, dist15, dist20;
		public int tsdc, tsdecel;
		public double gunHeat, angle;
		public Scan next, previous;
		public long time;
		public int round;
		public double BFT;
		public Point2D relativePoint;
		public int dir;
		public double adist2,adist4,adist8;
	}

	WeakHashMap<Point2D, Double> distances = new WeakHashMap<Point2D, Double>(
			11, 0.1f);

	static nat.KdTree.SqrEuclid<Scan> fireTree;
	static Scan first, last;
	ArrayList<Point2D> _enemyLocation = new ArrayList<Point2D>();

	List<Point2D> predictedPosition = null;
	Point2D fireLocation = null;
	Point2D myRelativePosition = null;

	static final int USE_POS = 100;
	static final int PREDICT_POS = 150;

	boolean aiming = false;
	boolean aiming2 = false;
	double power;
	double[][] densityArray;
	int fireIndex;
	Point2D fireMyLocation;

	Queue<Scan> buffer = new LinkedList<Scan>();

	static {
		fireTree = new nat.KdTree.SqrEuclid<Scan>(9, null);
	}

	public double[] buildLocation(Scan scan) {
		// DrussGT's
		// double[] result = new double[] { M.abs(scan.latVelocity * 0.125) *
		// 10,
		// M.limit(0, scan.advVelocity * 0.0625, 1) * 2,
		// M.limit(0, scan.distance / 900, 1) * 5, scan.accl * 5,
		// M.limit(0, scan.wallDist / 1.5, 1) * 5,
		// M.limit(0, scan.wallDistBack, 1) * 2,
		// (scan.currentGF + 1d) * 3,
		// M.limit(0, scan.dist10 / (10 * 8), 1) * 3,
		// 1 / (1 + 2 * scan.tsdc / scan.BFT) * 3,
		// 1 / (1 + 2 * scan.tsdecel / scan.BFT) * 3,
		// M.limit(0, scan.gunHeat, 1) * 100 };
		double[] result = new double[] { M.abs(scan.velocity) * 0.125, M.abs(scan.heading - scan.angle) / M.PI,
				M.limit(0,scan.distance,800) / 800, (scan.dir + 1) / 2,
				M.limit(0, scan.wallDist / M.PI, 1),
				M.limit(0, scan.wallDistBack / M.PI, 1),
				M.min(16d,M.max(-3, scan.adist2 + 3)) / 19d,
				M.min(36d,M.max(-10, scan.adist2 + 10)) / 42d,
				M.min(64d,M.max(-36, scan.adist2 + 36)) / 100d };
		return result;
	}

	public SamekhGun(Samekh r) {
		this.r = r;
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		Scan scan = new Scan();
		double angle = e.getBearingRadians() + r.getHeadingRadians();
		scan.velocity = e.getVelocity();
		scan.advVelocity = scan.velocity
				* -M.cos(e.getHeadingRadians() - angle);
		scan.latVelocity = scan.velocity * M.sin(e.getHeadingRadians() - angle);
		scan.wallDist = r.wallDistance(r._enemyLocation.getX(),
				r._enemyLocation.getY(), e.getDistance(), angle, 1);
		scan.wallDistBack = r.wallDistance(r._enemyLocation.getX(),
				r._enemyLocation.getY(), e.getDistance(), angle, -1);
		scan.distance = e.getDistance();
		scan.currentGF = currentGF;
		scan.heading = e.getHeadingRadians();
		scan.gunHeat = r.getGunHeat();
		scan.time = e.getTime();
		scan.round = r.getRoundNum();
		scan.headingDelta = 0;
		scan.angle = angle;
		scan.accl = scan.velocity;
		scan.tsdc = 0;
		scan.tsdecel = 0;
		scan.dir = (int) M.sign(scan.latVelocity);
		scan.setLocation(r._enemyLocation);
		if (last != null) {
			scan.headingDelta = scan.heading - last.heading;
			scan.accl -= last.velocity;
			if (M.abs(scan.velocity) < 0.01) {
				scan.dir = last.dir;
			}
			if (scan.dir == last.dir) {
				scan.tsdc = last.tsdc + 1;
			}
			if (scan.accl < 0) {
				scan.tsdecel = 0;
			} else
				scan.tsdecel = last.tsdecel + 1;
		}
		if (_enemyLocation.size() > 0) {
			Point2D last = _enemyLocation.get(_enemyLocation.size() - 1);
			if (_enemyLocation.size() >= 10)
				scan.dist10 = _enemyLocation.get(9).distance(r._enemyLocation);
			else
				scan.dist10 = last.distance(r._enemyLocation);
			if (_enemyLocation.size() >= 15)
				scan.dist15 = _enemyLocation.get(14).distance(r._enemyLocation);
			else
				scan.dist15 = last.distance(r._enemyLocation);
			if (_enemyLocation.size() >= 20)
				scan.dist20 = _enemyLocation.get(19).distance(r._enemyLocation);
			else
				scan.dist20 = last.distance(r._enemyLocation);
		}

		scan.relativePoint = getVector(scan.headingDelta, scan.velocity);
		scan.headingR = scan.dir == 1 ? scan.heading : M.normalAbsoluteAngle(scan.heading + M.PI);
		
		// calc adist
		if (_enemyLocation.size() > 0) {
			Scan cur = last;
			try {
				cur = cur.previous.previous;
				double angled = M.getAngle(cur, last) - cur.headingR;
				scan.adist2 = cur.distance(r._enemyLocation) * M.cos(angled);
				cur = cur.previous.previous;
				angled = M.getAngle(cur, last) - cur.headingR;
				scan.adist4 = cur.distance(r._enemyLocation) * M.cos(angled);
				cur = cur.previous.previous;
				cur = cur.previous.previous;
				angled = M.getAngle(cur, last) - cur.headingR;
				scan.adist8 = cur.distance(r._enemyLocation) * M.cos(angled);
			} catch (NullPointerException ignored) {}
		}
		

		_enemyLocation.add(0, r._enemyLocation);
		if (first == null)
			first = scan;
		if (last == null)
			last = scan;
		else {
			last.next = scan;
			scan.previous = last;
			last = scan;
		}

		double bulletPower = Math.min(r.getEnergy() / 4, Math.min(
				e.getEnergy() / 4, 2d));
		if (Samekh._TC)
			bulletPower = 3d;

		buffer.offer(scan);
		while (buffer.size() > 20) {
			Scan s = buffer.poll();
			fireTree.addPoint(buildLocation(s), s);
		}

		scan.BFT = scan.distance / Rules.getBulletSpeed(bulletPower);

		if (r.getGunHeat() < r.getGunCoolingRate() && !aiming2
				&& fireTree.size() > 50) {
			fireMyLocation = M.project(r._myLocation, r.getHeading(), r
					.getVelocity());
			if (aiming)
				aiming2 = true;
			aiming = true;
			power = bulletPower;
			predictPosition(Rules.getBulletSpeed(power));
			double fangle = getBestAngle();
			r.setTurnGunRightRadians(M.normalRelativeAngle(fangle
					- r.getGunHeadingRadians()));
		}

		if (aiming && M.isNear(0, r.getGunTurnRemaining())
				&& r.getEnergy() > power) {
			r.setFire(power);
			aiming = aiming2 = false;
			densityArray = null;
		}

		if (!aiming) {
			r.setTurnGunRightRadians(M.normalRelativeAngle(angle
					- r.getGunHeadingRadians()));
		}

		Wave w = new Wave();
		w.angle = angle;
		w.bulletV = Rules.getBulletSpeed(power);
		w.fireLocation = r._myLocation;
		r.addCustomEvent(w);
	}

	public Point2D rotate(Point2D pt, double angle) {
		double angle2 = M.normalAbsoluteAngle(Math.atan2(pt.getX(), pt.getY())
				+ angle);
		return getVector(angle2, pt.distance(0, 0));
	}

	public Point2D getVector(double angle, double dist) {
		return new Point2D.Double(Math.sin(angle) * dist, Math.cos(angle)
				* dist);
	}

	public double getBestAngle() {
		Point2D[] xy = predictedPosition.toArray(new Point2D[0]);
		Point2D best = null;

		if (xy.length == 0)
			return M.getAngle(r._myLocation, r._enemyLocation);

		densityArray = new double[4][xy.length];

		for (int i = 0; i < xy.length; i++) {
			double angle = M.getAngle(r._myLocation, xy[i]);
			densityArray[0][i] = angle;
			densityArray[1][i] = 20d / r._myLocation.distance(xy[i]);
			densityArray[2][i] = 1;// distances.get(xy[i]);
			densityArray[3][i] = 1;// distances.get(xy[i]);
			for (int j = 0; j < i; j++) {

				// Normal
				if (M.abs(densityArray[0][j] - angle) < densityArray[1][j]) {
					densityArray[2][j] += densityArray[3][i];// 1;
				}
				if (M.abs(densityArray[0][j] - angle) < densityArray[1][i]) {
					densityArray[2][i] += densityArray[3][j];// 1;
				}

				// KDE
//				 double u = (angle - densityArray[0][j]) / densityArray[1][i];
//				 double u2 = (densityArray[0][j] - angle) /
//				 densityArray[1][j];
//				 double ud = (Math.abs(u)<=1 ? 1 : 0);
//				 double u2d = (Math.abs(u2)<=1 ? 1 : 0);
				// Uniform
				// densityArray[2][i] += 0.5 * ud;
				// densityArray[2][j] += 0.5 * u2d;
				// Epanechnikov
				// densityArray[2][i] += 0.75 * (1 - u*u) * ud;
				// densityArray[2][j] += 0.75 * (1 - u2*u2) * u2d;
				// Triangle
				// densityArray[2][i] += (1- Math.abs(u)) * ud;
				// densityArray[2][j] += (1- Math.abs(u2)) * u2d;
				// Quartic
				// densityArray[2][i] += 0.9375 * (1 - u*u) * (1 - u*u) * ud;
				// densityArray[2][j] += 0.9375 * (1 - u*u) * (1 - u*u) * u2d;
				// Gaussian
//				 densityArray[2][i] += 0.3989422d * Math.exp(-0.5 * u * u);
//				 densityArray[2][j] += 0.3989422d * Math.exp(-0.5 * u2 * u2);
				// Cosinus
				// densityArray[2][i] += 0.7853981d * Math.cos(1.570796*u) * ud;
				// densityArray[2][j] += 0.7853981d * Math.cos(1.570796*u) *
				// u2d;
			}
		}

		double max = 0;
		int best2 = -1;
		for (int i = 0; i < xy.length; i++) {
			if (max < densityArray[2][i]) {
				max = densityArray[2][i];
				best = xy[i];
				best2 = i;
			}
		}
		if (best == null)
			return M.getAngle(r._myLocation, r._enemyLocation);
		fireLocation = best;
		fireIndex = best2;
		return M.getAngle(r._myLocation, best);
	}

	public static double densityAtPoint(double[] x, int n, double h, double p) {
		// x is the array of sample data points (ordered by t, 0 is prev. n-1 is
		// actual
		// n is the number of existing points in the array
		// h is the bandwidth
		// p is the point at which to calculate the estimate

		double k = 0;
		for (int i = n - 1; i >= 0; i--) {
			double u = (x[i] - p) / h;

			// Epanechnikov
			// k += (3.0/4.0) * (1 - u*u) * (Math.abs(u)<=1 ? 1 : 0);
			// Uniform
			k += (1.0 / 2.0) * (Math.abs(u) <= 1 ? 1 : 0);
			// Triangle
			// k += (1- Math.abs(u)) * (Math.abs(u)<=1 ? 1 : 0);
			// Quartic
			// k += (15.0/16.0) * (1 - u*u) * (1 - u*u) * (Math.abs(u)<=1 ? 1 :
			// 0);
			// Gaussian
			// k += (1 / Math.sqrt(2 * Math.PI)) * Math.exp(-0.5 * u * u);
			// Cosinus
			// k += (Math.PI/4.0) * Math.cos(Math.PI/2 * u) *
			// (Math.abs(u)<=1 ? 1 : 0);
		}
		return k;
	}

	public void predictPosition(double bulletV) {
		double[] location = buildLocation(last);
		List<nat.KdTree.Entry<Scan>> situations = fireTree.nearestNeighbor(
				location, PREDICT_POS, true);
		List<Point2D> positions = new ArrayList<Point2D>(USE_POS);
		int i = 0;
		for (i = situations.size() - 1; i >= 0 && positions.size() < USE_POS; i--) {
			nat.KdTree.Entry<Scan> scan = situations.get(i);
			Point2D predicted = predictSituationFastABC(scan.value, bulletV);
			if (predicted != null) {
				distances.put(predicted, scan.distance);
				positions.add(predicted);
			}
		}
		predictedPosition = positions;
	}

	public Point2D predictSituationABC(Scan scan, double bulletV) {
		int round = scan.round;
		double dist = last.distance(fireMyLocation);
		double ang = M.getAngle(last, fireMyLocation);
		double angDiff = scan.heading - last.heading;
		Point2D proj = M.project(scan, ang + angDiff, dist);
		double bDist = 0;
		do {
			scan = scan.next;
			if (scan == null || scan.round != round)
				return null;
			bDist += bulletV;
			dist = scan.distanceSq(proj);
		} while (M.sqr(bDist) < dist);
		ang = M.getAngle(proj, scan);
		dist = Math.sqrt(dist);
		Point2D result = M.project(fireMyLocation, ang - angDiff, dist);
		if (!Samekh._fieldRect.contains(result)) {
			return null;
		}
		return result;
	}

	public Point2D predictSituationFastABC(Scan start, double bulletVelocity) {
		Scan current = last;
		int currentRound = start.round;
		double distance = current.distance(fireMyLocation);
		double angle = M.getAngle(current, fireMyLocation);
		double deltaHeading = start.heading - current.heading;
		Point2D projectedMyLocation = M.project(start, angle + deltaHeading,
				distance);
		double bulletDistance = 0;
		int estimatedBFT = (int) M.ceil(distance / bulletVelocity);
		for (int i = 0; i < estimatedBFT; i++) {
			start = start.next;
			if (start == null || start.round != currentRound)
				return null;
			bulletDistance += bulletVelocity;
		}
		distance = start.distance(projectedMyLocation);
		int newBFT = (int) M.ceil(distance / bulletVelocity);
		distance *= distance;
		if (newBFT < estimatedBFT) {
			do {
				start = start.previous;
				bulletDistance -= bulletVelocity;
				distance = start.distanceSq(projectedMyLocation);
			} while (M.sqr(bulletDistance) > distance);
			start = start.next;
			bulletDistance += bulletVelocity;
			distance = start.distanceSq(projectedMyLocation);
		} else if (newBFT > estimatedBFT) {
			do {
				start = start.next;
				if (start == null || start.round != currentRound)
					return null;
				bulletDistance += bulletVelocity;
				distance = start.distanceSq(projectedMyLocation);
			} while (M.sqr(bulletDistance) < distance);
		}
		angle = M.getAngle(projectedMyLocation, start);
		distance = M.sqrt(distance);
		Point2D resultLocation = M.project(fireMyLocation, angle - deltaHeading,
				distance);
		if (!Samekh._fieldRect.contains(resultLocation)) {
			return null;
		}
		return resultLocation;
	}

	public Point2D predictSituationRelativePoint(Scan scan, double bulletV) {
		double bulletD = 0;
		int round = scan.round;
		double x = 0, y = 0;
		while (M.sqr(bulletD) < Point2D.distanceSq(x, y, last.distance, 0)) {
			bulletD += bulletV;
			x += scan.relativePoint.getX();
			y += scan.relativePoint.getY();
			scan = scan.next;
			if (scan == null || scan.round != round)
				return null;
		}
		Point2D newEnemyLocation = new Point2D.Double(x, y);
		newEnemyLocation = rotate(newEnemyLocation, last.heading);
		newEnemyLocation = new Point2D.Double(newEnemyLocation.getX()
				+ r._enemyLocation.getX(), newEnemyLocation.getY()
				+ r._enemyLocation.getY());
		if (!Samekh._fieldRect.contains(newEnemyLocation)) {
			return null;
		}
		return newEnemyLocation;
	}

	public Point2D predictSituationStepByStep(Scan scan, double bulletV) {
		double bulletD = -bulletV;
		int round = scan.round;
		double heading = last.heading;
		double x = r._enemyLocation.getX();
		double y = r._enemyLocation.getY();
		while (M.sqr(bulletD) < fireMyLocation.distanceSq(x, y)) {
			bulletD += bulletV;
			x += M.sin(heading += scan.headingDelta) * scan.velocity;
			y += M.cos(heading) * scan.velocity;
			scan = scan.next;
			if (scan == null || scan.round != round)
				return null;
		}
		Point2D newEnemyLocation = new Point2D.Double(x, y);
		if (!Samekh._fieldRect.contains(newEnemyLocation)) {
			return null;
		}
		return newEnemyLocation;
	}

	public Point2D predictSituationIterative(Scan scan, double bulletV) {
		double x = r._enemyLocation.getX();
		double y = r._enemyLocation.getY();
		int round = scan.round;
		Scan start = scan;
		int bft = (int) M.ceil((r._myLocation.distance(x, y) - 18) / bulletV);
		for (int i = 0; i < 50; i++) {
			scan = start;
			while (bft > 0 && scan.next != null) {
				scan = scan.next;
			}
			if (scan == null || scan.round != round)
				return null;
			double angle = M.normalAbsoluteAngle(M.getAngle(start, scan)
					- start.heading + last.heading);
			double distance = start.distance(scan);
			x = last.x + M.sin(angle) * distance;
			y = last.y + M.cos(angle) * distance;
			int bft2 = (int) M.ceil((r._myLocation.distance(x, y) - 18)
					/ bulletV);
			if (bft2 == bft) {
				break;
			}
			bft = bft2;
		}
		Point2D newEnemyLocation = new Point2D.Double(x, y);
		if (!Samekh._fieldRect.contains(newEnemyLocation)) {
			return null;
		}
		return newEnemyLocation;
	}

	public double currentGF;

	public void onPaint(Graphics2D g) {
		if (predictedPosition != null) {
			g.setColor(Color.red.darker().darker().darker());
			for (Point2D pt : predictedPosition) {
				g.draw(new Rectangle2D.Double(pt.getX() - 18, pt.getY() - 18,
						36, 36));
			}
			g.setColor(Color.yellow);
			if (fireLocation != null)
				g.draw(new Rectangle2D.Double(fireLocation.getX() - 18,
						fireLocation.getY() - 18, 36, 36));
		}
		if (densityArray != null) {
			double arrowDistance = last.distance / 2;
			g.setColor(Color.red);
			for (int i = 0; i < densityArray[0].length; i++) {
				drawArrow(g, fireMyLocation, densityArray[0][i], arrowDistance);
			}
			g.setColor(Color.yellow);
			drawArrow(g, fireMyLocation, densityArray[0][fireIndex],
					arrowDistance + 36d);
			Point2D p1 = M.project(fireMyLocation, densityArray[0][fireIndex]
					+ densityArray[1][fireIndex], arrowDistance + 10d);
			Point2D p2 = M.project(fireMyLocation, densityArray[0][fireIndex]
					- densityArray[1][fireIndex], arrowDistance + 10d);
			g.draw(new Line2D.Double(p1, p2));
		}
	}

	public void drawArrow(Graphics2D g, Point2D start, double angle,
			double distance) {
		Point2D p2 = M.project(start, angle, distance);
		Point2D a1 = M.project(p2, angle - M.PI - M.QUARTER_PI / 2, 12d);
		Point2D a2 = M.project(p2, angle - M.PI + M.QUARTER_PI / 2, 12d);
		g.draw(new Line2D.Double(start, p2));
		g.draw(new Line2D.Double(a1, p2));
		g.draw(new Line2D.Double(a2, p2));
	}

	class Wave extends Condition {
		double bulletV, distance, angle;
		Point2D fireLocation;

		@Override
		public boolean test() {
			if (r._enemyLocation.distanceSq(fireLocation) > M.sqr(distance)) {
				r.removeCustomEvent(this);
				currentGF = (M.getAngle(fireLocation, r._enemyLocation) - angle)
						/ M.asin(8 / bulletV);
			}
			return false;
		}

	}
}
