package djc;
import robocode.*;

/**
 * ButterflyGun - Based on Butterfly2 by Mike Dorgan
 */
public class ButterflyGun extends Gun
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */
    static int    e_dodgeTimer = 0;
    static double e_velocity   = 0;

    public ButterflyGun(StrategyBot _s, GunManager _gm) 
    {
	super(_s, _gm);
	name = GunManager.BUTTERFLY;
    }
    
    /** Resets the Gun */
    public void reset() {}

    /** Scanned a robot */
    public void onScannedRobot(ScannedRobotEvent e)
    {
	//----------- From Butterfly2 -------------------------
	double	abs_bearing = e.getBearingRadians() + self.getHeadingRadians();

	if(e_dodgeTimer-- == 0) {
	    e_velocity = e.getVelocity();
	}
		
	// Fire if we're aimed correctly and heat == 0.
	if(self.getGunTurnRemaining() == 0 && self.getGunHeat() == 0) {
	    // Fire!!!
	    self.fire(MathHelper.getPowerToKill(e.getEnergy()), GunManager.BUTTERFLY);

	    // DJC - Slight addition here...
	    Target t;
	    if(self.targetList.containsKey(e.getName())) {  // Existing target
		t = (Target)self.targetList.get(e.getName());
		// self.out.println("Old target: " + e.getName());
	    } else {
		t = new Target(e.getName(), self);
		self.targetList.put(e.getName(), t);
		// self.out.println("New target: " + e.getName());
	    }
	
	    // Just in case this is a stale reference to a previous "self"
	    t.self = self;
	    t.firedAtTarget(MathHelper.MAX_SHOT_ENERGY, e.getDistance(), self.getTime(), self.myPos);
	    self.currentTarget = t;

	    // Sample the target velocity 8 turns later to see if he has dodged. (aka Wolverine and other stop/go bots)
	    // This number may need some tweaking.
	    e_dodgeTimer = 8;
	}

	// The lead routine evolved a bit.  I'm now doing an average of 2 enemy velocities then
	// taking a random value from that.  This allows hitting stop/go bots and back and forth
	// bots more efficiectly than before.
	self.setTurnGunRightRadians(Math.asin(Math.sin(abs_bearing - 
						       self.getGunHeadingRadians() + 
						       Math.asin(((e.getVelocity() + 
								   2 * e_velocity) * Math.random() / (3 * 11)) * 
								 Math.sin(e.getHeadingRadians() - abs_bearing)))));
	//----------- From Butterfly2 -------------------------
    }
    
    /** Turn gun and fire at the enemy */
    public void setGunRotation() { }

    /**
     * Computes the FirePower to use when shooting a target.
     *
     * @author Dan Cieslak
     */
    public double computeFirePower(double targetDist, Target t)
    {
	if(self.getOthers() == 1) {
	    return MathHelper.MAX_SHOT_ENERGY;
	} else { // melee - conserve energy
	    if(targetDist < 300) return 3.0;
	    else if (targetDist < 500) return 2.0;
	    else if (targetDist < 800) return 1.5;
	    else return 1.2;
	}
    }


}
