package djc;

/**
 * A snapshot of a bot at a location and time
 */
public class Position extends Coordinate
{
    public double atTime = -1.0;
    public double velocity = 0.0;
    public double angvelocity = 0.0;
    public double avgVelocity = 0.0;
    public double avgAngVelocity = 0.0;
    public double heading = 0.0;
    public double distanceAway = 0.0;
    public double absBearing = 0.0;
    public int isHit = 0;  // Unknown=0, Hit=1, Miss=2

    public Position(double pX, double pY, double t,
		    double v, double av, double hdng,
		    double avgVel, double avgAngVel,
		    double d, double b)
    {
	super(pX,pY);
	atTime = t;
	velocity = v;
	angvelocity = av;
	heading = hdng;
	avgVelocity = avgVel;
	avgAngVelocity = avgAngVel;
	distanceAway = d;
	absBearing = b;
    }

    public Position() {}

    public void set(double posX, double posY, double hdng)
    {
	set(posX, posY);
	heading = hdng;
    }

    public void set(Coordinate c, double v, double hdng)
    {
	set(c.x, c.y);
	velocity = v;
	heading = hdng;
    }
}
