/*
 * GuessFactory.java
 *
 * Created on 17 maart 2004, 15:58
 */
package vic;
/**
 *
 * @author  Vic Stewart
 */
public class GuessFactory extends SegmentationManager
{
    int    numBins;
    int[] GuessFactors;
    float bestBinValue;
    
    float getBinValue(int Index)
    {
        return ((float)GuessFactors[Index] / bestBinValue);
    }
    
    void setBins(int pNumBins)
    {
        numBins = pNumBins;
        GuessFactors = new int[numBins];
    }
    
    double PerformStatistics(byte ETA, double Power, double enemyX, double enemyY, double currentHeading, double meX, double meY, Situation situation)
    {
            //first calculate the max escape angle
        double maxEscapeAngle = maxEscapeAngle(Power);
        //System.out.println("maxEscapeAngle="+Math.toDegrees(maxEscapeAngle));
            
            //calculate the absolute angle for guess factor 0
        double gf0 = getAbsoluteAngle(meX, meY, enemyX, enemyY);
        //System.out.println("gf0="+Math.toDegrees(gf0));

            //get the plus/minus angle defined by the distance and body width;
        double bodyAngleOffset = getBodyAngleOffset(getDistance(meX, meY, enemyX, enemyY));
        //double bodyAngleOffset = 0;
        //System.out.println("bodyAngleOffset="+Math.toDegrees(bodyAngleOffset));
        
            //clear the guess factor bins:
        for(int i=0; i<numBins; i++)
        {
            GuessFactors[i] = 0;
        }
            
            //fill the guess factor bins    
        double observationAngle, angle, gf;
        int minBin, maxBin, bestBin;
        
        for (int i=startIndex; i <= endIndex; i++)
        {
                //calculate absolute angle of the observation
            observationAngle = ((Observation)log.get(i)).getProjectedFiringAngle(ETA, enemyX, enemyY, currentHeading, meX, meY);
            //System.out.println("observation angle="+Math.toDegrees(observationAngle));
            
            if(observationAngle != 666)
            {
	                    //get the minBin:
	
	                //check if angle is within 180 degrees from gf0, if not, correct accordingly
	            angle = correctedAngle(gf0, observationAngle + bodyAngleOffset);
	            //System.out.println("minBin corrected angle="+Math.toDegrees(angle));
	                //calculate the relative angle to gf0
	            angle = getRelativeAngle(gf0, angle);
	            //System.out.println("minBin relative angle="+Math.toDegrees(angle));
	                //calculate the corresponding guessfactor
	            gf = calcGuessFactor(angle, maxEscapeAngle);
	            //System.out.println("minBin guessfactor="+gf);
	                //calculate the corresponding guess factor bin
	            minBin =  getBin(gf);
	            //System.out.println("minBin="+minBin);
	            
	                    //get the maxBin:
	            
	                //check if angle is within 180 degrees from gf0, if not, correct accordingly
	            angle = correctedAngle(gf0, observationAngle - bodyAngleOffset);
	            //System.out.println("maxBin corrected angle="+Math.toDegrees(angle));
	                //calculate the relative angle to gf0
	            angle = getRelativeAngle(gf0, angle);
	            //System.out.println("maxBin relative angle="+Math.toDegrees(angle));
	                //calculate the corresponding guessfactor
	            gf = calcGuessFactor(angle, maxEscapeAngle);
	            //System.out.println("maxBin guessfactor="+gf);
	                //calculate the corresponding guess factor bin
	            maxBin =  getBin(gf);
	            //System.out.println("maxBin="+maxBin);
	
	            //System.out.println("single bin angle="+Math.toDegrees(((maxEscapeAngle*2.0)/numBins)));
	
	                //now update the 'touched' bins
	            if(minBin<=maxBin) updateBin(i, minBin, maxBin, bodyAngleOffset, maxEscapeAngle, situation);
	            else updateBin(i, maxBin, minBin, bodyAngleOffset, maxEscapeAngle, situation);
	        }
	  }       
            //retrieve the most filled bin
        bestBin = getBestBin();
        //System.out.println("result bin="+bestBin);
        
            //calculate the corresponding guessfactor
        gf = getGuessFactor(bestBin);
        //System.out.println("result guessfactor="+gf);

            //calculate the corresponding relative angle
        angle = getRelativeAngleFromGuessFactor(gf, maxEscapeAngle);
        //System.out.println("result relative angle="+Math.toDegrees(angle));
        
            //calculate the absolute angle
        //System.out.println("result absolute angle="+Math.toDegrees(getAbsoluteAngle(gf0, angle)));
        //System.out.println();
        return getAbsoluteAngle(gf0, angle);
    }

    double calcGuessFactor(double angle, double maxEscapeAngle)
    {
        return angle / maxEscapeAngle;
    }
    
    int getBin(double gf)
    {
        return (int)Math.round((gf + 1.0D) * ((((double)numBins) - 1.0D) / 2.0D));
    }
   
    double getRelativeAngleFromGuessFactor(double gf, double maxEscapeAngle)
    {
        return (gf * maxEscapeAngle);
    }
    
    double getGuessFactor(int bin)
    {
        return (((double)bin) / ((((double)numBins) - 1.0D) / 2.0D)) - 1.0D;
    }
    
    double getAbsoluteAngle(double refAngle, double relAngle)
    {
        double result = refAngle + relAngle;
        if     (result >  Math.PI) result -= Math.PI * 2.0;
        else if(result < -Math.PI) result += Math.PI * 2.0;
        return result;
    }

    double getRelativeAngle(double refAngle, double absAngle)
    {
        return absAngle - refAngle;
    }

    double correctedAngle(double refAngle, double testAngle)
    {
        if(Math.abs(testAngle - refAngle) > Math.PI)
        {
            if(testAngle > refAngle) testAngle -= Math.PI * 2.0;
            else                     testAngle += Math.PI * 2.0;
        }
        return testAngle;
    }    

    int getBestBin()
    {
        int bestIndex = -1, startStreak = -1, lastStreak = -1;
        double best      =  -1;

        for(int i=0; i<numBins; i++)
        {
            if(GuessFactors[i] > best)
            {
                bestIndex = i;
                startStreak = i;
                lastStreak = i;
                best = GuessFactors[i];
            }
            else if(GuessFactors[i] == best)
            {
                if(lastStreak == (i-1))
                {
                    bestIndex = (int)Math.round(((double)(startStreak + i))/2.0D);
                    lastStreak = i;
                }
                else
                {
                    bestIndex = i;
                    startStreak = i;
                    lastStreak = i;
                    best = GuessFactors[i];
                }
            }
        }
        bestBinValue = (float)GuessFactors[bestIndex];
        return bestIndex;
    }

    void updateBin(int index, int min, int max, double offset, double maxEscapeAngle, Situation situation)
    {
        //System.out.println("min=" + min + " max=" + max + " #=" + (max-min+1));
        if(min<0) min=0;
        if(min>(numBins-1)) return;             //if the smallest is already out of range then quit now
        if(max<0) return;                       //if the biggest is already negatively out of range then quit now
        if(max>(numBins-1)) max=numBins-1;
        if(Math.abs(getRelativeAngleFromGuessFactor(getGuessFactor(min), maxEscapeAngle)) > offset)
        {
            //System.out.println("min out of range!");
            min++;
        }
        if(Math.abs(getRelativeAngleFromGuessFactor(getGuessFactor(max), maxEscapeAngle)) > offset)
        {
            //System.out.println("max out of range!");
            max--;
        }
        
        double weight, layers, x;
        if(Dmax==Dmin)
        {
            weight = 1;
        }
        else
        {	
            layers = 3;
            x = Math.sqrt(((Observation)log.get(index)).distance(situation));
            if(x>Dmax)x=Dmax;
            if(x<Dmin)x=Dmin;
            weight = 1.0 + (((Dmax - x) / (Dmax - Dmin)) * (layers - 1));
        }

        for(int i=min; i<=max; i++)
        {
            GuessFactors[i] += Math.round(weight);
            //System.out.println("Bin "+i+" touched");
        }
        //System.out.println();
    }

    double getBodyAngleOffset(double distance)
    {
        return Math.asin(getRobotWidth() / (2.0D * distance));
    }

    double maxEscapeAngle(double power)
    {
        return 1.15D * (8.0D / (20.0D - 3.0D * power));
    }
}

