package gh.micro;
import java.awt.geom.*;
//import java.awt.Color;

import robocode.*;
import robocode.util.Utils;
import robocode.Rules;

/**
 * Grinnik - a robot by Gert Heijenk
 *
 * Micro-bot with GuessFactorTargeting and StopNGo/Random movement
 *
 * Credits to PEZ for the 'MicroWave extends Condition' way of working as in Aristocles
 *
 * Revision information:
 * v0.1  20070303 take GresVretter 0.2.5, strip everything till unsegmented gun and fit it in a micro.
 *                StopNGo and double oscillator movement (from Gruweltje)
 * v0.2  20070309 small bugfix onBulletHit
 *                much less dive-in protection -> less stuck in corners
 * v0.3  20070320 a lot of shrinking and now with colors
 *                even less dive-in protection
 *                fire full-power bullets at close range (anti-ram)
 * v0.4  20070328 bugfix occasional 'freeze' (stuck outside fireField with very small distanceremaining)
 *                change StopAndGo movement to 'move a bit on every bullet' (codesize reasons)
 *                segment gun on Acceleration � la GresSuffurd
 * v0.5  20070725 fire a wave on every tick
 *                make movementlength a bit dependent on enemydistance
 * v0.6  20070730 back to previous movementlength (new one good for GrauwuarG, not for Grinnik)
 *                only switch to randommovement in the first 5 rounds
 * v0.7  20071125 added segmentation on velocity and distance
 *                simplified acceleration segment (only time-since, no more acc and decell)
 * v0.8  20190523 basic anti-bulletcatching
 * v1.0  20190723 remove anti-bulletcatching (not useful for micros)
 *                add acc/decel bins in vchange attribute
 *                let radar be independent of gunmovement (use setAdjustRadarForGunTurn)
 */
public class Grinnik extends AdvancedRobot
{

	static final int	BINS			= 37;	// distance 550, bulletpower 1.9, halfbotwidth
	static final int	MIDBIN			= BINS / 2;
	static final double	BINFACTOR		= 0.07;	// roughly angle per bin
	static final double DEFDISTANCE		= 475;	

//	static int[] unsegBuf = new int[BINS];
	static int[][][][] unsegBuf = new int[7][5][5][BINS];	// on acceleration

	static boolean randomMove;			// starts with false, meaning StopNGo
	static Point2D.Double enemyPos;
	static double enemyLastEnergy;		// for enemy-fire detection
	static int enemyLastVelocity;		// for gunsegmentation
	static int timeSinceVChange;		// for gunsegmentation
	static double dist = 48;			// default distance to move with StopAndGo

	/**
	 * run: Grinnik's default behavior
	 */
	public void run() {

		// Give the robot an appealing look
//		setColors( Color.red, Color.green, Color.red);	// 13 bytes !!

		// Let gun and radar move independently
		setAdjustGunForRobotTurn( true);
		setAdjustRadarForGunTurn( true);		// 5 bytes 

		// Start the mainloop
//		while(true) {
//			turnRadarRight( Double.POSITIVE_INFINITY);
//		}
	}

	/**
	 * onStatus: Just to save 3 bytes for radarhandling
	 */
    public void onStatus( StatusEvent e) {
        setTurnRadarRightRadians(1);
    }
	/**
	 * onScannedRobot: Event from scanning another robot
	 */
    public void onScannedRobot( ScannedRobotEvent e) {

		MicroWave gunWave = new MicroWave();
		double enemyAbsBearing = gunWave.HOTAngle = getHeadingRadians() + e.getBearingRadians();
		Point2D.Double myPos = gunWave.fireLocation = new Point2D.Double( getX(), getY());
		Rectangle2D.Double fireField = new Rectangle2D.Double( 18, 18, 764, 564);
		
		// some common stuff
		enemyPos = doProjectPos( myPos, enemyAbsBearing, e.getDistance());

		// radar
		setTurnRadarRightRadians( 2.2 * Utils.normalRelativeAngle( enemyAbsBearing - getRadarHeadingRadians()));

		// movement stuff
		if (randomMove == false) {
			if ( enemyLastEnergy - (enemyLastEnergy = e.getEnergy()) > 0.0) {
//				out.println(currTime+" Enemy bullet fired !!");
//				setMaxVelocity( (getVelocity() == 0.0 ? 8.0 : 0.0));	// 20 bytes extra !!
				setAhead( dist);
			}
		}
		else {
			if ( (dist = getDistanceRemaining()) == 0.0) {
				setAhead( dist = (( Math.sin( getTime()/11) * Math.cos( getTime()/29))*(260) + (Math.random()*100 - 50)));
			}
		}

//		double myDirection = (dist < 0 ? -1 : 1);
		double myDirection = (dist / Math.abs(dist));	// 4 bytes smaller
		double adjustAngle = ((e.getDistance() / DEFDISTANCE) - 1.0) * Math.PI/2 * (myDirection);	// distancing
		double prefAngle = adjustAngle = enemyAbsBearing + Math.PI/2 - adjustAngle;
		while( !fireField.contains( doProjectPos( myPos, adjustAngle -= (0.05*myDirection) , dist)));

		// Because it is relative to prefAngle, it is automatically distance dependent
		if (Math.abs( (adjustAngle - prefAngle)) > Math.PI/2.2) {
			setAhead( dist = -dist);
		}

		setTurnRightRadians( Utils.normalRelativeAngle( adjustAngle - getHeadingRadians()));

		// gunstuff
		gunWave.binFactor = ((e.getVelocity() * Math.sin( e.getHeadingRadians() - enemyAbsBearing)) < 0 ? -BINFACTOR : BINFACTOR);

		// accelerationsegment
//		int enemyAccBin = 2 + Math.min(3, (timeSinceVChange++ / 10));
//		if (Math.abs( prefAngle = enemyLastVelocity - (enemyLastVelocity = Math.abs(e.getVelocity()))) > 0.0) {
//			enemyAccBin = timeSinceVChange = ( prefAngle > 0 ? 0 : 1);
//		}
		int accBin = enemyLastVelocity - (enemyLastVelocity = (int)Math.abs(e.getVelocity()));
		if (accBin != 0) {
			accBin = timeSinceVChange = ( accBin > 0 ? 0 : 1);
		}
		else {
			accBin = 2 + Math.min(4, (timeSinceVChange++ / 8));
		}
//		if (enemyLastVelocity - (enemyLastVelocity = (int)Math.abs(e.getVelocity())) != 0.0) {
//			timeSinceVChange = 0;
//		}
		gunWave.gfBuf = unsegBuf[accBin][enemyLastVelocity/2][(int)(e.getDistance()/190)]; 

		// search best bin to aim
		int bindex = MIDBIN;
		int index = BINS - 1;
		do {
			if(gunWave.gfBuf[index] > gunWave.gfBuf[bindex]) {
				bindex = index;
			}
		} while (index-- > 0);
	
		// Fire in the hose!
//		prefAngle = (Math.random() < 0.5 ? 0.6 : -0.6) / e.getDistance();		// imperfection to lure bulletcatchers
//		prefAngle = 0.6 / e.getDistance();		// imperfection to lure bulletcatchers
		setTurnGunRightRadians( Utils.normalRelativeAngle( enemyAbsBearing - getGunHeadingRadians() + ((bindex - MIDBIN) * gunWave.binFactor)));
		if (getEnergy() > 1.9) {
//			setFire( 1.9);
			setFire( e.getDistance() < 100 ? 3.0 : 1.9);	// 17 bytes extra
			addCustomEvent( gunWave);
//			out.println("Fire !"+enemyAccBin);
//			out.println(currTime+" "+gunWave.fireLocation+" "+gunWave.HOTAngle);
		}
	}

	/**
	 * onDeath: I died, so try something else
	 */
	public void onDeath( DeathEvent e) {
		if (getRoundNum() < 5) randomMove = true;
	}

	/**
	 * onBulletHit: I hit the other
	 */
    public void onBulletHit( BulletHitEvent e) {
		enemyLastEnergy -= 9.4;	// damage by 1.9 bullet
    }

	/**
	 * onHitByBullet:  I am hit
	 */
	public void onHitByBullet(HitByBulletEvent e)
	{
		enemyLastEnergy += Rules.getBulletHitBonus(e.getPower()); // = -1 bytes
	}

	/**
	 * doProjectPos: Calculate position out of heading and distance
	 */
	static Point2D.Double doProjectPos( Point2D.Double startpos, double head, double dist){	
		return new Point2D.Double( startpos.x + (dist * Math.sin( head)), startpos.y + (dist * Math.cos( head)));			
	}

	/**
	 * MicroWave: a condition based Wave
	 * Credits to PEZ as this is based upon the MicroWave of Aristocles
	 */
	public class MicroWave extends Condition {

		double HOTAngle;
		double waveFront;
		double binFactor;	
		Point2D.Double fireLocation;
		int[]  gfBuf;

		public boolean test() {
			if ( enemyPos.distance( fireLocation) <= (waveFront += 14.3)) {
//				double angleDiff = Utils.normalRelativeAngle( Math.atan2( enemyPos.x - fireLocation.x, 
//																		  enemyPos.y - fireLocation.y) - HOTAngle);
//				gfBuf[ MIDBIN + (int)(angleDiff / binFactor)]++;
//				out.println("Virtual hit:"+ (MIDBIN + (int)(angleDiff / binFactor)));
				gfBuf[ MIDBIN + (int)(Utils.normalRelativeAngle( 
						Math.atan2( enemyPos.x - fireLocation.x, enemyPos.y - fireLocation.y)
						- HOTAngle)	/ binFactor)]++;
				removeCustomEvent(this);
			}
			return false;
		}
	}
}

