/*
 * Decompiled with CFR 0.152.
 */
package ara;

import java.awt.geom.Point2D;

public class Util {
    public static double normalDegA(double d) {
        if (d < 0.0) {
            return 360.0 + d % 360.0;
        }
        return d % 360.0;
    }

    public static double normalDegB(double d) {
        double dd = Util.normalDegA(d);
        if (dd >= 180.0) {
            dd -= 360.0;
        }
        return dd;
    }

    public static double Deg(double x1, double y1, double x2, double y2) {
        double xd = x2 - x1;
        double yd = y2 - y1;
        return Util.normalDegA(Math.toDegrees(Math.atan2(yd, xd)));
    }

    public static double Dist(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static double sinDeg(double deg) {
        return Math.sin(Math.toRadians(deg));
    }

    public static double cosDeg(double deg) {
        return Math.cos(Math.toRadians(deg));
    }

    public static Point2D.Double Normalize(Point2D.Double v) {
        double norm = Math.sqrt(v.x * v.x + v.y * v.y);
        return new Point2D.Double(v.x / norm, v.y / norm);
    }

    public static double PseudoAve(double ave, double no, double newentry) {
        return (ave * no + newentry) / (no + 1.0);
    }

    public static double Direction(double x1, double y1, double x2, double y2, double head, double vel) {
        if (Math.abs(vel) < 1.0) {
            return 0.0;
        }
        double d = Util.normalDegB(head - Util.Deg(x1, y1, x2, y2));
        d /= Math.abs(d);
        if (vel < 0.0) {
            d *= -1.0;
        }
        return d;
    }

    public static double Rand(double a, double b) {
        return Math.random() * (b - a) + a;
    }
}

