/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rGun;

import dsekercioglu.mega.core.GuessFactor;
import dsekercioglu.mega.core.wiki.FastMath;
import dsekercioglu.mega.rGun.BattleInfo;
import dsekercioglu.mega.rGun.FirePowerManager;
import dsekercioglu.mega.rGun.GunUtils;
import dsekercioglu.mega.rGun.Wave;
import dsekercioglu.mega.rGun.gun.ASGun;
import dsekercioglu.mega.rGun.gun.MainGun;
import dsekercioglu.mega.rGun.gun.Predictor;
import dsekercioglu.mega.rMove.MoveUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Claws {
    private boolean TC;
    AdvancedRobot BOT;
    BattleInfo currentBattleInfo;
    ArrayList<Wave> waves;
    ArrayList<Predictor> predictors;
    ArrayList<Double> scores;
    ArrayList<Double> coefficients;
    FirePowerManager FIRE_POWER_MANAGER;
    int currentGun = 0;
    double bulletsShot = 0.0;
    double bulletsHit = 0.0;
    double bulletHitBullet = 0.0;
    double enemyBulletsShot = 0.0;
    double enemyBulletsHit = 0.0;
    double damageReceived = 0.0;
    double enemyDamageReceived = 0.0;
    double healthGained = 0.0;
    double enemyHealthGained = 0.0;
    double enemyHealthLost = 0.0;
    int scans = 0;

    public void init(AdvancedRobot advBot, boolean TC) {
        this.TC = TC;
        this.BOT = advBot;
        this.currentBattleInfo = new BattleInfo(advBot);
        this.predictors = new ArrayList();
        this.scores = new ArrayList();
        this.coefficients = new ArrayList();
        this.predictors.add(new MainGun());
        this.scores.add(16.0);
        this.coefficients.add(1.05);
        this.predictors.add(new ASGun());
        this.scores.add(0.0);
        this.coefficients.add(1.0);
        this.FIRE_POWER_MANAGER = new FirePowerManager(this);
    }

    public void run() {
        this.waves = new ArrayList();
        this.currentBattleInfo.run();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.currentBattleInfo.onScannedRobot(e);
        if (this.currentBattleInfo.enemyFired()) {
            this.enemyHealthLost += this.currentBattleInfo.getLastFirePower();
            this.enemyBulletsShot += 1.0;
        }
        this.updateWaves();
        double firePower = this.TC ? Math.min(3.0, this.BOT.getEnergy()) : this.FIRE_POWER_MANAGER.firePower(this.currentBattleInfo);
        this.currentBattleInfo.setLastFirePower(firePower);
        Wave wave = new Wave(firePower, this.currentBattleInfo);
        this.waves.add(wave);
        if (this.BOT.getGunHeat() <= 0.3) {
            ArrayList<Double> guessFactors = this.getGuessFactors(firePower);
            int index = GunUtils.highestValue(this.scores);
            double guessFactor = guessFactors.get(index);
            wave.setGuessFactors(this.predictors.get(index).getGuessFactors(this.currentBattleInfo));
            double fireAngle = wave.getFireAngle(guessFactor);
            if (this.bulletHitBullet / this.bulletsShot > 0.3) {
                fireAngle += (double)((this.BOT.getTime() % 2L * 2L - 1L) * 9L) / this.currentBattleInfo.botDistance;
            }
            double gunHeading = this.BOT.getGunHeadingRadians();
            this.BOT.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(fireAngle - gunHeading)));
            if (this.BOT.getGunHeat() == 0.0 && this.BOT.getEnergy() > 0.0 && this.BOT.getGunTurnRemainingRadians() < FastMath.atan(18.0 / (this.currentBattleInfo.botDistance - 18.0))) {
                wave.setVirtualGunGuessFactors(guessFactors);
                this.currentBattleInfo.onFire();
                this.BOT.setFire(firePower);
                wave.setReal(true);
                this.FIRE_POWER_MANAGER.onFire(firePower, this.currentBattleInfo);
                this.bulletsShot += 1.0;
            }
        } else {
            this.BOT.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.currentBattleInfo.absoluteBearing - this.BOT.getGunHeadingRadians())));
        }
        if (this.scores.get(0) > this.scores.get(1)) {
            if (this.currentGun == 1) {
                System.out.println("Switching to Main Gun");
                this.currentGun = 0;
            }
        } else if (this.currentGun == 0) {
            System.out.println("Switching to AS Gun");
            this.currentGun = 1;
        }
        ++this.scans;
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.bulletHitBullet += 1.0;
    }

    public void onBulletHit(BulletHitEvent e) {
        this.bulletsHit += 1.0;
        double bulletPower = e.getBullet().getPower();
        this.enemyDamageReceived += Rules.getBulletDamage((double)bulletPower);
        this.healthGained += bulletPower * 3.0;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double bulletPower = e.getBullet().getPower();
        this.damageReceived += Rules.getBulletDamage((double)bulletPower);
        this.enemyHealthGained += bulletPower * 3.0;
        this.enemyBulletsHit += 1.0;
    }

    public ArrayList<Double> getGuessFactors(double firePower) {
        ArrayList<Double> guessFactors = new ArrayList<Double>();
        for (Predictor predictor : this.predictors) {
            Wave wave = new Wave(firePower, this.currentBattleInfo);
            wave.setGuessFactors(predictor.getGuessFactors(this.currentBattleInfo));
            guessFactors.add(this.chooseBestGuessFactor(wave));
        }
        return guessFactors;
    }

    public double chooseBestGuessFactor(Wave wave) {
        double score;
        double guessFactor;
        int i;
        int SENSITIVITY = 25;
        double highestScore = Double.NEGATIVE_INFINITY;
        double bestGuessFactor = 0.0;
        double botWidth = FastMath.atan(25.0 / this.currentBattleInfo.botDistance) / wave.MEA;
        int extraIndex = (int)Math.ceil(botWidth * 25.0);
        double[] BINS = new double[51];
        for (i = -25; i <= 25; ++i) {
            guessFactor = (double)i * 1.0 / 25.0;
            score = wave.getDanger(guessFactor - botWidth, guessFactor + botWidth, 1.0E-5);
            for (int j = Math.max(i - extraIndex, -25); j <= Math.min(i + extraIndex, 25); ++j) {
                int n = j + 25;
                BINS[n] = BINS[n] + score / (1.0 + MoveUtils.sq(i - j) * 10.0);
            }
        }
        for (i = -25; i <= 25; ++i) {
            guessFactor = 1.0 * (double)i / 25.0;
            score = BINS[i + 25];
            if (!(score > highestScore)) continue;
            highestScore = score;
            bestGuessFactor = guessFactor;
        }
        return bestGuessFactor;
    }

    public void updateWaves() {
        Point2D.Double botLocation = this.currentBattleInfo.enemyLocation;
        for (int i = 0; i < this.waves.size(); ++i) {
            Wave wave = this.waves.get(i);
            double botWidth = FastMath.atan(18.0 / (this.currentBattleInfo.botDistance - 18.0)) / wave.MEA;
            if (!wave.update(botLocation)) continue;
            GuessFactor preciseGuessFactor = new GuessFactor(wave.getPreciseGuessFactor(botLocation.x, botLocation.y), 1.0, (int)this.bulletsHit);
            for (Predictor predictor : this.predictors) {
                predictor.addData(wave.getInfo(), preciseGuessFactor, wave.isReal());
            }
            double guessFactor = wave.getGuessFactor(botLocation.x, botLocation.y);
            ArrayList<Double> guessFactors = wave.getVirtualGunGuessFactors();
            for (int j = 0; j < guessFactors.size(); ++j) {
                double currentGuessFactor = guessFactors.get(j);
                if (!(Math.abs(currentGuessFactor - guessFactor) < botWidth)) continue;
                this.scores.set(j, this.scores.get(j) + wave.WAVE_DAMAGE * this.coefficients.get(j));
            }
            this.waves.remove(i);
            --i;
        }
    }

    public void onPaint(Graphics2D g) {
        if (!this.waves.isEmpty() && this.BOT.getGunHeat() < 0.4) {
            ArrayList<Double> waveScores = new ArrayList<Double>();
            Wave wave = this.waves.get(this.waves.size() - 1);
            int SENSITIVITY = 20;
            int INDEX_FACTOR = 10;
            double botWidth = Math.atan(18.0 / (this.currentBattleInfo.botDistance - 18.0)) / wave.MEA;
            for (int i = -20; i <= 20; ++i) {
                double guessFactor = (double)i * 1.0 / 20.0;
                double score = wave.getDanger(guessFactor - botWidth, guessFactor + botWidth, 1.0E-5);
                waveScores.add(score);
            }
            ArrayList<Double> probabilities = GunUtils.normalize(waveScores);
            double avg = GunUtils.average(probabilities);
            double stdDev = GunUtils.stdDev(probabilities);
            Point2D.Double source = wave.SOURCE;
            int SCORE_FACTOR = 100;
            for (int i = -200; i <= 200; ++i) {
                double guessFactor = (double)i * 1.0 / 200.0;
                double score = probabilities.get((i + 200) / 10) * 100.0;
                double angle = wave.getFireAngle(guessFactor);
                int COLOR_SENSITIVITY = 10;
                int j = 10;
                while ((double)j < score) {
                    Point2D.Double scorePosition0 = GunUtils.project(source, angle, j - 10);
                    Point2D.Double scorePosition1 = GunUtils.project(source, angle, j);
                    g.setColor(Claws.heatMap((double)j * 1.0 / 200.0, avg, stdDev));
                    g.drawLine((int)scorePosition0.x, (int)scorePosition0.y, (int)scorePosition1.x, (int)scorePosition1.y);
                    j += 10;
                }
            }
        }
    }

    private static Color heatMap(double normalizedValue, double average, double stdDev) {
        if (normalizedValue == 0.0) {
            return Color.GREEN;
        }
        double min = average - stdDev;
        double max = average + stdDev;
        double range = max - min;
        double value = MoveUtils.limit(0.0, (normalizedValue - min) / range, 1.0);
        return new Color((int)Math.min(value * 510.0, 255.0), 0, (int)Math.min(510.0 - value * 510.0, 255.0));
    }
}

