/*
 * Decompiled with CFR 0.152.
 */
package josago;

import josago.InfoRobot;
import josago.Utilidades;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class GestorArmas {
    public static final double ARMA_POTENCIA_MAXIMA = 3.0;
    public static final double ARMA_POTENCIA_MINIMA = 0.1;
    public static final double ARMA_PENALIZACION_ENERGIA = 1.0;
    public static final int ARMA_LIMITE_ITERACIONES = 5;
    public static final int ARMA_VENTANA_PATRONES = 7;

    public static double potenciaDisparo(ScannedRobotEvent e, double mi_energia, double mapa_diagonal) {
        double penalizacion_energia;
        double potencia_base = 3.0 * (1.0 - e.getDistance() / mapa_diagonal);
        double potencia_calculada = potencia_base - 0.1 >= (penalizacion_energia = 1.0 * Math.pow(1.0 - Utilidades.normalizarEnergia(mi_energia), 2.0)) ? potencia_base - penalizacion_energia : 0.1;
        if (e.getEnergy() < Rules.getBulletDamage((double)potencia_calculada)) {
            return e.getEnergy() / 4.0 + 0.1;
        }
        return potencia_calculada;
    }

    public static Double anguloRectificacionAleatorio(double potencia_disparo) {
        double velocidad_disparo = Rules.getBulletSpeed((double)potencia_disparo);
        double angulo_escape_max = Math.asin(8.0 / velocidad_disparo);
        return (Math.random() - 0.5) * 2.0 * angulo_escape_max;
    }

    public static Double anguloRectificacionMRU(double potencia_disparo, double mi_orientacion, double mi_x, double mi_y, InfoRobot enemigo, double angulo_relativo, double ancho_pantalla, double alto_pantalla) {
        double velocidad_disparo = Rules.getBulletSpeed((double)potencia_disparo);
        double distancia_enemigo = Utilidades.distancia(enemigo.datos[0].x, enemigo.datos[0].y, mi_x, mi_y);
        double tiempo_vuelo = distancia_enemigo / velocidad_disparo;
        double[] coords_futuras = new double[2];
        for (int i = 1; i < 5; ++i) {
            coords_futuras[0] = enemigo.datos[0].x + tiempo_vuelo * enemigo.datos[0].velocidad * Math.sin(enemigo.datos[0].orientacion);
            coords_futuras[1] = enemigo.datos[0].y + tiempo_vuelo * enemigo.datos[0].velocidad * Math.cos(enemigo.datos[0].orientacion);
            coords_futuras = Utilidades.normalizarCoordenadas(coords_futuras, ancho_pantalla, alto_pantalla);
            double distancia_futura = Utilidades.distancia(mi_x, mi_y, coords_futuras[0], coords_futuras[1]);
            tiempo_vuelo = distancia_futura / velocidad_disparo;
        }
        double angulo_ahora = mi_orientacion + angulo_relativo;
        double angulo_final = Math.atan2(coords_futuras[0] - mi_x, coords_futuras[1] - mi_y);
        return Utils.normalRelativeAngle((double)(angulo_final - angulo_ahora));
    }

    public static Double anguloRectificacionMCU(double potencia_disparo, double mi_orientacion, double mi_x, double mi_y, InfoRobot enemigo, double angulo_relativo, double ancho_pantalla, double alto_pantalla) {
        if (enemigo.datosGuardados < 2) {
            return null;
        }
        double velocidad_giro = (enemigo.datos[0].orientacion - enemigo.datos[1].orientacion) / (double)(enemigo.datos[0].t - enemigo.datos[1].t);
        if (velocidad_giro == 0.0) {
            return null;
        }
        double velocidad_disparo = Rules.getBulletSpeed((double)potencia_disparo);
        double distancia_enemigo = Utilidades.distancia(enemigo.datos[0].x, enemigo.datos[0].y, mi_x, mi_y);
        double tiempo_vuelo = distancia_enemigo / velocidad_disparo;
        double[] coords_futuras = new double[2];
        for (int i = 1; i < 5; ++i) {
            coords_futuras[0] = enemigo.datos[0].x + enemigo.datos[0].velocidad * (Math.cos(enemigo.datos[0].orientacion) - Math.cos(enemigo.datos[0].orientacion + velocidad_giro * tiempo_vuelo)) / velocidad_giro;
            coords_futuras[1] = enemigo.datos[0].y + enemigo.datos[0].velocidad * (-Math.sin(enemigo.datos[0].orientacion) + Math.sin(enemigo.datos[0].orientacion + velocidad_giro * tiempo_vuelo)) / velocidad_giro;
            coords_futuras = Utilidades.normalizarCoordenadas(coords_futuras, ancho_pantalla, alto_pantalla);
            double distancia_futura = Utilidades.distancia(mi_x, mi_y, coords_futuras[0], coords_futuras[1]);
            tiempo_vuelo = distancia_futura / velocidad_disparo;
        }
        double angulo_ahora = mi_orientacion + angulo_relativo;
        double angulo_final = Math.atan2(coords_futuras[0] - mi_x, coords_futuras[1] - mi_y);
        return Utils.normalRelativeAngle((double)(angulo_final - angulo_ahora));
    }

    public static Double anguloRectificacionPatrones(ScannedRobotEvent e, double potencia_disparo, double mi_orientacion, double mi_x, double mi_y, InfoRobot enemigo, double ancho_pantalla, double alto_pantalla) {
        int indice = enemigo.indicePatron(7);
        if (indice == -1) {
            return null;
        }
        double velocidad_disparo = Rules.getBulletSpeed((double)potencia_disparo);
        double angulo_futuro = 0.0;
        double distancia_bala_futuro = 0.0;
        boolean punto_encontrado = false;
        for (int i = indice; i >= 0; --i) {
            double tiempo_vuelo = enemigo.datos[i].t - enemigo.datos[indice + 1].t;
            double aumento_x_historial = enemigo.datos[i].x - enemigo.datos[indice + 1].x;
            double aumento_y_historial = enemigo.datos[i].y - enemigo.datos[indice + 1].y;
            double argumento_historial = Math.sqrt(Math.pow(aumento_x_historial, 2.0) + Math.pow(aumento_y_historial, 2.0));
            double angulo_historial = Math.atan2(aumento_x_historial, aumento_y_historial);
            double[] coords_futuras = new double[]{enemigo.datos[0].x + argumento_historial * Math.sin(angulo_historial += enemigo.anguloDiferenciaPatron), enemigo.datos[0].y + argumento_historial * Math.cos(angulo_historial)};
            coords_futuras = Utilidades.normalizarCoordenadas(coords_futuras, ancho_pantalla, alto_pantalla);
            double distancia_futura = Utilidades.distancia(mi_x, mi_y, coords_futuras[0], coords_futuras[1]);
            angulo_futuro = Math.atan2(coords_futuras[0] - mi_x, coords_futuras[1] - mi_y);
            distancia_bala_futuro = Math.abs(distancia_futura - velocidad_disparo * tiempo_vuelo);
            if (!(distancia_futura <= velocidad_disparo * tiempo_vuelo)) continue;
            punto_encontrado = true;
            break;
        }
        if (!punto_encontrado) {
            return null;
        }
        double angulo_actual = Utils.normalRelativeAngle((double)(mi_orientacion + e.getBearingRadians()));
        return Utils.normalRelativeAngle((double)(angulo_futuro - angulo_actual));
    }
}

