/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.MEA;

import java.awt.Color;
import rdt.Wraith.EscapeEnvelope.EscapeEnvelopeData;
import rdt.Wraith.EscapeEnvelope.EscapeVector;
import rdt.Wraith.MEA.IMEACalculator;
import rdt.Wraith.MEA.MEA;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.Utils.FastMoveInterceptLookup;
import rdt.Wraith.Utils.FastOutsideOfBattlefield;
import rdt.Wraith.Utils.MathUtils;

public class RealWallCullingAndInterceptMEACalculator
implements IMEACalculator {
    private final FastOutsideOfBattlefield _fastOutsideOfBattlefield;
    private EscapeEnvelopeData _envelopeData = new EscapeEnvelopeData();

    public RealWallCullingAndInterceptMEACalculator(FastOutsideOfBattlefield fastOutsideOfBattlefield) {
        this._fastOutsideOfBattlefield = fastOutsideOfBattlefield;
    }

    @Override
    public boolean CalculateMEA(double sourceX, double sourceY, RobotSnapshot target, long numTicks, double bulletVelocity, MEA outMEA) {
        this.GetEscapeEnvelopeData(sourceX, sourceY, target, numTicks, bulletVelocity);
        this._envelopeData.GetMEA(sourceX, sourceY, target.LocationX, target.LocationY, target.RotationDirectionToTarget, outMEA);
        return true;
    }

    @Override
    public EscapeEnvelopeData GetEscapeEnvelopeData(double sourceX, double sourceY, RobotSnapshot target, long numTicks, double bulletVelocity) {
        double targetAbsoluteHeadingAlongVelocityVector = target.AbsoluteHeadingAlongVelocityVector;
        double targetAbsVelocity = target.AbsoluteVelocity;
        double absAngleToTarget = MathUtils.GetAngle(sourceX, sourceY, target.LocationX, target.LocationY);
        double angleToTargetDX = MathUtils.FastSin(absAngleToTarget);
        double angleToTargetDY = MathUtils.FastCos(absAngleToTarget);
        for (int vectorIndex = 0; vectorIndex < 32; ++vectorIndex) {
            double totalDistanceCanMove;
            EscapeVector escapeVector = EscapeVector.EscapeVectors[vectorIndex];
            double targetX = target.LocationX + escapeVector.dX * 1000.0;
            double targetY = target.LocationY + escapeVector.dY * 1000.0;
            this._envelopeData.Distances[vectorIndex] = totalDistanceCanMove = FastMoveInterceptLookup.GetDistanceCanMove(target.LocationX, target.LocationY, targetAbsoluteHeadingAlongVelocityVector, targetAbsVelocity, targetX, targetY, numTicks);
            double dot = MathUtils.Dot(angleToTargetDX, angleToTargetDY, escapeVector.dX, escapeVector.dY);
            if (!(dot < 0.0)) continue;
            double distance = FastMoveInterceptLookup.GetSmallestBulletInterceptDistanceAlongVector(sourceX, sourceY, bulletVelocity, target.LocationX, target.LocationY, targetAbsoluteHeadingAlongVelocityVector, targetAbsVelocity, escapeVector.dX, escapeVector.dY);
            this._envelopeData.Distances[vectorIndex] = Math.min(this._envelopeData.Distances[vectorIndex], distance);
        }
        this._envelopeData.ReduceForBotSize();
        this._envelopeData.CullOutsideOfBattlefield(target.LocationX, target.LocationY, this._fastOutsideOfBattlefield);
        return this._envelopeData;
    }

    @Override
    public Color GetDebugColour() {
        return Color.orange;
    }
}

