/*
 * Decompiled with CFR 0.152.
 */
package seed.wave;

import java.awt.geom.Point2D;
import robocode.util.Utils;
import seed.dataset.BulletData;
import seed.wave.Wave;

public class MyActiveBullet
extends Wave {
    protected BulletData bullet;

    public MyActiveBullet(BulletData bullet) {
        this.bullet = bullet;
    }

    protected void setOffset(double x, double y) {
        double negaDist;
        double posiRad = this.directAngle + 0.08726646259971647;
        double negaRad = this.directAngle - 0.08726646259971647;
        Point2D.Double pPos = this.getLocation(posiRad);
        Point2D.Double nPos = this.getLocation(negaRad);
        Point2D.Double dirPos = this.getLocation(this.directAngle);
        double posiDist = Point2D.distance(pPos.getX(), pPos.getY(), x, y);
        int sign = posiDist <= (negaDist = Point2D.distance(nPos.getX(), nPos.getY(), x, y)) ? 1 : -1;
        Point2D.Double v1 = new Point2D.Double(x - this.fireLocation.getX(), y - this.fireLocation.getY());
        Point2D.Double v2 = new Point2D.Double(dirPos.getX() - this.fireLocation.getX(), dirPos.getY() - this.fireLocation.getY());
        this.bullet.setRadian(this.getAngle(v1, v2) * (double)sign);
    }

    public BulletData getBullet(double enmX, double enmY) {
        this.setOffset(enmX, enmY);
        return this.bullet;
    }

    protected Point2D.Double getLocation(double angle) {
        double x = this.fireLocation.getX() + this.distanceTraveled * Math.sin(angle);
        double y = this.fireLocation.getY() + this.distanceTraveled * Math.cos(angle);
        return new Point2D.Double(x, y);
    }

    protected double getAngle(Point2D.Double v1, Point2D.Double v2) {
        double cos = (v1.getX() * v2.getX() + v1.getY() * v2.getY()) / (Point2D.distance(0.0, 0.0, v1.getX(), v1.getY()) * Point2D.distance(0.0, 0.0, v2.getX(), v2.getY()));
        if (Utils.isNear((double)Math.abs(cos), (double)Math.abs(1.0))) {
            cos = Math.pow(10.0, -10.0);
            double x = 0.9;
            while (x > Math.pow(10.0, -9.0)) {
                cos += x;
                x /= 10.0;
            }
        }
        return Math.acos(cos);
    }
}

