/*
 * Decompiled with CFR 0.152.
 */
package kenran.util;

import java.util.LinkedList;

public class FixedSizeQueue<E> {
    private final LinkedList<E> _items = new LinkedList();
    private final int _maxSize;

    public FixedSizeQueue(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException();
        }
        this._maxSize = maxSize;
    }

    public void push(E item) {
        this._items.addLast(item);
        if (this._items.size() > this._maxSize) {
            this._items.removeFirst();
        }
    }

    public E peek() {
        return this._items.peekFirst();
    }

    public boolean isFull() {
        return this._items.size() == this._maxSize;
    }

    public int maxSize() {
        return this._maxSize;
    }
}

