/*
 * Decompiled with CFR 0.152.
 */
package xander.core.track;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import robocode.BattleEndedEvent;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.RoundEndedEvent;
import xander.core.Configuration;
import xander.core.RobotEvents;
import xander.core.RobotProxy;
import xander.core.event.MyVirtualWaveListener;
import xander.core.event.MyWaveListener;
import xander.core.event.OpponentWaveListener;
import xander.core.event.RoundListener;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.paint.GunHitRatioPainter;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.core.track.WaveHistory;
import xander.core.track.XBulletWave;

public class GunStats
implements MyWaveListener,
MyVirtualWaveListener,
OpponentWaveListener,
RoundListener {
    private static final Log log = Logger.getLog(GunStats.class);
    private int[] cumulativeHitRatio = new int[3];
    private int[] oppCumulativeHitRatio = new int[3];
    private Map<String, int[]> hitRatios = new HashMap<String, int[]>();
    private Map<String, List<int[]>> rollingRatios = new HashMap<String, List<int[]>>();
    private int rollingVirtualHitRatioDepth;
    private double cumulativeOppPower;
    private int cumulativeOppShots;
    private int lastOppPowerIndex;
    private double[] lastOppPowers = new double[5];
    private long lastOppFireTime;
    private Map<String, int[]> oppHitRatios = new HashMap<String, int[]>();
    private RobotProxy robotProxy;

    public GunStats(RobotProxy robotProxy, WaveHistory waveHistory, RobotEvents robotEvents, Configuration configuration) {
        this.robotProxy = robotProxy;
        this.rollingVirtualHitRatioDepth = configuration.getRollingVirtualHitRatioDepth();
        waveHistory.addMyVirtualWaveListener(this);
        waveHistory.addMyWaveListener(this);
        waveHistory.addOpponentWaveListener(this);
        robotEvents.addRoundListener(this);
        if (configuration.isDrawHitRatios()) {
            robotEvents.addPainter(new GunHitRatioPainter(this));
        }
    }

    public Set<String> getGunNames() {
        return this.hitRatios.keySet();
    }

    public Set<String> getDriveNames() {
        return this.oppHitRatios.keySet();
    }

    public double getHitRatio(String gunName) {
        int[] hitRatio = this.hitRatios.get(gunName);
        if (hitRatio == null) {
            return 0.0;
        }
        int actionedBullets = hitRatio[2] - hitRatio[1];
        if (actionedBullets == 0) {
            return 0.0;
        }
        return (double)hitRatio[0] / (double)actionedBullets;
    }

    public double getVirtualHitRatio(String gunName) {
        int[] hitRatio = this.hitRatios.get(gunName);
        if (hitRatio == null) {
            return 0.0;
        }
        int actionedBullets = hitRatio[5] - hitRatio[4];
        if (actionedBullets == 0) {
            return 0.0;
        }
        return (double)hitRatio[3] / (double)actionedBullets;
    }

    public double getRollingHitRatio(String gunName) {
        return this.getRollingVirtualHitRatio(gunName);
    }

    public double getRollingVirtualHitRatio(String gunName) {
        int[] hitRatio = this.hitRatios.get(gunName);
        if (hitRatio == null) {
            return 0.0;
        }
        int actionedBullets = hitRatio[8] - hitRatio[7];
        if (actionedBullets == 0) {
            return 0.0;
        }
        return (double)hitRatio[6] / (double)actionedBullets;
    }

    public double getOpponentHitRatioAgainstDrive(String driveName) {
        int[] ratio = this.oppHitRatios.get(driveName);
        if (ratio == null) {
            return 0.0;
        }
        return (double)ratio[0] / (double)ratio[1];
    }

    public double getOverallHitRatio() {
        int actionedBullets = this.cumulativeHitRatio[2] - this.cumulativeHitRatio[1];
        if (actionedBullets == 0) {
            return 0.0;
        }
        return (double)this.cumulativeHitRatio[0] / (double)actionedBullets;
    }

    public double getOverallInterferenceRatio() {
        if (this.cumulativeHitRatio[2] == 0) {
            return 0.0;
        }
        return (double)this.cumulativeHitRatio[1] / (double)this.cumulativeHitRatio[2];
    }

    public double getOverallOpponentHitRatio() {
        int actionedBullets = this.oppCumulativeHitRatio[2] - this.oppCumulativeHitRatio[1];
        if (actionedBullets == 0) {
            return 0.0;
        }
        return (double)this.oppCumulativeHitRatio[0] / (double)actionedBullets;
    }

    public int getBulletsFired() {
        return this.cumulativeHitRatio[2];
    }

    public int getActionedBulletsFired(String gunName) {
        int[] hitRatio = this.hitRatios.get(gunName);
        if (hitRatio == null) {
            return 0;
        }
        return hitRatio[2] - hitRatio[1];
    }

    public int getVirtualBulletsFired(String gunName) {
        int[] hitRatio = this.hitRatios.get(gunName);
        if (hitRatio == null) {
            return 0;
        }
        return hitRatio[5] - hitRatio[4];
    }

    public int getRollingVirtualBulletsFired(String gunName) {
        int[] hitRatio = this.hitRatios.get(gunName);
        if (hitRatio == null) {
            return 0;
        }
        return hitRatio[8] - hitRatio[7];
    }

    public int getShotsAgainstDrive(String driveName) {
        int[] ratio = this.oppHitRatios.get(driveName);
        if (ratio == null) {
            return 0;
        }
        return ratio[1];
    }

    public int[] getHitRatioValues(String gunName) {
        return this.hitRatios.get(gunName);
    }

    public double getAverageOpponentBulletPower() {
        if (this.cumulativeOppShots == 0) {
            return 0.0;
        }
        return this.cumulativeOppPower / (double)this.cumulativeOppShots;
    }

    public double getRollingAverageOpponentBulletPower() {
        int values = 0;
        double sum = 0.0;
        int i = 0;
        while (i < this.lastOppPowers.length) {
            sum += this.lastOppPowers[i];
            if (this.lastOppPowers[i] > 0.0) {
                ++values;
            }
            ++i;
        }
        return values == 0 ? 0.0 : sum / (double)values;
    }

    public double getLastOpponentBulletPower() {
        return this.lastOppPowers[this.lastOppPowerIndex];
    }

    public long getLastOpponentFireTime() {
        return this.lastOppFireTime;
    }

    private void updateRatio(String gunName, int hits, int interferences, int fires) {
        int[] ratio = this.hitRatios.get(gunName);
        if (ratio == null) {
            ratio = new int[9];
            this.hitRatios.put(gunName, ratio);
        }
        this.cumulativeHitRatio[0] = this.cumulativeHitRatio[0] + hits;
        this.cumulativeHitRatio[1] = this.cumulativeHitRatio[1] + interferences;
        this.cumulativeHitRatio[2] = this.cumulativeHitRatio[2] + fires;
        ratio[0] = ratio[0] + hits;
        ratio[1] = ratio[1] + interferences;
        ratio[2] = ratio[2] + fires;
        ratio[3] = ratio[3] + hits;
        ratio[4] = ratio[4] + interferences;
        ratio[5] = ratio[5] + fires;
        ratio[6] = ratio[6] + hits;
        ratio[7] = ratio[7] + interferences;
        ratio[8] = ratio[8] + fires;
        List<int[]> gunRollingRatios = this.rollingRatios.get(gunName);
        if (gunRollingRatios == null) {
            gunRollingRatios = new ArrayList<int[]>();
            this.rollingRatios.put(gunName, gunRollingRatios);
        }
        gunRollingRatios.add(new int[]{hits, interferences, fires});
        if (gunRollingRatios.size() > this.rollingVirtualHitRatioDepth) {
            int[] oldCount = gunRollingRatios.remove(0);
            ratio[6] = ratio[6] - oldCount[0];
            ratio[7] = ratio[7] - oldCount[1];
            ratio[8] = ratio[8] - oldCount[2];
        }
    }

    private void updateOpponentRatio(int hits, int interferences, int fires) {
        this.oppCumulativeHitRatio[0] = this.oppCumulativeHitRatio[0] + hits;
        this.oppCumulativeHitRatio[1] = this.oppCumulativeHitRatio[1] + interferences;
        this.oppCumulativeHitRatio[2] = this.oppCumulativeHitRatio[2] + fires;
    }

    private void updateOpponentRatio(String driveName, int hits, int shots) {
        int[] ratio = this.oppHitRatios.get(driveName);
        if (ratio == null) {
            ratio = new int[2];
            this.oppHitRatios.put(driveName, ratio);
        }
        ratio[0] = ratio[0] + hits;
        ratio[1] = ratio[1] + shots;
    }

    private void updateVirtualRatio(String gunName, int hits, int interferences, int fires) {
        int[] ratio = this.hitRatios.get(gunName);
        if (ratio == null) {
            ratio = new int[9];
            this.hitRatios.put(gunName, ratio);
        }
        ratio[3] = ratio[3] + hits;
        ratio[4] = ratio[4] + interferences;
        ratio[5] = ratio[5] + fires;
        ratio[6] = ratio[6] + hits;
        ratio[7] = ratio[7] + interferences;
        ratio[8] = ratio[8] + fires;
        List<int[]> gunRollingRatios = this.rollingRatios.get(gunName);
        if (gunRollingRatios == null) {
            gunRollingRatios = new ArrayList<int[]>();
            this.rollingRatios.put(gunName, gunRollingRatios);
        }
        gunRollingRatios.add(new int[]{hits, interferences, fires});
        if (gunRollingRatios.size() > this.rollingVirtualHitRatioDepth) {
            int[] oldCount = gunRollingRatios.remove(0);
            ratio[6] = ratio[6] - oldCount[0];
            ratio[7] = ratio[7] - oldCount[1];
            ratio[8] = ratio[8] - oldCount[2];
        }
    }

    private void logGunHitRatios() {
        for (Map.Entry<String, int[]> entry : this.hitRatios.entrySet()) {
            double denom = entry.getValue()[2] - entry.getValue()[1];
            String percent = denom > 0.0 ? Logger.format((double)entry.getValue()[0] * 100.0 / denom) : "?";
            log.stat("Hit ratio for " + entry.getKey() + ": " + percent + "% (" + entry.getValue()[0] + "," + entry.getValue()[1] + "," + entry.getValue()[2] + ")");
        }
        log.stat("My overall hit ratio:       " + Logger.format(100.0 * this.getOverallHitRatio()) + "%");
        log.stat("Opponent overall hit ratio: " + Logger.format(100.0 * this.getOverallOpponentHitRatio()) + "%");
    }

    @Override
    public void oppWaveCreated(Wave wave) {
        this.lastOppFireTime = wave.getOriginTime();
        this.cumulativeOppPower += wave.getBulletPower();
        ++this.cumulativeOppShots;
        ++this.lastOppPowerIndex;
        if (this.lastOppPowerIndex >= this.lastOppPowers.length) {
            this.lastOppPowerIndex = 0;
        }
        this.lastOppPowers[this.lastOppPowerIndex] = wave.getBulletPower();
    }

    @Override
    public void oppWaveHitBullet(Wave wave, Bullet bullet) {
        this.updateOpponentRatio(0, 1, 1);
    }

    @Override
    public void oppWaveHit(Wave wave) {
        this.updateOpponentRatio(0, 0, 1);
        if (this.robotProxy.getTime() - wave.getOriginTime() > 5L) {
            this.updateOpponentRatio(this.robotProxy.getActiveDriveName(), 0, 1);
        }
    }

    @Override
    public void oppNextWaveToHit(Wave wave) {
    }

    @Override
    public void oppBulletHit(Wave wave, HitByBulletEvent hitByBulletEvent) {
        this.updateOpponentRatio(1, 0, 0);
        if (this.robotProxy.getTime() - wave.getOriginTime() > 5L) {
            this.updateOpponentRatio(this.robotProxy.getActiveDriveName(), 1, 0);
        }
    }

    @Override
    public void oppWavePassing(Wave wave) {
    }

    @Override
    public void oppWavePassed(Wave wave) {
    }

    @Override
    public void oppWaveUpdated(Wave wave) {
    }

    @Override
    public void oppWaveDestroyed(Wave wave) {
    }

    @Override
    public void myVirtualWaveCreated(XBulletWave wave) {
    }

    @Override
    public void myVirtualWaveHit(XBulletWave wave) {
        this.updateVirtualRatio(wave.getGunName(), 0, 0, 1);
    }

    @Override
    public void myVirtualBulletHit(XBulletWave wave) {
        this.updateVirtualRatio(wave.getGunName(), 1, 0, 0);
    }

    @Override
    public void myVirtualWavePassing(XBulletWave wave) {
    }

    @Override
    public void myVirtualWavePassed(XBulletWave wave) {
    }

    @Override
    public void myVirtualWaveDestroyed(XBulletWave wave) {
    }

    @Override
    public void myWaveCreated(XBulletWave wave) {
    }

    @Override
    public void myWaveHitBullet(XBulletWave wave, Bullet bullet) {
        this.updateRatio(wave.getGunName(), 0, 1, 1);
    }

    @Override
    public void myWaveHit(XBulletWave wave, Snapshot opponentSnapshot) {
        this.updateRatio(wave.getGunName(), 0, 0, 1);
    }

    @Override
    public void myBulletHit(XBulletWave wave, BulletHitEvent bulletHitEvent) {
        this.updateRatio(wave.getGunName(), 1, 0, 0);
    }

    @Override
    public void myWavePassing(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWavePassed(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWaveDestroyed(XBulletWave wave) {
    }

    @Override
    public void onBattleEnded(BattleEndedEvent event) {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent event) {
        this.logGunHitRatios();
        this.lastOppFireTime = 0L;
    }
}

