/*
 * Decompiled with CFR 0.152.
 */
package syl.fire;

import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import syl.core.Enemy;
import syl.fire.FireStrategy;
import syl.util.Coordinate;
import syl.util.RobotMath;

public class VirtualBullet {
    private static final double ENEMY_SIZE = 22.5;
    private Coordinate startCoordinate;
    private Coordinate endCoordinate;
    private Coordinate enemyCoordinateAtFireTime;
    private long startTime;
    private Enemy target;
    private double power;
    private double heading;
    private long endTime;
    private FireStrategy fireStrategy;
    private boolean missed;

    public VirtualBullet(FireStrategy fireStrategy, Coordinate robotCoordinate, Coordinate endCoordinate, long startTime, Enemy target, double power) {
        this.fireStrategy = fireStrategy;
        this.startCoordinate = robotCoordinate.getClone();
        this.endCoordinate = endCoordinate.getClone();
        this.startTime = startTime;
        this.enemyCoordinateAtFireTime = target.getCoordinate();
        this.target = target;
        this.power = power;
        this.heading = this.startCoordinate.getAngle(endCoordinate);
        double distance = this.startCoordinate.getDistance(endCoordinate);
        this.endTime = startTime + (long)(distance / RobotMath.getBulletVelocity(power));
    }

    public boolean hasHit(long time) {
        double distance = this.getBulletDistance(time);
        Coordinate bulletCoordinate = this.startCoordinate.getCoordinate(distance, this.heading);
        Coordinate enemyCoordinate = this.target.getCoordinate();
        if (enemyCoordinate.getDistance(bulletCoordinate) < 50.0) {
            double interTime = time;
            int i = 0;
            while (i < 10) {
                distance = ((interTime += 0.1) - (double)this.startTime) * RobotMath.getBulletVelocity(this.power);
                bulletCoordinate = this.startCoordinate.getCoordinate(distance, this.heading);
                if (enemyCoordinate.getDistance(bulletCoordinate) < 22.5) {
                    this.fireStrategy.bulletHit(this);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean hasMissed(long time) {
        double enemyDistance;
        double bulletDistance = this.getBulletDistance(time);
        if (bulletDistance > (enemyDistance = this.startCoordinate.getDistance(this.target.getCoordinate())) + 22.5) {
            this.fireStrategy.bulletMissed(this);
            return true;
        }
        boolean isValid = this.isValid(time);
        if (!isValid) {
            this.fireStrategy.bulletMissed(this);
            return true;
        }
        return false;
    }

    public boolean isValid(long time) {
        double distance = (double)(time - this.startTime) * RobotMath.getBulletVelocity(this.power);
        Coordinate bulletCoordinate = this.startCoordinate.getCoordinate(distance, this.heading);
        return bulletCoordinate.isValid();
    }

    private double getBulletDistance(long time) {
        return (double)(time - this.startTime) * RobotMath.getBulletVelocity(this.power);
    }

    public double getHeading() {
        return this.heading;
    }

    public Enemy getTarget() {
        return this.target;
    }

    public double getPower() {
        return this.power;
    }

    public Coordinate getStartCoordinate() {
        return this.startCoordinate;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Coordinate getTargetCoordinate() {
        return this.endCoordinate;
    }

    public Coordinate getEnemyCoordinateAtFireTime() {
        return this.enemyCoordinateAtFireTime;
    }

    public static void main(String[] args) {
        Rectangle2D.Double rect = new Rectangle2D.Double(50.0, 50.0, 10.0, 10.0);
        Line2D.Double line = new Line2D.Double(50.0, 61.0, 50.0, 60.0);
        System.out.println(rect.intersectsLine(line));
    }
}

